/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.common.ui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.ui.AbstractArticleItemTable;
import org.openconcerto.erp.core.common.ui.AbstractVenteArticleItemTable;
import org.openconcerto.erp.core.common.ui.DeviseNumericHTConvertorCellEditor;
import org.openconcerto.erp.core.common.ui.DeviseTableCellRenderer;
import org.openconcerto.erp.core.common.ui.NiveauTableCellEditor;
import org.openconcerto.erp.core.common.ui.NiveauTableCellRender;
import org.openconcerto.erp.core.common.ui.QteCellEditor;
import org.openconcerto.erp.core.finance.accounting.model.CurrencyConverter;
import org.openconcerto.erp.core.finance.tax.model.TaxeCache;
import org.openconcerto.erp.core.sales.pos.io.BarcodeReader;
import org.openconcerto.erp.core.sales.pos.ui.BarcodeListener;
import org.openconcerto.erp.core.sales.product.element.LotSQLElement;
import org.openconcerto.erp.core.sales.product.element.ReferenceArticleSQLElement;
import org.openconcerto.erp.core.sales.product.ui.CurrencyWithSymbolRenderer;
import org.openconcerto.erp.core.sales.product.ui.QteMultipleRowValuesRenderer;
import org.openconcerto.erp.core.sales.product.ui.QteUnitRowValuesRenderer;
import org.openconcerto.erp.core.sales.product.ui.QtyRowValuesRenderer;
import org.openconcerto.erp.core.supplychain.stock.element.DepotStockSQLElement;
import org.openconcerto.erp.core.supplychain.stock.element.StockSQLElement;
import org.openconcerto.erp.preferences.DefaultNXProps;
import org.openconcerto.erp.preferences.GestionArticleGlobalPreferencePanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldPath;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.UndefinedRowValuesCache;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.sql.sqlobject.ITextArticleWithCompletionCellEditor;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.EditPanel;
import org.openconcerto.sql.view.list.AutoCompletionManager;
import org.openconcerto.sql.view.list.CellDynamicModifier;
import org.openconcerto.sql.view.list.RowValuesTable;
import org.openconcerto.sql.view.list.RowValuesTableModel;
import org.openconcerto.sql.view.list.SQLTableElement;
import org.openconcerto.sql.view.list.ValidStateChecker;
import org.openconcerto.ui.preferences.DefaultProps;
import org.openconcerto.utils.CompareUtils;
import org.openconcerto.utils.DecimalUtils;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.Tuple3;
import org.openconcerto.utils.checks.ValidState;
import org.openconcerto.utils.i18n.TranslationManager;

public abstract class AbstractAchatArticleItemTable
extends AbstractArticleItemTable {
    private AutoCompletionManager m;
    private AutoCompletionManager m2;
    private AutoCompletionManager m3;
    private AutoCompletionManager m4;
    private final SQLTable tableArticle = this.getSQLElement().getTable().getTable("ARTICLE");
    private SQLRowAccessor rowDevise;
    private boolean supplierCode;
    private static Map<String, Boolean> visibilityMap = new HashMap<String, Boolean>();
    private String incoterm = "";
    private SQLRow rowFournisseur = null;
    private BigDecimal tauxConversion = null;
    private final List<String> trFields = Arrays.asList("ID_COMMANDE_ELEMENT", "ID_BON_RECEPTION_ELEMENT");

    @Override
    public AutoCompletionManager getCodeCompletionManager() {
        return this.m;
    }

    @Override
    protected void setModel(RowValuesTableModel model) {
        super.setModel(model);
        model.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                AbstractAchatArticleItemTable.this.calculTarifNomenclature();
            }
        });
    }

    @Override
    protected void init() {
        String val;
        Boolean b;
        SQLElement e = this.getSQLElement();
        final SQLPreferences prefs = SQLPreferences.getMemCached(this.getSQLElement().getTable().getDBRoot());
        boolean selectArticle = prefs.getBoolean(GestionArticleGlobalPreferencePanel.USE_CREATED_ARTICLE, false);
        boolean createAuto = prefs.getBoolean(GestionArticleGlobalPreferencePanel.CREATE_ARTICLE_AUTO, true);
        boolean showEco = prefs.getBoolean(AbstractVenteArticleItemTable.SHOW_ECO_CONTRIBUTION_COLUMNS, false);
        boolean showDmdAchat = prefs.getBoolean(GestionArticleGlobalPreferencePanel.ACTIVE_DEMANDE_ACHAT, false);
        boolean showDevise = prefs.getBoolean("ArticleShowDevise", false);
        this.supplierCode = prefs.getBoolean(GestionArticleGlobalPreferencePanel.SUPPLIER_PRODUCT_CODE, false);
        boolean withDeclinaison = prefs.getBoolean(GestionArticleGlobalPreferencePanel.ACTIVER_DECLINAISON, false);
        Vector<SQLTableElement> list = new Vector<SQLTableElement>();
        SQLTableElement eNiveau = new SQLTableElement(e.getTable().getField("NIVEAU")){

            @Override
            public void setValueFrom(SQLRowValues row, Object value) {
                super.setValueFrom(row, value);
            }
        };
        eNiveau.setRenderer(new NiveauTableCellRender());
        eNiveau.setEditor(new NiveauTableCellEditor());
        list.add(eNiveau);
        list.add(new SQLTableElement(e.getTable().getField("ID_STYLE")));
        SQLTableElement dmdElt = null;
        if (showDmdAchat && e.getTable().contains("ID_DEMANDE_ACHAT_ELEMENT")) {
            dmdElt = new SQLTableElement(e.getTable().getField("ID_DEMANDE_ACHAT_ELEMENT"));
            list.add(dmdElt);
        }
        if (e.getTable().contains("ID_AFFAIRE")) {
            list.add(new SQLTableElement(e.getTable().getField("ID_AFFAIRE")));
        }
        SQLTableElement tableElementCodeFournisseur = null;
        if (e.getTable().contains("ID_CODE_FOURNISSEUR") && this.supplierCode) {
            tableElementCodeFournisseur = new SQLTableElement(e.getTable().getField("ID_CODE_FOURNISSEUR"), true, true, true);
            list.add(tableElementCodeFournisseur);
        }
        if (e.getTable().contains("ID_COMPTE_PCE")) {
            list.add(new SQLTableElement(e.getTable().getField("ID_COMPTE_PCE")));
        }
        SQLTableElement tableElementArticle = new SQLTableElement(e.getTable().getField("ID_ARTICLE"), true, true, true){

            @Override
            public boolean isCellEditable(SQLRowValues vals, int rowIndex, int columnIndex) {
                boolean b = super.isCellEditable(vals, rowIndex, columnIndex);
                return b && !AbstractAchatArticleItemTable.this.isFromTranferred(vals) && !AbstractAchatArticleItemTable.this.isLotLinked(vals);
            }
        };
        list.add(tableElementArticle);
        SQLTableElement tableElementDepot = new SQLTableElement(e.getTable().getField("ID_DEPOT_STOCK"), true, true, true);
        list.add(tableElementDepot);
        Set<String> fieldsName = e.getTable().getFieldsName();
        if (fieldsName.contains("ID_FAMILLE_ARTICLE")) {
            SQLTableElement tableFamille = new SQLTableElement(e.getTable().getField("ID_FAMILLE_ARTICLE"));
            list.add(tableFamille);
        }
        if (fieldsName.contains("ID_ECO_CONTRIBUTION")) {
            this.tableElementEcoID = new SQLTableElement(e.getTable().getField("ID_ECO_CONTRIBUTION"));
            list.add(this.tableElementEcoID);
        }
        if (fieldsName.contains("INCOTERM")) {
            SQLTableElement tableElementInco = new SQLTableElement(e.getTable().getField("INCOTERM"));
            tableElementInco.setEditable(false);
            list.add(tableElementInco);
        }
        if (fieldsName.contains("PREBILAN")) {
            SQLTableElement tableElementPre = new SQLTableElement(e.getTable().getField("PREBILAN"), BigDecimal.class);
            tableElementPre.setRenderer(new DeviseTableCellRenderer());
            list.add(tableElementPre);
        }
        SQLTableElement tableElementCode = new SQLTableElement(e.getTable().getField("CODE"), String.class, new ITextArticleWithCompletionCellEditor(e.getTable().getTable("ARTICLE"), e.getTable().getTable("ARTICLE_FOURNISSEUR"), withDeclinaison)){

            @Override
            public boolean isCellEditable(SQLRowValues vals, int rowIndex, int columnIndex) {
                boolean b = super.isCellEditable(vals, rowIndex, columnIndex);
                return b && !AbstractAchatArticleItemTable.this.isFromTranferred(vals) && !AbstractAchatArticleItemTable.this.isLotLinked(vals);
            }
        };
        list.add(tableElementCode);
        SQLTableElement tableElementNom = new SQLTableElement(e.getTable().getField("NOM")){

            @Override
            public boolean isCellEditable(SQLRowValues vals, int rowIndex, int columnIndex) {
                boolean b = super.isCellEditable(vals, rowIndex, columnIndex);
                return b && !AbstractAchatArticleItemTable.this.isFromTranferred(vals) && !AbstractAchatArticleItemTable.this.isLotLinked(vals);
            }
        };
        list.add(tableElementNom);
        ArrayList<String> fieldDecl = new ArrayList<String>();
        if (withDeclinaison) {
            for (String string : fieldsName) {
                if (!string.startsWith("ID_ARTICLE_DECLINAISON")) continue;
                SQLTableElement tableElementDeclinaison = new SQLTableElement(e.getTable().getField(string));
                tableElementDeclinaison.setEditable(false);
                fieldDecl.add(string);
                list.add(tableElementDeclinaison);
            }
        }
        if (fieldsName.contains("DESCRIPTIF")) {
            SQLTableElement tableElementDesc = new SQLTableElement(e.getTable().getField("DESCRIPTIF"));
            list.add(tableElementDesc);
        }
        if (fieldsName.contains("COLORIS")) {
            SQLTableElement tableElementColoris = new SQLTableElement(e.getTable().getField("COLORIS"));
            list.add(tableElementColoris);
        }
        if (fieldsName.contains("ID_FABRICANT")) {
            SQLTableElement fab = new SQLTableElement(e.getTable().getField("ID_FABRICANT"));
            list.add(fab);
        }
        SQLTableElement tableElement_ValeurMetrique2 = new SQLTableElement(e.getTable().getField("VALEUR_METRIQUE_2"), Float.class);
        list.add(tableElement_ValeurMetrique2);
        SQLTableElement tableElement_ValeurMetrique3 = new SQLTableElement(e.getTable().getField("VALEUR_METRIQUE_3"), Float.class);
        list.add(tableElement_ValeurMetrique3);
        SQLTableElement tableElement_ValeurMetrique1 = new SQLTableElement(e.getTable().getField("VALEUR_METRIQUE_1"), Float.class);
        list.add(tableElement_ValeurMetrique1);
        final DeviseNumericHTConvertorCellEditor editorPAHT = new DeviseNumericHTConvertorCellEditor(e.getTable().getField("PRIX_METRIQUE_HA_1"));
        SQLTableElement tableElement_PrixMetrique1_AchatHT = new SQLTableElement(e.getTable().getField("PRIX_METRIQUE_HA_1"), BigDecimal.class, editorPAHT);
        tableElement_PrixMetrique1_AchatHT.setRenderer(new CurrencyWithSymbolRenderer());
        list.add(tableElement_PrixMetrique1_AchatHT);
        if (fieldsName.contains("ECO_CONTRIBUTION")) {
            this.tableElementEco = new SQLTableElement(e.getTable().getField("ECO_CONTRIBUTION"));
            list.add(this.tableElementEco);
        }
        SQLTableElement tableElement_Devise = new SQLTableElement(e.getTable().getField("ID_DEVISE"));
        tableElement_Devise.setEditable(false);
        SQLTableElement tableElement_PA_Devise = new SQLTableElement(e.getTable().getField("PA_DEVISE"), BigDecimal.class);
        Path p = (Path)new Path(this.getSQLElement().getTable()).addForeignField("ID_DEVISE");
        tableElement_PA_Devise.setRenderer(new CurrencyWithSymbolRenderer(new FieldPath(p, "CODE")));
        if (showDevise) {
            list.add(tableElement_Devise);
            list.add(tableElement_PA_Devise);
        }
        SQLTableElement tableElement_ModeVente = new SQLTableElement(e.getTable().getField("ID_MODE_VENTE_ARTICLE"));
        list.add(tableElement_ModeVente);
        this.ha = new SQLTableElement(e.getTable().getField("PA_HT"), BigDecimal.class);
        this.ha.setRenderer(new CurrencyWithSymbolRenderer());
        list.add(this.ha);
        SQLTableElement qteU = new SQLTableElement(e.getTable().getField("QTE_UNITAIRE"), BigDecimal.class){

            @Override
            public boolean isCellEditable(SQLRowValues vals, int rowIndex, int columnIndex) {
                SQLRowAccessor row = vals.getForeign("ID_UNITE_VENTE");
                if (row != null && !row.isUndefined() && row.getBoolean("A_LA_PIECE").booleanValue()) {
                    return false;
                }
                return super.isCellEditable(vals, rowIndex, columnIndex) && !AbstractAchatArticleItemTable.this.isLotLinked(vals);
            }

            @Override
            public TableCellRenderer getTableCellRenderer() {
                return new QteUnitRowValuesRenderer();
            }

            @Override
            protected Object getDefaultNullValue() {
                return BigDecimal.ZERO;
            }
        };
        list.add(qteU);
        SQLTableElement uniteVente = new SQLTableElement(e.getTable().getField("ID_UNITE_VENTE"));
        list.add(uniteVente);
        SQLTableElement tableCmdElt = null;
        if (e.getTable().contains("ID_COMMANDE_ELEMENT")) {
            tableCmdElt = new SQLTableElement(e.getTable().getField("ID_COMMANDE_ELEMENT"));
            tableCmdElt.setRenderer(new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    SQLRowValues rowVals = AbstractAchatArticleItemTable.this.getRowValuesTable().getRowValuesTableModel().getRowValuesAt(row);
                    JLabel tableCellRendererComponent = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    tableCellRendererComponent.setText("");
                    if (rowVals.getObject("ID_COMMANDE_ELEMENT") != null && !rowVals.isForeignEmpty("ID_COMMANDE_ELEMENT")) {
                        SQLRowAccessor rowCmdItem = rowVals.getForeign("ID_COMMANDE_ELEMENT");
                        int qte = rowCmdItem.getInt("QTE");
                        BigDecimal qteU = rowCmdItem.getBigDecimal("QTE_UNITAIRE");
                        BigDecimal qteR = rowCmdItem.getBigDecimal("QTE_RECUE");
                        qteU = qteU.multiply(new BigDecimal(qte));
                        if (qteR != null) {
                            tableCellRendererComponent.setText(qteU.subtract(qteR).setScale(2, RoundingMode.HALF_UP).toString());
                        } else {
                            tableCellRendererComponent.setText(qteU.setScale(2, RoundingMode.HALF_UP).toString());
                        }
                    }
                    return tableCellRendererComponent;
                }
            });
            tableCmdElt.setEditable(false);
            list.add(tableCmdElt);
        }
        if (e.getTable().contains("ID_BON_RECEPTION_ELEMENT")) {
            SQLTableElement tableBrElt = null;
            tableBrElt = new SQLTableElement(e.getTable().getField("ID_BON_RECEPTION_ELEMENT"));
            tableBrElt.setEditable(false);
            list.add(tableBrElt);
        }
        if (fieldsName.contains("QTE_ORIGINE")) {
            SQLTableElement tableQteO = new SQLTableElement(e.getTable().getField("QTE_ORIGINE"));
            tableQteO.setEditable(false);
            list.add(tableQteO);
        }
        SQLTableElement qteElement = new SQLTableElement(e.getTable().getField("QTE"), Integer.class, new QteCellEditor()){

            @Override
            protected Object getDefaultNullValue() {
                return 0;
            }

            @Override
            public boolean isCellEditable(SQLRowValues vals, int rowIndex, int columnIndex) {
                return super.isCellEditable(vals, rowIndex, columnIndex) && !AbstractAchatArticleItemTable.this.isLotLinked(vals);
            }

            @Override
            public TableCellRenderer getTableCellRenderer() {
                if (AbstractAchatArticleItemTable.this.getSQLElement().getTable().getFieldsName().contains("QTE_ACHAT")) {
                    return new QteMultipleRowValuesRenderer();
                }
                return super.getTableCellRenderer();
            }
        };
        if (fieldsName.contains("QTE_ORIGINE")) {
            qteElement.setRenderer(new QtyRowValuesRenderer(false));
        }
        list.add(qteElement);
        this.tableElementTVA = new SQLTableElement(e.getTable().getField("ID_TAXE"));
        list.add(this.tableElementTVA);
        SQLTableElement tableElementPoids = new SQLTableElement(e.getTable().getField("POIDS"), Float.class);
        list.add(tableElementPoids);
        this.tableElementPoidsTotal = new SQLTableElement(e.getTable().getField("T_POIDS"), Float.class);
        list.add(this.tableElementPoidsTotal);
        if (e.getTable().contains("POIDS_COLIS_NET") && prefs.getBoolean(GestionArticleGlobalPreferencePanel.ITEM_PACKAGING, false)) {
            SQLTableElement tareColis = new SQLTableElement(e.getTable().getField("TARE"), BigDecimal.class){

                @Override
                public TableCellRenderer getTableCellRenderer() {
                    return new QteUnitRowValuesRenderer();
                }
            };
            list.add(tareColis);
            SQLTableElement poidsColis = new SQLTableElement(e.getTable().getField("POIDS_COLIS_NET"), BigDecimal.class){

                @Override
                public TableCellRenderer getTableCellRenderer() {
                    return new QteUnitRowValuesRenderer();
                }
            };
            list.add(poidsColis);
            SQLTableElement nbColis = new SQLTableElement(e.getTable().getField("NB_COLIS"), Integer.class);
            list.add(nbColis);
            final SQLTableElement totalPoidsColis = new SQLTableElement(e.getTable().getField("T_POIDS_COLIS_NET"), BigDecimal.class){

                @Override
                public TableCellRenderer getTableCellRenderer() {
                    return new QteUnitRowValuesRenderer();
                }
            };
            list.add(totalPoidsColis);
            poidsColis.addModificationListener(totalPoidsColis);
            nbColis.addModificationListener(totalPoidsColis);
            totalPoidsColis.setModifier(new CellDynamicModifier(){

                @Override
                public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                    BigDecimal pdsColis = row.getBigDecimal("POIDS_COLIS_NET");
                    Object o3 = row.getObject("NB_COLIS");
                    BigDecimal pdsColisTotal = BigDecimal.ZERO;
                    if (pdsColis != null && o3 != null) {
                        int nb = (Integer)o3;
                        pdsColisTotal = pdsColis.multiply(new BigDecimal(nb), DecimalUtils.HIGH_PRECISION);
                    }
                    return pdsColisTotal.setScale(totalPoidsColis.getDecimalDigits(), RoundingMode.HALF_UP);
                }
            });
            final SQLTableElement totalPoidsBrut = new SQLTableElement(e.getTable().getField("T_POIDS_BRUT"), BigDecimal.class){

                @Override
                public TableCellRenderer getTableCellRenderer() {
                    return new QteUnitRowValuesRenderer();
                }
            };
            list.add(totalPoidsBrut);
            tareColis.addModificationListener(totalPoidsBrut);
            poidsColis.addModificationListener(totalPoidsBrut);
            nbColis.addModificationListener(totalPoidsBrut);
            this.tableElementPoidsTotal.addModificationListener(totalPoidsBrut);
            totalPoidsBrut.setModifier(new CellDynamicModifier(){

                @Override
                public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                    BigDecimal tare = row.getBigDecimal("TARE");
                    int qte = row.getInt("QTE");
                    BigDecimal pdsColis = row.getBigDecimal("POIDS_COLIS_NET");
                    Object o3 = row.getObject("NB_COLIS");
                    BigDecimal pdsBrutTotal = BigDecimal.ZERO;
                    if (row.getObject("T_POIDS") != null) {
                        pdsBrutTotal = new BigDecimal(row.getFloat("T_POIDS"));
                    }
                    if (tare != null) {
                        pdsBrutTotal = pdsBrutTotal.add(tare.multiply(new BigDecimal(qte)));
                    }
                    if (pdsColis != null && o3 != null) {
                        int nb = (Integer)o3;
                        pdsBrutTotal = pdsBrutTotal.add(pdsColis.multiply(new BigDecimal(nb), DecimalUtils.HIGH_PRECISION));
                    }
                    return pdsBrutTotal.setScale(totalPoidsBrut.getDecimalDigits(), RoundingMode.HALF_UP);
                }
            });
        }
        if ((b = Boolean.valueOf(val = DefaultNXProps.getInstance().getStringProperty("ArticleService"))) != null && b.booleanValue()) {
            this.service = new SQLTableElement(e.getTable().getField("SERVICE"), Boolean.class);
            list.add(this.service);
        }
        if (showDevise) {
            this.tableElementTotalDevise = new SQLTableElement(e.getTable().getField("PA_DEVISE_T"), BigDecimal.class);
            CurrencyWithSymbolRenderer deviseTotalRenderer = new CurrencyWithSymbolRenderer(new FieldPath(p, "CODE"));
            deviseTotalRenderer.setHideZeroValue(true);
            this.tableElementTotalDevise.setRenderer(deviseTotalRenderer);
            list.add(this.tableElementTotalDevise);
        }
        SQLTableElement tableElementRemise = null;
        if (e.getTable().contains("POURCENT_REMISE")) {
            tableElementRemise = new SQLTableElement(e.getTable().getField("POURCENT_REMISE"));
            list.add(tableElementRemise);
        }
        if (fieldsName.contains("T_ECO_CONTRIBUTION")) {
            this.tableElementEcoTotal = new SQLTableElement(e.getTable().getField("T_ECO_CONTRIBUTION"));
            list.add(this.tableElementEcoTotal);
        }
        this.totalHT = new SQLTableElement(e.getTable().getField("T_PA_HT"), BigDecimal.class);
        DeviseTableCellRenderer totalRenderer = new DeviseTableCellRenderer();
        totalRenderer.setHideZeroValue(true);
        this.totalHT.setRenderer(totalRenderer);
        this.totalHT.setEditable(false);
        if (e.getTable().contains("POURCENT_REMISE") && tableElementRemise != null) {
            tableElementRemise.addModificationListener(this.totalHT);
        }
        list.add(this.totalHT);
        this.totalHA = this.totalHT;
        this.tableElementTotalTTC = new SQLTableElement(e.getTable().getField("T_PA_TTC"), BigDecimal.class);
        this.tableElementTotalTTC.setRenderer(totalRenderer);
        list.add(this.tableElementTotalTTC);
        this.defaultRowVals = new SQLRowValues(UndefinedRowValuesCache.getInstance().getDefaultRowValues(e.getTable()));
        this.defaultRowVals.put("ID_TAXE", TaxeCache.getCache().getFirstTaxeAchat().getID());
        this.defaultRowVals.put("CODE", "");
        this.defaultRowVals.put("NOM", "");
        this.defaultRowVals.put("QTE", 1);
        this.defaultRowVals.put("QTE_UNITAIRE", BigDecimal.ONE);
        this.defaultRowVals.put("ID_UNITE_VENTE", 2);
        this.defaultRowVals.put("ID_MODE_VENTE_ARTICLE", 5);
        if (e.getTable().contains("ID_DEPOT_STOCK")) {
            DefaultProps props = DefaultNXProps.getInstance();
            Integer depotDefault = props.getIntProperty("DepotStockDefault", DepotStockSQLElement.DEFAULT_ID);
            this.defaultRowVals.put("ID_DEPOT_STOCK", depotDefault);
        }
        RowValuesTableModel model = new RowValuesTableModel(e, list, e.getTable().getField("QTE"), false, this.defaultRowVals){

            @Override
            public void commitData() throws SQLException {
                this.commitData(true);
            }

            @Override
            public void commitData(boolean useMultipleInsertUpdate) throws SQLException {
                super.commitData(useMultipleInsertUpdate);
                if (this.getSQLElement().getTable().getName().equalsIgnoreCase("BON_RECEPTION_ELEMENT")) {
                    this.getSQLElement().getDirectory().getElement(LotSQLElement.class).updateLotQuantiteFromBRItems(this.getCopyOfValues());
                }
            }

            @Override
            public List<SQLRowValues> fetchDataFromDB(SQLRowAccessor rowVals, SQLField referentField, SQLField fieldWhere, Object value) {
                SQLTable table = this.getSQLElement().getTable();
                if (table.getName().equals("BON_RECEPTION_ELEMENT")) {
                    ArrayList<SQLRowValues> newRows = new ArrayList<SQLRowValues>();
                    SQLRowValues rowValsBrItem = new SQLRowValues(table);
                    rowValsBrItem.putNulls(table.getFieldsName());
                    SQLTable tableLotR = table.getTable("LOT_RECEPTION");
                    SQLRowValues rowValsLotRecp = new SQLRowValues(tableLotR);
                    rowValsLotRecp.putNulls(rowValsLotRecp.getTable().getFieldsName());
                    rowValsLotRecp.put("ID_BON_RECEPTION_ELEMENT", (Object)rowValsBrItem);
                    List<SQLRowValues> fetch = SQLRowValuesListFetcher.create(rowValsBrItem).fetch(new Where((FieldRef)table.getField("ID_BON_RECEPTION"), "=", rowVals.getID()));
                    for (SQLRowValues row2 : fetch) {
                        if (fieldWhere != null && !CompareUtils.equals(row2.getObject(fieldWhere.getName()), value)) continue;
                        newRows.add(row2);
                    }
                    return newRows;
                }
                return super.fetchDataFromDB(rowVals, referentField, fieldWhere, value);
            }
        };
        if (this.getSQLElement().getTable().getName().equalsIgnoreCase("BON_RECEPTION_ELEMENT")) {
            model.setGestionReferentActive(true);
        }
        this.setModel(model);
        this.table = new RowValuesTable(model, this.getConfigurationFile()){

            @Override
            public synchronized ValidState getValidState() {
                LotSQLElement element;
                ValidState lotState;
                if (AbstractAchatArticleItemTable.this.getSQLElement().getTable().getName().equalsIgnoreCase("BON_RECEPTION_ELEMENT") && (lotState = (element = AbstractAchatArticleItemTable.this.getSQLElement().getDirectory().getElement(LotSQLElement.class)).getValidStateOfRowValuesTable(AbstractAchatArticleItemTable.this.getRowValuesTable().getRowValuesTableModel(), LotSQLElement.TypeLot.RECEPTION)) != ValidState.getTrueInstance()) {
                    return lotState;
                }
                return super.getValidState();
            }
        };
        ToolTipManager.sharedInstance().unregisterComponent(this.table);
        ToolTipManager.sharedInstance().unregisterComponent(this.table.getTableHeader());
        if (this.getSQLElement().getTable().getName().equals("COMMANDE_ELEMENT")) {
            this.table.getClearCloneTableElement().add("QTE_RECUE");
            this.table.getClearCloneTableElement().add("RECU");
            this.table.getClearCloneTableElement().add("RECU_FORCED");
        } else if (this.getSQLElement().getTable().getName().equals("BON_RECEPTION_ELEMENT")) {
            this.table.getClearCloneTableElement().add("ID_COMMANDE_ELEMENT");
        } else if (this.getSQLElement().getTable().getName().equals("FACTURE_FOURNISSEUR_ELEMENT")) {
            if (this.getSQLElement().getTable().contains("ID_COMMANDE_ELEMENT")) {
                this.table.getClearCloneTableElement().add("ID_COMMANDE_ELEMENT");
            }
            if (this.getSQLElement().getTable().contains("ID_BON_RECEPTION_ELEMENT")) {
                this.table.getClearCloneTableElement().add("ID_BON_RECEPTION_ELEMENT");
            }
        }
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                this.handlePopup(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.handlePopup(e);
            }

            public void handlePopup(MouseEvent e) {
                final int rowindex = AbstractAchatArticleItemTable.this.table.getSelectedRow();
                if (rowindex < 0) {
                    return;
                }
                if (e.isPopupTrigger() && e.getComponent() instanceof JTable) {
                    JPopupMenu popup = new JPopupMenu();
                    if (prefs.getBoolean(GestionArticleGlobalPreferencePanel.CAN_EXPAND_NOMENCLATURE_HA, true)) {
                        popup.add(new AbstractAction(TranslationManager.getInstance().getTranslationForItem("product.bom.expand")){

                            @Override
                            public void actionPerformed(ActionEvent arg0) {
                                AbstractAchatArticleItemTable.this.expandNomenclature(rowindex, AbstractAchatArticleItemTable.this.m, AbstractArticleItemTable.EXPAND_TYPE.EXPAND);
                            }
                        });
                        popup.add(new AbstractAction(TranslationManager.getInstance().getTranslationForItem("product.bom.expose")){

                            @Override
                            public void actionPerformed(ActionEvent arg0) {
                                AbstractAchatArticleItemTable.this.expandNomenclature(rowindex, AbstractAchatArticleItemTable.this.m, AbstractArticleItemTable.EXPAND_TYPE.VIEW_ONLY);
                            }
                        });
                        popup.add(new AbstractAction(TranslationManager.getInstance().getTranslationForItem("product.bom.flat")){

                            @Override
                            public void actionPerformed(ActionEvent arg0) {
                                AbstractAchatArticleItemTable.this.expandNomenclature(rowindex, AbstractAchatArticleItemTable.this.m, AbstractArticleItemTable.EXPAND_TYPE.FLAT);
                            }
                        });
                    }
                    for (AbstractAction action : AbstractAchatArticleItemTable.this.getAdditionnalMouseAction(rowindex)) {
                        popup.add(action);
                    }
                    popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        if (dmdElt != null) {
            AutoCompletionManager dmd = new AutoCompletionManager(dmdElt, ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete().getField("DEMANDE_ACHAT_ELEMENT.ID"), this.table, this.table.getRowValuesTableModel(), 2, true, true, new ValidStateChecker());
            dmd.fill("ID_FAMILLE_ARTICLE", "ID_FAMILLE_ARTICLE");
        }
        ArrayList<String> completionFields = new ArrayList<String>();
        if (fieldsName.contains("INCOTERM")) {
            completionFields.add("INCOTERM");
        }
        if (fieldsName.contains("ID_ECO_CONTRIBUTION")) {
            completionFields.add("ID_ECO_CONTRIBUTION");
        }
        completionFields.add("ID_UNITE_VENTE");
        completionFields.add("QTE_UNITAIRE");
        completionFields.add("PA_HT");
        completionFields.add("PV_HT");
        completionFields.add("POIDS");
        completionFields.add("ID_TAXE");
        completionFields.add("ID_MODE_VENTE_ARTICLE");
        completionFields.add("PRIX_METRIQUE_HA_1");
        completionFields.add("PRIX_METRIQUE_HA_2");
        completionFields.add("PRIX_METRIQUE_HA_3");
        completionFields.add("VALEUR_METRIQUE_1");
        completionFields.add("VALEUR_METRIQUE_2");
        completionFields.add("VALEUR_METRIQUE_3");
        completionFields.add("PRIX_METRIQUE_VT_1");
        completionFields.add("PRIX_METRIQUE_VT_2");
        completionFields.add("PRIX_METRIQUE_VT_3");
        completionFields.add("SERVICE");
        completionFields.add("ID_DEVISE");
        completionFields.add("PA_DEVISE");
        completionFields.addAll(fieldDecl);
        if (fieldsName.contains("COLORIS")) {
            completionFields.add("COLORIS");
        }
        if (fieldsName.contains("DESCRIPTIF")) {
            completionFields.add("DESCRIPTIF");
        }
        if (fieldsName.contains("ID_FAMILLE_ARTICLE")) {
            completionFields.add("ID_FAMILLE_ARTICLE");
        }
        SQLTable sqlTableArticle = e.getTable().getTable("ARTICLE");
        if (this.getSQLElement().getTable().getFieldsName().contains("POIDS_COLIS_NET") && sqlTableArticle.getTable().getFieldsName().contains("POIDS_COLIS_NET")) {
            completionFields.add("POIDS_COLIS_NET");
        }
        if (this.getSQLElement().getTable().getFieldsName().contains("TARE") && sqlTableArticle.getTable().getFieldsName().contains("TARE")) {
            completionFields.add("TARE");
        }
        if (this.getSQLElement().getTable().getFieldsName().contains("QTE_ACHAT") && sqlTableArticle.getTable().getFieldsName().contains("QTE_ACHAT")) {
            completionFields.add("QTE_ACHAT");
        }
        this.m = new AutoCompletionManager(tableElementCode, sqlTableArticle.getField("CODE"), this.table, this.table.getRowValuesTableModel()){

            @Override
            protected Object getValueFrom(SQLRow row, String field, SQLRowAccessor rowDest) {
                Object res = AbstractAchatArticleItemTable.this.tarifCompletion(row, field);
                if (res == null) {
                    if (field.equalsIgnoreCase("ID_CODE_FOURNISSEUR")) {
                        return null;
                    }
                    return super.getValueFrom(row, field, rowDest);
                }
                return res;
            }
        };
        this.m.fill("NOM", "NOM");
        this.m.fill("ID", "ID_ARTICLE");
        if (e.getTable().contains("ID_CODE_FOURNISSEUR") && this.supplierCode) {
            this.m.fill("ID_CODE_FOURNISSEUR", "ID_CODE_FOURNISSEUR");
        }
        for (String string : completionFields) {
            this.m.fill(string, string);
        }
        Where w = new Where((FieldRef)sqlTableArticle.getField("OBSOLETE"), "=", (Object)Boolean.FALSE);
        this.m.setWhere(w);
        this.m2 = new AutoCompletionManager(tableElementNom, ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete().getField("ARTICLE.NOM"), this.table, this.table.getRowValuesTableModel()){

            @Override
            protected Object getValueFrom(SQLRow row, String field, SQLRowAccessor rowDest) {
                Object res = AbstractAchatArticleItemTable.this.tarifCompletion(row, field);
                if (res == null) {
                    return super.getValueFrom(row, field, rowDest);
                }
                return res;
            }
        };
        this.m2.fill("CODE", "CODE");
        this.m2.fill("ID", "ID_ARTICLE");
        for (String string : completionFields) {
            this.m2.fill(string, string);
        }
        this.m2.setWhere(w);
        this.m3 = new AutoCompletionManager(tableElementArticle, ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete().getField("ARTICLE.NOM"), this.table, this.table.getRowValuesTableModel(), 2, true, true, new ValidStateChecker()){

            @Override
            protected Object getValueFrom(SQLRow row, String field, SQLRowAccessor rowDest) {
                Object res = AbstractAchatArticleItemTable.this.tarifCompletion(row, field);
                if (res == null) {
                    return super.getValueFrom(row, field, rowDest);
                }
                return res;
            }
        };
        this.m3.fill("CODE", "CODE");
        this.m3.fill("NOM", "NOM");
        for (String string : completionFields) {
            this.m3.fill(string, string);
        }
        this.m3.setWhere(w);
        if (e.getTable().contains("ID_CODE_FOURNISSEUR") && this.supplierCode) {
            this.m4 = new AutoCompletionManager(tableElementCodeFournisseur, ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete().getField("ARTICLE.NOM"), this.table, this.table.getRowValuesTableModel(), 2, true, true, new ValidStateChecker()){

                @Override
                protected Object getValueFrom(SQLRow row, String field, SQLRowAccessor rowDest) {
                    Object res = AbstractAchatArticleItemTable.this.tarifCompletion(row, field);
                    if (res == null) {
                        return super.getValueFrom(row, field, rowDest);
                    }
                    return res;
                }
            };
            this.m4.fill("ID", "ID_ARTICLE");
            this.m4.fill("CODE", "CODE");
            this.m4.fill("NOM", "NOM");
            for (String string : completionFields) {
                this.m4.fill(string, string);
            }
        }
        tableElementCode.addModificationListener(tableElementArticle);
        tableElementArticle.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                try {
                    SQLRowAccessor foreign = row.getForeign("ID_ARTICLE");
                    if (foreign != null && !foreign.isUndefined() && foreign.getObject("CODE") != null && foreign.getString("CODE").equals(row.getString("CODE"))) {
                        return foreign.getID();
                    }
                    return AbstractAchatArticleItemTable.this.tableArticle.getUndefinedID();
                }
                catch (Exception e) {
                    return AbstractAchatArticleItemTable.this.tableArticle.getUndefinedID();
                }
            }
        });
        if (this.tableElementEco != null && this.tableElementEcoTotal != null && this.tableElementEcoID != null) {
            qteElement.addModificationListener(this.tableElementEcoTotal);
            this.tableElementEco.addModificationListener(this.tableElementEcoTotal);
            this.tableElementEcoTotal.setModifier(new CellDynamicModifier(){

                @Override
                public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                    int qte = Integer.parseInt(row.getObject("QTE").toString());
                    BigDecimal f = row.getObject("ECO_CONTRIBUTION") == null ? BigDecimal.ZERO : (BigDecimal)row.getObject("ECO_CONTRIBUTION");
                    return f.multiply(new BigDecimal(qte));
                }
            });
            this.tableElementEcoID.addModificationListener(this.tableElementEco);
            this.tableElementEco.setModifier(new CellDynamicModifier(){

                @Override
                public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                    if (source.equals(AbstractAchatArticleItemTable.this.tableElementEcoID)) {
                        return row.getForeign("ID_ECO_CONTRIBUTION").getBigDecimal("TAUX");
                    }
                    return row.getObject("ECO_CONTRIBUTION");
                }
            });
        }
        qteElement.addModificationListener(this.totalHT);
        qteU.addModificationListener(this.totalHT);
        this.ha.addModificationListener(this.totalHT);
        this.totalHT.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                int qte = Integer.parseInt(row.getObject("QTE").toString());
                BigDecimal f = row.getObject("PA_HT") == null ? BigDecimal.ZERO : (BigDecimal)row.getObject("PA_HT");
                BigDecimal b = row.getObject("QTE_UNITAIRE") == null ? BigDecimal.ONE : (BigDecimal)row.getObject("QTE_UNITAIRE");
                BigDecimal r = b.multiply(f.multiply(BigDecimal.valueOf(qte)), DecimalUtils.HIGH_PRECISION).setScale(AbstractAchatArticleItemTable.this.totalHT.getDecimalDigits(), 4);
                if (row.getTable().contains("POURCENT_REMISE")) {
                    BigDecimal lremise;
                    Object o2 = row.getObject("POURCENT_REMISE");
                    BigDecimal bigDecimal = lremise = o2 == null ? BigDecimal.ZERO : (BigDecimal)o2;
                    if (lremise.compareTo(BigDecimal.ZERO) >= 0 && lremise.compareTo(BigDecimal.valueOf(100L)) < 0) {
                        r = r.multiply(new BigDecimal(100).subtract(lremise).movePointLeft(2)).setScale(AbstractAchatArticleItemTable.this.totalHT.getDecimalDigits(), 4);
                    }
                }
                return r;
            }
        });
        if (showDevise) {
            if (tableElement_PA_Devise != null) {
                tableElement_PA_Devise.addModificationListener(tableElement_PrixMetrique1_AchatHT);
            }
            if (tableElement_PA_Devise != null) {
                tableElement_PrixMetrique1_AchatHT.addModificationListener(tableElement_PA_Devise);
                tableElement_PA_Devise.setModifier(new CellDynamicModifier(){

                    @Override
                    public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                        if (source != null && source.getField().getName().equals("PA_DEVISE")) {
                            return row.getObject("PA_DEVISE");
                        }
                        if (row.contains("ID_DEVISE") && !row.isForeignEmpty("ID_DEVISE")) {
                            String devCode = row.getForeign("ID_DEVISE").getString("CODE");
                            BigDecimal bigDecimal = (BigDecimal)row.getObject("PRIX_METRIQUE_HA_1");
                            CurrencyConverter c = new CurrencyConverter();
                            BigDecimal result = AbstractAchatArticleItemTable.this.convert(bigDecimal, devCode, true);
                            if (result == null) {
                                JOptionPane.showMessageDialog(AbstractAchatArticleItemTable.this, "Unable to convert " + bigDecimal + " from " + c.getCompanyCurrencyCode() + " to " + devCode);
                                return BigDecimal.ZERO;
                            }
                            return result;
                        }
                        if (source != null && source.getField().getName().equalsIgnoreCase("PRIX_METRIQUE_HA_1")) {
                            return row.getObject("PRIX_METRIQUE_HA_1");
                        }
                        return row.getObject("PA_DEVISE");
                    }
                });
            }
            qteElement.addModificationListener(this.tableElementTotalDevise);
            qteU.addModificationListener(this.tableElementTotalDevise);
            tableElement_PA_Devise.addModificationListener(this.tableElementTotalDevise);
            if (e.getTable().contains("POURCENT_REMISE") && tableElementRemise != null) {
                tableElementRemise.addModificationListener(this.tableElementTotalDevise);
            }
            this.tableElementTotalDevise.setModifier(new CellDynamicModifier(){

                @Override
                public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                    int qte = Integer.parseInt(row.getObject("QTE").toString());
                    BigDecimal f = (BigDecimal)row.getObject("PA_DEVISE");
                    BigDecimal b = row.getObject("QTE_UNITAIRE") == null ? BigDecimal.ONE : (BigDecimal)row.getObject("QTE_UNITAIRE");
                    BigDecimal r = b.multiply(f.multiply(BigDecimal.valueOf(qte)), DecimalUtils.HIGH_PRECISION).setScale(AbstractAchatArticleItemTable.this.tableElementTotalDevise.getDecimalDigits(), 4);
                    if (row.getTable().contains("POURCENT_REMISE")) {
                        BigDecimal lremise;
                        Object o2 = row.getObject("POURCENT_REMISE");
                        BigDecimal bigDecimal = lremise = o2 == null ? BigDecimal.ZERO : (BigDecimal)o2;
                        if (lremise.compareTo(BigDecimal.ZERO) >= 0 && lremise.compareTo(BigDecimal.valueOf(100L)) < 0) {
                            r = r.multiply(new BigDecimal(100).subtract(lremise).movePointLeft(2)).setScale(AbstractAchatArticleItemTable.this.tableElementTotalDevise.getDecimalDigits(), 4);
                        }
                    }
                    return r;
                }
            });
        }
        qteElement.addModificationListener(this.tableElementTotalTTC);
        qteU.addModificationListener(this.tableElementTotalTTC);
        this.ha.addModificationListener(this.tableElementTotalTTC);
        this.tableElementTVA.addModificationListener(this.tableElementTotalTTC);
        this.tableElementTotalTTC.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                int qte = Integer.parseInt(row.getObject("QTE").toString());
                BigDecimal f = (BigDecimal)row.getObject("PA_HT");
                int idTaux = Integer.parseInt(row.getObject("ID_TAXE").toString());
                Float resultTaux = TaxeCache.getCache().getTauxFromId(idTaux);
                if (resultTaux == null) {
                    SQLRow rowTax = TaxeCache.getCache().getFirstTaxe();
                    row.put("ID_TAXE", rowTax.getID());
                    resultTaux = Float.valueOf(rowTax.getFloat("TAUX"));
                }
                editorPAHT.setTaxe(resultTaux.floatValue());
                BigDecimal b = row.getObject("QTE_UNITAIRE") == null ? BigDecimal.ONE : (BigDecimal)row.getObject("QTE_UNITAIRE");
                BigDecimal r = b.multiply(f.multiply(BigDecimal.valueOf(qte), DecimalUtils.HIGH_PRECISION), DecimalUtils.HIGH_PRECISION).setScale(AbstractAchatArticleItemTable.this.tableElementTotalTTC.getDecimalDigits(), 4);
                float taux = resultTaux == null ? 0.0f : resultTaux.floatValue();
                BigDecimal total = r.multiply(BigDecimal.ONE.add(new BigDecimal(taux / 100.0f))).setScale(AbstractAchatArticleItemTable.this.tableElementTotalTTC.getDecimalDigits(), RoundingMode.HALF_UP);
                return total;
            }
        });
        this.table.readState();
        String valModeAvanceVt = DefaultNXProps.getInstance().getStringProperty("ArticleModeVenteAvance");
        Boolean bModeAvance = Boolean.valueOf(valModeAvanceVt);
        boolean view = bModeAvance == null || bModeAvance != false;
        this.setColumnVisible(model.getColumnForField("VALEUR_METRIQUE_1"), view);
        this.setColumnVisible(model.getColumnForField("VALEUR_METRIQUE_2"), view);
        this.setColumnVisible(model.getColumnForField("VALEUR_METRIQUE_3"), view);
        this.setColumnVisible(model.getColumnForField("PRIX_METRIQUE_VT_1"), view);
        this.setColumnVisible(model.getColumnForField("ID_MODE_VENTE_ARTICLE"), view);
        this.setColumnVisible(model.getColumnForField("PA_HT"), view);
        if (e.getTable().contains("ID_COMMANDE_ELEMENT")) {
            this.setColumnVisible(model.getColumnForField("ID_COMMANDE_ELEMENT"), false);
        }
        if (e.getTable().contains("ID_BON_RECEPTION_ELEMENT")) {
            this.setColumnVisible(model.getColumnForField("ID_BON_RECEPTION_ELEMENT"), false);
        }
        boolean gestionUV = prefs.getBoolean(GestionArticleGlobalPreferencePanel.UNITE_VENTE, true);
        this.setColumnVisible(model.getColumnForField("QTE_UNITAIRE"), gestionUV);
        this.setColumnVisible(model.getColumnForField("ID_UNITE_VENTE"), gestionUV);
        this.setColumnVisible(model.getColumnForField("ID_STYLE"), DefaultNXProps.getInstance().getBooleanValue("ArticleShowStyle", true));
        if (this.tableElementEco != null && this.tableElementEcoTotal != null && this.tableElementEcoID != null) {
            this.setColumnVisible(model.getColumnForField("ID_ECO_CONTRIBUTION"), showEco);
            this.setColumnVisible(model.getColumnForField("ECO_CONTRIBUTION"), showEco);
            this.setColumnVisible(model.getColumnForField("T_ECO_CONTRIBUTION"), showEco);
        }
        this.setColumnVisible(model.getColumnForField("ID_ARTICLE"), selectArticle);
        this.setColumnVisible(model.getColumnForField("CODE"), !selectArticle || selectArticle && createAuto);
        this.setColumnVisible(model.getColumnForField("NOM"), !selectArticle || selectArticle && createAuto);
        this.setColumnVisible(model.getColumnForField("ID_DEPOT_STOCK"), prefs.getBoolean(GestionArticleGlobalPreferencePanel.STOCK_MULTI_DEPOT, false));
        this.setColumnVisible(model.getColumnForField("T_POIDS_COLIS_NET"), false);
        this.setColumnVisible(model.getColumnForField("T_POIDS_BRUT"), false);
        tableElement_ValeurMetrique1.addModificationListener(tableElementPoids);
        tableElement_ValeurMetrique2.addModificationListener(tableElementPoids);
        tableElement_ValeurMetrique3.addModificationListener(tableElementPoids);
        tableElementPoids.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                return new Float(ReferenceArticleSQLElement.getPoidsFromDetails(row));
            }
        });
        tableElementPoids.addModificationListener(this.tableElementPoidsTotal);
        qteElement.addModificationListener(this.tableElementPoidsTotal);
        qteU.addModificationListener(this.tableElementPoidsTotal);
        this.tableElementPoidsTotal.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                Integer f = row.getObject("POIDS") == null ? (Number)0 : (Number)((Number)row.getObject("POIDS"));
                int qte = Integer.parseInt(row.getObject("QTE").toString());
                BigDecimal b = row.getObject("QTE_UNITAIRE") == null ? BigDecimal.ONE : (BigDecimal)row.getObject("QTE_UNITAIRE");
                return Float.valueOf(b.multiply(new BigDecimal(((Number)f).floatValue() * (float)qte)).floatValue());
            }
        });
        tableElement_PrixMetrique1_AchatHT.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                if (source != null && source.getField().getName().equals("PRIX_METRIQUE_HA_1")) {
                    return row.getObject("PRIX_METRIQUE_HA_1");
                }
                if (source != null && source.getField().getName().equals("PA_DEVISE")) {
                    if (row.contains("ID_DEVISE") && !row.isForeignEmpty("ID_DEVISE")) {
                        String devCode = row.getForeign("ID_DEVISE").getString("CODE");
                        BigDecimal bigDecimal = (BigDecimal)row.getObject("PA_DEVISE");
                        return AbstractAchatArticleItemTable.this.convert(bigDecimal, devCode, false);
                    }
                    return row.getObject("PRIX_METRIQUE_HA_1");
                }
                return row.getObject("PRIX_METRIQUE_HA_1");
            }
        });
        tableElement_ValeurMetrique1.addModificationListener(this.ha);
        tableElement_ValeurMetrique2.addModificationListener(this.ha);
        tableElement_ValeurMetrique3.addModificationListener(this.ha);
        tableElement_PrixMetrique1_AchatHT.addModificationListener(this.ha);
        this.ha.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                if (row.isForeignEmpty("ID_MODE_VENTE_ARTICLE") || row.getInt("ID_MODE_VENTE_ARTICLE") == 5) {
                    return row.getObject("PRIX_METRIQUE_HA_1");
                }
                BigDecimal prixHAFromDetails = ReferenceArticleSQLElement.getPrixHAFromDetails(row);
                return prixHAFromDetails.setScale(AbstractAchatArticleItemTable.this.ha.getDecimalDigits(), RoundingMode.HALF_UP);
            }
        });
        uniteVente.addModificationListener(qteU);
        qteU.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                SQLRowAccessor rowUnite = row.getForeign("ID_UNITE_VENTE");
                if (rowUnite != null && !rowUnite.isUndefined() && rowUnite.getBoolean("A_LA_PIECE").booleanValue()) {
                    return BigDecimal.ONE;
                }
                return row.getObject("QTE_UNITAIRE");
            }
        });
        this.setColumnVisible(model.getColumnIndexForElement(tableElement_Devise), false);
        for (String string : visibilityMap.keySet()) {
            this.setColumnVisible(model.getColumnForField(string), visibilityMap.get(string));
        }
        final BarcodeReader barcodeReader = ComptaPropsConfiguration.getInstanceCompta().getBarcodeReader();
        if (barcodeReader != null) {
            final BarcodeListener l = new BarcodeListener(){

                @Override
                public void keyReceived(KeyEvent ee) {
                }

                @Override
                public void barcodeRead(String code) {
                    if (((JFrame)SwingUtilities.getRoot(AbstractAchatArticleItemTable.this.getRowValuesTable())).isActive()) {
                        SQLSelect selArticle = new SQLSelect();
                        SQLTable tableArticle = AbstractAchatArticleItemTable.this.getSQLElement().getForeignElement("ID_ARTICLE").getTable();
                        selArticle.addSelectStar(tableArticle);
                        Where w = new Where((FieldRef)tableArticle.getField("OBSOLETE"), "=", (Object)Boolean.FALSE);
                        w = w.and(new Where((FieldRef)tableArticle.getField("CODE_BARRE"), "=", (Object)code));
                        selArticle.setWhere(w);
                        List<SQLRow> l2 = SQLRowListRSH.execute(selArticle);
                        if (l2.size() > 0) {
                            System.err.println("ARTICLE " + l2.get(0).getString("NOM"));
                            Tuple3<Double, String, String> art = Tuple3.create(1.0, l2.get(0).getString("CODE"), l2.get(0).getString("NOM"));
                            ArrayList<Tuple3<Double, String, String>> l = new ArrayList<Tuple3<Double, String, String>>();
                            l.add(art);
                            AbstractAchatArticleItemTable.this.insertFromDrop(l, AbstractAchatArticleItemTable.this.m);
                        } else {
                            System.err.println("ARTICLE NOT FOUND !");
                        }
                    }
                }
            };
            this.getRowValuesTable().addHierarchyListener(new HierarchyListener(){

                @Override
                public void hierarchyChanged(HierarchyEvent e) {
                    if ((e.getChangeFlags() & 2L) != 0L) {
                        if (AbstractAchatArticleItemTable.this.getRowValuesTable().isDisplayable()) {
                            barcodeReader.addBarcodeListener(l);
                        } else {
                            barcodeReader.removeBarcodeListener(l);
                        }
                    }
                }
            });
        }
        this.table.writeState();
        if (this.table.getRowValuesTableModel().getColumnForField("ID_DEPOT_STOCK") >= 0 && this.table.getRowValuesTableModel().getColumnForField("ID_ARTICLE") >= 0) {
            if (this.buttons == null) {
                this.buttons = new ArrayList();
            }
            JButton buttonStock = new JButton("Consulter le stock");
            buttonStock.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    try {
                        SQLRowAccessor rowValsStock;
                        SQLRowAccessor foreignArt;
                        SQLRowValues rowValsSel = AbstractAchatArticleItemTable.this.table.getSelectedRowValues();
                        if (rowValsSel != null && (foreignArt = rowValsSel.getForeign("ID_ARTICLE")) != null && !foreignArt.isUndefined() && (rowValsStock = StockSQLElement.getStock(rowValsSel)) != null && !rowValsStock.isUndefined()) {
                            EditFrame frame = new EditFrame(AbstractAchatArticleItemTable.this.table.getRowValuesTableModel().getSQLElement().getDirectory().getElement("STOCK"), EditPanel.EditMode.READONLY);
                            frame.selectionId(rowValsStock.getID());
                            frame.setVisible(true);
                        }
                    }
                    catch (Exception e) {
                        ExceptionHandler.handle("Erreur d'acc\u00e8s au stock", e);
                    }
                }
            });
            this.buttons.add(buttonStock);
        }
    }

    public static Map<String, Boolean> getVisibilityMap() {
        return visibilityMap;
    }

    public void setIncoterms(String incoterm) {
        if (incoterm == null) {
            incoterm = "";
        }
        this.incoterm = incoterm;
    }

    public void setFournisseur(SQLRow rowFournisseur) {
        this.rowFournisseur = rowFournisseur;
        if (this.getSQLElement().getTable().contains("ID_CODE_FOURNISSEUR") && this.supplierCode) {
            if (rowFournisseur != null && !rowFournisseur.isUndefined()) {
                Where w = new Where((FieldRef)this.getSQLElement().getTable().getTable("CODE_FOURNISSEUR").getField("ID_FOURNISSEUR"), "=", rowFournisseur.getID());
                this.m4.setWhere(w);
            } else {
                this.m4.setWhere(null);
            }
        }
    }

    private BigDecimal getPrice(SQLRowAccessor r, List<String> list) {
        BigDecimal result = r.getBigDecimal(list.get(0));
        int i = 1;
        while (i < list.size()) {
            BigDecimal m0 = r.getBigDecimal(list.get(i));
            if (m0 != null && m0.floatValue() > 0.0f) {
                result = result.divide(m0, 2, RoundingMode.HALF_UP);
            }
            ++i;
        }
        return result;
    }

    public Object tarifCompletion(SQLRow row, String field) {
        SQLTable tTarifFournisseur = this.getSQLElement().getTable().getDBRoot().getTable("ARTICLE_TARIF_FOURNISSEUR");
        if (row != null && !row.isUndefined() && field.equalsIgnoreCase("ID_CODE_FOURNISSEUR") && this.rowFournisseur != null && !this.rowFournisseur.isUndefined()) {
            SQLTable foreignTableCodeF = this.getSQLElement().getTable().getForeignTable("ID_CODE_FOURNISSEUR");
            Collection resultCode = row.getReferentRows(foreignTableCodeF);
            for (SQLRow sqlRow : resultCode) {
                if (sqlRow.getForeignID("ID_FOURNISSEUR") != this.rowFournisseur.getID()) continue;
                return sqlRow.getID();
            }
            return foreignTableCodeF.getUndefinedIDNumber();
        }
        if (field.equalsIgnoreCase("ID_CODE_FOURNISSEUR")) {
            SQLTable foreignTableCodeF = this.getSQLElement().getTable().getForeignTable("ID_CODE_FOURNISSEUR");
            return foreignTableCodeF.getUndefinedIDNumber();
        }
        if (row != null && !row.isUndefined() && (field.equalsIgnoreCase("PRIX_METRIQUE_HA_1") || field.equalsIgnoreCase("PA_HT")) && tTarifFournisseur != null) {
            List<Object> rows;
            List<String> incoTerms = this.incoterm != null && this.incoterm.equalsIgnoreCase("CPT") ? Arrays.asList("PRIX_ACHAT", "COEF_TRANSPORT_PORT") : (this.incoterm != null && this.incoterm.equalsIgnoreCase("DDP") ? Arrays.asList("PRIX_ACHAT", "COEF_TRANSPORT_PORT", "COEF_TAXE_D") : Arrays.asList("PRIX_ACHAT"));
            if (this.rowFournisseur != null && !this.rowFournisseur.isUndefined()) {
                SQLRowValues rowValsTarif = new SQLRowValues(tTarifFournisseur);
                rowValsTarif.putNulls(tTarifFournisseur.getFieldsName());
                Where where = new Where((FieldRef)tTarifFournisseur.getField("ID_FOURNISSEUR"), "=", this.rowFournisseur.getID()).and(new Where((FieldRef)tTarifFournisseur.getField("ID_ARTICLE"), "=", row.getID()));
                rows = SQLRowValuesListFetcher.create(rowValsTarif).fetch(where);
                if (rows.isEmpty() && row.getObject("ID_ARTICLE_VIRTUEL_PERE") != null && !row.isForeignEmpty("ID_ARTICLE_VIRTUEL_PERE")) {
                    Where where2 = new Where((FieldRef)tTarifFournisseur.getField("ID_FOURNISSEUR"), "=", this.rowFournisseur.getID()).and(new Where((FieldRef)tTarifFournisseur.getField("ID_ARTICLE"), "=", row.getForeignID("ID_ARTICLE_VIRTUEL_PERE")));
                    rows = SQLRowValuesListFetcher.create(rowValsTarif).fetch(where2);
                }
            } else {
                rows = Collections.emptyList();
            }
            if (row.getBoolean("AUTO_PRIX_ACHAT_NOMENCLATURE").booleanValue() && row.getTable().getDBRoot().contains("ARTICLE_PRIX_REVIENT")) {
                Collection rowsElt = row.getReferentRows(row.getTable().getTable("ARTICLE_ELEMENT").getField("ID_ARTICLE_PARENT"));
                BigDecimal price = BigDecimal.ZERO;
                final HashSet<String> hashSet = new HashSet<String>();
                for (SQLRow sqlRow : rowsElt) {
                    Collection rowsT = sqlRow.getForeign("ID_ARTICLE").getReferentRows(tTarifFournisseur);
                    boolean priceFound = false;
                    boolean tarifFound = false;
                    if (rowsT.size() > 0) {
                        BigDecimal min = BigDecimal.ZERO;
                        BigDecimal defaultPrice = sqlRow.getForeign("ID_ARTICLE").getBigDecimal("PRIX_METRIQUE_HA_1");
                        Calendar c = null;
                        for (SQLRow sqlRowT : rowsT) {
                            BigDecimal priceT;
                            if (this.rowFournisseur == null || this.rowFournisseur.getID() != sqlRowT.getForeignID("ID_FOURNISSEUR")) continue;
                            defaultPrice = priceT = this.getPrice(sqlRowT, incoTerms);
                            Calendar datePrice = sqlRowT.getDate("DATE_PRIX");
                            datePrice.set(10, 0);
                            datePrice.set(12, 0);
                            datePrice.set(13, 0);
                            datePrice.set(14, 0);
                            if (datePrice == null || this.getDateDevise() != null && !this.getDateDevise().before(datePrice.getTime())) {
                                if (c == null || c.before(datePrice)) {
                                    min = priceT;
                                    c = datePrice;
                                    priceFound = true;
                                } else if (c != null) {
                                    defaultPrice = priceT;
                                }
                            }
                            tarifFound = true;
                        }
                        price = priceFound ? price.add(min.multiply(sqlRow.getBigDecimal("QTE_UNITAIRE").multiply(new BigDecimal(sqlRow.getInt("QTE"), DecimalUtils.HIGH_PRECISION)))) : price.add(defaultPrice.multiply(sqlRow.getBigDecimal("QTE_UNITAIRE").multiply(new BigDecimal(sqlRow.getInt("QTE"), DecimalUtils.HIGH_PRECISION))));
                    }
                    if (tarifFound) continue;
                    hashSet.add(sqlRow.getForeign("ID_ARTICLE").getString("CODE"));
                }
                if (!hashSet.isEmpty()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JOptionPane.showMessageDialog(AbstractAchatArticleItemTable.this.table, "Attention, impossible de calculer le tarif.\nLes articles suivants n'ont pas de tarif associ\u00e9 :\n" + hashSet);
                        }
                    });
                }
                return price;
            }
            if (!rows.isEmpty()) {
                BigDecimal min = row.getBigDecimal("PRIX_METRIQUE_HA_1");
                Calendar c = null;
                for (SQLRowValues sQLRowValues : rows) {
                    if (this.rowFournisseur == null || this.rowFournisseur.getID() != sQLRowValues.getForeignID("ID_FOURNISSEUR")) continue;
                    BigDecimal price = this.getPrice(sQLRowValues, incoTerms);
                    Calendar datePrice = sQLRowValues.getDate("DATE_PRIX");
                    if (datePrice != null && (this.getDateDevise() == null || this.getDateDevise().before(datePrice.getTime())) || c != null && !c.before(datePrice)) continue;
                    min = price;
                    c = datePrice;
                }
                return min.setScale(2, RoundingMode.HALF_UP);
            }
        }
        if (field.equalsIgnoreCase("INCOTERM")) {
            return this.incoterm;
        }
        if (this.getDevise() != null && !this.getDevise().isUndefined()) {
            if (field.equalsIgnoreCase("ID_DEVISE") || field.equalsIgnoreCase("ID_DEVISE_HA")) {
                return this.getDevise().getID();
            }
            if (field.equalsIgnoreCase("PA_DEVISE")) {
                if (row.getBigDecimal("PA_DEVISE") != null && row.getBigDecimal("PA_DEVISE").signum() != 0 && this.incoterm.length() == 0) {
                    return row.getBigDecimal("PA_DEVISE");
                }
                String devCode = this.getDevise().getString("CODE");
                BigDecimal tarifCompletion = (BigDecimal)this.tarifCompletion(row, "PRIX_METRIQUE_HA_1");
                if (tarifCompletion == null) {
                    tarifCompletion = row.getBigDecimal("PRIX_METRIQUE_HA_1");
                }
                if (tarifCompletion == null) {
                    return null;
                }
                return this.convert(tarifCompletion, devCode, true);
            }
        } else {
            if (field.equalsIgnoreCase("ID_DEVISE") || field.equalsIgnoreCase("ID_DEVISE_HA")) {
                return Configuration.getInstance().getDirectory().getElement("DEVISE").getTable().getUndefinedID();
            }
            if (field.equalsIgnoreCase("PA_DEVISE")) {
                return BigDecimal.ZERO;
            }
        }
        if (field.equalsIgnoreCase("ID_TAXE") && this.rowCatComptable != null) {
            return this.rowCatComptable.getForeignID("ID_TAXE_VENTE");
        }
        return null;
    }

    @Override
    protected void refreshDeviseAmount() {
        int count = this.getRowValuesTable().getRowCount();
        int columnForField = this.getRowValuesTable().getRowValuesTableModel().getColumnForField("PA_DEVISE");
        if (columnForField >= 0) {
            SQLTableElement eltDevise = this.getRowValuesTable().getRowValuesTableModel().getSQLTableElementAt(columnForField);
            int i = 0;
            while (i < count) {
                SQLRowValues rowVals = this.getRowValuesTable().getRowValuesTableModel().getRowValuesAt(i);
                eltDevise.setValueFrom(rowVals, rowVals.getObject("PA_DEVISE"));
                this.getRowValuesTable().getRowValuesTableModel().fireTableChanged(new TableModelEvent(this.getRowValuesTable().getRowValuesTableModel(), i, i, columnForField));
                ++i;
            }
        }
    }

    public SQLRowAccessor getDevise() {
        return this.rowDevise;
    }

    public void setDevise(SQLRowAccessor deviseRow) {
        this.rowDevise = deviseRow;
        if (deviseRow == null) {
            this.getDefaultRowValues().put("ID_DEVISE", null);
        } else {
            this.getDefaultRowValues().put("ID_DEVISE", this.rowDevise.getID());
        }
    }

    public void setTauxConversion(BigDecimal tauxConversion) {
        if (tauxConversion != null && tauxConversion.signum() == 0) {
            tauxConversion = null;
        }
        this.tauxConversion = tauxConversion;
        this.refreshDeviseAmount();
    }

    public BigDecimal convert(BigDecimal val, String devCode, boolean fromCompanyCurrency) {
        if (val == null) {
            return val;
        }
        if (this.tauxConversion == null) {
            CurrencyConverter c = new CurrencyConverter();
            if (fromCompanyCurrency) {
                return c.convert(val, c.getCompanyCurrencyCode(), devCode, this.getDateDevise(), this.isUsedBiasedDevise());
            }
            return c.convert(val, devCode, c.getCompanyCurrencyCode(), this.getDateDevise(), this.isUsedBiasedDevise());
        }
        if (fromCompanyCurrency) {
            return val.divide(this.tauxConversion, DecimalUtils.HIGH_PRECISION).setScale(val.scale(), RoundingMode.HALF_UP);
        }
        return val.multiply(this.tauxConversion, DecimalUtils.HIGH_PRECISION).setScale(val.scale(), RoundingMode.HALF_UP);
    }

    public void setFournisseurFilterOnCompletion(SQLRow row) {
        SQLTable sqlTableArticle = ((ComptaPropsConfiguration)Configuration.getInstance()).getRootSociete().getTable("ARTICLE");
        Where w = new Where((FieldRef)sqlTableArticle.getField("OBSOLETE"), "=", (Object)Boolean.FALSE);
        if (row != null && !row.isUndefined()) {
            w = w.and(new Where((FieldRef)this.tableArticle.getField("ID_FOURNISSEUR"), "=", row.getID()));
        }
        this.m.setWhere(w);
        this.m2.setWhere(w);
        this.m3.setWhere(w);
    }

    private void insertFromDrop(List<Tuple3<Double, String, String>> articles, AutoCompletionManager m) {
        ArrayList<String> code = new ArrayList<String>(articles.size());
        int i = articles.size() - 1;
        while (i >= 0) {
            Tuple3<Double, String, String> tuple = articles.get(i);
            code.add((String)tuple.get1());
            --i;
        }
        int rowCount = this.getRowValuesTable().getRowValuesTableModel().getRowCount();
        HashMap<Integer, Integer> mapRows = new HashMap<Integer, Integer>();
        int i2 = 0;
        while (i2 < rowCount) {
            SQLRowValues rowVals = this.getRowValuesTable().getRowValuesTableModel().getRowValuesAt(i2);
            if (rowVals.getObject("ID_ARTICLE") != null && !rowVals.isForeignEmpty("ID_ARTICLE")) {
                mapRows.put(rowVals.getForeignID("ID_ARTICLE"), i2);
            }
            ++i2;
        }
        SQLSelect sel = new SQLSelect();
        SQLTable articleTable = this.getSQLElement().getTable().getForeignTable("ID_ARTICLE");
        sel.addSelectStar(articleTable);
        sel.setWhere(new Where(articleTable.getField("CODE"), code));
        List<SQLRow> matchCode = SQLRowListRSH.execute(sel);
        HashMap<String, SQLRow> mapCode = new HashMap<String, SQLRow>();
        for (SQLRow sqlRow : matchCode) {
            mapCode.put(sqlRow.getString("CODE"), sqlRow);
        }
        Set<String> fieldsFrom = m.getFieldsFrom();
        fieldsFrom.remove("POURCENT_REMISE");
        int i3 = articles.size() - 1;
        while (i3 >= 0) {
            Tuple3<Double, String, String> tuple = articles.get(i3);
            SQLRow article = (SQLRow)mapCode.get(tuple.get1());
            if (article != null && mapRows.containsKey(article.getID())) {
                Integer index = (Integer)mapRows.get(article.getID());
                SQLRowValues rowVals = this.getRowValuesTable().getRowValuesTableModel().getRowValuesAt(index);
                this.getRowValuesTable().getRowValuesTableModel().putValue(rowVals.getInt("QTE") + 1, index, "QTE");
            } else {
                SQLRowValues row2Insert = new SQLRowValues(this.getRowValuesTable().getRowValuesTableModel().getDefaultRowValues());
                if (article != null) {
                    m.fillRowValues(article, fieldsFrom, row2Insert);
                    row2Insert.put("ID_ARTICLE", article.getID());
                    row2Insert.put("CODE", article.getObject("CODE"));
                    row2Insert.put("NOM", article.getObject("NOM"));
                } else {
                    row2Insert.put("CODE", tuple.get1());
                    row2Insert.put("NOM", tuple.get2());
                }
                row2Insert.put("QTE", Math.round(((Double)tuple.get0()).floatValue()));
                row2Insert.put("PA_HT", row2Insert.getObject("PRIX_METRIQUE_HA_1"));
                BigDecimal resultTotalHT = row2Insert.getBigDecimal("PA_HT").multiply(new BigDecimal(row2Insert.getInt("QTE")));
                row2Insert.put("T_PA_HT", resultTotalHT);
                Float resultTaux = TaxeCache.getCache().getTauxFromId(row2Insert.getForeignID("ID_TAXE"));
                if (resultTaux == null) {
                    SQLRow rowTax = TaxeCache.getCache().getFirstTaxeAchat();
                    resultTaux = Float.valueOf(rowTax.getFloat("TAUX"));
                }
                float taux = resultTaux == null ? 0.0f : resultTaux.floatValue();
                BigDecimal r = resultTotalHT.multiply(BigDecimal.valueOf(taux).movePointLeft(2).add(BigDecimal.ONE), DecimalUtils.HIGH_PRECISION);
                row2Insert.put("T_PA_TTC", r);
                this.getRowValuesTable().getRowValuesTableModel().addRowAt(0, row2Insert);
            }
            --i3;
        }
    }

    private boolean isFromTranferred(SQLRowValues vals) {
        for (String trField : this.trFields) {
            boolean noCmdElt;
            if (!vals.getTable().contains(trField)) continue;
            boolean bl = noCmdElt = vals.getObject(trField) == null || vals.isForeignEmpty(trField);
            if (noCmdElt) continue;
            return true;
        }
        return false;
    }

    private boolean isLotLinked(SQLRowValues vals) {
        if (vals.getTable().getName().equals("BON_RECEPTION_ELEMENT")) {
            return !vals.getReferentRows(vals.getTable().getTable("LOT_RECEPTION").getField("ID_BON_RECEPTION_ELEMENT")).isEmpty();
        }
        return false;
    }
}

