/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.text;

import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.jcip.annotations.Immutable;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.text.DateProp;
import org.openconcerto.utils.text.DateTimeComponents;
import org.openconcerto.utils.text.DateTimeFormatComponent;

@Immutable
public final class DateTimeFormat
extends DateTimeComponents {
    private final List<DateTimeFormatComponent> components;

    DateTimeFormat(List<? extends DateTimeFormatComponent> components) {
        this.components = CollectionUtils.toImmutableList((Collection)Objects.requireNonNull(components));
    }

    public final List<DateTimeFormatComponent> getComponents() {
        return this.components;
    }

    public final DateTimeFormatterBuilder createJavaFormatterBuilder() {
        return DateProp.createJavaFormatterBuilder(this.getComponents());
    }

    public final DateTimeFormatter createJavaFormatter(Locale locale) {
        return this.createJavaFormatterBuilder().toFormatter(locale);
    }

    public static final class Literal
    extends DateTimeFormatComponent {
        private final String value;

        Literal(String value) {
            this.value = Objects.requireNonNull(value);
        }

        public final String getValue() {
            return this.value;
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Literal other = (Literal)obj;
            return this.value.equals(other.value);
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + ' ' + this.getValue();
        }
    }
}

