/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.doml;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.openconcerto.utils.doml.Document;

public class Element {
    private String name;
    private List<String> attributes;
    private List<Element> children;
    private static final ThreadLocal<SimpleDateFormat> DATE_FORMAT = ThreadLocal.withInitial(() -> {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return dateFormat;
    });
    private static final ThreadLocal<DecimalFormat> DOUBLE_FORMAT = ThreadLocal.withInitial(() -> {
        DecimalFormat f = new DecimalFormat("0", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        f.setMaximumFractionDigits(340);
        return f;
    });
    private static final ThreadLocal<DecimalFormat> FLOAT_FORMAT = ThreadLocal.withInitial(() -> {
        DecimalFormat f = new DecimalFormat("0", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        f.setMaximumFractionDigits(170);
        return f;
    });

    public Element(String name) {
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }
        this.name = name;
    }

    public Element(String name, int expectedAttributesCount) {
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }
        this.name = name;
        if (expectedAttributesCount > 0) {
            this.attributes = new ArrayList<String>(expectedAttributesCount * 2);
        }
    }

    public Element(String name, int expectedAttributesCount, int expecteChildrenCount) {
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }
        this.name = name;
        if (expectedAttributesCount > 0) {
            this.attributes = new ArrayList<String>(expectedAttributesCount * 2);
        }
        if (expecteChildrenCount > 0) {
            this.children = new ArrayList<Element>(expecteChildrenCount);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }
        this.name = name;
    }

    public int getAttributeCount() {
        if (this.attributes == null) {
            return 0;
        }
        return this.attributes.size() / 2;
    }

    public String getAttribute(String name) {
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }
        if (this.attributes == null) {
            return null;
        }
        int size = this.attributes.size();
        int i = 0;
        while (i < size) {
            if (this.attributes.get(i).equals(name)) {
                return this.attributes.get(i + 1);
            }
            i += 2;
        }
        return null;
    }

    public String getAttribute(String name, String defaultValue) {
        String v = this.getAttribute(name);
        if (v == null) {
            return defaultValue;
        }
        return v;
    }

    public void setAttribute(String name, String value) {
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }
        if (value == null) {
            throw new IllegalArgumentException("null value for attribute " + name);
        }
        if (this.attributes == null) {
            this.attributes = new ArrayList<String>();
        } else {
            int size = this.attributes.size();
            int i = 0;
            while (i < size) {
                if (this.attributes.get(i).equals(name)) {
                    this.attributes.set(i + 1, value);
                    return;
                }
                i += 2;
            }
        }
        this.attributes.add(name);
        this.attributes.add(value);
    }

    public Integer getAttributeAsInteger(String name) {
        String v = this.getAttribute(name);
        if (v == null) {
            return null;
        }
        return Integer.parseInt(v);
    }

    public int getAttributeAsInteger(String name, int defaultValue) {
        String v = this.getAttribute(name);
        if (v == null) {
            return defaultValue;
        }
        return Integer.parseInt(v);
    }

    public void setAttribute(String name, int value) {
        this.setAttribute(name, String.valueOf(value));
    }

    public Long getAttributeAsLong(String name) {
        String v = this.getAttribute(name);
        if (v == null) {
            return null;
        }
        return Long.parseLong(v);
    }

    public long getAttributeAsLong(String name, long defaultValue) {
        String v = this.getAttribute(name);
        if (v == null) {
            return defaultValue;
        }
        return Long.parseLong(v);
    }

    public void setAttribute(String name, long value) {
        this.setAttribute(name, String.valueOf(value));
    }

    public Float getAttributeAsFloat(String name) {
        String v = this.getAttribute(name);
        if (v == null) {
            return null;
        }
        return Float.valueOf(Element.parseFloat(v));
    }

    public float getAttributeAsFloat(String name, float defaultValue) {
        String v = this.getAttribute(name);
        if (v == null) {
            return defaultValue;
        }
        return Element.parseFloat(v);
    }

    public void setAttribute(String name, float value) {
        this.setAttribute(name, Element.floatToString(value));
    }

    public Double getAttributeAsDouble(String name) {
        String v = this.getAttribute(name);
        if (v == null) {
            return null;
        }
        return Element.parseDouble(name);
    }

    public double getAttributeAsLong(String name, double defaultValue) {
        String v = this.getAttribute(name);
        if (v == null) {
            return defaultValue;
        }
        return Element.parseDouble(name);
    }

    public void setAttribute(String name, double value) {
        this.setAttribute(name, Element.doubleToString(value));
    }

    public static String doubleToString(double d) {
        if (StrictMath.rint(d) == d && Double.isFinite(d)) {
            return Long.toString((long)d);
        }
        return DOUBLE_FORMAT.get().format(d);
    }

    private static double parseDouble(String v) {
        int length;
        boolean neg = false;
        int start = 0;
        if (v.charAt(0) == '-') {
            neg = true;
            start = 1;
        }
        double result = 0.0;
        int pointIndex = length = v.length();
        int i = start;
        while (i < length) {
            char c = v.charAt(i);
            if (c == '.') {
                pointIndex = i;
                break;
            }
            ++i;
        }
        i = start;
        while (i < pointIndex) {
            result = 10.0 * result + (double)(v.charAt(i) - 48);
            ++i;
        }
        int n = 0;
        int div = 1;
        int i2 = pointIndex + 1;
        while (i2 < length) {
            n = 10 * n + (v.charAt(i2) - 48);
            div *= 10;
            ++i2;
        }
        result += (double)n / (double)div;
        if (neg) {
            result *= -1.0;
        }
        return result;
    }

    public static String floatToString(double d) {
        if (StrictMath.rint(d) == d && Double.isFinite(d)) {
            return Long.toString((long)d);
        }
        return FLOAT_FORMAT.get().format(d);
    }

    private static float parseFloat(String v) {
        int length;
        boolean neg = false;
        int start = 0;
        if (v.charAt(0) == '-') {
            neg = true;
            start = 1;
        }
        float result = 0.0f;
        int pointIndex = length = v.length();
        int i = start;
        while (i < length) {
            char c = v.charAt(i);
            if (c == '.') {
                pointIndex = i;
                break;
            }
            ++i;
        }
        i = start;
        while (i < pointIndex) {
            result = 10.0f * result + (float)(v.charAt(i) - 48);
            ++i;
        }
        int n = 0;
        int div = 1;
        int i2 = pointIndex + 1;
        while (i2 < length) {
            n = 10 * n + (v.charAt(i2) - 48);
            div *= 10;
            ++i2;
        }
        result += (float)n / (float)div;
        if (neg) {
            result *= -1.0f;
        }
        return result;
    }

    public BigDecimal getAttributeAsBigDecimal(String name) {
        String v = this.getAttribute(name);
        if (v == null) {
            return null;
        }
        return new BigDecimal(v);
    }

    public BigDecimal getAttributeAsBigDecimal(String name, BigDecimal defaultValue) {
        String v = this.getAttribute(name);
        if (v == null) {
            return defaultValue;
        }
        return new BigDecimal(v);
    }

    public void setAttribute(String name, BigDecimal value) {
        this.setAttribute(name, String.valueOf(value));
    }

    public Boolean getAttributeAsBoolean(String name) {
        String v = this.getAttribute(name);
        if (v == null) {
            return null;
        }
        if (name.equals("true")) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public boolean getAttributeAsBoolean(String name, boolean defaultValue) {
        String v = this.getAttribute(name);
        if (v == null) {
            return defaultValue;
        }
        return name.equals("true");
    }

    public void setAttribute(String name, boolean value) {
        this.setAttribute(name, value ? "true" : "false");
    }

    public Date getAttributeAsDate(String name) {
        String v = this.getAttribute(name);
        if (v == null) {
            return null;
        }
        try {
            return DATE_FORMAT.get().parse(v);
        }
        catch (ParseException e) {
            throw new IllegalStateException("cannot parse date : '" + v + "' : " + e);
        }
    }

    public Date getAttributeAsDate(String name, Date defaultValue) {
        Date v = this.getAttributeAsDate(name);
        if (v == null) {
            return defaultValue;
        }
        return v;
    }

    public void setAttribute(String name, Date value) {
        this.setAttribute(name, value.toInstant().toString());
    }

    public Instant getAttributeAsInstant(String name) {
        String v = this.getAttribute(name);
        if (v == null) {
            return null;
        }
        return Instant.parse(v);
    }

    public void setAttribute(String name, Instant value) {
        this.setAttribute(name, value.toString());
    }

    public void addChild(Element child) {
        if (child == null) {
            throw new IllegalArgumentException("null child");
        }
        if (this.children == null) {
            this.children = new ArrayList<Element>();
        }
        this.children.add(child);
    }

    public void addChildren(List<Element> children) {
        if (children == null) {
            throw new IllegalArgumentException("null children");
        }
        if (this.children == null) {
            this.children = new ArrayList<Element>(children.size() * 2);
        }
        this.children.addAll(children);
    }

    public Element getChild(String name) {
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }
        if (this.children == null) {
            return null;
        }
        for (Element e : this.children) {
            if (!e.getName().equals(name)) continue;
            return e;
        }
        return null;
    }

    public List<Element> getChildren(String name) {
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }
        if (this.children == null) {
            return Collections.emptyList();
        }
        ArrayList<Element> result = new ArrayList<Element>();
        for (Element e : this.children) {
            if (!e.getName().equals(name)) continue;
            result.add(e);
        }
        return result;
    }

    public List<Element> getChildren() {
        if (this.children == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.children);
    }

    public boolean removeChild(String name) {
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }
        if (this.children == null) {
            return false;
        }
        int size = this.children.size();
        int i = 0;
        while (i < size) {
            if (this.children.get(i).getName().equals(name)) {
                this.children.remove(i);
                return true;
            }
            ++i;
        }
        return false;
    }

    public int getChildrenCount() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    void appendAttributes(BufferedWriter writer) throws IOException {
        if (this.attributes == null) {
            return;
        }
        int size = this.attributes.size();
        int i = 0;
        while (i < size) {
            writer.append(' ');
            writer.append(this.attributes.get(i));
            writer.append('=');
            writer.append('\"');
            writer.append(this.escapeAttributeValue(this.attributes.get(i + 1)));
            writer.append('\"');
            i += 2;
        }
    }

    void writeAttributes(BufferedOutputStream out) throws IOException {
        int size = this.attributes.size();
        int i = 0;
        while (i < size) {
            Document.writeUTF(out, this.attributes.get(i));
            Document.writeUTF(out, this.attributes.get(i + 1));
            i += 2;
        }
    }

    private String escapeAttributeValue(String string) {
        StringBuilder b = new StringBuilder(string.length());
        int length = string.length();
        int i = 0;
        while (i < length) {
            char c = string.charAt(i);
            if (c == '\n') {
                b.append('\\');
                b.append('n');
            } else if (c == '\r') {
                b.append('\\');
                b.append('r');
            } else if (c == '\t') {
                b.append('\\');
                b.append('t');
            } else if (c == '\\') {
                b.append('\\');
                b.append('\\');
            } else if (c == '\"') {
                b.append('\\');
                b.append('\"');
            } else {
                b.append(c);
            }
            ++i;
        }
        return b.toString();
    }

    void addAttributeNoCheck(String name, String value) {
        this.attributes.add(name);
        this.attributes.add(value);
    }

    void addChildNoCheck(Element child) {
        if (child == null) {
            throw new IllegalArgumentException("null child");
        }
        this.children.add(child);
    }
}

