/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.io.IOException;
import java.io.OutputStream;

public class MultipleOutputStream
extends OutputStream {
    private OutputStream[] streams;

    public MultipleOutputStream(OutputStream o1, OutputStream o2) {
        this(new OutputStream[]{o1, o2});
    }

    public MultipleOutputStream(OutputStream[] outputStreams) {
        this.streams = outputStreams;
    }

    @Override
    public void write(int b) throws IOException {
        int i = 0;
        while (i < this.streams.length) {
            this.streams[i].write(b);
            ++i;
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        int i = 0;
        while (i < this.streams.length) {
            this.streams[i].write(b);
            ++i;
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int i = 0;
        while (i < this.streams.length) {
            this.streams[i].write(b, off, len);
            ++i;
        }
    }

    @Override
    public void close() throws IOException {
        int i = 0;
        while (i < this.streams.length) {
            this.streams[i].close();
            ++i;
        }
    }

    @Override
    public void flush() throws IOException {
        int i = 0;
        while (i < this.streams.length) {
            this.streams[i].flush();
            ++i;
        }
    }
}

