/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.filters;

import java.math.BigDecimal;
import java.text.Format;
import java.text.ParsePosition;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import org.openconcerto.ui.filters.DecimalFormatFilter;
import org.openconcerto.ui.filters.FloatFormatFilter;
import org.openconcerto.ui.filters.IntFormatFilter;
import org.openconcerto.ui.filters.NumberFormatFilter;
import org.openconcerto.utils.Tuple2;

public class FormatFilter<T>
extends DocumentFilter {
    private final Format format;
    private final Class<T> c;

    public static final <T> FormatFilter<? super T> create(Class<T> clazz) {
        NumberFormatFilter res;
        if (clazz.equals(BigDecimal.class)) {
            res = new DecimalFormatFilter();
        } else if (clazz.equals(Float.class) || clazz.equals(Double.class)) {
            res = new FloatFormatFilter();
        } else if (clazz.equals(Integer.class) || clazz.equals(Long.class)) {
            res = new IntFormatFilter();
        } else {
            throw new IllegalArgumentException("no format filter for " + clazz);
        }
        assert (res.getValueClass().isAssignableFrom(clazz));
        DecimalFormatFilter casted = res;
        return casted;
    }

    public static final boolean isValid(Format f, String s) {
        return FormatFilter.isValid(s, f, Object.class).get0();
    }

    public static final <T> Tuple2<Boolean, T> isValid(String s, Format f, Class<T> c) {
        if (s.isEmpty()) {
            return Tuple2.create(true, null);
        }
        ParsePosition pp = new ParsePosition(0);
        Object o = f.parseObject(s, pp);
        boolean ok = c.isInstance(o) && pp.getIndex() == s.length();
        return ok ? Tuple2.create(ok, c.cast(o)) : Tuple2.create(false, null);
    }

    private static final String subString(Document doc, int offset) throws BadLocationException {
        return doc.getText(offset, doc.getLength() - offset);
    }

    public FormatFilter(Format f, Class<T> c) {
        this.format = f;
        this.c = c;
    }

    @Override
    public final void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
        String newString = String.valueOf(fb.getDocument().getText(0, offset)) + string + FormatFilter.subString(fb.getDocument(), offset);
        if (this.isValid(newString)) {
            fb.insertString(offset, string, attr);
        }
    }

    @Override
    public final void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
        String newString = String.valueOf(fb.getDocument().getText(0, offset)) + text + FormatFilter.subString(fb.getDocument(), offset + length);
        if (this.isValid(newString)) {
            fb.replace(offset, length, text, attrs);
        }
    }

    public final boolean isValid(String s) {
        return this.isPartialValid(s) || this.isCompleteValid(s);
    }

    public final boolean isCompleteValid(String s) {
        return this.parse(s).get0();
    }

    public final Tuple2<Boolean, T> parse(String s) {
        return FormatFilter.isValid(s, this.getFormat(), this.c);
    }

    public boolean isPartialValid(String s) {
        return false;
    }

    public String getValidationText(String s) {
        if (this.isCompleteValid(s)) {
            return String.valueOf(s) + " est valide";
        }
        if (this.isPartialValid(s)) {
            return this.getPartialValidationText(s);
        }
        return String.valueOf(s) + " n'est pas du tout valide";
    }

    protected String getPartialValidationText(String s) {
        return String.valueOf(s) + " n'est que partiellement valide";
    }

    public final Class<T> getValueClass() {
        return this.c;
    }

    public final Format getFormat() {
        return this.format;
    }

    public String format(T o) {
        return this.getFormat().format(o);
    }
}

