/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.search;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;
import org.openconcerto.sql.view.list.ITableModel;
import org.openconcerto.sql.view.list.SQLTableModelColumn;
import org.openconcerto.sql.view.search.SearchItemComponent;
import org.openconcerto.sql.view.search.SearchList;
import org.openconcerto.utils.FormatGroup;

public class SearchListComponent
extends JPanel {
    private ITableModel model;
    private final List<SearchItemComponent> items = new ArrayList<SearchItemComponent>();
    private final GridBagConstraints c;
    private Runnable r = null;
    private final Map<Class<?>, FormatGroup> formats = new HashMap();

    public SearchListComponent(ITableModel model) {
        this.setLayout(new GridBagLayout());
        this.c = new GridBagConstraints();
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.c.insets = new Insets(0, 2, 0, 2);
        this.c.fill = 2;
        this.c.weightx = 1.0;
        this.reset(model);
    }

    protected final TableModel getTableModel() {
        return this.model;
    }

    final String[] getColumnNames(int index) {
        SQLTableModelColumn col = this.model.getLinesSource().getParent().getColumn(index);
        String[] res = new String[]{col.getName(), col.getToolTip(), col.getIdentifier()};
        assert (res[res.length - 1] != null) : "Null identifier for " + col;
        int i = res.length - 2;
        while (i >= 0) {
            if (res[i] == null) {
                res[i] = res[i + 1];
            }
            --i;
        }
        return res;
    }

    private SearchItemComponent getItem(int i) {
        return this.items.get(i);
    }

    private void checkEDT() {
        if (!SwingUtilities.isEventDispatchThread()) {
            Thread.dumpStack();
        }
    }

    public void reset(ITableModel newModel) {
        this.model = newModel;
        this.reset();
    }

    private void reset() {
        this.checkEDT();
        this.removeAll();
        this.items.clear();
        this.c.gridy = 0;
        if (this.getTableModel() != null) {
            this.addNewSearchItem();
            this.updateSearch();
        } else {
            this.revalidate();
        }
    }

    public void addNewSearchItem() {
        this.checkEDT();
        SearchItemComponent item = new SearchItemComponent(this);
        this.add((Component)item, this.c);
        ++this.c.gridy;
        this.items.add(item);
        this.revalidate();
    }

    public void updateSearch() {
        this.checkEDT();
        this.model.search(this.getSearchList(), this.r);
    }

    private SearchList getSearchList() {
        SearchList l = new SearchList();
        int i = 0;
        while (i < this.items.size()) {
            SearchItemComponent component = this.items.get(i);
            l.addSearchItem(component.getSearchItem());
            ++i;
        }
        return l;
    }

    public void removeSearchItem(SearchItemComponent item) {
        this.checkEDT();
        if (this.items.size() > 1) {
            this.items.remove(item);
            this.remove(item);
            this.revalidate();
            this.updateSearch();
        } else {
            this.getItem(0).resetState();
        }
    }

    public void clear() {
        this.reset();
    }

    public void setSearchString(String s) {
        this.setSearchString(s, null);
    }

    public void setSearchString(String s, Runnable r) {
        this.checkEDT();
        this.clear();
        this.r = r;
        this.getItem(0).setText(s);
        this.r = null;
    }

    public void setSearchFullMode(boolean b) {
        this.checkEDT();
        int i = 0;
        while (i < this.items.size()) {
            SearchItemComponent component = this.items.get(i);
            component.setSearchFullMode(b);
            ++i;
        }
    }

    public final void setFormats(Map<Class<?>, FormatGroup> formats) {
        this.formats.clear();
        this.formats.putAll(formats);
    }

    public final Map<Class<?>, FormatGroup> getFormats() {
        return this.formats;
    }
}

