/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.ui.light;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelListener;
import net.minidev.json.JSONObject;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.DOMBuilder;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.FieldPath;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLFunctionField;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.ui.light.LightListSqlRow;
import org.openconcerto.sql.ui.light.TableSearchColumnMatcher;
import org.openconcerto.sql.ui.light.TableSearchMatcher;
import org.openconcerto.sql.view.list.ITableModel;
import org.openconcerto.sql.view.list.ListSQLLine;
import org.openconcerto.sql.view.list.SQLTableModelColumn;
import org.openconcerto.sql.view.list.SQLTableModelSourceOnline;
import org.openconcerto.ui.SwingThreadUtils;
import org.openconcerto.ui.light.ColumnSpec;
import org.openconcerto.ui.light.ColumnsSpec;
import org.openconcerto.ui.light.LightUIElement;
import org.openconcerto.ui.light.LightUITable;
import org.openconcerto.ui.light.Row;
import org.openconcerto.ui.light.TableSearchParameter;
import org.openconcerto.ui.light.TableSearchParameterType;
import org.openconcerto.ui.light.UserSearch;
import org.openconcerto.utils.NumberUtils;
import org.openconcerto.utils.cc.ITransformer;

public abstract class LightRowValuesTable
extends LightUITable {
    public static final int MAX_LINE_TO_SEND = 100;
    private int totalRowCount = -1;
    private int offset = 0;
    private transient ITableModel model;
    private transient ITransformer<SQLSelect, SQLSelect> orginTransformer;
    private transient List<TableModelListener> tableModelListeners = new ArrayList<TableModelListener>();
    private Map<TableSearchParameter, TableSearchMatcher> searchMap = new HashMap<TableSearchParameter, TableSearchMatcher>();

    public LightRowValuesTable() {
    }

    public LightRowValuesTable(Configuration configuration, Number userId, String id, ITableModel model) {
        super(id);
        this.model = model;
        ColumnsSpec columnsSpec = this.createColumnsSpecFromModelSource(configuration, userId);
        this.getTableSpec().setColumns(columnsSpec);
        if (model.getReq() instanceof SQLTableModelSourceOnline) {
            SQLTableModelSourceOnline source = (SQLTableModelSourceOnline)model.getReq();
            this.orginTransformer = source.getReq().getSelectTransf();
            final List<SQLTableModelColumn> columns = model.getReq().getColumns();
            TableSearchParameter tableSearchParameterAll = new TableSearchParameter("all", "Tous");
            TableSearchMatcher m = new TableSearchMatcher(){

                @Override
                public boolean useMatch() {
                    return false;
                }

                @Override
                public boolean match(SQLRowValues r, TableSearchParameterType type, String txt) {
                    return true;
                }

                @Override
                public Where getWhere(SQLSelect sel, TableSearchParameterType type, String txt) {
                    HashSet<FieldPath> fields = new HashSet<FieldPath>();
                    for (SQLTableModelColumn col : columns) {
                        fields.addAll(col.getPaths());
                    }
                    ArrayList<Where> wFields = new ArrayList<Where>(fields.size());
                    for (FieldPath fpath : fields) {
                        Where w;
                        if (!fpath.getField().getType().getJavaType().equals(String.class)) continue;
                        FieldRef fieldRef = sel.followFieldPath(fpath);
                        if (type.getType().equals("contains")) {
                            w = new Where((FieldRef)new SQLFunctionField(SQLFunctionField.SQLFunction.LOWER, fieldRef), "LIKE", (Object)("%" + txt.toLowerCase() + "%"));
                            wFields.add(w);
                        }
                        if (type.getType().equals("starts")) {
                            w = new Where((FieldRef)new SQLFunctionField(SQLFunctionField.SQLFunction.LOWER, fieldRef), "LIKE", (Object)(String.valueOf(txt.toLowerCase()) + "%"));
                            wFields.add(w);
                        }
                        if (!type.getType().equals("is")) continue;
                        w = new Where((FieldRef)new SQLFunctionField(SQLFunctionField.SQLFunction.LOWER, fieldRef), "LIKE", (Object)txt.toLowerCase());
                        wFields.add(w);
                    }
                    return Where.or(wFields);
                }

                @Override
                public List<FieldPath> getAdditionnalFieldsToFetch() {
                    return Collections.emptyList();
                }
            };
            tableSearchParameterAll.add(TableSearchParameterType.getContainsStringInstance(Locale.FRENCH));
            tableSearchParameterAll.add(TableSearchParameterType.getIsStringInstance(Locale.FRENCH));
            this.addSearchParameter(tableSearchParameterAll, m);
            int i = 0;
            while (i < columns.size()) {
                SQLTableModelColumn col = columns.get(i);
                TableSearchParameter tableSearchParameter = new TableSearchParameter("col" + i, col.getName());
                tableSearchParameter.add(TableSearchParameterType.getContainsStringInstance(Locale.FRENCH));
                tableSearchParameter.add(TableSearchParameterType.getIsStringInstance(Locale.FRENCH));
                TableSearchColumnMatcher tableSearchMatcher = new TableSearchColumnMatcher(col);
                this.addSearchParameter(tableSearchParameter, tableSearchMatcher);
                ++i;
            }
        } else {
            this.orginTransformer = null;
        }
        this.setDynamicLoad(true);
    }

    public LightRowValuesTable(LightRowValuesTable tableElement) {
        super(tableElement);
        this.model = tableElement.model;
        this.totalRowCount = tableElement.totalRowCount;
        this.orginTransformer = tableElement.orginTransformer;
    }

    public LightRowValuesTable(JSONObject json) {
        super(json);
        this.orginTransformer = null;
    }

    public final int getTotalRowsCount() {
        return this.totalRowCount;
    }

    public final int getOffset() {
        return this.offset;
    }

    public final void setOffset(int offset) {
        this.offset = offset;
    }

    public final void addTableModelListener(final TableModelListener tableModelListener) {
        this.tableModelListeners.add(tableModelListener);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LightRowValuesTable.this.model.addTableModelListener(tableModelListener);
            }
        });
    }

    public final void removeTableModelListener(TableModelListener tableModelListener) {
        this.tableModelListeners.remove(tableModelListener);
        this.model.removeTableModelListener(tableModelListener);
    }

    public ITableModel getModel() {
        return this.model;
    }

    public final LightListSqlRow getRowFromSqlID(Number sqlID) {
        if (this.hasRow()) {
            int size = this.getTableSpec().getContent().getRowsCount();
            int i = 0;
            while (i < size) {
                LightListSqlRow row = (LightListSqlRow)this.getRow(i);
                if (NumberUtils.areNumericallyEqual(row.getSqlRow().getIDNumber(), sqlID)) {
                    return row;
                }
                ++i;
            }
        }
        return null;
    }

    public final LightListSqlRow createLightListRowFromListLine(ListSQLLine listSqlLine, int index) throws IllegalStateException {
        ColumnsSpec columnsSpec = this.getTableSpec().getColumns();
        List<SQLTableModelColumn> sqlColumns = this.getModelColumns();
        int colSize = sqlColumns.size();
        LightListSqlRow row = new LightListSqlRow(listSqlLine.getRow(), (Number)listSqlLine.getID());
        ArrayList<Object> values = new ArrayList<Object>();
        int i = 0;
        while (i < colSize) {
            Object value;
            String columnId = columnsSpec.getColumn(i).getId();
            SQLTableModelColumn col = this.getColumnFromId(sqlColumns, columnId);
            if (col != null) {
                value = col.show(row.getSqlRow());
                if (col.getLightUIrenderer() != null) {
                    value = col.getLightUIrenderer().getLightUIElement(value, 0, i);
                }
            } else {
                throw new IllegalArgumentException("column " + columnId + " is in ColumnsSpec but it is not found in SQLTableModelColumn");
            }
            values.add(value);
            ++i;
        }
        row.setValues(values);
        return row;
    }

    public final SQLRowAccessor getFirstSelectedSqlRow() {
        List<Row> selectedRows = this.getSelectedRows();
        if (selectedRows.isEmpty()) {
            return null;
        }
        return ((LightListSqlRow)selectedRows.get(0)).getSqlRow();
    }

    private final List<SQLTableModelColumn> getModelColumns() {
        try {
            return SwingThreadUtils.call(new Callable<List<SQLTableModelColumn>>(){

                @Override
                public List<SQLTableModelColumn> call() throws Exception {
                    return LightRowValuesTable.this.getModel().getReq().getColumns();
                }
            });
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    private final SQLTableModelColumn getColumnFromId(List<SQLTableModelColumn> allCols, String columnId) {
        int columnSize = allCols.size();
        int i = 0;
        while (i < columnSize) {
            SQLTableModelColumn tableModelColumn = allCols.get(i);
            if (tableModelColumn.getIdentifier().equals(columnId)) {
                return tableModelColumn;
            }
            ++i;
        }
        return null;
    }

    private final Document getColumnsSpecUserPerfs(Configuration configuration, Number userId) throws IllegalArgumentException, IllegalStateException {
        Document columnsPrefs = null;
        DOMBuilder in = new DOMBuilder();
        org.w3c.dom.Document w3cDoc = null;
        w3cDoc = configuration.getXMLConf(userId, this.getId());
        if (w3cDoc != null) {
            columnsPrefs = in.build(w3cDoc);
        }
        return columnsPrefs;
    }

    private final ColumnsSpec createColumnsSpecFromModelSource(Configuration configuration, Number userId) throws IllegalArgumentException, IllegalStateException {
        ArrayList<String> possibleColumnIds = new ArrayList<String>();
        ArrayList<String> sortedIds = new ArrayList<String>();
        ArrayList<ColumnSpec> columnsSpec = new ArrayList<ColumnSpec>();
        List<SQLTableModelColumn> columns = this.getModelColumns();
        int columnsCount = columns.size();
        int i = 0;
        while (i < columnsCount) {
            SQLTableModelColumn sqlColumn = columns.get(i);
            String columnId = sqlColumn.getIdentifier();
            possibleColumnIds.add(columnId);
            Class<LightUIElement> valueClass = sqlColumn.getValueClass();
            if (sqlColumn.getLightUIrenderer() != null) {
                valueClass = LightUIElement.class;
            }
            columnsSpec.add(new ColumnSpec(columnId, valueClass, sqlColumn.getName(), null, false, null));
            ++i;
        }
        sortedIds.add(((ColumnSpec)columnsSpec.get(0)).getId());
        ColumnsSpec cSpec = new ColumnsSpec(this.getId(), columnsSpec, possibleColumnIds, sortedIds);
        cSpec.setAllowMove(true);
        cSpec.setAllowResize(true);
        try {
            Document xmlColumnsPref = this.getColumnsSpecUserPerfs(configuration, userId);
            if (!cSpec.setUserPrefs(xmlColumnsPref)) {
                configuration.removeXMLConf(userId, this.getId());
            }
        }
        catch (Exception e) {
            System.err.println("LightRowValuesTable.createColumnsSpecFromModelSource() no column pref for conf : " + configuration.getRoot().getName() + " , user id : " + userId);
        }
        return cSpec;
    }

    public abstract void doSearch(Configuration var1, UserSearch var2, int var3);

    public void addSearchParameter(TableSearchParameter tableSearchParameter, TableSearchMatcher tableSearchMatcher) {
        this.searchMap.put(tableSearchParameter, tableSearchMatcher);
        this.getTableSpec().addSearchParameter(tableSearchParameter);
    }

    protected TableSearchMatcher getSearchMatcher(String colId, String searchType) {
        for (TableSearchParameter p : this.searchMap.keySet()) {
            if (!p.getId().equals(colId)) continue;
            for (TableSearchParameterType t : p.getTypes()) {
                if (!t.getType().equals(searchType)) continue;
                return this.searchMap.get(p);
            }
        }
        return null;
    }

    @Override
    public Row getRowById(Number rowId) {
        int i = 0;
        while (i < this.model.getRowCount()) {
            if (NumberUtils.areNumericallyEqual(this.model.getRow(i).getID(), rowId)) {
                return this.createLightListRowFromListLine(this.model.getRow(i), i);
            }
            ++i;
        }
        return super.getRowById(rowId);
    }

    @Override
    public Document createDefaultXmlPreferences() {
        Element rootElement = new Element("list");
        List<SQLTableModelColumn> columns = this.getModelColumns();
        int sqlColumnsCount = columns.size();
        int i = 0;
        while (i < sqlColumnsCount) {
            SQLTableModelColumn sqlColumn = columns.get(i);
            String columnId = sqlColumn.getIdentifier();
            ColumnSpec columnSpec = new ColumnSpec(columnId, sqlColumn.getValueClass(), sqlColumn.getName(), null, false, null);
            Element columnElement = this.createXmlColumn(columnId, columnSpec.getMaxWidth(), columnSpec.getMinWidth(), columnSpec.getWidth());
            rootElement.addContent(columnElement);
            ++i;
        }
        Document xmlConf = new Document(rootElement);
        return xmlConf;
    }

    @Override
    public void destroy() {
        super.destroy();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    List listeners = LightRowValuesTable.this.tableModelListeners;
                    int i = listeners.size() - 1;
                    while (i > -1) {
                        LightRowValuesTable.this.removeTableModelListener((TableModelListener)listeners.get(i));
                        --i;
                    }
                }
            });
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
        this.clearRows();
    }
}

