/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLSelectJoin;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.UndefinedRowValuesCache;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.TablesMap;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.sql.utils.AlterTable;
import org.openconcerto.sql.utils.ChangeTable;
import org.openconcerto.sql.utils.SQLCreateTable;
import org.openconcerto.sql.view.list.SQLTableModelSourceOnline;
import org.openconcerto.utils.StringUtils;
import org.openconcerto.utils.cc.ITransformer;
import org.openconcerto.utils.i18n.Grammar;

public class SQLInjector {
    private final SQLTable tableSrc;
    private final SQLTable tableDest;
    private final ArrayList<SQLField> from = new ArrayList();
    private final ArrayList<SQLField> to = new ArrayList();
    private final Map<SQLField, Object> values = new HashMap<SQLField, Object>();
    private static final Map<DBRoot, Map<SQLTable, Map<SQLTable, SQLInjector>>> allRegisteredInjectors = new HashMap<DBRoot, Map<SQLTable, Map<SQLTable, SQLInjector>>>();
    private boolean storeTransfer;
    private static Map<DBRoot, Map<SQLTable, Map<SQLTable, SQLInjector>>> injectors = new HashMap<DBRoot, Map<SQLTable, Map<SQLTable, SQLInjector>>>();
    DateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");

    public SQLInjector(DBRoot r, String src, String dest, boolean storeTransfer) {
        this(r.findTable(src), r.findTable(dest), storeTransfer);
    }

    public SQLInjector(SQLTable src, SQLTable dest, boolean storeTransfer) {
        Map<SQLTable, SQLInjector> srcs;
        this.tableDest = dest;
        this.tableSrc = src;
        this.storeTransfer = storeTransfer;
        DBRoot dbRoot = src.getDBRoot();
        Map<SQLTable, Map<SQLTable, SQLInjector>> inj = allRegisteredInjectors.get(dbRoot);
        if (inj == null) {
            inj = new HashMap<SQLTable, Map<SQLTable, SQLInjector>>();
            allRegisteredInjectors.put(dbRoot, inj);
        }
        if ((srcs = inj.get(src)) == null) {
            srcs = new HashMap<SQLTable, SQLInjector>();
            inj.put(src, srcs);
        }
        srcs.put(dest, this);
        if (storeTransfer) {
            inj = injectors.get(dbRoot);
            if (inj == null) {
                inj = new HashMap<SQLTable, Map<SQLTable, SQLInjector>>();
                injectors.put(dbRoot, inj);
            }
            if ((srcs = inj.get(src)) == null) {
                srcs = new HashMap<SQLTable, SQLInjector>();
                inj.put(src, srcs);
            }
            srcs.put(dest, this);
        }
    }

    public synchronized SQLRowValues createRowValuesFrom(int idSrc) {
        ArrayList<SQLRow> srcRows = new ArrayList<SQLRow>(1);
        srcRows.add(this.getSource().getRow(idSrc));
        return this.createRowValuesFrom(srcRows);
    }

    public synchronized SQLRowValues createRowValuesFrom(SQLRow srcRow) {
        SQLRowValues rowVals = new SQLRowValues(this.getDestination());
        if (!srcRow.getTable().equals(this.getSource())) {
            throw new IllegalArgumentException("Row not from source table : " + srcRow);
        }
        this.merge(srcRow, rowVals);
        return rowVals;
    }

    public synchronized SQLRowValues createRowValuesFrom(List<? extends SQLRowAccessor> srcRows) {
        SQLRowValues rowVals = new SQLRowValues(this.getDestination());
        for (SQLRowAccessor sQLRowAccessor : srcRows) {
            if (!sQLRowAccessor.getTable().equals(this.getSource())) {
                throw new IllegalArgumentException("Row not from source table : " + sQLRowAccessor);
            }
            this.merge(sQLRowAccessor, rowVals);
        }
        return rowVals;
    }

    public void commitTransfert(List<? extends SQLRowAccessor> srcRows, int destId) throws SQLException {
        if (this.storeTransfer) {
            System.err.println("SQLInjector.commitTransfert() : transfert from " + this.getSource().getName() + " to " + this.getDestination().getName());
            SQLTable tableTransfert = this.getSource().getDBRoot().getTable(this.getTableTranferName());
            if (tableTransfert == null) {
                throw new IllegalStateException("No table transfer for " + this.getSource().getName());
            }
            for (SQLRowAccessor sQLRowAccessor : srcRows) {
                SQLRowValues rowTransfer = new SQLRowValues(tableTransfert);
                Set<SQLField> foreignKeysSrc = tableTransfert.getForeignKeys(this.getSource());
                Set<SQLField> foreignKeysDest = tableTransfert.getForeignKeys(this.getDestination());
                if (foreignKeysSrc.isEmpty()) {
                    throw new IllegalStateException("No foreign (src) to " + this.getSource().getName() + " in " + tableTransfert.getName());
                }
                if (foreignKeysDest.isEmpty()) {
                    throw new IllegalStateException("No foreign (dest) to " + this.getDestination().getName() + " in " + tableTransfert.getName());
                }
                rowTransfer.put(foreignKeysSrc.iterator().next().getName(), sQLRowAccessor.getIDNumber());
                rowTransfer.put(foreignKeysDest.iterator().next().getName(), destId);
                rowTransfer.commit();
            }
        }
    }

    private String getTableTranferName() {
        return "TR_" + this.getSource().getName();
    }

    protected void merge(SQLRowAccessor srcRow, SQLRowValues rowVals) {
        for (SQLField field : this.values.keySet()) {
            rowVals.put(field.getName(), this.values.get(field));
        }
        SQLSystem dbSystem = srcRow.getTable().getDBSystemRoot().getServer().getSQLSystem();
        int size = this.getFrom().size();
        int i = 0;
        while (i < size) {
            SQLField sqlFieldFrom = this.getFrom().get(i);
            SQLField sqlFieldTo = this.getTo().get(i);
            Object o = srcRow.getObject(sqlFieldFrom.getName());
            if (dbSystem == SQLSystem.H2 && sqlFieldFrom.getType().getJavaType() == Long.class && sqlFieldTo.getType().getJavaType() == Integer.class) {
                this.merge(sqlFieldTo, ((Long)o).intValue(), rowVals);
            } else {
                this.merge(sqlFieldTo, o, rowVals);
            }
            ++i;
        }
    }

    protected void merge(SQLField field, Object value, SQLRowValues rowVals) {
        rowVals.put(field.getName(), value);
    }

    private String cleanRef(String value) {
        List<String> l = StringUtils.fastSplit(value, ',');
        HashSet<String> s = new HashSet<String>(l);
        String nom = "";
        if (s.size() > 1) {
            HashSet<String> refAdded = new HashSet<String>();
            for (String string : s) {
                if (string.trim().length() <= 0 || refAdded.contains(string.trim())) continue;
                nom = String.valueOf(nom) + string + ",";
                refAdded.add(string.trim());
            }
        } else if (s.size() == 1) {
            nom = (String)s.iterator().next();
        }
        return nom;
    }

    protected void transfertReference(SQLRowAccessor srcRow, SQLRowValues rowVals, SQLTable tableElementDestination, String refField, String from, String to) {
        String label = rowVals.getString(to);
        SQLPreferences prefs = SQLPreferences.getMemCached(srcRow.getTable().getDBRoot());
        String ref = srcRow.getString(from);
        if (ref != null && ref.trim().length() > 0) {
            if (prefs.getBoolean("TransfertRef", true) || !to.equals("NOM")) {
                if (label != null && label.trim().length() > 0) {
                    rowVals.put(to, this.cleanRef(String.valueOf(label) + ", " + ref));
                } else {
                    rowVals.put(to, ref);
                }
            } else if (prefs.getBoolean("TransfertMultiRef", false)) {
                SQLRowValues rowValsHeader = new SQLRowValues(UndefinedRowValuesCache.getInstance().getDefaultRowValues(tableElementDestination));
                rowValsHeader.put("NOM", ref);
                rowValsHeader.put(refField, (Object)rowVals);
            }
        }
    }

    protected void transfertNumberReference(SQLRowAccessor srcRow, SQLRowValues rowVals, SQLTable tableElementDestination, String refField) {
        SQLPreferences prefs = SQLPreferences.getMemCached(srcRow.getTable().getDBRoot());
        if (!prefs.getBoolean("TransfertNoRef", false)) {
            if (prefs.getBoolean("TransfertRef", true)) {
                String label = rowVals.getString("NOM");
                if (label != null && label.trim().length() > 0) {
                    String value = String.valueOf(label) + ", " + srcRow.getString("NUMERO");
                    rowVals.put("NOM", this.cleanRef(value));
                } else {
                    rowVals.put("NOM", srcRow.getString("NUMERO"));
                }
            }
            if (prefs.getBoolean("TransfertMultiRef", false)) {
                SQLRowValues rowValsHeader = new SQLRowValues(UndefinedRowValuesCache.getInstance().getDefaultRowValues(tableElementDestination));
                rowValsHeader.put("ID_STYLE", 3);
                SQLElement element = Configuration.getInstance().getDirectory().getElement(this.getSource());
                if (element == null) {
                    element = Configuration.getInstance().getDirectory().getElement(this.getSource().getName());
                }
                String elementName = StringUtils.firstUp(element.getName().getVariant(Grammar.SINGULAR));
                rowValsHeader.put("NOM", String.valueOf(elementName) + "\n N\u00b0 " + srcRow.getString("NUMERO") + " du " + this.dateFormat.format(srcRow.getDate("DATE").getTime()));
                rowValsHeader.put(refField, (Object)rowVals);
            }
        }
    }

    public synchronized SQLRow insertFrom(SQLRowAccessor srcRow) throws SQLException {
        return this.createRowValuesFrom(Arrays.asList(srcRow)).insert();
    }

    protected final synchronized void mapDefaultValues(SQLField fieldDest, Object defaultValue) {
        if (!fieldDest.getTable().getName().equalsIgnoreCase(this.tableDest.getName())) {
            throw new IllegalArgumentException("SQLField " + fieldDest + " is not a field of table " + this.tableDest);
        }
        this.values.put(fieldDest, defaultValue);
    }

    protected final synchronized void map(SQLField from, SQLField to) throws IllegalArgumentException {
        if (!from.getTable().getName().equalsIgnoreCase(this.tableSrc.getName())) {
            throw new IllegalArgumentException("SQLField " + from + " is not a field of table " + this.tableSrc);
        }
        if (!to.getTable().getName().equalsIgnoreCase(this.tableDest.getName())) {
            throw new IllegalArgumentException("SQLField " + to + " is not a field of table " + this.tableDest);
        }
        int index = this.from.indexOf(from);
        if (index > 0) {
            this.to.set(index, to);
        } else {
            this.from.add(from);
            this.to.add(to);
        }
    }

    protected final synchronized void remove(SQLField from, SQLField to) throws IllegalArgumentException {
        if (!from.getTable().getName().equalsIgnoreCase(this.tableSrc.getName())) {
            throw new IllegalArgumentException("SQLField " + from + " is not a field of table " + this.tableSrc);
        }
        if (!to.getTable().getName().equalsIgnoreCase(this.tableDest.getName())) {
            throw new IllegalArgumentException("SQLField " + to + " is not a field of table " + this.tableDest);
        }
        int index = this.from.indexOf(from);
        if (this.to.get(index).getName().equalsIgnoreCase(to.getName())) {
            this.to.remove(to);
            this.from.remove(from);
        }
    }

    public synchronized void createDefaultMap() {
        for (SQLField field : this.tableSrc.getContentFields()) {
            if (!this.tableDest.contains(field.getName())) continue;
            this.map(field, this.tableDest.getField(field.getName()));
        }
    }

    public synchronized ArrayList<SQLField> getFrom() {
        return this.from;
    }

    public synchronized ArrayList<SQLField> getTo() {
        return this.to;
    }

    public static synchronized SQLInjector getInjector(SQLTable src, SQLTable dest) {
        SQLInjector injector = SQLInjector.getRegistrereddInjector(src, dest);
        if (injector == null) {
            injector = SQLInjector.createDefaultInjector(src, dest);
        }
        return injector;
    }

    public static synchronized SQLInjector getRegistrereddInjector(SQLTable src, SQLTable dest) {
        Map<SQLTable, Map<SQLTable, SQLInjector>> map = allRegisteredInjectors.get(src.getDBRoot());
        if (map == null) {
            return null;
        }
        Map<SQLTable, SQLInjector> m = map.get(src);
        if (m != null) {
            return m.get(dest);
        }
        return null;
    }

    private static synchronized SQLInjector createDefaultInjector(SQLTable src, SQLTable dest) {
        System.err.println("No SQLInjector defined for " + src + " , " + dest + ". SQLInjector created automatically.");
        SQLInjector injector = new SQLInjector(src, dest, false);
        injector.createDefaultMap();
        return injector;
    }

    public synchronized SQLTable getDestination() {
        return this.tableDest;
    }

    public synchronized SQLTable getSource() {
        return this.tableSrc;
    }

    public static synchronized void createTransferTables(DBRoot root) throws SQLException {
        Map<SQLTable, Map<SQLTable, SQLInjector>> map = injectors.get(root);
        if (root == null) {
            System.err.println("No SQLInjector for root " + root);
            return;
        }
        Set<SQLTable> srcTables = map.keySet();
        if (srcTables.isEmpty()) {
            System.err.println("No SQLInjector for root " + root);
            return;
        }
        ArrayList<SQLCreateTable> createTablesQueries = new ArrayList<SQLCreateTable>();
        for (SQLTable sqlTable : srcTables) {
            String trTableName = "TR_" + sqlTable.getName();
            if (root.getTable(trTableName) != null) continue;
            SQLCreateTable createTable = new SQLCreateTable(root, trTableName);
            createTable.setPlain(false);
            createTable.addForeignColumn("ID_" + sqlTable.getName(), sqlTable);
            createTablesQueries.add(createTable);
        }
        if (createTablesQueries.size() > 0) {
            root.createTables(createTablesQueries);
        }
        ArrayList<AlterTable> alterTablesQueries = new ArrayList<AlterTable>();
        TablesMap toRefresh = new TablesMap();
        for (SQLTable srcTable : srcTables) {
            String trTableName = "TR_" + srcTable.getName();
            SQLTable transfertTable = root.getTable(trTableName);
            AlterTable alter = new AlterTable(transfertTable);
            Set<SQLTable> destTables = map.get(srcTable).keySet();
            for (SQLTable destTable : destTables) {
                String fk = "ID_" + destTable.getName();
                if (transfertTable.contains(fk)) continue;
                alter.addForeignColumn(fk, destTable);
            }
            if (alter.isEmpty()) continue;
            alterTablesQueries.add(alter);
            toRefresh.add(alter.getRootName(), alter.getName());
        }
        for (String q : ChangeTable.cat(alterTablesQueries)) {
            root.getDBSystemRoot().getDataSource().execute(q);
        }
        root.getSchema().updateVersion();
        root.getDBSystemRoot().refresh(toRefresh, false);
    }

    public void setOnlyTransfered(SQLTableModelSourceOnline tableSource) {
        tableSource.getReq().setLockSelect(false);
        tableSource.getReq().setSelectTransf(new ITransformer<SQLSelect, SQLSelect>(){

            @Override
            public SQLSelect transformChecked(SQLSelect input) {
                SQLTable tableTR = SQLInjector.this.getSource().getTable(SQLInjector.this.getTableTranferName());
                SQLSelectJoin j = input.addBackwardJoin("INNER", null, tableTR.getForeignKeys(SQLInjector.this.getSource()).iterator().next(), null);
                j.setWhere(new Where((FieldRef)tableTR.getForeignKeys(SQLInjector.this.getDestination()).iterator().next(), "!=", SQLInjector.this.getDestination().getUndefinedID()));
                input.setDistinct(true);
                System.err.println(input.asString());
                return input;
            }
        });
    }

    public void setOnlyNotTransfered(SQLTableModelSourceOnline tableSource) {
        tableSource.getReq().setSelectTransf(new ITransformer<SQLSelect, SQLSelect>(){

            @Override
            public SQLSelect transformChecked(SQLSelect input) {
                SQLTable tableTR = SQLInjector.this.getSource().getTable(SQLInjector.this.getTableTranferName());
                Where w = new Where((FieldRef)tableTR.getForeignKeys(SQLInjector.this.getSource()).iterator().next(), "=", input.getAlias(SQLInjector.this.getSource().getKey()));
                input.addJoin("LEFT", tableTR, w);
                Where w2 = new Where((FieldRef)tableTR.getForeignKeys(SQLInjector.this.getDestination()).iterator().next(), "IS", (Object)null);
                input.setWhere(w2);
                System.err.println(input.asString());
                return input;
            }
        });
    }

    public void addTransfert(int idFrom, int idTo) throws SQLException {
        SQLTable tableTransfert = this.getSource().getTable(this.getTableTranferName());
        SQLRowValues rowTransfer = new SQLRowValues(tableTransfert);
        Set<SQLField> foreignKeysSrc = tableTransfert.getForeignKeys(this.getSource());
        Set<SQLField> foreignKeysDest = tableTransfert.getForeignKeys(this.getDestination());
        rowTransfer.put(foreignKeysSrc.iterator().next().getName(), idFrom);
        rowTransfer.put(foreignKeysDest.iterator().next().getName(), idTo);
        rowTransfer.commit();
    }
}

