/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.injector;

import java.math.BigDecimal;
import java.util.Collection;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLInjector;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;

public class BonFactureSQLInjector
extends SQLInjector {
    public BonFactureSQLInjector(DBRoot root) {
        super(root.getTable("BON_DE_LIVRAISON"), root.getTable("SAISIE_VENTE_FACTURE"), true);
        SQLTable tableBon = this.getSource();
        SQLTable tableFacture = this.getDestination();
        this.map(tableBon.getField("ID_CLIENT"), tableFacture.getField("ID_CLIENT"));
        if (tableBon.getTable().contains("ID_POLE_PRODUIT")) {
            this.map(tableBon.getField("ID_POLE_PRODUIT"), tableFacture.getField("ID_POLE_PRODUIT"));
        }
        if (tableBon.contains("T_ACOMPTE") && tableFacture.contains("T_ACOMPTE")) {
            this.map(tableBon.getField("T_ACOMPTE"), tableFacture.getField("T_ACOMPTE"));
        }
        if (this.getSource().getTable().contains("ID_CONTACT")) {
            this.map(this.getSource().getField("ID_CONTACT"), this.getDestination().getField("ID_CONTACT"));
        }
        if (this.getSource().getTable().contains("ID_CLIENT_DEPARTEMENT")) {
            this.map(this.getSource().getField("ID_CLIENT_DEPARTEMENT"), this.getDestination().getField("ID_CLIENT_DEPARTEMENT"));
        }
        if (this.getSource().getTable().contains("ID_ADRESSE") && this.getDestination().contains("ID_ADRESSE")) {
            this.map(this.getSource().getField("ID_ADRESSE"), this.getDestination().getField("ID_ADRESSE"));
        }
        if (this.getSource().getTable().contains("ID_ADRESSE_LIVRAISON")) {
            this.map(this.getSource().getField("ID_ADRESSE_LIVRAISON"), this.getDestination().getField("ID_ADRESSE_LIVRAISON"));
        }
        if (this.getSource().getTable().contains("ID_CATEGORIE_COMPTABLE") && this.getDestination().getTable().contains("ID_CATEGORIE_COMPTABLE")) {
            this.map(this.getSource().getField("ID_CATEGORIE_COMPTABLE"), this.getDestination().getField("ID_CATEGORIE_COMPTABLE"));
        }
        if (tableBon.contains("ID_TAXE_PORT")) {
            this.map(tableBon.getField("ID_TAXE_PORT"), tableFacture.getField("ID_TAXE_PORT"));
        }
        if (tableBon.contains("PORT_HT")) {
            this.map(tableBon.getField("PORT_HT"), tableFacture.getField("PORT_HT"));
        }
        if (this.getSource().contains("FRAIS_DOCUMENT_HT") && this.getDestination().contains("FRAIS_DOCUMENT_HT")) {
            this.map(this.getSource().getField("FRAIS_DOCUMENT_HT"), this.getDestination().getField("FRAIS_DOCUMENT_HT"));
        }
        if (this.getSource().contains("ID_TAXE_FRAIS_DOCUMENT") && this.getDestination().contains("ID_TAXE_FRAIS_DOCUMENT")) {
            this.map(this.getSource().getField("ID_TAXE_FRAIS_DOCUMENT"), this.getDestination().getField("ID_TAXE_FRAIS_DOCUMENT"));
        }
        if (tableBon.contains("REMISE_HT")) {
            this.map(tableBon.getField("REMISE_HT"), tableFacture.getField("REMISE_HT"));
        }
        if (this.getSource().getTable().contains("ID_TARIF") && this.getDestination().getTable().contains("ID_TARIF")) {
            this.map(this.getSource().getField("ID_TARIF"), this.getDestination().getField("ID_TARIF"));
        }
        if (this.getSource().getTable().contains("ACOMPTE_COMMANDE")) {
            this.map(this.getSource().getField("ACOMPTE_COMMANDE"), this.getDestination().getField("ACOMPTE_COMMANDE"));
        }
    }

    @Override
    protected void merge(SQLRowAccessor srcRow, SQLRowValues rowVals) {
        SQLRowAccessor rowClient;
        SQLRowAccessor rowFrais;
        super.merge(srcRow, rowVals);
        SQLTable tableElementSource = this.getSource().getTable("BON_DE_LIVRAISON_ELEMENT");
        SQLTable tableElementDestination = this.getSource().getTable("SAISIE_VENTE_FACTURE_ELEMENT");
        Collection myListItem = srcRow.asRow().getReferentRows(tableElementSource);
        this.transfertNumberReference(srcRow, rowVals, tableElementDestination, "ID_SAISIE_VENTE_FACTURE");
        this.transfertReference(srcRow, rowVals, tableElementDestination, "ID_SAISIE_VENTE_FACTURE", "NOM", "NOM");
        this.transfertReference(srcRow, rowVals, tableElementDestination, "ID_SAISIE_VENTE_FACTURE", "INFOS", "INFOS");
        if (this.getDestination().contains("ID_TAXE_FRAIS_DOCUMENT") && (rowFrais = (rowClient = srcRow.getForeign("ID_CLIENT")).getForeign("ID_FRAIS_DOCUMENT")) != null && !rowFrais.isUndefined()) {
            rowVals.put("FRAIS_DOCUMENT_HT", rowFrais.getLong("MONTANT_HT"));
            rowVals.put("ID_TAXE_FRAIS_DOCUMENT", rowFrais.getForeignID("ID_TAXE"));
        }
        if (myListItem.size() != 0) {
            SQLInjector injector = SQLInjector.getInjector(tableElementSource, tableElementDestination);
            for (SQLRowAccessor rowElt : myListItem) {
                SQLRowValues createRowValuesFrom = injector.createRowValuesFrom(rowElt.asRow());
                if (createRowValuesFrom.getTable().getFieldsName().contains("POURCENT_ACOMPTE") && createRowValuesFrom.getObject("POURCENT_ACOMPTE") == null) {
                    createRowValuesFrom.put("POURCENT_ACOMPTE", new BigDecimal(100.0));
                }
                createRowValuesFrom.put("ID_SAISIE_VENTE_FACTURE", (Object)rowVals);
            }
        }
    }
}

