/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc.gestcomm;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.utils.DecimalUtils;
import org.openconcerto.utils.cc.ITransformer;

public class OptionDocProcessor
implements ITransformer<List<SQLRowAccessor>, List<SQLRowAccessor>> {
    @Override
    public List<SQLRowAccessor> transformChecked(List<SQLRowAccessor> input) {
        ArrayList<SQLRowValues> resultRowValues = new ArrayList<SQLRowValues>(input.size());
        SQLRowValues lastRowNonOptionnal = null;
        HashSet<SQLRowValues> recalculPrixUnitaire = new HashSet<SQLRowValues>();
        for (SQLRowAccessor sqlRowAccessor : input) {
            SQLRowAccessor nonEmptyForeign = sqlRowAccessor.getNonEmptyForeign("ID_ARTICLE");
            SQLRowValues asRowValues = sqlRowAccessor.asRowValues();
            if (lastRowNonOptionnal != null && nonEmptyForeign != null && nonEmptyForeign.getBoolean("OPTION").booleanValue()) {
                lastRowNonOptionnal.put("T_PV_HT", lastRowNonOptionnal.getBigDecimal("T_PV_HT").add(asRowValues.getBigDecimal("T_PV_HT")));
                lastRowNonOptionnal.put("T_PV_TTC", lastRowNonOptionnal.getBigDecimal("T_PV_TTC").add(asRowValues.getBigDecimal("T_PV_TTC")));
                recalculPrixUnitaire.add(lastRowNonOptionnal);
                asRowValues.put("PRIX_METRIQUE_VT_1", null);
                asRowValues.put("PV_HT", null);
                asRowValues.put("T_PV_HT", null);
                asRowValues.put("T_PV_TTC", null);
                asRowValues.putEmptyLink("ID_TAXE");
            } else {
                lastRowNonOptionnal = asRowValues;
            }
            resultRowValues.add(asRowValues);
        }
        ArrayList<SQLRowAccessor> result = new ArrayList<SQLRowAccessor>(input.size());
        for (SQLRowValues sqlRowValues : resultRowValues) {
            if (recalculPrixUnitaire.contains(sqlRowValues)) {
                String fieldQte = sqlRowValues.getTable().getName().startsWith("BON_DE_LIVRAISON") ? "QTE_LIVREE" : "QTE";
                BigDecimal qte = sqlRowValues.getBigDecimal("QTE_UNITAIRE").multiply(new BigDecimal(sqlRowValues.getInt(fieldQte), DecimalUtils.HIGH_PRECISION));
                if (qte.signum() != 0) {
                    BigDecimal totalHT = sqlRowValues.getBigDecimal("T_PV_HT");
                    BigDecimal remisePercent = sqlRowValues.getBigDecimal("POURCENT_REMISE");
                    if (remisePercent != null && remisePercent.signum() > 0 && !remisePercent.movePointLeft(2).equals(BigDecimal.ONE) && BigDecimal.ONE.subtract(remisePercent.movePointLeft(2)).signum() != 0) {
                        totalHT = totalHT.divide(BigDecimal.ONE.subtract(remisePercent.movePointLeft(2)), DecimalUtils.HIGH_PRECISION);
                    }
                    BigDecimal unitPrice = totalHT.divide(qte, DecimalUtils.HIGH_PRECISION);
                    sqlRowValues.put("PV_HT", unitPrice);
                    sqlRowValues.put("PRIX_METRIQUE_VT_1", unitPrice);
                }
            }
            result.add(sqlRowValues);
        }
        return result;
    }
}

