/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.stock.element;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import org.openconcerto.erp.core.sales.product.model.ProductComponent;
import org.openconcerto.erp.core.sales.product.model.ProductHelper;
import org.openconcerto.erp.core.supplychain.stock.element.DepotStockSQLElement;
import org.openconcerto.erp.core.supplychain.stock.element.StockItem;
import org.openconcerto.erp.core.supplychain.stock.element.StockItemComponent;
import org.openconcerto.erp.importer.ArrayTableModel;
import org.openconcerto.erp.importer.DataImporter;
import org.openconcerto.erp.preferences.GestionArticleGlobalPreferencePanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLInsert;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.SQLUpdate;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.utils.Tuple3;
import org.openconcerto.utils.cc.ITransformer;

public class InventaireFromEtatStockImporter {
    private Map<String, SQLRowValues> kits = new HashMap<String, SQLRowValues>();
    private Map<Integer, InventaireProductLine> kitsChildren = new HashMap<Integer, InventaireProductLine>();
    private List<String> codeKits = new ArrayList<String>();
    private static String FAMILLE = "Famille";
    private static String CODE = "Code";
    private static String NOM = "Nom";
    private static String TAILLE = "Taille";
    private static String DEPOT = "D\u00e9p\u00f4t";
    private static String COULEUR = "Couleur";
    private static String QTE = "Qt\u00e9 r\u00e9elle relev\u00e9e";
    private static String QTE_OPENCONCERTO = "QTE OpenConcerto";
    private final Map<String, Integer> mapCouleur = new HashMap<String, Integer>();
    private final Map<String, Integer> mapTaille = new HashMap<String, Integer>();
    private final DBRoot root;
    private final SQLElement artElt;
    private final Map<String, InventaireProductLine> mapDepotArticle = new HashMap<String, InventaireProductLine>();
    private final Map<String, InventaireProductLine> mapDepotArticleVirtuel = new HashMap<String, InventaireProductLine>();
    private final Map<Tuple3<String, String, String>, InventaireProductLine> mapDepotDeclArticle = new HashMap<Tuple3<String, String, String>, InventaireProductLine>();

    public InventaireFromEtatStockImporter(SQLElement articleElt) {
        this.root = articleElt.getTable().getDBRoot();
        this.artElt = articleElt;
        SQLSelect sel = new SQLSelect();
        sel.addSelect(articleElt.getTable().getTable("ARTICLE_DECLINAISON_COULEUR").getKey());
        sel.addSelect(articleElt.getTable().getTable("ARTICLE_DECLINAISON_COULEUR").getField("NOM"));
        List<SQLRow> l = SQLRowListRSH.execute(sel);
        for (SQLRow sqlRow : l) {
            this.mapCouleur.put(sqlRow.getString("NOM").trim(), sqlRow.getID());
        }
        sel = new SQLSelect();
        sel.addSelect(articleElt.getTable().getTable("ARTICLE_DECLINAISON_TAILLE").getKey());
        sel.addSelect(articleElt.getTable().getTable("ARTICLE_DECLINAISON_TAILLE").getField("NOM"));
        l = SQLRowListRSH.execute(sel);
        for (SQLRow sqlRow : l) {
            this.mapTaille.put(sqlRow.getString("NOM").trim(), sqlRow.getID());
        }
    }

    public void importArticles(File file, DBRoot root) throws IOException, SQLException {
        SQLTable table = root.findTable("ARTICLE");
        SQLTable tableArtElt = root.findTable("ARTICLE_ELEMENT");
        this.fillArticles();
        HashMap<String, Integer> columnMapping = new HashMap<String, Integer>();
        columnMapping.put(CODE, null);
        columnMapping.put(NOM, null);
        columnMapping.put(TAILLE, null);
        columnMapping.put(FAMILLE, null);
        columnMapping.put(COULEUR, null);
        columnMapping.put(QTE, null);
        columnMapping.put(QTE_OPENCONCERTO, null);
        columnMapping.put(DEPOT, null);
        DataImporter importer = new DataImporter(table);
        importer.setSkipFirstLine(false);
        ArrayTableModel m = importer.createModelFrom(file);
        List line = m.getLineValuesAt(0);
        int i = 0;
        while (i < line.size()) {
            Object object = line.get(i);
            if (object != null) {
                for (String key : columnMapping.keySet()) {
                    if (!object.toString().equalsIgnoreCase(key)) continue;
                    columnMapping.put(key, i);
                }
            }
            ++i;
        }
        String msg = "Colonnes import\u00e9es : \n";
        SQLPreferences prefs = SQLPreferences.getMemCached(table.getDBRoot());
        boolean hasDeclinaison = prefs.getBoolean(GestionArticleGlobalPreferencePanel.ACTIVER_DECLINAISON, false);
        List<String> required = hasDeclinaison ? Arrays.asList(CODE, QTE, QTE_OPENCONCERTO, TAILLE, COULEUR) : Arrays.asList(CODE, QTE, QTE_OPENCONCERTO);
        SQLSelect selDepot = new SQLSelect();
        selDepot.addSelectStar(tableArtElt.getTable("DEPOT_STOCK"));
        List<SQLRow> listDepot = SQLRowListRSH.execute(selDepot);
        HashMap<String, SQLRow> mapDepot = new HashMap<String, SQLRow>();
        for (SQLRow sQLRow : listDepot) {
            mapDepot.put(sQLRow.getString("NOM"), sQLRow);
        }
        for (Map.Entry entry : columnMapping.entrySet()) {
            if (entry.getValue() != null) {
                msg = String.valueOf(msg) + (String)entry.getKey() + " : " + this.getColumnName((Integer)entry.getValue()) + "\n";
                continue;
            }
            if (required.contains(entry.getKey())) {
                JOptionPane.showMessageDialog(null, "Aucune colonne " + (String)entry.getKey() + " trouv\u00e9e, import annul\u00e9!\nCette colonne est obligatoire.");
                return;
            }
            msg = String.valueOf(msg) + (String)entry.getKey() + " : non import\u00e9e\n";
        }
        int n = JOptionPane.showConfirmDialog(null, msg = String.valueOf(msg) + "\nVoulez vous continuer ?");
        if (n == 0) {
            DataImporter importer2 = new DataImporter(table){

                protected void customizeRowValuesToFetch(SQLRowValues vals) {
                    vals.putRowValues("ID_STOCK").putNulls("ID", "QTE_REEL", "QTE_TH", "ID_DEPOT_STOCK");
                }
            };
            importer2.setSkipFirstLine(true);
            ArrayTableModel m2 = importer2.createModelFrom(file);
            boolean multiDepotPrefs = prefs.getBoolean(GestionArticleGlobalPreferencePanel.STOCK_MULTI_DEPOT, false);
            SQLRow defaultDepotRow = null;
            boolean multiDepotFile = columnMapping.containsKey(DEPOT);
            if (!multiDepotFile) {
                if (!multiDepotPrefs) {
                    defaultDepotRow = table.getTable("DEPOT_STOCK").getRow(DepotStockSQLElement.DEFAULT_ID);
                }
            } else {
                HashSet<String> errors = new HashSet<String>();
                int i2 = 1;
                while (i2 < m2.getRowCount()) {
                    List o = m2.getLineValuesAt(i2);
                    if (o.size() >= 5) {
                        System.err.println(o);
                        String code = o.get((Integer)columnMapping.get(CODE)).toString();
                        if (code.trim().length() > 0) {
                            String depotName = o.get((Integer)columnMapping.get(DEPOT)).toString().trim();
                            if (depotName.length() == 0) {
                                errors.add("Le Dep\u00f4t n'est pas renseign\u00e9, ligne " + i2 + ". Import annul\u00e9!");
                            } else if (mapDepot.get(depotName) == null) {
                                errors.add("Impossible de trouver le d\u00e9p\u00f4t " + depotName + ", ligne " + i2 + ". Import annul\u00e9!");
                            }
                        }
                    }
                    ++i2;
                }
                if (!errors.isEmpty()) {
                    JOptionPane.showMessageDialog(null, errors);
                    return;
                }
            }
            Calendar c = Calendar.getInstance();
            Date today = c.getTime();
            HashMap<Integer, Integer> mapDepotEtat = new HashMap<Integer, Integer>();
            ArrayList<SQLInsert> inserts = new ArrayList<SQLInsert>();
            ArrayList<SQLUpdate> updates = new ArrayList<SQLUpdate>();
            int i3 = 1;
            while (i3 < m2.getRowCount()) {
                List o = m2.getLineValuesAt(i3);
                if (o.size() >= 5) {
                    System.err.println(o);
                    String code = o.get((Integer)columnMapping.get(CODE)).toString();
                    if (code.trim().length() > 0) {
                        InventaireProductLine match;
                        String stringQty = o.get((Integer)columnMapping.get(QTE)).toString();
                        Double qty = stringQty.trim().length() == 0 ? 0.0 : Double.valueOf(stringQty);
                        String stringQtyOld = o.get((Integer)columnMapping.get(QTE_OPENCONCERTO)).toString();
                        float qtyOld = stringQtyOld.trim().length() == 0 ? 0.0f : Float.valueOf(stringQtyOld).floatValue();
                        String couleur = "";
                        if (columnMapping.get(COULEUR) != null) {
                            couleur = o.get((Integer)columnMapping.get(COULEUR)).toString();
                        }
                        String taille = "";
                        if (columnMapping.get(TAILLE) != null) {
                            taille = o.get((Integer)columnMapping.get(TAILLE)).toString();
                        }
                        if ((match = this.findArticle(code, couleur, taille)) != null) {
                            SQLRowAccessor depotRow = defaultDepotRow;
                            if (multiDepotFile) {
                                String depotName = o.get((Integer)columnMapping.get(DEPOT)).toString().trim();
                                depotRow = (SQLRowAccessor)mapDepot.get(depotName);
                            }
                            if (!mapDepotEtat.containsKey(depotRow.getID())) {
                                mapDepotEtat.put(depotRow.getID(), this.createEtat(table.getTable("ETAT_STOCK"), depotRow.getID()).commit().getID());
                            }
                            int etatID = (Integer)mapDepotEtat.get(depotRow.getID());
                            SQLRowValues stockValues = match.getOrCreateStockRowValues(depotRow);
                            SQLTable tableMvt = table.getTable("MOUVEMENT_STOCK");
                            SQLInsert insertMvtStockClotureFermeture = new SQLInsert();
                            insertMvtStockClotureFermeture.add(tableMvt.getField("QTE"), Float.valueOf(-qtyOld));
                            insertMvtStockClotureFermeture.add(tableMvt.getField("NOM"), "Cl\u00f4ture stock avant inventaire");
                            insertMvtStockClotureFermeture.add(tableMvt.getField("ID_ARTICLE"), match.getRowValsArt().getID());
                            insertMvtStockClotureFermeture.add(tableMvt.getField("DATE"), today);
                            insertMvtStockClotureFermeture.add(tableMvt.getField("REEL"), Boolean.TRUE);
                            insertMvtStockClotureFermeture.add(tableMvt.getField("ID_STOCK"), ((SQLRowAccessor)stockValues).getID());
                            BigDecimal prc = this.getPRC(match.getRowValsArt(), Math.round(qtyOld), today);
                            if (prc == null) {
                                prc = BigDecimal.ZERO;
                            }
                            if (tableMvt.contains("PRICE")) {
                                insertMvtStockClotureFermeture.add(tableMvt.getField("PRICE"), prc);
                            }
                            insertMvtStockClotureFermeture.add(tableMvt.getField("CLOTURE"), Boolean.TRUE);
                            insertMvtStockClotureFermeture.add(tableMvt.getField("ID_ETAT_STOCK"), etatID);
                            inserts.add(insertMvtStockClotureFermeture);
                            SQLTable tableEtatElt = table.getTable("ETAT_STOCK_ELEMENT");
                            SQLInsert insertItem = new SQLInsert();
                            insertItem.add(tableEtatElt.getField("ID_ETAT_STOCK"), etatID);
                            insertItem.add(tableEtatElt.getField("PA"), prc);
                            insertItem.add(tableEtatElt.getField("PV"), BigDecimal.ZERO);
                            insertItem.add(tableEtatElt.getField("QTE"), Float.valueOf(qtyOld));
                            insertItem.add(tableEtatElt.getField("T_PA"), prc.multiply(new BigDecimal(qtyOld)));
                            insertItem.add(tableEtatElt.getField("T_PV"), BigDecimal.ZERO);
                            insertItem.add(tableEtatElt.getField("CODE"), match.getRowValsArt().getString("CODE"));
                            insertItem.add(tableEtatElt.getField("NOM"), match.getRowValsArt().getString("NOM"));
                            insertItem.add(tableEtatElt.getField("ID_ARTICLE"), match.getRowValsArt().getID());
                            inserts.add(insertItem);
                            SQLInsert insertMvtStockClotureOuverture = new SQLInsert();
                            insertMvtStockClotureOuverture.add(tableMvt.getField("QTE"), qty);
                            insertMvtStockClotureOuverture.add(tableMvt.getField("NOM"), "Mise en stock inventaire");
                            insertMvtStockClotureOuverture.add(tableMvt.getField("ID_ETAT_STOCK"), etatID);
                            insertMvtStockClotureOuverture.add(tableMvt.getField("ID_ARTICLE"), match.getRowValsArt().getID());
                            insertMvtStockClotureOuverture.add(tableMvt.getField("DATE"), today);
                            insertMvtStockClotureOuverture.add(tableMvt.getField("REEL"), Boolean.TRUE);
                            insertMvtStockClotureOuverture.add(tableMvt.getField("ID_STOCK"), ((SQLRowAccessor)stockValues).getID());
                            insertMvtStockClotureOuverture.add(tableMvt.getField("OUVERTURE"), Boolean.TRUE);
                            if (tableMvt.contains("PRICE")) {
                                insertMvtStockClotureOuverture.add(tableMvt.getField("PRICE"), this.getPRC(match.getRowValsArt(), qty.intValue(), today));
                            }
                            inserts.add(insertMvtStockClotureOuverture);
                            SQLUpdate up = new SQLUpdate(new Where((FieldRef)stockValues.getTable().getKey(), "=", ((SQLRowAccessor)stockValues).getID()));
                            up.add(stockValues.getTable().getField("QTE_REEL"), qty);
                        } else {
                            System.err.println("Aucun article correspondant au code " + code);
                        }
                    }
                }
                ++i3;
            }
            if (!inserts.isEmpty()) {
                SQLInsert.executeMultipleWithBatch(table.getDBSystemRoot(), inserts);
            }
            if (!updates.isEmpty()) {
                SQLUpdate.executeMultipleWithBatch(table.getDBSystemRoot(), updates);
            }
            List<SQLRowAccessor> rowsDepot = multiDepotFile ? listDepot : Arrays.asList(defaultDepotRow);
            ArrayList<String> reqs = new ArrayList<String>();
            for (String code : this.codeKits) {
                System.err.println(code);
                SQLRowValues rowValsKit = this.kits.get(code);
                Collection referentRowsStock = rowValsKit.getReferentRows(table.getTable("STOCK").getField("ID_ARTICLE"));
                for (SQLRowAccessor d : referentRowsStock) {
                    StockItem item = new StockItem(rowValsKit, d);
                    Collection elts = rowValsKit.getReferentRows(tableArtElt.getField("ID_ARTICLE_PARENT"));
                    for (SQLRowValues sqlRowValues : elts) {
                        SQLRowValues stockArticle;
                        InventaireProductLine inventaireProductLine = this.kitsChildren.get(sqlRowValues.getID());
                        if (sqlRowValues.getForeign("ID_ARTICLE") == null || (stockArticle = inventaireProductLine.getStockRowValues(d.getForeign("ID_DEPOT_STOCK"))) == null) continue;
                        item.addItemComponent(new StockItemComponent(new StockItem(sqlRowValues.getForeign("ID_ARTICLE"), stockArticle), sqlRowValues.getBigDecimal("QTE_UNITAIRE"), sqlRowValues.getInt("QTE")));
                    }
                    item.updateQtyFromChildren();
                    reqs.add(item.getUpdateRequest());
                }
            }
            if (!reqs.isEmpty()) {
                ArrayList<Object> handlers = new ArrayList<Object>(reqs.size());
                for (String s : reqs) {
                    handlers.add(null);
                }
                SQLUtils.executeMultiple(table.getDBSystemRoot(), reqs, handlers);
            }
        }
    }

    public static SQLInsert getCreateStock(SQLRowAccessor article, SQLRowAccessor depot) {
        SQLTable stockTable = article.getTable().getTable("STOCK");
        SQLRowValues putRowValuesStock = new SQLRowValues(stockTable);
        putRowValuesStock.putNulls(stockTable.getTable().getFieldsName());
        SQLRowValuesListFetcher fetch = SQLRowValuesListFetcher.create(putRowValuesStock);
        Where w = new Where((FieldRef)putRowValuesStock.getTable().getField("ID_DEPOT_STOCK"), "=", depot.getID());
        Where w2 = new Where((FieldRef)putRowValuesStock.getTable().getField("ID_ARTICLE"), "=", article.getID());
        List<SQLRowValues> rowValsResult = fetch.fetch(w.and(w2));
        if (rowValsResult.size() == 0) {
            SQLInsert insert = new SQLInsert();
            insert.add(stockTable.getField("ID_ARTICLE"), article.getID());
            insert.add(stockTable.getField("ID_DEPOT_STOCK"), depot.getID());
            insert.add(stockTable.getField("QTE_TH"), Float.valueOf(0.0f));
            insert.add(stockTable.getField("QTE_REEL"), Float.valueOf(0.0f));
            insert.add(stockTable.getField("QTE_RECEPT_ATTENTE"), Float.valueOf(0.0f));
            insert.add(stockTable.getField("QTE_LIV_ATTENTE"), Float.valueOf(0.0f));
            return insert;
        }
        return null;
    }

    private SQLRowValues createEtat(SQLTable tableEtat, int depotID) {
        SQLRowValues rowVals = new SQLRowValues(tableEtat);
        rowVals.put("DATE", new Date());
        rowVals.put("INVENTAIRE", Boolean.TRUE);
        rowVals.put("ID_DEPOT_STOCK", depotID);
        return rowVals;
    }

    private void checkMinPrice(SQLRow rowValsSuplierLastValid, SQLRow lastValidRow) {
        boolean update = false;
        ProductHelper helper = new ProductHelper(rowValsSuplierLastValid.getTable().getDBRoot());
        BigDecimal result = helper.getEnumPrice(rowValsSuplierLastValid, ProductHelper.SupplierPriceField.COEF_PRIX_MINI);
        if (result != null) {
            int qteSuplier = rowValsSuplierLastValid.getInt("QTE");
            Calendar date2 = rowValsSuplierLastValid.getDate("DATE_PRIX");
            if (date2 != null && lastValidRow != null) {
                Calendar date1 = lastValidRow.getDate("DATE");
                if (date1.get(1) == date2.get(1) && date1.get(2) == date2.get(2) && date1.get(5) == date2.get(5) || date1.after(date2)) {
                    if (lastValidRow.getBigDecimal("PRIX") != null && lastValidRow.getInt("QTE") <= qteSuplier) {
                        try {
                            lastValidRow.asRowValues().put("PRIX", result).commit();
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                        update = true;
                    }
                } else if (date1.before(date2)) {
                    SQLRowValues rowValsToInsert = new SQLRowValues(lastValidRow.getTable());
                    rowValsToInsert.put("PRIX", result);
                    rowValsToInsert.put("DATE", rowValsSuplierLastValid.getObject("DATE_PRIX"));
                    rowValsToInsert.put("QTE", rowValsSuplierLastValid.getObject("QTE"));
                    rowValsToInsert.put("ID_ARTICLE", rowValsSuplierLastValid.getInt("ID_ARTICLE"));
                    try {
                        rowValsToInsert.commit();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public BigDecimal getPRC(SQLRowValues rowVals, int qty, Date d) {
        ProductComponent comp = new ProductComponent(rowVals, new BigDecimal(qty), null, null);
        return comp.getPRC(d);
    }

    private void fillArticles() throws SQLException {
        SQLTable table = Configuration.getInstance().getRoot().findTable("ARTICLE");
        SQLRowValues graph = new SQLRowValues(table);
        graph.put("ID", null);
        graph.put("CODE", null);
        graph.put("NOM", null);
        graph.put("VIRTUEL", null);
        graph.putRowValues("ID_ARTICLE_DECLINAISON_COULEUR").putNulls("ID", "NOM");
        graph.putRowValues("ID_ARTICLE_DECLINAISON_TAILLE").putNulls("ID", "NOM");
        SQLTable foreignTableStock = table.getForeignTable("ID_STOCK");
        SQLRowValues graphStock = new SQLRowValues(foreignTableStock);
        graphStock.putNulls("ID", "QTE_REEL", "QTE_TH", "QTE_LIV_ATTENTE", "QTE_RECEPT_ATTENTE").putRowValues("ID_DEPOT_STOCK").putNulls("NOM");
        graphStock.put("ID_ARTICLE", (Object)graph);
        SQLRowValues graphStockArt = new SQLRowValues(foreignTableStock);
        graphStockArt.putNulls("ID", "QTE_REEL", "QTE_TH", "QTE_LIV_ATTENTE", "QTE_RECEPT_ATTENTE").putRowValues("ID_DEPOT_STOCK").putNulls("NOM");
        graph.put("ID_STOCK", (Object)graphStockArt);
        SQLTable tableArtElt = table.getTable("ARTICLE_ELEMENT");
        SQLRowValues artElt = new SQLRowValues(tableArtElt);
        artElt.put("ID", null);
        artElt.put("QTE", null);
        artElt.put("QTE_UNITAIRE", null);
        artElt.put("ID_ARTICLE_PARENT", (Object)graph);
        SQLRowValues articleParent = artElt.putRowValues("ID_ARTICLE");
        articleParent.putNulls("ID", "CODE", "NOM", "VIRTUEL");
        articleParent.putRowValues("ID_ARTICLE_DECLINAISON_COULEUR").putNulls("ID", "NOM");
        articleParent.putRowValues("ID_ARTICLE_DECLINAISON_TAILLE").putNulls("ID", "NOM");
        SQLRowValues graphStockItem = new SQLRowValues(foreignTableStock);
        graphStockItem.put("ID_ARTICLE", (Object)articleParent);
        SQLRowValues graphStockArtItem = new SQLRowValues(foreignTableStock);
        graphStockArtItem.putNulls("ID_DEPOT_STOCK", "ID", "QTE_REEL", "QTE_TH", "QTE_LIV_ATTENTE", "QTE_RECEPT_ATTENTE");
        articleParent.put("ID_STOCK", (Object)graphStockArtItem);
        SQLRowValuesListFetcher fetcher = SQLRowValuesListFetcher.create(graph);
        List<SQLRowValues> results = fetcher.fetch();
        Calendar c = Calendar.getInstance();
        c.add(2, -2);
        c.set(5, 31);
        for (SQLRowValues sqlRowValues : results) {
            SQLRowAccessor taille;
            String code = sqlRowValues.getString("CODE");
            if (sqlRowValues.getBoolean("VIRTUEL").booleanValue()) {
                this.mapDepotArticleVirtuel.put(sqlRowValues.getString("CODE"), new InventaireProductLine(sqlRowValues));
            }
            SQLRowAccessor couleur = sqlRowValues.getObject("ID_ARTICLE_DECLINAISON_COULEUR") == null ? null : sqlRowValues.getNonEmptyForeign("ID_ARTICLE_DECLINAISON_COULEUR");
            SQLRowAccessor sQLRowAccessor = taille = sqlRowValues.getObject("ID_ARTICLE_DECLINAISON_TAILLE") == null ? null : sqlRowValues.getNonEmptyForeign("ID_ARTICLE_DECLINAISON_TAILLE");
            if (couleur == null && taille == null) {
                this.mapDepotArticle.put(sqlRowValues.getString("CODE"), new InventaireProductLine(sqlRowValues));
            } else if (couleur == null) {
                this.mapDepotDeclArticle.put(Tuple3.create(sqlRowValues.getString("CODE"), null, taille.getString("NOM")), new InventaireProductLine(sqlRowValues));
            } else if (taille == null) {
                this.mapDepotDeclArticle.put(Tuple3.create(sqlRowValues.getString("CODE"), couleur.getString("NOM"), null), new InventaireProductLine(sqlRowValues));
            } else {
                this.mapDepotDeclArticle.put(Tuple3.create(sqlRowValues.getString("CODE"), couleur.getString("NOM"), taille.getString("NOM")), new InventaireProductLine(sqlRowValues));
            }
            Collection referentRows = sqlRowValues.getReferentRows(tableArtElt.getField("ID_ARTICLE_PARENT"));
            if (referentRows.size() == 0) continue;
            boolean contains = false;
            for (SQLRowValues sqlRowValues2 : referentRows) {
                if (sqlRowValues2.getForeign("ID_ARTICLE") == null || sqlRowValues2.isForeignEmpty("ID_ARTICLE") || sqlRowValues2.getForeign("ID_ARTICLE").getString("CODE") == null || !this.codeKits.contains(sqlRowValues2.getForeign("ID_ARTICLE").getString("CODE"))) continue;
                contains = true;
                break;
            }
            if (!contains) {
                this.codeKits.add(0, code);
            } else {
                this.codeKits.add(code);
            }
            this.kits.put(code, sqlRowValues);
        }
        this.fillKitChildren();
    }

    private void fillKitChildren() {
        SQLTable table = Configuration.getInstance().getRoot().findTable("ARTICLE");
        SQLRowValues graph = new SQLRowValues(table);
        graph.put("ID", null);
        graph.put("CODE", null);
        graph.put("NOM", null);
        graph.put("VIRTUEL", null);
        graph.putRowValues("ID_ARTICLE_DECLINAISON_COULEUR").putNulls("ID", "NOM");
        graph.putRowValues("ID_ARTICLE_DECLINAISON_TAILLE").putNulls("ID", "NOM");
        SQLTable foreignTableStock = table.getForeignTable("ID_STOCK");
        SQLRowValues graphStock = new SQLRowValues(foreignTableStock);
        graphStock.putNulls("ID", "QTE_REEL", "QTE_TH", "QTE_LIV_ATTENTE", "QTE_RECEPT_ATTENTE").putRowValues("ID_DEPOT_STOCK").putNulls("NOM");
        graphStock.put("ID_ARTICLE", (Object)graph);
        final SQLTable tableArtElt = table.getTable("ARTICLE_ELEMENT");
        SQLRowValues artElt = new SQLRowValues(tableArtElt);
        artElt.put("ID", null);
        artElt.put("QTE", null);
        artElt.put("QTE_UNITAIRE", null);
        artElt.put("ID_ARTICLE", (Object)graph);
        SQLRowValuesListFetcher fetcher = SQLRowValuesListFetcher.create(graph);
        fetcher.appendSelTransf(new ITransformer<SQLSelect, SQLSelect>(){

            @Override
            public SQLSelect transformChecked(SQLSelect input) {
                input.setWhere(Where.inValues(tableArtElt.getField("ID_ARTICLE_PARENT"), SQLRow.getIDs(InventaireFromEtatStockImporter.this.kits.values())));
                return input;
            }
        });
        List<SQLRowValues> results = fetcher.fetch();
        for (SQLRowValues sqlRowValues : results) {
            SQLRowAccessor foreign = sqlRowValues.getNonEmptyForeign("ID_ARTICLE");
            if (foreign == null) continue;
            this.kitsChildren.put(foreign.getID(), new InventaireProductLine(foreign.asRowValues()));
        }
    }

    private InventaireProductLine findArticle(String code, String couleur, String taille) throws SQLException {
        InventaireProductLine t;
        SQLRowValues rowVals;
        if (!this.mapCouleur.containsKey(couleur)) {
            rowVals = new SQLRowValues(this.root.getTable("ARTICLE_DECLINAISON_COULEUR"));
            rowVals.put("NOM", couleur);
            this.mapCouleur.put(couleur, rowVals.commit().getID());
        }
        if (!this.mapTaille.containsKey(taille)) {
            rowVals = new SQLRowValues(this.root.getTable("ARTICLE_DECLINAISON_TAILLE"));
            rowVals.put("NOM", taille);
            this.mapTaille.put(taille, rowVals.commit().getID());
        }
        if (!(couleur != null && couleur.trim().length() != 0 || taille != null && taille.trim().length() != 0)) {
            t = this.mapDepotArticle.get(code);
        } else if (couleur == null || couleur.trim().length() == 0) {
            t = this.mapDepotDeclArticle.get(Tuple3.create(code, null, taille.trim()));
            if (t == null) {
                SQLRowValues artRow = this.cloneFromArticle(this.mapDepotArticleVirtuel.get(code).getRowValsArt(), null, this.mapTaille.get(taille.trim())).asRowValues();
                t = new InventaireProductLine(artRow);
                this.mapDepotDeclArticle.put(Tuple3.create(code, null, taille.trim()), t);
            }
        } else if (taille == null || taille.trim().length() == 0) {
            t = this.mapDepotDeclArticle.get(Tuple3.create(code, couleur.trim(), null));
            if (t == null) {
                SQLRowValues artRow = this.cloneFromArticle(this.mapDepotArticleVirtuel.get(code).getRowValsArt(), this.mapCouleur.get(couleur.trim()), null).asRowValues();
                t = new InventaireProductLine(artRow);
                this.mapDepotDeclArticle.put(Tuple3.create(code, couleur.trim(), null), t);
            }
        } else {
            t = this.mapDepotDeclArticle.get(Tuple3.create(code, couleur.trim(), taille.trim()));
            if (t == null && this.mapDepotArticleVirtuel.get(code) != null) {
                SQLRowValues artRow = this.cloneFromArticle(this.mapDepotArticleVirtuel.get(code).getRowValsArt(), this.mapCouleur.get(couleur.trim()), this.mapTaille.get(taille.trim())).asRowValues();
                t = new InventaireProductLine(artRow);
                this.mapDepotDeclArticle.put(Tuple3.create(code, couleur.trim(), taille.trim()), t);
            }
        }
        return t;
    }

    public SQLRow cloneFromArticle(SQLRowAccessor rArt, Integer idCouleur, Integer idTaille) throws SQLException {
        if (rArt == null) {
            return null;
        }
        SQLRowValues copy = this.artElt.createCopy(rArt.getID());
        copy.put("VIRTUEL", Boolean.FALSE);
        copy.put("ID_ARTICLE_VIRTUEL_PERE", rArt.getID());
        if (idCouleur != null) {
            copy.put("ID_ARTICLE_DECLINAISON_COULEUR", idCouleur);
        }
        if (idTaille != null) {
            copy.put("ID_ARTICLE_DECLINAISON_TAILLE", idTaille);
        }
        return copy.commit();
    }

    private String getColumnName(int columnNumber) {
        int dividend = columnNumber;
        String columnName = "";
        while (dividend >= 0) {
            int modulo = dividend % 26;
            columnName = String.valueOf(String.valueOf((char)(65 + modulo))) + columnName;
            if ((dividend = (dividend - modulo) / 26) <= 0) break;
            --dividend;
        }
        return columnName;
    }

    class InventaireProductLine {
        private final SQLRowValues rowValsArt;
        private final Map<String, SQLRowValues> stockMap = new HashMap<String, SQLRowValues>();

        public InventaireProductLine(SQLRowValues rowValsArt) {
            this.rowValsArt = rowValsArt;
            Collection<SQLRowValues> stocks = this.rowValsArt.getReferentRows(this.rowValsArt.getTable().getTable("STOCK"));
            for (SQLRowValues rowValsStock : stocks) {
                this.stockMap.put(rowValsStock.getForeign("ID_DEPOT_STOCK").getString("NOM"), rowValsStock);
            }
        }

        public SQLRowValues getOrCreateStockRowValues(SQLRowAccessor depot) {
            String depotName = depot.getString("NOM");
            if (!this.stockMap.containsKey(depotName)) {
                this.stockMap.put(depotName, ProductComponent.findOrCreateStock(this.rowValsArt, depot).asRowValues());
            }
            return this.stockMap.get(depotName);
        }

        public SQLRowValues getStockRowValues(SQLRowAccessor depot) {
            String depotName = depot.getString("NOM");
            if (!this.stockMap.containsKey(depotName)) {
                return null;
            }
            return this.stockMap.get(depotName);
        }

        public SQLRowValues getRowValsArt() {
            return this.rowValsArt;
        }
    }
}

