/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.shipment.ui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.ui.AbstractArticleItemTable;
import org.openconcerto.erp.core.common.ui.AbstractVenteArticleItemTable;
import org.openconcerto.erp.core.common.ui.Acompte;
import org.openconcerto.erp.core.common.ui.AcompteCellEditor;
import org.openconcerto.erp.core.common.ui.DeviseNumericCellEditor;
import org.openconcerto.erp.core.common.ui.DeviseNumericHTConvertorCellEditor;
import org.openconcerto.erp.core.common.ui.DeviseTableCellRenderer;
import org.openconcerto.erp.core.common.ui.ItemAutoCompletionManager;
import org.openconcerto.erp.core.common.ui.NiveauTableCellEditor;
import org.openconcerto.erp.core.common.ui.NiveauTableCellRender;
import org.openconcerto.erp.core.common.ui.QteCellEditor;
import org.openconcerto.erp.core.common.ui.Remise;
import org.openconcerto.erp.core.finance.accounting.model.CurrencyConverter;
import org.openconcerto.erp.core.finance.tax.model.TaxeCache;
import org.openconcerto.erp.core.sales.pos.io.BarcodeReader;
import org.openconcerto.erp.core.sales.pos.ui.BarcodeListener;
import org.openconcerto.erp.core.sales.product.element.ReferenceArticleSQLElement;
import org.openconcerto.erp.core.sales.product.ui.ArticleRowValuesRenderer;
import org.openconcerto.erp.core.sales.product.ui.CurrencyWithSymbolRenderer;
import org.openconcerto.erp.core.sales.product.ui.DeliveredQtyRowValuesRenderer;
import org.openconcerto.erp.core.sales.product.ui.QteUnitRowValuesRenderer;
import org.openconcerto.erp.core.sales.product.ui.QtyToDeliverRowValuesRenderer;
import org.openconcerto.erp.core.sales.product.ui.ReliquatRowValuesTable;
import org.openconcerto.erp.core.supplychain.stock.element.StockSQLElement;
import org.openconcerto.erp.preferences.DefaultNXProps;
import org.openconcerto.erp.preferences.GestionArticleGlobalPreferencePanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.UndefinedRowValuesCache;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.sql.sqlobject.ITextArticleWithCompletionCellEditor;
import org.openconcerto.sql.users.rights.UserRights;
import org.openconcerto.sql.users.rights.UserRightsManager;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.EditPanel;
import org.openconcerto.sql.view.list.CellDynamicModifier;
import org.openconcerto.sql.view.list.RowValuesTable;
import org.openconcerto.sql.view.list.RowValuesTableModel;
import org.openconcerto.sql.view.list.SQLTableElement;
import org.openconcerto.sql.view.list.SQLTextComboTableCellEditor;
import org.openconcerto.sql.view.list.ValidStateChecker;
import org.openconcerto.ui.table.XTableColumnModel;
import org.openconcerto.utils.DecimalUtils;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.Tuple3;
import org.openconcerto.utils.cc.ITransformer;
import org.openconcerto.utils.i18n.TranslationManager;

public class BonDeLivraisonItemTable
extends AbstractVenteArticleItemTable {
    private SQLTableElement tableElementPoidsTotalLivree;
    private SQLTable tableArticle = Configuration.getInstance().getBase().getTable("ARTICLE");
    private ReliquatRowValuesTable reliquatTable;
    public static Map<String, Boolean> customVisibilityMap = new HashMap<String, Boolean>();

    public BonDeLivraisonItemTable(List<JButton> l) {
        super(l);
    }

    public void setReliquatTable(ReliquatRowValuesTable reliquatTable) {
        this.reliquatTable = reliquatTable;
    }

    @Override
    protected Map<String, Boolean> getCustomVisibilityMap() {
        return customVisibilityMap;
    }

    @Override
    protected void init() {
        BarcodeReader barcodeReader;
        final SQLElement e = this.getSQLElement();
        SQLPreferences prefs = new SQLPreferences(this.getSQLElement().getTable().getDBRoot());
        boolean selectArticle = prefs.getBoolean(GestionArticleGlobalPreferencePanel.USE_CREATED_ARTICLE, false);
        final boolean activeCalculM2 = prefs.getBoolean(GestionArticleGlobalPreferencePanel.ACTIVE_CALCUL_M2, false);
        boolean createAuto = prefs.getBoolean(GestionArticleGlobalPreferencePanel.CREATE_ARTICLE_AUTO, true);
        final boolean filterFamilleArticle = prefs.getBoolean(GestionArticleGlobalPreferencePanel.FILTER_BY_FAMILY, false);
        boolean showEco = prefs.getBoolean(AbstractVenteArticleItemTable.SHOW_ECO_CONTRIBUTION_COLUMNS, false);
        boolean showDevise = prefs.getBoolean("ArticleShowDevise", false);
        boolean withDeclinaison = prefs.getBoolean(GestionArticleGlobalPreferencePanel.ACTIVER_DECLINAISON, false);
        UserRights rights = UserRightsManager.getCurrentUserRights();
        boolean editVTPrice = rights.haveRight("CORPS_EDITER_PRIX_VENTE");
        boolean showHAPrice = rights.haveRight("CORPS_VOIR_PRIX_ACHAT");
        boolean lockVTMinPrice = rights.haveRight("CORPS_VERROU_PRIX_MIN_VENTE");
        Vector<SQLTableElement> list = new Vector<SQLTableElement>();
        SQLTableElement eNiveau = new SQLTableElement(e.getTable().getField("NIVEAU")){

            @Override
            public void setValueFrom(SQLRowValues row, Object value) {
                super.setValueFrom(row, value);
            }
        };
        eNiveau.setRenderer(new NiveauTableCellRender());
        eNiveau.setEditor(new NiveauTableCellEditor());
        list.add(eNiveau);
        list.add(new SQLTableElement(e.getTable().getField("ID_STYLE")));
        SQLTableElement tableFamille = new SQLTableElement(e.getTable().getField("ID_FAMILLE_ARTICLE"));
        list.add(tableFamille);
        SQLTableElement tableElementDepot = new SQLTableElement(e.getTable().getField("ID_DEPOT_STOCK"), true, true, true);
        list.add(tableElementDepot);
        SQLTableElement tableElementArticle = new SQLTableElement(e.getTable().getField("ID_ARTICLE"), true, true, true){

            @Override
            public boolean isCellEditable(SQLRowValues vals, int rowIndex, int columnIndex) {
                boolean b = super.isCellEditable(vals, rowIndex, columnIndex);
                if (e.getTable().contains("ID_COMMANDE_CLIENT_ELEMENT")) {
                    boolean noCmdElt;
                    boolean bl = noCmdElt = vals.getObject("ID_COMMANDE_CLIENT_ELEMENT") == null || vals.isForeignEmpty("ID_COMMANDE_CLIENT_ELEMENT");
                    return b && noCmdElt;
                }
                return b;
            }
        };
        list.add(tableElementArticle);
        if (e.getTable().getFieldsName().contains("ID_ECO_CONTRIBUTION")) {
            this.tableElementEcoID = new SQLTableElement(e.getTable().getField("ID_ECO_CONTRIBUTION"));
            list.add(this.tableElementEcoID);
        }
        SQLTableElement tableElementCode = new SQLTableElement(e.getTable().getField("CODE"), String.class, new ITextArticleWithCompletionCellEditor(e.getTable().getTable("ARTICLE"), e.getTable().getTable("ARTICLE_FOURNISSEUR"), withDeclinaison)){

            @Override
            public boolean isCellEditable(SQLRowValues vals, int rowIndex, int columnIndex) {
                boolean b = super.isCellEditable(vals, rowIndex, columnIndex);
                if (e.getTable().contains("ID_COMMANDE_CLIENT_ELEMENT")) {
                    boolean noCmdElt;
                    boolean bl = noCmdElt = vals.getObject("ID_COMMANDE_CLIENT_ELEMENT") == null || vals.isForeignEmpty("ID_COMMANDE_CLIENT_ELEMENT");
                    return b && noCmdElt;
                }
                return b;
            }
        };
        list.add(tableElementCode);
        SQLTableElement tableElementNom = new SQLTableElement(e.getTable().getField("NOM")){

            @Override
            public boolean isCellEditable(SQLRowValues vals, int rowIndex, int columnIndex) {
                boolean b = super.isCellEditable(vals, rowIndex, columnIndex);
                if (e.getTable().contains("ID_COMMANDE_CLIENT_ELEMENT")) {
                    boolean noCmdElt;
                    boolean bl = noCmdElt = vals.getObject("ID_COMMANDE_CLIENT_ELEMENT") == null || vals.isForeignEmpty("ID_COMMANDE_CLIENT_ELEMENT");
                    return b && noCmdElt;
                }
                return b;
            }
        };
        list.add(tableElementNom);
        Set<String> fieldsName = e.getTable().getFieldsName();
        ArrayList<String> fieldDecl = new ArrayList<String>();
        if (withDeclinaison) {
            for (String string : fieldsName) {
                if (!string.startsWith("ID_ARTICLE_DECLINAISON")) continue;
                SQLTableElement tableElementDeclinaison = new SQLTableElement(e.getTable().getField(string));
                tableElementDeclinaison.setEditable(false);
                fieldDecl.add(string);
                list.add(tableElementDeclinaison);
            }
        }
        SQLTableElement tableElementDesc = new SQLTableElement(e.getTable().getField("DESCRIPTIF"));
        list.add(tableElementDesc);
        if (e.getTable().getFieldsName().contains("DELAI")) {
            SQLTableElement tableElementDelai = new SQLTableElement(e.getTable().getField("DELAI"));
            list.add(tableElementDelai);
        }
        SQLTableElement eltLongueur = new SQLTableElement(e.getTable().getField("LONGUEUR")){

            @Override
            public boolean isCellEditable(SQLRowValues vals, int rowIndex, int columnIndex) {
                int idUv = vals.getForeignID("ID_UNITE_VENTE");
                return idUv == 4;
            }
        };
        list.add(eltLongueur);
        SQLTableElement eltLargeur = new SQLTableElement(e.getTable().getField("LARGEUR")){

            @Override
            public boolean isCellEditable(SQLRowValues vals, int rowIndex, int columnIndex) {
                int idUv = vals.getForeignID("ID_UNITE_VENTE");
                return idUv == 4;
            }
        };
        list.add(eltLargeur);
        SQLTableElement eltHauteur = new SQLTableElement(e.getTable().getField("HAUTEUR"));
        list.add(eltHauteur);
        SQLTableElement qteU = new SQLTableElement(e.getTable().getField("QTE_UNITAIRE"), BigDecimal.class){

            @Override
            public boolean isCellEditable(SQLRowValues vals, int rowIndex, int columnIndex) {
                SQLRowAccessor row = vals.getForeign("ID_UNITE_VENTE");
                if (row != null && !row.isUndefined() && row.getBoolean("A_LA_PIECE").booleanValue()) {
                    return false;
                }
                if (activeCalculM2 && row != null && !row.isUndefined() && row.getID() == 4) {
                    return false;
                }
                return super.isCellEditable(vals, rowIndex, columnIndex);
            }

            @Override
            protected Object getDefaultNullValue() {
                return BigDecimal.ZERO;
            }

            @Override
            public TableCellRenderer getTableCellRenderer() {
                return new QteUnitRowValuesRenderer();
            }
        };
        list.add(qteU);
        SQLTableElement uniteVente = new SQLTableElement(e.getTable().getField("ID_UNITE_VENTE"));
        list.add(uniteVente);
        this.qte = new SQLTableElement(e.getTable().getField("QTE"), Integer.class, new QteCellEditor()){

            @Override
            protected Object getDefaultNullValue() {
                return 0;
            }

            @Override
            public TableCellRenderer getTableCellRenderer() {
                return new QtyToDeliverRowValuesRenderer();
            }
        };
        list.add(this.qte);
        SQLTableElement tableElement_QuantiteLivree = new SQLTableElement(e.getTable().getField("QTE_LIVREE"), Integer.class){

            @Override
            public TableCellRenderer getTableCellRenderer() {
                return new DeliveredQtyRowValuesRenderer();
            }

            @Override
            protected Object getDefaultNullValue() {
                return 0;
            }
        };
        list.add(tableElement_QuantiteLivree);
        SQLTableElement tableElement_ValeurMetrique2 = new SQLTableElement(e.getTable().getField("VALEUR_METRIQUE_2"), Float.class){

            @Override
            public boolean isCellEditable(SQLRowValues vals, int rowIndex, int columnIndex) {
                Number modeNumber = (Number)vals.getObject("ID_MODE_VENTE_ARTICLE");
                if (modeNumber != null && (modeNumber.intValue() == 5 || modeNumber.intValue() == 4 || modeNumber.intValue() == 2)) {
                    return false;
                }
                return super.isCellEditable(vals, rowIndex, columnIndex);
            }

            @Override
            public TableCellRenderer getTableCellRenderer() {
                return new ArticleRowValuesRenderer(null);
            }
        };
        list.add(tableElement_ValeurMetrique2);
        SQLTableElement tableElement_ValeurMetrique3 = new SQLTableElement(e.getTable().getField("VALEUR_METRIQUE_3"), Float.class){

            @Override
            public boolean isCellEditable(SQLRowValues vals, int rowIndex, int columnIndex) {
                Number modeNumber = (Number)vals.getObject("ID_MODE_VENTE_ARTICLE");
                if (modeNumber != null && modeNumber.intValue() != 4) {
                    return false;
                }
                return super.isCellEditable(vals, rowIndex, columnIndex);
            }

            @Override
            public TableCellRenderer getTableCellRenderer() {
                return new ArticleRowValuesRenderer(null);
            }
        };
        list.add(tableElement_ValeurMetrique3);
        SQLTableElement tableElement_ValeurMetrique1 = new SQLTableElement(e.getTable().getField("VALEUR_METRIQUE_1"), Float.class){

            @Override
            public boolean isCellEditable(SQLRowValues vals, int rowIndex, int columnIndex) {
                Number modeNumber = (Number)vals.getObject("ID_MODE_VENTE_ARTICLE");
                if (modeNumber != null && (modeNumber.intValue() == 5 || modeNumber.intValue() == 4 || modeNumber.intValue() == 6)) {
                    return false;
                }
                return super.isCellEditable(vals, rowIndex, columnIndex);
            }

            @Override
            public TableCellRenderer getTableCellRenderer() {
                return new ArticleRowValuesRenderer(null);
            }
        };
        list.add(tableElement_ValeurMetrique1);
        SQLTableElement tableElement_PrixMetrique1_AchatHT = new SQLTableElement(e.getTable().getField("PRIX_METRIQUE_HA_1"), BigDecimal.class){

            @Override
            protected Object getDefaultNullValue() {
                return BigDecimal.ZERO;
            }

            @Override
            public boolean isCellEditable(SQLRowValues vals, int rowIndex, int columnIndex) {
                return BonDeLivraisonItemTable.this.isCellNiveauEditable(vals, rowIndex, columnIndex);
            }
        };
        tableElement_PrixMetrique1_AchatHT.setRenderer(new CurrencyWithSymbolRenderer());
        list.add(tableElement_PrixMetrique1_AchatHT);
        SQLField field = e.getTable().getField("PRIX_METRIQUE_VT_1");
        final DeviseNumericHTConvertorCellEditor editorPVHT = new DeviseNumericHTConvertorCellEditor(field);
        SQLTableElement tableElement_PrixMetrique1_VenteHT = new SQLTableElement(field, BigDecimal.class, editorPVHT);
        tableElement_PrixMetrique1_VenteHT.setRenderer(new DeviseTableCellRenderer());
        list.add(tableElement_PrixMetrique1_VenteHT);
        if (e.getTable().getFieldsName().contains("ECO_CONTRIBUTION")) {
            this.tableElementEco = new SQLTableElement(e.getTable().getField("ECO_CONTRIBUTION"));
            list.add(this.tableElementEco);
        }
        SQLTableElement eltDevise = null;
        SQLTableElement eltUnitDevise = null;
        if (showDevise) {
            eltDevise = new SQLTableElement(e.getTable().getField("ID_DEVISE"));
            list.add(eltDevise);
            eltUnitDevise = new SQLTableElement(e.getTable().getField("PV_U_DEVISE"), BigDecimal.class){

                @Override
                public boolean isCellEditable(SQLRowValues vals, int rowIndex, int columnIndex) {
                    return BonDeLivraisonItemTable.this.isCellNiveauEditable(vals, rowIndex, columnIndex);
                }
            };
            eltUnitDevise.setRenderer(new DeviseTableCellRenderer());
            list.add(eltUnitDevise);
        }
        SQLTableElement tableElement_ModeVente = new SQLTableElement(e.getTable().getField("ID_MODE_VENTE_ARTICLE"));
        list.add(tableElement_ModeVente);
        SQLField prixAchatHTField = e.getTable().getField("PA_HT");
        DeviseNumericCellEditor editorPAchatHT = new DeviseNumericCellEditor(prixAchatHTField);
        this.ha = new SQLTableElement(prixAchatHTField, BigDecimal.class, editorPAchatHT){

            @Override
            protected Object getDefaultNullValue() {
                return BigDecimal.ZERO;
            }

            @Override
            public boolean isCellEditable(SQLRowValues vals, int rowIndex, int columnIndex) {
                return BonDeLivraisonItemTable.this.isCellNiveauEditable(vals, rowIndex, columnIndex);
            }
        };
        this.ha.setRenderer(new CurrencyWithSymbolRenderer());
        list.add(this.ha);
        final SQLTableElement tableElement_PrixVente_HT = new SQLTableElement(e.getTable().getField("PV_HT"), BigDecimal.class);
        tableElement_PrixVente_HT.setRenderer(new DeviseTableCellRenderer());
        list.add(tableElement_PrixVente_HT);
        this.tableElementTVA = new SQLTableElement(e.getTable().getField("ID_TAXE"));
        list.add(this.tableElementTVA);
        SQLTableElement tableElementPoids = new SQLTableElement(e.getTable().getField("POIDS"), Float.class);
        list.add(tableElementPoids);
        this.tableElementPoidsTotal = new SQLTableElement(e.getTable().getField("T_POIDS"), Float.class);
        list.add(this.tableElementPoidsTotal);
        this.tableElementPoidsTotalLivree = new SQLTableElement(e.getTable().getField("T_POIDS_LIVREE"), Float.class);
        list.add(this.tableElementPoidsTotalLivree);
        if (prefs.getBoolean(GestionArticleGlobalPreferencePanel.ITEM_PACKAGING, false)) {
            SQLTableElement poidsColis = new SQLTableElement(e.getTable().getField("POIDS_COLIS_NET"), BigDecimal.class);
            list.add(poidsColis);
            SQLTableElement nbColis = new SQLTableElement(e.getTable().getField("NB_COLIS"), Integer.class);
            list.add(nbColis);
            final SQLTableElement totalPoidsColis = new SQLTableElement(e.getTable().getField("T_POIDS_COLIS_NET"), BigDecimal.class);
            list.add(totalPoidsColis);
            poidsColis.addModificationListener(totalPoidsColis);
            nbColis.addModificationListener(totalPoidsColis);
            totalPoidsColis.setModifier(new CellDynamicModifier(){

                @Override
                public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                    Object o2 = row.getObject("POIDS_COLIS_NET");
                    Object o3 = row.getObject("NB_COLIS");
                    if (o2 != null && o3 != null) {
                        BigDecimal poids = (BigDecimal)o2;
                        int nb = (Integer)o3;
                        return poids.multiply(new BigDecimal(nb), DecimalUtils.HIGH_PRECISION).setScale(totalPoidsColis.getDecimalDigits(), RoundingMode.HALF_UP);
                    }
                    return row.getObject("T_POIDS_COLIS_NET");
                }
            });
        }
        if (showDevise) {
            this.tableElementTotalDevise = new SQLTableElement(e.getTable().getField("PV_T_DEVISE"), BigDecimal.class){

                @Override
                public boolean isCellEditable(SQLRowValues vals, int rowIndex, int columnIndex) {
                    return BonDeLivraisonItemTable.this.isCellNiveauEditable(vals, rowIndex, columnIndex);
                }
            };
            this.tableElementTotalDevise.setRenderer(new DeviseTableCellRenderer());
            list.add(this.tableElementTotalDevise);
        }
        SQLField fieldRemise = e.getTable().getField("POURCENT_REMISE");
        if (e.getTable().getFieldsName().contains("MONTANT_REMISE")) {
            this.tableElementRemise = new SQLTableElement(e.getTable().getField("POURCENT_REMISE"), Acompte.class, new AcompteCellEditor("POURCENT_REMISE", "MONTANT_REMISE")){

                @Override
                public void setValueFrom(SQLRowValues row, Object value) {
                    if (value != null) {
                        Acompte a = (Acompte)value;
                        row.put("MONTANT_REMISE", a.getMontant());
                        row.put("POURCENT_REMISE", a.getPercent());
                    } else {
                        row.put("MONTANT_REMISE", null);
                        row.put("POURCENT_REMISE", BigDecimal.ZERO);
                    }
                    this.fireModification(row);
                }
            };
            this.tableElementRemise.setRenderer(new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    SQLRowValues rowVals = ((RowValuesTable)table).getRowValuesTableModel().getRowValuesAt(row);
                    JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    BigDecimal percent = rowVals.getBigDecimal("POURCENT_REMISE");
                    BigDecimal amount = rowVals.getBigDecimal("MONTANT_REMISE");
                    Remise a = new Remise(percent, amount);
                    label.setText(a.toPlainString(true));
                    return label;
                }
            });
        } else {
            this.tableElementRemise = new SQLTableElement(fieldRemise){

                @Override
                protected Object getDefaultNullValue() {
                    return BigDecimal.ZERO;
                }
            };
        }
        list.add(this.tableElementRemise);
        this.totalHA = new SQLTableElement(e.getTable().getField("T_PA_HT"), BigDecimal.class);
        this.totalHA.setRenderer(new CurrencyWithSymbolRenderer());
        this.totalHA.setEditable(false);
        list.add(this.totalHA);
        this.totalHT = new SQLTableElement(e.getTable().getField("T_PV_HT"), BigDecimal.class);
        this.totalHT.setRenderer(new DeviseTableCellRenderer());
        if (e.getTable().getFieldsName().contains("MARGE_HT")) {
            final SQLTableElement marge = new SQLTableElement(e.getTable().getField("MARGE_HT"), BigDecimal.class){

                @Override
                protected Object getDefaultNullValue() {
                    return BigDecimal.ZERO;
                }

                @Override
                public boolean isCellEditable(SQLRowValues vals, int rowIndex, int columnIndex) {
                    return BonDeLivraisonItemTable.this.isCellNiveauEditable(vals, rowIndex, columnIndex);
                }
            };
            marge.setRenderer(new CurrencyWithSymbolRenderer());
            marge.setEditable(false);
            list.add(marge);
            this.totalHT.addModificationListener(marge);
            this.totalHA.addModificationListener(marge);
            marge.setModifier(new CellDynamicModifier(){

                @Override
                public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                    BigDecimal vt = (BigDecimal)row.getObject("T_PV_HT");
                    BigDecimal ha = (BigDecimal)row.getObject("T_PA_HT");
                    BigDecimal acomptePercent = row.getBigDecimal("POURCENT_FACTURABLE");
                    BigDecimal acompteMontant = row.getBigDecimal("MONTANT_FACTURABLE");
                    Acompte acompte = new Acompte(acomptePercent, acompteMontant);
                    ha = acompte.getResultFrom(ha);
                    vt = acompte.getResultFrom(vt);
                    return vt.subtract(ha).setScale(marge.getDecimalDigits(), RoundingMode.HALF_UP);
                }
            });
        }
        if (e.getTable().getFieldsName().contains("T_ECO_CONTRIBUTION")) {
            this.tableElementEcoTotal = new SQLTableElement(e.getTable().getField("T_ECO_CONTRIBUTION"));
            list.add(this.tableElementEcoTotal);
        }
        list.add(this.totalHT);
        this.tableElementTotalTTC = new SQLTableElement(e.getTable().getField("T_PV_TTC"), BigDecimal.class);
        this.tableElementTotalTTC.setRenderer(new DeviseTableCellRenderer());
        list.add(this.tableElementTotalTTC);
        if (e.getTable().contains("ID_COMMANDE_CLIENT_ELEMENT")) {
            SQLTableElement tableCmdElt = new SQLTableElement(e.getTable().getField("ID_COMMANDE_CLIENT_ELEMENT"));
            list.add(tableCmdElt);
        }
        this.defaultRowVals = new SQLRowValues(UndefinedRowValuesCache.getInstance().getDefaultRowValues(e.getTable()));
        this.defaultRowVals.put("ID_TAXE", TaxeCache.getCache().getFirstTaxe().getID());
        this.defaultRowVals.put("CODE", "");
        this.defaultRowVals.put("NOM", "");
        RowValuesTableModel model = new RowValuesTableModel(e, list, e.getTable().getField("NOM"), false, this.defaultRowVals){

            @Override
            public void commitData() {
                int size = this.getRowCount();
                int i = 0;
                while (i < size) {
                    SQLRowValues rowVals = this.getRowValuesAt(i);
                    if (rowVals.getObject("PV_U_DEVISE") == null) {
                        rowVals.put("PV_U_DEVISE", rowVals.getObject("PRIX_METRIQUE_VT_1"));
                        BigDecimal globalQty = rowVals.getBigDecimal("QTE_UNITAIRE").multiply(new BigDecimal(rowVals.getInt("QTE")));
                        rowVals.put("PV_T_DEVISE", rowVals.getBigDecimal("PRIX_METRIQUE_VT_1").multiply(globalQty));
                    }
                    ++i;
                }
                super.commitData(true);
            }
        };
        this.setModel(model);
        this.table = new RowValuesTable(model, this.getConfigurationFile());
        ToolTipManager.sharedInstance().unregisterComponent(this.table);
        ToolTipManager.sharedInstance().unregisterComponent(this.table.getTableHeader());
        this.table.getClearCloneTableElement().add("ID_COMMANDE_CLIENT_ELEMENT");
        if (filterFamilleArticle) {
            ((SQLTextComboTableCellEditor)tableElementArticle.getTableCellEditor(this.table)).setDynamicWhere(e.getTable().getTable("ARTICLE").getField("ID_FAMILLE_ARTICLE"));
        }
        ArrayList<String> completionField = new ArrayList<String>();
        final SQLTable sqlTableArticle = ((ComptaPropsConfiguration)Configuration.getInstance()).getRootSociete().getTable("ARTICLE");
        if (showDevise) {
            completionField.add("CODE_DOUANIER");
            completionField.add("ID_PAYS");
        }
        if (e.getTable().getFieldsName().contains("ID_ECO_CONTRIBUTION")) {
            completionField.add("ID_ECO_CONTRIBUTION");
        }
        completionField.add("POURCENT_REMISE");
        completionField.add("ID_UNITE_VENTE");
        completionField.add("QTE_UNITAIRE");
        completionField.add("PA_HT");
        completionField.add("PV_HT");
        completionField.add("ID_TAXE");
        completionField.add("POIDS");
        completionField.add("PRIX_METRIQUE_HA_1");
        completionField.add("PRIX_METRIQUE_HA_2");
        completionField.add("PRIX_METRIQUE_HA_3");
        completionField.add("VALEUR_METRIQUE_1");
        completionField.add("VALEUR_METRIQUE_2");
        completionField.add("VALEUR_METRIQUE_3");
        completionField.add("ID_MODE_VENTE_ARTICLE");
        completionField.add("PRIX_METRIQUE_VT_1");
        completionField.add("PRIX_METRIQUE_VT_2");
        completionField.add("PRIX_METRIQUE_VT_3");
        completionField.add("SERVICE");
        completionField.add("ID_FAMILLE_ARTICLE");
        completionField.add("LONGUEUR");
        completionField.add("LARGEUR");
        completionField.add("HAUTEUR");
        completionField.addAll(fieldDecl);
        if (this.getSQLElement().getTable().getFieldsName().contains("DESCRIPTIF")) {
            completionField.add("DESCRIPTIF");
        }
        if (showDevise) {
            completionField.add("ID_DEVISE");
            completionField.add("PV_U_DEVISE");
        }
        if (this.getSQLElement().getTable().getFieldsName().contains("QTE_ACHAT") && sqlTableArticle.getTable().getFieldsName().contains("QTE_ACHAT")) {
            completionField.add("QTE_ACHAT");
        }
        this.codeCompletionManager = new ItemAutoCompletionManager(this, tableElementCode, ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete().getField("ARTICLE.CODE"), this.table, this.table.getRowValuesTableModel());
        this.codeCompletionManager.fill("NOM", "NOM");
        this.codeCompletionManager.fill("ID", "ID_ARTICLE");
        for (String string : completionField) {
            this.codeCompletionManager.fill(string, string);
        }
        ITransformer<SQLSelect, SQLSelect> selTrans = new ITransformer<SQLSelect, SQLSelect>(){

            @Override
            public SQLSelect transformChecked(SQLSelect input) {
                SQLTable tableStock = sqlTableArticle.getTable("STOCK");
                input.andWhere(new Where((FieldRef)tableStock.getKey(), "=", sqlTableArticle.getField("ID_STOCK")));
                input.setExcludeUndefined(false, tableStock);
                Where w = new Where((FieldRef)sqlTableArticle.getField("OBSOLETE"), "=", (Object)Boolean.FALSE).or(new Where(input.getAlias(tableStock.getKey()), "=", tableStock.getUndefinedID())).or(new Where(input.getAlias(tableStock.getField("QTE_REEL")), ">", 0));
                if (input.getWhere() != null) {
                    input.setWhere(input.getWhere().and(w));
                } else {
                    input.setWhere(w);
                }
                input.asString();
                return input;
            }
        };
        this.codeCompletionManager.setSelectTransformer(selTrans);
        if (prefs.getBoolean(GestionArticleGlobalPreferencePanel.CAN_EXPAND_NOMENCLATURE_VT, true)) {
            this.table.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    this.handlePopup(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    this.handlePopup(e);
                }

                public void handlePopup(MouseEvent e) {
                    final int rowindex = BonDeLivraisonItemTable.this.table.getSelectedRow();
                    if (rowindex < 0) {
                        return;
                    }
                    if (e.isPopupTrigger() && e.getComponent() instanceof JTable) {
                        JPopupMenu popup = new JPopupMenu();
                        popup.add(new AbstractAction(TranslationManager.getInstance().getTranslationForItem("product.bom.expand")){

                            @Override
                            public void actionPerformed(ActionEvent arg0) {
                                BonDeLivraisonItemTable.this.expandNomenclature(rowindex, BonDeLivraisonItemTable.this.codeCompletionManager, AbstractArticleItemTable.EXPAND_TYPE.EXPAND);
                            }
                        });
                        popup.add(new AbstractAction(TranslationManager.getInstance().getTranslationForItem("product.bom.expose")){

                            @Override
                            public void actionPerformed(ActionEvent arg0) {
                                BonDeLivraisonItemTable.this.expandNomenclature(rowindex, BonDeLivraisonItemTable.this.codeCompletionManager, AbstractArticleItemTable.EXPAND_TYPE.VIEW_ONLY);
                            }
                        });
                        for (AbstractAction action : BonDeLivraisonItemTable.this.getAdditionnalMouseAction(rowindex)) {
                            popup.add(action);
                        }
                        popup.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            });
        }
        final ItemAutoCompletionManager m2 = new ItemAutoCompletionManager(this, tableElementNom, ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete().getField("ARTICLE.NOM"), this.table, this.table.getRowValuesTableModel());
        m2.fill("CODE", "CODE");
        m2.fill("ID", "ID_ARTICLE");
        for (String string : completionField) {
            m2.fill(string, string);
        }
        m2.setSelectTransformer(selTrans);
        ItemAutoCompletionManager m3 = new ItemAutoCompletionManager(this, tableElementArticle, sqlTableArticle.getField("NOM"), this.table, this.table.getRowValuesTableModel(), 2, true, true, new ValidStateChecker());
        m3.fill("CODE", "CODE");
        m3.fill("NOM", "NOM");
        for (String string : completionField) {
            m3.fill(string, string);
        }
        m3.setSelectTransformer(selTrans);
        if (this.tableElementEco != null && this.tableElementEcoTotal != null && this.tableElementEcoID != null) {
            this.qte.addModificationListener(this.tableElementEcoTotal);
            this.tableElementEco.addModificationListener(this.tableElementEcoTotal);
            this.tableElementEcoTotal.setModifier(new CellDynamicModifier(){

                @Override
                public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                    int qte = Integer.parseInt(row.getObject("QTE").toString());
                    BigDecimal f = row.getObject("ECO_CONTRIBUTION") == null ? BigDecimal.ZERO : (BigDecimal)row.getObject("ECO_CONTRIBUTION");
                    return f.multiply(new BigDecimal(qte));
                }
            });
            this.tableElementEcoID.addModificationListener(this.tableElementEco);
            this.tableElementEco.setModifier(new CellDynamicModifier(){

                @Override
                public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                    if (source != null && source.equals(BonDeLivraisonItemTable.this.tableElementEcoID)) {
                        return row.getForeign("ID_ECO_CONTRIBUTION").getBigDecimal("TAUX");
                    }
                    return row.getObject("ECO_CONTRIBUTION");
                }
            });
        }
        this.qte.addModificationListener(tableElement_PrixMetrique1_VenteHT);
        tableElement_QuantiteLivree.addModificationListener(this.totalHT);
        tableElement_QuantiteLivree.addModificationListener(this.totalHA);
        qteU.addModificationListener(this.totalHT);
        qteU.addModificationListener(this.totalHA);
        this.ha.addModificationListener(this.totalHA);
        this.tableElementRemise.addModificationListener(this.totalHT);
        tableElement_PrixVente_HT.addModificationListener(this.totalHT);
        this.totalHT.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                Object qteL = row.getObject("QTE_LIVREE");
                int qte = qteL == null ? 0 : Integer.parseInt(qteL.toString());
                BigDecimal f = (BigDecimal)row.getObject("PV_HT");
                System.out.println("Qte:" + qte + " et PV_HT:" + f);
                BigDecimal b = row.getObject("QTE_UNITAIRE") == null ? BigDecimal.ONE : (BigDecimal)row.getObject("QTE_UNITAIRE");
                BigDecimal r = b.multiply(f.multiply(BigDecimal.valueOf(qte)), DecimalUtils.HIGH_PRECISION).setScale(BonDeLivraisonItemTable.this.totalHT.getDecimalDigits(), 4);
                if (row.getTable().getFieldsName().contains("MONTANT_REMISE")) {
                    BigDecimal acomptePercent = row.getBigDecimal("POURCENT_REMISE");
                    BigDecimal acompteMontant = row.getBigDecimal("MONTANT_REMISE");
                    Remise remise = new Remise(acomptePercent, acompteMontant);
                    r = remise.getResultFrom(r);
                }
                return r;
            }
        });
        this.totalHA.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                Object qteL = row.getObject("QTE_LIVREE");
                int qte = qteL == null ? 0 : Integer.parseInt(qteL.toString());
                BigDecimal f = (BigDecimal)row.getObject("PA_HT");
                BigDecimal b = row.getObject("QTE_UNITAIRE") == null ? BigDecimal.ONE : (BigDecimal)row.getObject("QTE_UNITAIRE");
                BigDecimal r = b.multiply(f.multiply(BigDecimal.valueOf(qte)), DecimalUtils.HIGH_PRECISION).setScale(BonDeLivraisonItemTable.this.totalHA.getDecimalDigits(), 4);
                return r;
            }
        });
        tableElement_QuantiteLivree.addModificationListener(this.tableElementTotalTTC);
        qteU.addModificationListener(this.tableElementTotalTTC);
        tableElement_PrixVente_HT.addModificationListener(this.tableElementTotalTTC);
        this.tableElementTVA.addModificationListener(this.tableElementTotalTTC);
        this.tableElementTotalTTC.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                BigDecimal f = (BigDecimal)row.getObject("T_PV_HT");
                int idTaux = Integer.parseInt(row.getObject("ID_TAXE").toString());
                Float resultTaux = TaxeCache.getCache().getTauxFromId(idTaux);
                float taux = resultTaux == null ? 0.0f : resultTaux.floatValue();
                editorPVHT.setTaxe(taux);
                BigDecimal r = f.multiply(BigDecimal.ONE.add(BigDecimal.valueOf(taux).movePointLeft(2)), DecimalUtils.HIGH_PRECISION).setScale(6, 4);
                return r.setScale(BonDeLivraisonItemTable.this.tableElementTotalTTC.getDecimalDigits(), 4);
            }
        });
        tableElement_ValeurMetrique1.addModificationListener(tableElementPoids);
        tableElement_ValeurMetrique2.addModificationListener(tableElementPoids);
        tableElement_ValeurMetrique3.addModificationListener(tableElementPoids);
        tableElementPoids.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                return new Float(ReferenceArticleSQLElement.getPoidsFromDetails(row));
            }
        });
        tableElementPoids.addModificationListener(this.tableElementPoidsTotal);
        this.qte.addModificationListener(this.tableElementPoidsTotal);
        qteU.addModificationListener(this.tableElementPoidsTotal);
        this.tableElementPoidsTotal.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                Number f = (Number)row.getObject("POIDS");
                int qte = Integer.parseInt(row.getObject("QTE").toString());
                BigDecimal b = row.getObject("QTE_UNITAIRE") == null ? BigDecimal.ONE : (BigDecimal)row.getObject("QTE_UNITAIRE");
                return Float.valueOf(b.multiply(new BigDecimal(f.floatValue() * (float)qte)).floatValue());
            }
        });
        tableElementPoids.addModificationListener(this.tableElementPoidsTotalLivree);
        tableElement_QuantiteLivree.addModificationListener(this.tableElementPoidsTotalLivree);
        this.tableElementPoidsTotalLivree.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                Number f = (Number)row.getObject("POIDS");
                Object qteOb = row.getObject("QTE_LIVREE");
                int qte = qteOb == null ? 0 : Integer.parseInt(qteOb.toString());
                float fValue = f == null ? 0.0f : f.floatValue();
                BigDecimal b = row.getObject("QTE_UNITAIRE") == null ? BigDecimal.ONE : (BigDecimal)row.getObject("QTE_UNITAIRE");
                return Float.valueOf(b.multiply(new BigDecimal(fValue * (float)qte)).floatValue());
            }
        });
        tableElement_PrixMetrique1_VenteHT.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                boolean noCmdElt;
                if (source != null && source.getField().getName().equals("PRIX_METRIQUE_VT_1")) {
                    return row.getObject("PRIX_METRIQUE_VT_1");
                }
                if (source != null && source.getField().getName().equals("PV_U_DEVISE")) {
                    if (!row.isForeignEmpty("ID_DEVISE")) {
                        String devCode = row.getForeign("ID_DEVISE").getString("CODE");
                        BigDecimal bigDecimal = (BigDecimal)row.getObject("PV_U_DEVISE");
                        CurrencyConverter c = new CurrencyConverter();
                        BigDecimal result = c.convert(bigDecimal, devCode, c.getCompanyCurrencyCode(), new Date(), true);
                        return result;
                    }
                    return row.getObject("PRIX_METRIQUE_VT_1");
                }
                boolean bl = noCmdElt = row.getObject("ID_COMMANDE_CLIENT_ELEMENT") == null || row.isForeignEmpty("ID_COMMANDE_CLIENT_ELEMENT");
                if (!noCmdElt) {
                    return row.getObject("PRIX_METRIQUE_VT_1");
                }
                return BonDeLivraisonItemTable.this.tarifCompletion(row.getForeign("ID_ARTICLE"), "PRIX_METRIQUE_VT_1", row);
            }
        });
        if (showDevise) {
            if (eltUnitDevise != null) {
                eltUnitDevise.addModificationListener(tableElement_PrixMetrique1_VenteHT);
            }
            if (eltUnitDevise != null) {
                tableElement_PrixMetrique1_VenteHT.addModificationListener(eltUnitDevise);
                this.tableElementRemise.addModificationListener(this.tableElementTotalDevise);
                eltUnitDevise.setModifier(new CellDynamicModifier(){

                    @Override
                    public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                        boolean noCmdElt;
                        if (source != null && source.getField().getName().equals("PV_U_DEVISE")) {
                            return row.getObject("PV_U_DEVISE");
                        }
                        if (!row.isForeignEmpty("ID_DEVISE")) {
                            String devCode = row.getForeign("ID_DEVISE").getString("CODE");
                            BigDecimal bigDecimal = (BigDecimal)row.getObject("PRIX_METRIQUE_VT_1");
                            CurrencyConverter c = new CurrencyConverter();
                            BigDecimal result = c.convert(bigDecimal, c.getCompanyCurrencyCode(), devCode, new Date(), true);
                            return result;
                        }
                        if (source != null && source.getField().getName().equalsIgnoreCase("PRIX_METRIQUE_VT_1")) {
                            return row.getObject("PRIX_METRIQUE_VT_1");
                        }
                        boolean bl = noCmdElt = row.getObject("ID_COMMANDE_CLIENT_ELEMENT") == null || row.isForeignEmpty("ID_COMMANDE_CLIENT_ELEMENT");
                        if (!noCmdElt) {
                            return row.getObject("PV_U_DEVISE");
                        }
                        return row.getObject("PV_U_DEVISE");
                    }
                });
                this.tableElementRemise.addModificationListener(this.tableElementTotalDevise);
                this.tableElementTotalDevise.setModifier(new CellDynamicModifier(){

                    @Override
                    public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                        int qte = row.getInt("QTE_LIVREE");
                        BigDecimal prixDeVenteUnitaireDevise = row.getObject("PV_U_DEVISE") == null ? BigDecimal.ZERO : (BigDecimal)row.getObject("PV_U_DEVISE");
                        BigDecimal qUnitaire = row.getObject("QTE_UNITAIRE") == null ? BigDecimal.ONE : (BigDecimal)row.getObject("QTE_UNITAIRE");
                        BigDecimal prixVente = qUnitaire.multiply(prixDeVenteUnitaireDevise.multiply(BigDecimal.valueOf(qte), DecimalUtils.HIGH_PRECISION), DecimalUtils.HIGH_PRECISION);
                        if (row.getTable().getFieldsName().contains("MONTANT_REMISE")) {
                            BigDecimal acomptePercent = row.getBigDecimal("POURCENT_REMISE");
                            BigDecimal acompteMontant = row.getBigDecimal("MONTANT_REMISE");
                            Remise remise = new Remise(acomptePercent, acompteMontant);
                            prixVente = remise.getResultFrom(prixVente);
                        }
                        return prixVente.setScale(BonDeLivraisonItemTable.this.tableElementTotalDevise.getDecimalDigits(), 4);
                    }
                });
            }
        }
        tableElement_ValeurMetrique1.addModificationListener(tableElement_PrixVente_HT);
        tableElement_ValeurMetrique2.addModificationListener(tableElement_PrixVente_HT);
        tableElement_ValeurMetrique3.addModificationListener(tableElement_PrixVente_HT);
        tableElement_PrixMetrique1_VenteHT.addModificationListener(tableElement_PrixVente_HT);
        tableElement_PrixVente_HT.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                if (row.getInt("ID_MODE_VENTE_ARTICLE") == 5) {
                    System.err.println("Don't computeValue PV_HT --> " + row.getObject("PV_HT") + row);
                    return row.getObject("PRIX_METRIQUE_VT_1");
                }
                BigDecimal prixVTFromDetails = ReferenceArticleSQLElement.getPrixVTFromDetails(row);
                System.out.println("Prix de vente calcul\u00e9 au d\u00e9tail:" + prixVTFromDetails);
                return prixVTFromDetails.setScale(tableElement_PrixVente_HT.getDecimalDigits(), RoundingMode.HALF_UP);
            }
        });
        tableElement_ValeurMetrique1.addModificationListener(this.ha);
        tableElement_ValeurMetrique2.addModificationListener(this.ha);
        tableElement_ValeurMetrique3.addModificationListener(this.ha);
        tableElement_PrixMetrique1_AchatHT.addModificationListener(this.ha);
        this.ha.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                if (row.isForeignEmpty("ID_MODE_VENTE_ARTICLE") || row.getInt("ID_MODE_VENTE_ARTICLE") == 5) {
                    return row.getObject("PRIX_METRIQUE_HA_1");
                }
                BigDecimal prixHAFromDetails = ReferenceArticleSQLElement.getPrixHAFromDetails(row);
                return prixHAFromDetails.setScale(BonDeLivraisonItemTable.this.ha.getDecimalDigits(), RoundingMode.HALF_UP);
            }
        });
        this.table.readState();
        tableFamille.addModificationListener(tableElementArticle);
        tableElementCode.addModificationListener(tableElementArticle);
        tableElementArticle.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                SQLRowAccessor foreign;
                if (filterFamilleArticle) {
                    if (row.isForeignEmpty("ID_FAMILLE_ARTICLE")) {
                        BonDeLivraisonItemTable.this.codeCompletionManager.setWhere(null);
                        m2.setWhere(null);
                    } else {
                        BonDeLivraisonItemTable.this.codeCompletionManager.setWhere(new Where((FieldRef)sqlTableArticle.getField("ID_FAMILLE_ARTICLE"), "=", row.getForeignID("ID_FAMILLE_ARTICLE")));
                        m2.setWhere(new Where((FieldRef)sqlTableArticle.getField("ID_FAMILLE_ARTICLE"), "=", row.getForeignID("ID_FAMILLE_ARTICLE")));
                    }
                }
                if ((foreign = row.getForeign("ID_ARTICLE")) != null && !foreign.isUndefined() && foreign.getObject("CODE") != null && foreign.getString("CODE").equals(row.getString("CODE"))) {
                    return foreign.getID();
                }
                return BonDeLivraisonItemTable.this.tableArticle.getUndefinedID();
            }
        });
        uniteVente.addModificationListener(qteU);
        eltLargeur.addModificationListener(qteU);
        eltLongueur.addModificationListener(qteU);
        qteU.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                SQLRowAccessor rowUnite = row.getForeign("ID_UNITE_VENTE");
                if (rowUnite != null && !rowUnite.isUndefined() && rowUnite.getBoolean("A_LA_PIECE").booleanValue()) {
                    return BigDecimal.ONE;
                }
                if (activeCalculM2 && rowUnite != null && !rowUnite.isUndefined() && rowUnite.getID() == 4) {
                    BigDecimal longueur = row.getBigDecimal("LONGUEUR");
                    BigDecimal largeur = row.getBigDecimal("LARGEUR");
                    if (longueur == null || largeur == null) {
                        return BigDecimal.ONE;
                    }
                    return longueur.multiply(largeur);
                }
                return row.getObject("QTE_UNITAIRE");
            }
        });
        String valModeAvanceVt = DefaultNXProps.getInstance().getStringProperty("ArticleModeVenteAvance");
        Boolean bModeAvance = Boolean.valueOf(valModeAvanceVt);
        if (bModeAvance != null && !bModeAvance.booleanValue()) {
            this.hideColumn(model.getColumnForField("VALEUR_METRIQUE_1"));
            this.hideColumn(model.getColumnForField("VALEUR_METRIQUE_2"));
            this.hideColumn(model.getColumnForField("VALEUR_METRIQUE_3"));
            this.hideColumn(model.getColumnForField("PV_HT"));
            this.hideColumn(model.getColumnForField("PA_HT"));
            this.hideColumn(model.getColumnForField("ID_MODE_VENTE_ARTICLE"));
        }
        if (prefs.getBoolean(GestionArticleGlobalPreferencePanel.ITEM_PACKAGING, false)) {
            this.setColumnVisible(model.getColumnForField("T_POIDS_COLIS_NET"), false);
        }
        this.setColumnVisible(model.getColumnForField("HAUTEUR"), false);
        this.setColumnVisible(model.getColumnForField("LARGEUR"), activeCalculM2);
        this.setColumnVisible(model.getColumnForField("LONGUEUR"), activeCalculM2);
        this.setColumnVisible(model.getColumnForField("ID_ARTICLE"), selectArticle);
        this.setColumnVisible(model.getColumnForField("CODE"), !selectArticle || selectArticle && createAuto);
        this.setColumnVisible(model.getColumnForField("NOM"), !selectArticle || selectArticle && createAuto);
        this.setColumnVisible(this.getModel().getColumnForField("ID_FAMILLE_ARTICLE"), filterFamilleArticle);
        if (this.tableElementEco != null && this.tableElementEcoTotal != null && this.tableElementEcoID != null) {
            this.setColumnVisible(model.getColumnForField("ID_ECO_CONTRIBUTION"), showEco);
            this.setColumnVisible(model.getColumnForField("ECO_CONTRIBUTION"), showEco);
            this.setColumnVisible(model.getColumnForField("T_ECO_CONTRIBUTION"), showEco);
        }
        boolean gestionUV = prefs.getBoolean(GestionArticleGlobalPreferencePanel.UNITE_VENTE, true);
        this.setColumnVisible(model.getColumnForField("QTE_UNITAIRE"), gestionUV);
        this.setColumnVisible(model.getColumnForField("ID_UNITE_VENTE"), gestionUV);
        this.setColumnVisible(model.getColumnForField("PRIX_METRIQUE_HA_1"), showHAPrice);
        this.setColumnVisible(model.getColumnForField("MARGE_HT"), showHAPrice);
        this.setColumnVisible(model.getColumnForField("T_PA_HT"), showHAPrice);
        this.setColumnVisible(model.getColumnForField("ID_DEPOT_STOCK"), prefs.getBoolean(GestionArticleGlobalPreferencePanel.STOCK_MULTI_DEPOT, false));
        if (e.getTable().contains("ID_COMMANDE_CLIENT_ELEMENT")) {
            this.setColumnVisible(model.getColumnForField("ID_COMMANDE_CLIENT_ELEMENT"), false);
        }
        for (String string : AbstractVenteArticleItemTable.getVisibilityMap().keySet()) {
            this.setColumnVisible(model.getColumnForField(string), AbstractVenteArticleItemTable.getVisibilityMap().get(string));
        }
        Map<String, Boolean> mapCustom = this.getCustomVisibilityMap();
        if (mapCustom != null) {
            for (String string : mapCustom.keySet()) {
                this.setColumnVisible(model.getColumnForField(string), mapCustom.get(string));
            }
        }
        if ((barcodeReader = ComptaPropsConfiguration.getInstanceCompta().getBarcodeReader()) != null) {
            final BarcodeListener l = new BarcodeListener(){

                @Override
                public void keyReceived(KeyEvent ee) {
                }

                @Override
                public void barcodeRead(String code) {
                    if (((JFrame)SwingUtilities.getRoot(BonDeLivraisonItemTable.this.getRowValuesTable())).isActive()) {
                        SQLSelect selArticle = new SQLSelect();
                        SQLTable tableArticle = BonDeLivraisonItemTable.this.getSQLElement().getForeignElement("ID_ARTICLE").getTable();
                        selArticle.addSelectStar(tableArticle);
                        Where w = new Where((FieldRef)tableArticle.getField("OBSOLETE"), "=", (Object)Boolean.FALSE);
                        w = w.and(new Where((FieldRef)tableArticle.getField("CODE_BARRE"), "=", (Object)code));
                        selArticle.setWhere(w);
                        List<SQLRow> l2 = SQLRowListRSH.execute(selArticle);
                        if (l2.size() > 0) {
                            System.err.println("ARTICLE " + l2.get(0).getString("NOM"));
                            Tuple3<Double, String, String> art = Tuple3.create(1.0, l2.get(0).getString("CODE"), l2.get(0).getString("NOM"));
                            ArrayList<Tuple3<Double, String, String>> l = new ArrayList<Tuple3<Double, String, String>>();
                            l.add(art);
                            BonDeLivraisonItemTable.this.insertFromDrop(l, BonDeLivraisonItemTable.this.codeCompletionManager);
                        } else {
                            System.err.println("ARTICLE NOT FOUND !");
                        }
                    }
                }
            };
            this.getRowValuesTable().addHierarchyListener(new HierarchyListener(){

                @Override
                public void hierarchyChanged(HierarchyEvent e) {
                    if ((e.getChangeFlags() & 2L) != 0L) {
                        if (BonDeLivraisonItemTable.this.getRowValuesTable().isDisplayable()) {
                            barcodeReader.addBarcodeListener(l);
                        } else {
                            barcodeReader.removeBarcodeListener(l);
                        }
                    }
                }
            });
        }
        if (this.table.getRowValuesTableModel().getColumnForField("ID_DEPOT_STOCK") >= 0 && this.table.getRowValuesTableModel().getColumnForField("ID_ARTICLE") >= 0) {
            if (this.buttons == null) {
                this.buttons = new ArrayList();
            }
            JButton buttonStock = new JButton("Consulter le stock");
            buttonStock.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    try {
                        SQLRowAccessor rowValsStock;
                        SQLRowAccessor foreignArt;
                        SQLRowValues rowValsSel = BonDeLivraisonItemTable.this.table.getSelectedRowValues();
                        if (rowValsSel != null && (foreignArt = rowValsSel.getForeign("ID_ARTICLE")) != null && !foreignArt.isUndefined() && (rowValsStock = StockSQLElement.getStock(rowValsSel)) != null && !rowValsStock.isUndefined()) {
                            EditFrame frame = new EditFrame(BonDeLivraisonItemTable.this.table.getRowValuesTableModel().getSQLElement().getDirectory().getElement("STOCK"), EditPanel.EditMode.READONLY);
                            frame.selectionId(rowValsStock.getID());
                            frame.setVisible(true);
                        }
                    }
                    catch (Exception e) {
                        ExceptionHandler.handle("Erreur d'acc\u00e8s au stock", e);
                    }
                }
            });
            this.buttons.add(buttonStock);
        }
        this.table.writeState();
    }

    @Override
    public float getPoidsTotal() {
        float poids = 0.0f;
        int poidsTColIndex = this.getModel().getColumnIndexForElement(this.tableElementPoidsTotalLivree);
        if (poidsTColIndex >= 0) {
            int i = 0;
            while (i < this.table.getRowCount()) {
                Number tmp = (Number)this.getModel().getValueAt(i, poidsTColIndex);
                if (tmp != null) {
                    poids += tmp.floatValue();
                }
                ++i;
            }
        }
        return poids;
    }

    @Override
    protected String getConfigurationFileName() {
        return "Table_Bon_Livraison.xml";
    }

    @Override
    public SQLElement getSQLElement() {
        return Configuration.getInstance().getDirectory().getElement("BON_DE_LIVRAISON_ELEMENT");
    }

    @Override
    protected List<AbstractAction> getAdditionnalMouseAction(final int rowIndex) {
        ArrayList<AbstractAction> actions = new ArrayList<AbstractAction>();
        actions.addAll(super.getAdditionnalMouseAction(rowIndex));
        actions.add(new AbstractAction("Ajouter un reliquat"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (BonDeLivraisonItemTable.this.reliquatTable != null) {
                    SQLRowValues sqlRowArticleChildElement = BonDeLivraisonItemTable.this.getRowValuesTable().getRowValuesTableModel().getRowValuesAt(rowIndex);
                    SQLRowValues row2Insert = new SQLRowValues(BonDeLivraisonItemTable.this.reliquatTable.getDefaultRowValues());
                    row2Insert.put("ID_BON_DE_LIVRAISON_ELEMENT", (Object)sqlRowArticleChildElement);
                    row2Insert.put("QTE", 1);
                    row2Insert.put("QTE_UNITAIRE", BigDecimal.ONE);
                    BonDeLivraisonItemTable.this.reliquatTable.getRowValuesTable().getRowValuesTableModel().addRow(row2Insert);
                }
            }
        });
        return actions;
    }

    private void hideColumn(int col) {
        if (col >= 0) {
            XTableColumnModel columnModel = this.table.getColumnModel();
            columnModel.setColumnVisible(columnModel.getColumnByModelIndex(col), false);
        }
    }
}

