/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.shipment.action;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingWorker;
import org.openconcerto.erp.action.CreateListFrameAbstractAction;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.component.TransfertBaseSQLComponent;
import org.openconcerto.erp.core.common.ui.IListFilterDatePanel;
import org.openconcerto.erp.core.common.ui.IListTotalPanel;
import org.openconcerto.erp.core.sales.shipment.element.BonDeLivraisonSQLElement;
import org.openconcerto.erp.core.sales.shipment.report.BonLivraisonXmlSheet;
import org.openconcerto.erp.model.MouseSheetXmlListeListener;
import org.openconcerto.sql.model.FieldPath;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLInjector;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.model.graph.PathBuilder;
import org.openconcerto.sql.view.ListeAddPanel;
import org.openconcerto.sql.view.list.BaseSQLTableModelColumn;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.RowAction;
import org.openconcerto.sql.view.list.SQLTableModelSourceOnline;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.table.PercentTableCellRenderer;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.DecimalUtils;
import org.openconcerto.utils.ExceptionHandler;

public class ListeDesBonsDeLivraisonAction
extends CreateListFrameAbstractAction<BonDeLivraisonSQLElement, JFrame> {
    public ListeDesBonsDeLivraisonAction(ComptaPropsConfiguration conf) {
        super(conf, BonDeLivraisonSQLElement.class);
    }

    protected JFrame instantiateFrame() {
        JFrame frame = new JFrame(String.valueOf(this.getValue("Name")));
        RowAction toInvoiceAction = new RowAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListeDesBonsDeLivraisonAction.this.transfertFactureClient(IListe.get(e).getSelectedRows());
            }
        }, false, "sales.shipment.create.invoice"){

            @Override
            public boolean enabledFor(List<SQLRowValues> selection) {
                if (!selection.isEmpty()) {
                    for (SQLRowValues sqlRowValues : selection) {
                        if (!sqlRowValues.getBoolean("VERROU_FACTURATION").booleanValue()) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
        };
        JTabbedPane tabs = new JTabbedPane();
        tabs.addTab(this.getConf().getERP_TM().translate("sales.shipment.allShipments", new Object[0]), this.createAllDeliveryPanel(toInvoiceAction));
        tabs.addTab(this.getConf().getERP_TM().translate("sales.shipment.nonInvoicedShipments", new Object[0]), this.createDeliveryWithoutInvoicePanel(toInvoiceAction));
        tabs.addTab(this.getConf().getERP_TM().translate("sales.shipment.invoicedShipments", new Object[0]), this.createDeliveryWithInvoicePanel());
        frame.setContentPane(tabs);
        return frame;
    }

    private ListeAddPanel getPanel(BonDeLivraisonSQLElement eltCmd, SQLTableModelSourceOnline tableSource, final List<RowAction> allowedActions, String variant) {
        ListeAddPanel panel = new ListeAddPanel(eltCmd, new IListe(tableSource), variant);
        ArrayList<SQLField> fields = new ArrayList<SQLField>(2);
        fields.add(eltCmd.getTable().getField("TOTAL_HT"));
        IListTotalPanel totalPanel = new IListTotalPanel(panel.getListe(), fields, this.getConf().getERP_TM().translate("sales.shipment.listTotal", new Object[0]));
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridwidth = 0;
        c.fill = 1;
        c.anchor = 13;
        c.weightx = 1.0;
        c.gridy = 4;
        IListFilterDatePanel datePanel = new IListFilterDatePanel(panel.getListe(), eltCmd.getTable().getField("DATE"), IListFilterDatePanel.getDefaultMap());
        panel.getListe().addIListeActions(new MouseSheetXmlListeListener(eltCmd, BonLivraisonXmlSheet.class){

            public List<RowAction> addToMenu() {
                return allowedActions;
            }
        }.getRowActions());
        panel.getListe().addIListeAction(eltCmd.getCloneAction());
        datePanel.setFilterOnDefault();
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new GridBagLayout());
        bottomPanel.setOpaque(false);
        DefaultGridBagConstraints c2 = new DefaultGridBagConstraints();
        c2.fill = 0;
        c2.weightx = 1.0;
        bottomPanel.add((Component)datePanel, c2);
        ++c2.gridx;
        c2.weightx = 0.0;
        c2.anchor = 13;
        bottomPanel.add((Component)totalPanel, c2);
        panel.add((Component)bottomPanel, c);
        return panel;
    }

    JPanel createAllDeliveryPanel(RowAction toInvoiceAction) {
        final BonDeLivraisonSQLElement eltCmd = (BonDeLivraisonSQLElement)this.getElem();
        SQLTableModelSourceOnline tableSource = eltCmd.getTableSource(true);
        ArrayList<RowAction> allowedActions = new ArrayList<RowAction>();
        allowedActions.add(toInvoiceAction);
        BaseSQLTableModelColumn colAvancement = new BaseSQLTableModelColumn(eltCmd.getDirectory().getTranslator().getDescFor(eltCmd.getTable(), "invoiceProgress").getTitleLabel(), BigDecimal.class){

            @Override
            protected Object show_(SQLRowAccessor r) {
                return ListeDesBonsDeLivraisonAction.this.getAvancement(r);
            }

            @Override
            public Set<FieldPath> getPaths() {
                Path p = ((PathBuilder)((PathBuilder)new PathBuilder(eltCmd.getTable()).addTable("TR_BON_DE_LIVRAISON")).addTable("SAISIE_VENTE_FACTURE")).build();
                return CollectionUtils.createSet(new FieldPath(p, "T_HT"));
            }
        };
        tableSource.getColumns().add(colAvancement);
        colAvancement.setRenderer(new PercentTableCellRenderer());
        ListeAddPanel panel = this.getPanel(eltCmd, tableSource, allowedActions, "alldelivery");
        return panel;
    }

    private BigDecimal getAvancement(SQLRowAccessor r) {
        Collection<? extends SQLRowAccessor> rows = r.getReferentRows(r.getTable().getTable("TR_BON_DE_LIVRAISON"));
        long totalFact = 0L;
        long total = r.getLong("TOTAL_HT");
        for (SQLRowAccessor sQLRowAccessor : rows) {
            if (sQLRowAccessor.isForeignEmpty("ID_SAISIE_VENTE_FACTURE")) continue;
            SQLRowAccessor rowFact = sQLRowAccessor.getForeign("ID_SAISIE_VENTE_FACTURE");
            Long l = rowFact.getLong("T_HT");
            totalFact += l.longValue();
        }
        if (total > 0L) {
            return new BigDecimal(totalFact).divide(new BigDecimal(total), DecimalUtils.HIGH_PRECISION).movePointRight(2).setScale(2, RoundingMode.HALF_UP);
        }
        return BigDecimal.ONE.movePointRight(2);
    }

    JPanel createDeliveryWithInvoicePanel() {
        BonDeLivraisonSQLElement eltCmd = (BonDeLivraisonSQLElement)this.getElem();
        SQLTableModelSourceOnline tableSource = eltCmd.getTableSource(true);
        ArrayList<RowAction> allowedActions = new ArrayList<RowAction>();
        SQLInjector injector = SQLInjector.getInjector(eltCmd.getTable(), eltCmd.getTable().getTable("SAISIE_VENTE_FACTURE"));
        injector.setOnlyTransfered(tableSource);
        ListeAddPanel panel = this.getPanel(eltCmd, tableSource, allowedActions, "invoiced");
        return panel;
    }

    JPanel createDeliveryWithoutInvoicePanel(RowAction toInvoiceAction) {
        BonDeLivraisonSQLElement eltCmd = (BonDeLivraisonSQLElement)this.getElem();
        SQLTableModelSourceOnline tableSource = eltCmd.getTableSource(true);
        ArrayList<RowAction> allowedActions = new ArrayList<RowAction>();
        allowedActions.add(toInvoiceAction);
        SQLInjector injector = SQLInjector.getInjector(eltCmd.getTable(), eltCmd.getTable().getTable("SAISIE_VENTE_FACTURE"));
        injector.setOnlyNotTransfered(tableSource);
        ListeAddPanel panel = this.getPanel(eltCmd, tableSource, allowedActions, "waiting");
        return panel;
    }

    private void transfertFactureClient(final List<SQLRowValues> selectedRows) {
        SwingWorker<Boolean, Object> worker = new SwingWorker<Boolean, Object>(){

            @Override
            protected Boolean doInBackground() throws Exception {
                boolean b = TransfertBaseSQLComponent.isAlreadyAllTransfert(selectedRows, ListeDesBonsDeLivraisonAction.this.getConf().getRootSociete().getTable("BON_DE_LIVRAISON"), ListeDesBonsDeLivraisonAction.this.getConf().getRootSociete().getTable("SAISIE_VENTE_FACTURE"), "TOTAL_HT", "T_HT");
                if (b) {
                    String label = "Attention ";
                    label = selectedRows.size() > 1 ? String.valueOf(label) + " les bons de livraisons  ont d\u00e9j\u00e0 \u00e9t\u00e9 transf\u00e9r\u00e9!" : String.valueOf(label) + "le bon de livraison a d\u00e9j\u00e0 \u00e9t\u00e9 transf\u00e9r\u00e9!";
                    int ans = JOptionPane.showConfirmDialog(null, label = String.valueOf(label) + "\n Voulez vous continuer?", "Transfert Bon de livraison", 0);
                    if (ans == 1) {
                        return Boolean.FALSE;
                    }
                }
                return Boolean.TRUE;
            }

            @Override
            protected void done() {
                try {
                    Boolean b = (Boolean)this.get();
                    if (b.booleanValue()) {
                        ArrayList<SQLRowValues> selRows = new ArrayList<SQLRowValues>();
                        for (SQLRowValues r : selectedRows) {
                            selRows.add(r.createEmptyUpdateRow());
                        }
                        TransfertBaseSQLComponent.openTransfertFrame(selectedRows, "SAISIE_VENTE_FACTURE");
                    }
                }
                catch (Exception e) {
                    ExceptionHandler.handle("Erreur lors du transfert des bons de livraisons!", e);
                }
            }
        };
        worker.execute();
    }
}

