/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.element;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openconcerto.erp.config.Log;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.finance.accounting.importer.Transaction;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.model.ConnectionHandlerNoSetup;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLInsert;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.utils.SQLUtils;

public class ReleveBancaireSQLElement
extends ComptaSQLConfElement {
    public static final String TABLE_NAME = "RELEVE_BANCAIRE";

    public ReleveBancaireSQLElement(DBRoot root) {
        super(root.getTable(TABLE_NAME));
    }

    @Override
    protected List<String> getListFields() {
        return Arrays.asList("LABEL", "ANNEE", "MOIS", "DEBIT", "CREDIT");
    }

    @Override
    protected SQLComponent createComponent() {
        return null;
    }

    public void importReleve(int idBanque, final int month, final int year, final List<Transaction> transactions) throws SQLException {
        LocalDate min;
        if (transactions.isEmpty()) {
            return;
        }
        LocalDate max = min = transactions.get(0).getDateValue();
        for (Transaction t : transactions) {
            LocalDate d = t.getDateValue();
            if (d.isBefore(min)) {
                min = d;
                continue;
            }
            if (!d.isAfter(max)) continue;
            max = d;
        }
        if (min.getYear() != year) {
            throw new IllegalArgumentException("a transaction is not in the specified year (" + year + ") but is " + min.getYear());
        }
        if (max.getYear() != year) {
            throw new IllegalArgumentException("a transaction is not in the specified year (" + year + ") but is " + max.getYear());
        }
        if (min.getMonthValue() != month) {
            throw new IllegalArgumentException("a transaction is not in the specified month (" + month + ") but is " + min.getMonthValue());
        }
        if (max.getMonthValue() != month) {
            throw new IllegalArgumentException("a transaction is not in the specified month (" + month + ") but is " + max.getMonthValue());
        }
        Set<String> existingUUIDs = this.getElementUUIDs(min, max);
        if (!existingUUIDs.isEmpty()) {
            throw new IllegalArgumentException("transaction already defined in month: " + month + " year:" + year);
        }
        ArrayList<SQLInsert> releveInserts = new ArrayList<SQLInsert>(transactions.size());
        SQLTable tReleve = this.getTable();
        BigDecimal debit = BigDecimal.ZERO;
        BigDecimal credit = BigDecimal.ZERO;
        for (Transaction t : transactions) {
            if (t.getAmount().signum() > 0) {
                credit = credit.add(t.getAmount());
                continue;
            }
            debit = debit.add(t.getAmount());
        }
        final SQLInsert rinsert = new SQLInsert();
        rinsert.add(tReleve.getField("ID_BANQUE"), idBanque);
        rinsert.add(tReleve.getField("ANNEE"), year);
        rinsert.add(tReleve.getField("MOIS"), month);
        rinsert.add(tReleve.getField("DEBIT"), debit);
        rinsert.add(tReleve.getField("CREDIT"), credit);
        releveInserts.add(rinsert);
        SQLUtils.executeAtomic(this.getTable().getDBSystemRoot().getDataSource(), new ConnectionHandlerNoSetup<Object, SQLException>(){

            @Override
            public Object handle(SQLDataSource ds) throws SQLException {
                int idReleve = ((Number)ds.executeScalar(rinsert.asString())).intValue();
                SQLTable tReleveElement = ReleveBancaireSQLElement.this.getTable().getTable("RELEVE_BANCAIRE_ELEMENT");
                ArrayList<SQLInsert> transactionsInserts = new ArrayList<SQLInsert>();
                for (Transaction t : transactions) {
                    SQLInsert insert = new SQLInsert();
                    insert.add(tReleveElement.getField("ID_RELEVE_BANCAIRE"), idReleve);
                    insert.add(tReleveElement.getField("UUID"), t.getUUID());
                    insert.add(tReleveElement.getField("TYPE"), t.getType());
                    insert.add(tReleveElement.getField("NAME"), t.getName());
                    insert.add(tReleveElement.getField("DESCRIPTION"), t.getMemo());
                    insert.add(tReleveElement.getField("COMMENT"), "");
                    insert.add(tReleveElement.getField("MONTANT"), t.getAmount());
                    insert.add(tReleveElement.getField("DATE"), ReleveBancaireSQLElement.this.toTimeStamp(t.getDate()));
                    insert.add(tReleveElement.getField("DATE_VALEUR"), ReleveBancaireSQLElement.this.toTimeStamp(t.getDateValue()));
                    transactionsInserts.add(insert);
                }
                Log.get().info("creating " + transactionsInserts + " lines for " + month + "/" + year);
                SQLInsert.executeSimilarInserts(ReleveBancaireSQLElement.this.getTable().getDBSystemRoot(), transactionsInserts, false);
                return null;
            }
        });
    }

    public Set<ReleveRef> getExistingReleve(int idBanque, LocalDate min, LocalDate max) {
        int minYear = min.getYear();
        int minMonth = min.getMonthValue();
        int maxYear = min.getYear();
        int maxMonth = min.getMonthValue();
        SQLTable tReleve = this.getTable();
        SQLSelect select = new SQLSelect();
        select.addSelect(tReleve.getField("ANNE"));
        select.addSelect(tReleve.getField("MOIS"));
        Where w = new Where((FieldRef)tReleve.getField("ID_BANQUE"), "=", idBanque);
        w = w.and(new Where((FieldRef)tReleve.getField("ANNE"), ">=", minYear)).and(new Where((FieldRef)tReleve.getField("ANNE"), "<=", maxYear));
        w = w.and(new Where((FieldRef)tReleve.getField("MOIS"), ">=", minMonth)).and(new Where((FieldRef)tReleve.getField("MOIS"), "<=", maxMonth));
        select.setWhere(w);
        List<SQLRow> rows = SQLRowListRSH.execute(select);
        HashSet<ReleveRef> result = new HashSet<ReleveRef>();
        for (SQLRow r : rows) {
            ReleveRef ref = new ReleveRef();
            ref.id = r.getID();
            ref.month = r.getInt("MOIS");
            ref.year = r.getInt("ANNE");
            result.add(ref);
        }
        return result;
    }

    private Set<String> getElementUUIDs(LocalDate min, LocalDate max) {
        SQLTable tReleveElement = this.getTable().getTable("RELEVE_BANCAIRE_ELEMENT");
        SQLSelect select = new SQLSelect();
        select.addSelect(tReleveElement.getField("UUID"));
        select.setWhere(new Where((FieldRef)tReleveElement.getField("DATE_VALEUR"), this.toTimeStamp(min), (Object)this.toTimeStamp(max)));
        List<SQLRow> rows = SQLRowListRSH.execute(select);
        HashSet<String> result = new HashSet<String>();
        for (SQLRow r : rows) {
            result.add(r.getString("UUID"));
        }
        return result;
    }

    private Timestamp toTimeStamp(LocalDate d) {
        Timestamp time = Timestamp.valueOf(d.atStartOfDay());
        return time;
    }

    class ReleveRef {
        Number id;
        int year;
        int month;

        ReleveRef() {
        }

        public boolean equals(Object obj) {
            ReleveRef r = (ReleveRef)obj;
            return r.year == this.year && r.month == this.month;
        }

        public int hashCode() {
            return this.year * 100 + this.month;
        }
    }
}

