/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.common.ui;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Set;
import org.openconcerto.erp.core.common.ui.AbstractVenteArticleItemTable;
import org.openconcerto.erp.core.common.ui.Acompte;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.view.list.AutoCompletionManager;
import org.openconcerto.sql.view.list.RowValuesTable;
import org.openconcerto.sql.view.list.RowValuesTableModel;
import org.openconcerto.sql.view.list.SQLTableElement;
import org.openconcerto.sql.view.list.ValidStateChecker;

public class ItemAutoCompletionManager
extends AutoCompletionManager {
    private final AbstractVenteArticleItemTable t;

    public ItemAutoCompletionManager(AbstractVenteArticleItemTable t, SQLTableElement tableElementCode, SQLField field, RowValuesTable table, RowValuesTableModel rowValuesTableModel) {
        super(tableElementCode, field, table, rowValuesTableModel);
        this.t = t;
    }

    public ItemAutoCompletionManager(AbstractVenteArticleItemTable t, SQLTableElement tableElementArticle, SQLField field, RowValuesTable table, RowValuesTableModel rowValuesTableModel, int modeContains, boolean b, boolean c, ValidStateChecker validStateChecker) {
        super(tableElementArticle, field, table, rowValuesTableModel, modeContains, b, c, validStateChecker);
        this.t = t;
    }

    @Override
    public void fillRowValues(SQLRowAccessor from, Set<String> fields, SQLRowValues to) {
        boolean piece = from.getForeignID("ID_UNITE_VENTE") == 2;
        for (String fromField : fields) {
            String toField = this.getToField(fromField);
            Object valueFrom = this.getValueFrom(from.asRow(), fromField, to);
            if (fromField.equals("POURCENT_REMISE") && valueFrom != null && valueFrom instanceof Acompte) {
                Acompte acompte = (Acompte)valueFrom;
                to.put("POURCENT_REMISE", acompte.getPercent());
                to.put("MONTANT_REMISE", acompte.getMontant());
                continue;
            }
            if (piece && toField.equals("QTE_UNITAIRE")) {
                to.put(toField, BigDecimal.ONE);
                to.put("QTE", from.getBigDecimal("QTE_UNITAIRE").setScale(0, RoundingMode.HALF_UP).intValue());
                if (!to.getTable().getName().equals("BON_DE_LIVRAISON_ELEMENT")) continue;
                to.put("QTE_A_LIVRER", from.getBigDecimal("QTE_UNITAIRE").setScale(0, RoundingMode.HALF_UP).intValue());
                continue;
            }
            to.put(toField, valueFrom);
        }
    }

    @Override
    protected Object getValueFrom(SQLRow from, String field, SQLRowAccessor rowDest) {
        boolean piece;
        boolean fromArticleFournisseur;
        boolean bl = fromArticleFournisseur = from != null && from.getTable().getName().equals("ARTICLE_FOURNISSEUR");
        if (fromArticleFournisseur && field.equals("ID_ARTICLE")) {
            return this.t.getSQLElement().getTable().getForeignTable("ID_ARTICLE").getUndefinedID();
        }
        boolean bl2 = piece = from.getForeignID("ID_UNITE_VENTE") == 2;
        if (piece) {
            if (field.equals("QTE")) {
                return from.getBigDecimal("QTE_UNITAIRE").setScale(0, RoundingMode.HALF_UP).intValue();
            }
            if (field.equals("QTE_UNITAIRE")) {
                return BigDecimal.ONE;
            }
        } else if (field.equals("QTE")) {
            return 1;
        }
        if (fromArticleFournisseur) {
            if (field.equals("POURCENT_REMISE")) {
                return new Acompte(BigDecimal.ZERO, BigDecimal.ZERO);
            }
            if (!from.getTable().contains(field)) {
                return null;
            }
        }
        Object res = null;
        if (!fromArticleFournisseur) {
            res = this.t.tarifCompletion(from, field, rowDest, true);
        }
        if (res == null) {
            res = super.getValueFrom(from, field, rowDest);
        }
        if (!fromArticleFournisseur && field.equals("POURCENT_REMISE")) {
            return this.t.getRemiseClient(from, (Acompte)res);
        }
        return res;
    }
}

