/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.invoice.report;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openconcerto.erp.core.sales.invoice.report.ReportingClientXml;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.request.ComboSQLRequest;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.EmailComposer;
import org.openconcerto.ui.JDate;
import org.openconcerto.ui.JLabelBold;
import org.openconcerto.utils.ExceptionHandler;

public class ReportingClientPanel
extends JPanel {
    public ReportingClientPanel() {
        super(new GridBagLayout());
        JLabelBold title = new JLabelBold("G\u00e9n\u00e9ration d'un relev\u00e9 des factures d'un client");
        JLabel labelCom = new JLabel("Relev\u00e9 du client");
        final ElementComboBox box = new ElementComboBox(true);
        SQLElement element = Configuration.getInstance().getDirectory().getElement("CLIENT");
        ComboSQLRequest comboRequest = element.getComboRequest(true);
        box.init(element, comboRequest);
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridwidth = 0;
        this.add((Component)title, c);
        ++c.gridy;
        c.gridwidth = 1;
        this.add((Component)labelCom, c);
        ++c.gridx;
        c.gridwidth = 0;
        this.add((Component)box, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.add((Component)new JLabel("Facture \u00e9mises entre le"), c);
        final JDate d1 = new JDate();
        ++c.gridx;
        this.add((Component)d1, c);
        ++c.gridx;
        this.add((Component)new JLabel("et le"), c);
        final JDate d2 = new JDate();
        ++c.gridx;
        this.add((Component)d2, c);
        final JButton buttonValid = new JButton(new AbstractAction("Valider"){

            @Override
            public void actionPerformed(ActionEvent e) {
                new Thread(){

                    @Override
                    public void run() {
                        SQLRow selectedClient = box.getSelectedRow();
                        ReportingClientXml sheet = new ReportingClientXml(selectedClient, d1.getValue(), d2.getValue());
                        try {
                            sheet.createDocument();
                            String mail = selectedClient.getString("MAIL");
                            try {
                                EmailComposer.getInstance().compose(mail, "", "", sheet.getGeneratedFile());
                            }
                            catch (Exception exn) {
                                ExceptionHandler.handle(null, "Impossible de cr\u00e9er le courriel", exn);
                            }
                        }
                        catch (Exception e) {
                            ExceptionHandler.handle("Une erreur est survenue lors de la cr\u00e9ation du document", e);
                        }
                    }
                }.start();
            }
        });
        ++c.gridx;
        this.add((Component)buttonValid, c);
        buttonValid.setEnabled(false);
        box.addModelListener("wantedID", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent arg0) {
                buttonValid.setEnabled(box.getWantedID() != -1 && box.getWantedID() != box.getRequest().getPrimaryTable().getUndefinedID());
            }
        });
    }
}

