/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.util.Arrays;
import java.util.Collection;

public class IntHashSet {
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final int DEFAULT_INITIAL_SIZE = 16;
    private static final int INT_PHI = -1640531527;
    private static final int INV_INT_PHI = 340573321;
    protected transient int[] key;
    protected transient int mask;
    protected transient boolean containsNull;
    protected transient int n;
    protected transient int maxFill;
    protected final transient int minN;
    protected int size;
    protected final float f;

    public IntHashSet(int expected, float f) {
        if (f <= 0.0f || f >= 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than 1");
        }
        if (expected < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f;
        this.minN = this.n = IntHashSet.arraySize(expected, f);
        this.mask = this.n - 1;
        this.maxFill = IntHashSet.maxFill(this.n, f);
        this.key = new int[this.n + 1];
    }

    public IntHashSet(int expected) {
        this(expected, 0.75f);
    }

    public IntHashSet() {
        this(16, 0.75f);
    }

    public IntHashSet(Collection<? extends Integer> c, float f) {
        this(c.size(), f);
        this.addAll(c);
    }

    public IntHashSet(Collection<? extends Integer> c) {
        this(c, 0.75f);
    }

    public IntHashSet(int[] a, int offset, int length, float f) {
        this(length < 0 ? 0 : length, f);
        IntHashSet.ensureOffsetLength(a.length, offset, length);
        int i = 0;
        while (i < length) {
            this.add(a[offset + i]);
            ++i;
        }
    }

    public IntHashSet(int[] a, int offset, int length) {
        this(a, offset, length, 0.75f);
    }

    public IntHashSet(int[] a, float f) {
        this(a, 0, a.length, f);
    }

    public IntHashSet(int[] a) {
        this(a, 0.75f);
    }

    public static IntHashSet of() {
        return new IntHashSet();
    }

    public static int arraySize(int expected, float f) {
        long s = Math.max(2L, IntHashSet.nextPowerOfTwo((long)Math.ceil((float)expected / f)));
        if (s > 0x40000000L) {
            throw new IllegalArgumentException("Too large (" + expected + " expected elements with load factor " + f + ")");
        }
        return (int)s;
    }

    public static int maxFill(int n, float f) {
        return Math.min((int)Math.ceil((float)n * f), n - 1);
    }

    public static IntHashSet of(int e) {
        IntHashSet result = new IntHashSet(1, 0.75f);
        result.add(e);
        return result;
    }

    public static IntHashSet of(int e0, int e1) {
        IntHashSet result = new IntHashSet(2, 0.75f);
        result.add(e0);
        if (!result.add(e1)) {
            throw new IllegalArgumentException("Duplicate element: " + e1);
        }
        return result;
    }

    public static IntHashSet of(int e0, int e1, int e2) {
        IntHashSet result = new IntHashSet(3, 0.75f);
        result.add(e0);
        if (!result.add(e1)) {
            throw new IllegalArgumentException("Duplicate element: " + e1);
        }
        if (!result.add(e2)) {
            throw new IllegalArgumentException("Duplicate element: " + e2);
        }
        return result;
    }

    public static IntHashSet of(int ... a) {
        IntHashSet result = new IntHashSet(a.length, 0.75f);
        int[] nArray = a;
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            int element = nArray[n2];
            if (!result.add(element)) {
                throw new IllegalArgumentException("Duplicate element " + element);
            }
            ++n2;
        }
        return result;
    }

    private int realSize() {
        return this.containsNull ? this.size - 1 : this.size;
    }

    private void ensureCapacity(int capacity) {
        int needed = IntHashSet.arraySize(capacity, this.f);
        if (needed > this.n) {
            this.rehash(needed);
        }
    }

    private void tryCapacity(long capacity) {
        int needed = (int)Math.min(0x40000000L, Math.max(2L, IntHashSet.nextPowerOfTwo((long)Math.ceil((float)capacity / this.f))));
        if (needed > this.n) {
            this.rehash(needed);
        }
    }

    public void addAll(Collection<? extends Integer> c) {
        if ((double)this.f <= 0.5) {
            this.ensureCapacity(c.size());
        } else {
            this.tryCapacity(this.size() + c.size());
        }
        for (Integer n : c) {
            this.add(n);
        }
    }

    public static int mix(int x) {
        int h = x * -1640531527;
        return h ^ h >>> 16;
    }

    public static int invMix(int x) {
        return (x ^ x >>> 16) * 340573321;
    }

    /*
     * Unable to fully structure code
     */
    public boolean add(int k) {
        block4: {
            block5: {
                block3: {
                    if (k != 0) break block3;
                    if (this.containsNull) {
                        return false;
                    }
                    this.containsNull = true;
                    break block4;
                }
                key = this.key;
                pos = IntHashSet.mix(k) & this.mask;
                curr = key[pos];
                if (curr == 0) break block5;
                if (curr != k) ** GOTO lbl15
                return false;
lbl-1000:
                // 1 sources

                {
                    if (curr != k) continue;
                    return false;
lbl15:
                    // 2 sources

                    ** while ((curr = key[pos = pos + 1 & this.mask]) != 0)
                }
            }
            key[pos] = k;
        }
        if (this.size++ >= this.maxFill) {
            this.rehash(IntHashSet.arraySize(this.size + 1, this.f));
        }
        return true;
    }

    protected final void shiftKeys(int pos) {
        int[] key = this.key;
        while (true) {
            int curr;
            int last = pos;
            pos = last + 1 & this.mask;
            while (true) {
                if ((curr = key[pos]) == 0) {
                    key[last] = 0;
                    return;
                }
                int slot = IntHashSet.mix(curr) & this.mask;
                if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                pos = pos + 1 & this.mask;
            }
            key[last] = curr;
        }
    }

    private boolean removeEntry(int pos) {
        --this.size;
        this.shiftKeys(pos);
        if (this.n > this.minN && this.size < this.maxFill / 4 && this.n > 16) {
            this.rehash(this.n / 2);
        }
        return true;
    }

    private boolean removeNullEntry() {
        this.containsNull = false;
        this.key[this.n] = 0;
        --this.size;
        if (this.n > this.minN && this.size < this.maxFill / 4 && this.n > 16) {
            this.rehash(this.n / 2);
        }
        return true;
    }

    public boolean remove(int k) {
        if (k == 0) {
            if (this.containsNull) {
                return this.removeNullEntry();
            }
            return false;
        }
        int[] key = this.key;
        int pos = IntHashSet.mix(k) & this.mask;
        int curr = key[pos];
        if (curr == 0) {
            return false;
        }
        if (k == curr) {
            return this.removeEntry(pos);
        }
        do {
            if ((curr = key[pos = pos + 1 & this.mask]) != 0) continue;
            return false;
        } while (k != curr);
        return this.removeEntry(pos);
    }

    public boolean contains(int k) {
        if (k == 0) {
            return this.containsNull;
        }
        int[] key = this.key;
        int pos = IntHashSet.mix(k) & this.mask;
        int curr = key[pos];
        if (curr == 0) {
            return false;
        }
        if (k == curr) {
            return true;
        }
        do {
            if ((curr = key[pos = pos + 1 & this.mask]) != 0) continue;
            return false;
        } while (k != curr);
        return true;
    }

    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        this.containsNull = false;
        Arrays.fill(this.key, 0);
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean trim() {
        return this.trim(this.size);
    }

    public boolean trim(int n) {
        int l = IntHashSet.nextPowerOfTwo((int)Math.ceil((float)n / this.f));
        if (l >= this.n || this.size > IntHashSet.maxFill(l, this.f)) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(int newN) {
        int[] key = this.key;
        int mask = newN - 1;
        int[] newKey = new int[newN + 1];
        int i = this.n;
        int j = this.realSize();
        while (j-- != 0) {
            while (key[--i] == 0) {
            }
            int pos = IntHashSet.mix(key[i]) & mask;
            if (newKey[pos] != 0) {
                while (newKey[pos = pos + 1 & mask] != 0) {
                }
            }
            newKey[pos] = key[i];
        }
        this.n = newN;
        this.mask = mask;
        this.maxFill = IntHashSet.maxFill(this.n, this.f);
        this.key = newKey;
    }

    public IntHashSet clone() {
        IntHashSet c;
        try {
            c = (IntHashSet)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.key = (int[])this.key.clone();
        c.containsNull = this.containsNull;
        return c;
    }

    /*
     * Unable to fully structure code
     */
    public int hashCode() {
        h = 0;
        j = this.realSize();
        i = 0;
        ** GOTO lbl10
        {
            ++i;
            do {
                if (this.key[i] == 0) continue block0;
                h += this.key[i];
                ++i;
lbl10:
                // 2 sources

            } while (j-- != 0);
        }
        return h;
    }

    public static int nextPowerOfTwo(int x) {
        if (x == 0) {
            return 1;
        }
        --x;
        x |= x >> 1;
        x |= x >> 2;
        x |= x >> 4;
        x |= x >> 8;
        return (x | x >> 16) + 1;
    }

    public static long nextPowerOfTwo(long x) {
        if (x == 0L) {
            return 1L;
        }
        --x;
        x |= x >> 1;
        x |= x >> 2;
        x |= x >> 4;
        x |= x >> 8;
        x |= x >> 16;
        return (x | x >> 32) + 1L;
    }

    public static void ensureOffsetLength(int arrayLength, int offset, int length) {
        if (offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Offset (" + offset + ") is negative");
        }
        if (length < 0) {
            throw new IllegalArgumentException("Length (" + length + ") is negative");
        }
        if (offset + length > arrayLength) {
            throw new ArrayIndexOutOfBoundsException("Last index (" + (offset + length) + ") is greater than array length (" + arrayLength + ")");
        }
    }
}

