/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openconcerto.erp.core.sales.pos.model.Article;
import org.openconcerto.erp.core.sales.pos.ui.ArticleModel;
import org.openconcerto.erp.core.sales.pos.ui.ArticleSelectionListener;
import org.openconcerto.erp.core.sales.pos.ui.ArticleSelector;
import org.openconcerto.erp.core.sales.pos.ui.CaisseControler;
import org.openconcerto.erp.core.sales.pos.ui.CaisseFrame;
import org.openconcerto.ui.touch.ScrollableList;

public class ArticleSelectorDialogPanel
extends JPanel {
    private final ScrollableList list;
    private final CaisseControler controller;
    private final ArticleSelectionListener listener;

    public ArticleSelectorDialogPanel(CaisseFrame caisseFrame, List<Article> articles, ArticleSelectionListener articleSelectionListener) {
        this.listener = articleSelectionListener;
        this.controller = caisseFrame.getControler();
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        ArticleModel model = new ArticleModel();
        model.setArticles(articles);
        final Font f = this.controller.getPOSConf().getScreenWidth() < 1280 ? new Font("Arial", 0, 18) : new Font("Arial", 0, 21);
        this.list = new ScrollableList(model){
            int maxStringWidth;
            {
                super($anonymous0);
                this.maxStringWidth = 0;
            }

            @Override
            public void paint(Graphics g) {
                if (this.maxStringWidth == 0) {
                    int strW;
                    g.setFont(f);
                    int w = this.getWidth();
                    int priceWidth = (int)g.getFontMetrics(f).getStringBounds("9999 \u20ac", g).getWidth();
                    int maxW = w - priceWidth - ArticleSelectorDialogPanel.this.getLeftMargin();
                    String str = "a";
                    do {
                        strW = (int)g.getFontMetrics(f).getStringBounds(str, g).getWidth();
                        str = String.valueOf(str) + "a";
                    } while (strW < maxW);
                    this.maxStringWidth = Math.max(1, str.length() - 1);
                }
                super.paint(g);
                g.setColor(Color.GRAY);
                g.drawLine(0, 0, 0, this.getHeight());
            }

            @Override
            public void paintCell(Graphics g, Object object, int index, boolean isSelected, int posY) {
                Article article = (Article)object;
                ArticleSelector.paintArticle(f, g, article, isSelected, posY, this.getWidth(), this.getCellHeight(), this.maxStringWidth, ArticleSelectorDialogPanel.this.getLeftMargin(), false);
            }
        };
        this.list.setFixedCellHeight(64);
        this.list.setOpaque(true);
        this.add((Component)this.list, c);
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Object sel = ArticleSelectorDialogPanel.this.list.getSelectedValue();
                if (sel != null && !e.getValueIsAdjusting()) {
                    Article article = (Article)sel;
                    ArticleSelectorDialogPanel.this.controller.setArticleSelected(article);
                }
            }
        });
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Object sel = ArticleSelectorDialogPanel.this.list.getSelectedValue();
                if (sel != null) {
                    Article article = (Article)sel;
                    ArticleSelectorDialogPanel.this.articledSelected(article);
                }
            }
        });
    }

    public void articledSelected(Article a) {
        this.listener.articleSelected(a);
    }

    public int getLeftMargin() {
        if (this.controller.getPOSConf().getScreenWidth() < 1280) {
            return 3;
        }
        return 10;
    }

    @Override
    public Dimension getPreferredSize() {
        int w = Math.min(1000, this.controller.getPOSConf().getScreenWidth());
        w = (int)((float)w * 0.8f);
        int h = (int)(0.8 * (double)this.controller.getPOSConf().getScreenHeight());
        return new Dimension(w, h);
    }
}

