/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.config.update;

import java.math.BigDecimal;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.prefs.BackingStoreException;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.config.InstallationPanel;
import org.openconcerto.erp.core.common.element.BanqueSQLElement;
import org.openconcerto.erp.core.finance.payment.element.SDDMessageSQLElement;
import org.openconcerto.erp.core.finance.payment.element.SEPAMandateSQLElement;
import org.openconcerto.erp.core.sales.order.ui.TypeFactureCommandeClient;
import org.openconcerto.erp.core.sales.pos.element.TicketCaisseSQLElement;
import org.openconcerto.erp.core.sales.product.element.ReferenceArticleSQLElement;
import org.openconcerto.erp.core.supplychain.stock.element.ComposedItemStockUpdater;
import org.openconcerto.erp.core.supplychain.stock.element.DepotStockSQLElement;
import org.openconcerto.erp.core.supplychain.stock.element.StockItem;
import org.openconcerto.sql.changer.convert.AddMDFields;
import org.openconcerto.sql.changer.convert.SetFKDefault;
import org.openconcerto.sql.model.AliasedTable;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.DBStructureItem;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLSyntax;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.SQLUpdate;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.sql.request.UpdateBuilder;
import org.openconcerto.sql.utils.AlterTable;
import org.openconcerto.sql.utils.ChangeTable;
import org.openconcerto.sql.utils.SQLCreateTable;
import org.openconcerto.sql.utils.UniqueConstraintCreatorHelper;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.ExceptionHandler;

public class Updater_1_5 {
    private static final String COMPTE_CLIENT_TRANSACTION = "COMPTE_CLIENT_TRANSACTION";

    public static void update(DBRoot root) throws SQLException {
        SQLCreateTable createTarif;
        SQLTable tableNumAuto;
        SQLTable tableFactureF;
        SQLTable tableVF;
        SQLTable tableAvoirC;
        SQLTable tableEchF;
        SQLTable sQLTable;
        SQLTable tableEch;
        SQLTable tableTypeRglt;
        SQLTable tableInfosSalarie;
        SQLTable tableSalarie;
        AlterTable alter;
        SQLTable tableRgltPaye;
        AlterTable t;
        SQLTable tableContrat;
        SQLTable tableTrCmd;
        AlterTable alterB;
        SQLTable tableBL;
        SQLTable tableCheque;
        SQLTable tablePosteAn;
        SQLTable tableDevisElt;
        SQLTable tableBLElt;
        SQLTable tableTrDevis;
        AlterTable t2;
        SQLCreateTable createTable;
        SQLTable fichePayeT;
        String tBanque;
        SQLCreateTable createTableCR;
        SQLTable articleFT;
        SQLTable articleT;
        String chequeDepotTable;
        SQLCreateTable createSDDMsgTable;
        SQLTable contactT;
        SQLTable tkmElt;
        SQLTable tableEcr;
        AlterTable t3;
        SQLTable table;
        SQLTable tableDevis;
        SQLTable tableFPayeElt;
        AlterTable alterB2;
        SQLTable tableCommandeAcompte;
        AlterTable alterC;
        SQLTable tableDevisAcompte;
        AlterTable alterArt;
        SQLTable tableArt;
        SQLTable tableFournisseur;
        AlterTable alterArticle;
        SQLTable tableArticle;
        SQLTable tableClient;
        SQLTable tableEtatCivil;
        SQLTable tableCpaye;
        AlterTable alterB3;
        SQLTable tableFpaye;
        SQLTable tableVarSal;
        AlterTable alt;
        SQLTable tableFacturationCmd;
        SQLTable tableEtatDmdAChat;
        AlterTable alterB4;
        SQLTable tableDmdAChat;
        SQLCreateTable createTableDmd;
        SQLRowValues rowVals;
        SQLCreateTable createTableEtat;
        SQLTable tableCmdFElt;
        SQLTable tableBRElt;
        SQLTable tableCmdElt;
        SQLTable tableVFElt;
        AlterTable alter2;
        SQLTable tableAttachment;
        SQLTable tTva;
        SQLTable tCmdClient;
        SQLTable tCompteClient;
        AlterTable alterClient;
        SQLTable tClient;
        SQLTable tableTitre;
        SQLTable tableCompte = root.getTable("COMPTE_PCE");
        if (!tableCompte.contains("OBSOLETE")) {
            AlterTable alter6 = new AlterTable(tableCompte);
            alter6.addBooleanColumn("OBSOLETE", Boolean.FALSE, false);
            tableCompte.getBase().getDataSource().execute(alter6.asString());
            tableCompte.getSchema().updateVersion();
            tableCompte.fetchFields();
        }
        if (!(tableTitre = root.getTable("TITRE_PERSONNEL")).contains("OBSOLETE")) {
            AlterTable alter7 = new AlterTable(tableTitre);
            alter7.addBooleanColumn("OBSOLETE", Boolean.FALSE, false);
            tableTitre.getBase().getDataSource().execute(alter7.asString());
            tableTitre.getSchema().updateVersion();
            tableTitre.fetchFields();
            UpdateBuilder updBuilder = new UpdateBuilder(tableTitre).setObject(tableTitre.getField("OBSOLETE"), (Object)Boolean.TRUE);
            updBuilder.setWhere(new Where((FieldRef)tableTitre.getField("CODE"), "=", (Object)"Mlle"));
            tableTitre.getBase().getDataSource().execute(updBuilder.asString());
            UpdateBuilder updBuilder2 = new UpdateBuilder(tableTitre).setObject(tableTitre.getField("CODE"), (Object)"M.");
            updBuilder2.setWhere(new Where((FieldRef)tableTitre.getField("CODE"), "=", (Object)"Mr"));
            tableTitre.getBase().getDataSource().execute(updBuilder2.asString());
        }
        if (!root.contains(COMPTE_CLIENT_TRANSACTION)) {
            SQLCreateTable createTable3 = new SQLCreateTable(root, COMPTE_CLIENT_TRANSACTION);
            createTable3.addForeignColumn("CLIENT");
            createTable3.addDateAndTimeColumn("DATE");
            createTable3.addDecimalColumn("MONTANT", 16, 6, BigDecimal.valueOf(0L), false);
            createTable3.addForeignColumn("MODE_REGLEMENT");
            createTable3.addForeignColumn("MOUVEMENT");
            try {
                root.getBase().getDataSource().execute(createTable3.asString());
                InstallationPanel.insertUndef(createTable3);
                root.refetchTable(COMPTE_CLIENT_TRANSACTION);
                root.getSchema().updateVersion();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table COMPTE_CLIENT_TRANSACTION", ex);
            }
        }
        if (!(tClient = root.getTable("CLIENT")).contains("SOLDE_COMPTE")) {
            alterClient = new AlterTable(tClient);
            alterClient.addDecimalColumn("SOLDE_COMPTE", 16, 6, BigDecimal.valueOf(0L), false);
            tClient.getBase().getDataSource().execute(alterClient.asString());
            tClient.getSchema().updateVersion();
            tClient.fetchFields();
        }
        if (!tClient.contains("DATE")) {
            alterClient = new AlterTable(tClient);
            alterClient.addColumn("DATE", "date");
            tClient.getBase().getDataSource().execute(alterClient.asString());
            tClient.getSchema().updateVersion();
            tClient.fetchFields();
        }
        if (!tClient.contains("COMMENTAIRES")) {
            alterClient = new AlterTable(tClient);
            alterClient.addVarCharColumn("COMMENTAIRES", 2048);
            tClient.getBase().getDataSource().execute(alterClient.asString());
            tClient.getSchema().updateVersion();
            tClient.fetchFields();
        }
        if (!tClient.contains("ALERTE")) {
            alterClient = new AlterTable(tClient);
            alterClient.addVarCharColumn("ALERTE", 4096);
            tClient.getBase().getDataSource().execute(alterClient.asString());
            tClient.getSchema().updateVersion();
            tClient.fetchFields();
        }
        if (!(tCompteClient = root.getTable(COMPTE_CLIENT_TRANSACTION)).contains("ID_MOUVEMENT")) {
            AlterTable alterClient2 = new AlterTable(tCompteClient);
            alterClient2.addForeignColumn("ID_MOUVEMENT", root.getTable("MOUVEMENT"));
            tClient.getBase().getDataSource().execute(alterClient2.asString());
            tClient.getSchema().updateVersion();
            tClient.fetchFields();
        }
        if (!(tCmdClient = root.getTable("COMMANDE_CLIENT")).contains("DATE_LIVRAISON_PREV")) {
            AlterTable alterCmdClient = new AlterTable(tCmdClient);
            alterCmdClient.addColumn("DATE_LIVRAISON_PREV", "date");
            tCmdClient.getBase().getDataSource().execute(alterCmdClient.asString());
            tCmdClient.getSchema().updateVersion();
            tCmdClient.fetchFields();
        }
        if (!tClient.contains("CONDITIONS_LIVRAISON")) {
            AlterTable alterClient3 = new AlterTable(tClient);
            alterClient3.addVarCharColumn("CONDITIONS_LIVRAISON", 512);
            tClient.getBase().getDataSource().execute(alterClient3.asString());
            tClient.getSchema().updateVersion();
            tClient.fetchFields();
        }
        List<String> tablesCheque = Arrays.asList("CHEQUE_A_ENCAISSER", "CHEQUE_FOURNISSEUR");
        for (String string : tablesCheque) {
            SQLTable table2 = root.getTable(string);
            if (table2.contains("SANS_VALEUR_ENCAISSEMENT")) continue;
            AlterTable alterElt = new AlterTable(table2);
            alterElt.addBooleanColumn("SANS_VALEUR_ENCAISSEMENT", Boolean.FALSE, false);
            table2.getBase().getDataSource().execute(alterElt.asString());
            root.refetchTable(string);
            root.getSchema().updateVersion();
            UpdateBuilder upBuilder = new UpdateBuilder(table2);
            upBuilder.setObject("SANS_VALEUR_ENCAISSEMENT", (Object)Boolean.TRUE);
            table2.getBase().getDataSource().execute(upBuilder.asString());
        }
        SQLTable tableEncElt = root.getTable("ENCAISSER_MONTANT_ELEMENT");
        if (tableEncElt.getField("DATE").getType().getType() == 93) {
            AlterTable t7 = new AlterTable(tableEncElt);
            t7.alterColumn("DATE", EnumSet.allOf(SQLField.Properties.class), "date", null, Boolean.TRUE);
            tableEncElt.getBase().getDataSource().execute(t7.asString());
            root.refetchTable(tableEncElt.getName());
            root.getSchema().updateVersion();
        }
        if (!(tTva = root.getTable("TAXE")).contains("ID_COMPTE_PCE_COLLECTE_INTRA")) {
            AlterTable alterTaxe = new AlterTable(tTva);
            alterTaxe.addForeignColumn("ID_COMPTE_PCE_COLLECTE_INTRA", root.getTable("COMPTE_PCE"));
            alterTaxe.addForeignColumn("ID_COMPTE_PCE_DED_INTRA", root.getTable("COMPTE_PCE"));
            tTva.getBase().getDataSource().execute(alterTaxe.asString());
            tTva.getSchema().updateVersion();
            tTva.fetchFields();
        }
        if (!root.contains("TAXE_COMPLEMENTAIRE")) {
            SQLCreateTable createTable2 = new SQLCreateTable(root, "TAXE_COMPLEMENTAIRE");
            createTable2.addForeignColumn("ID_COMPTE_PCE_PRODUITS", root.getTable("COMPTE_PCE"));
            createTable2.addForeignColumn("ID_COMPTE_PCE", root.getTable("COMPTE_PCE"));
            createTable2.addDecimalColumn("POURCENT", 16, 6, BigDecimal.valueOf(0L), false);
            createTable2.addVarCharColumn("CODE", 25);
            createTable2.addVarCharColumn("NOM", 256);
            try {
                root.getBase().getDataSource().execute(createTable2.asString());
                InstallationPanel.insertUndef(createTable2);
                root.refetchTable("TAXE_COMPLEMENTAIRE");
                root.getSchema().updateVersion();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table TAXE_COMPLEMENTAIRE", ex);
            }
            SQLTable tableArt2 = root.getTable("ARTICLE");
            AlterTable alterArt2 = new AlterTable(tableArt2);
            alterArt2.addForeignColumn("ID_TAXE_COMPLEMENTAIRE", root.getTable("TAXE_COMPLEMENTAIRE"));
            tableArt2.getBase().getDataSource().execute(alterArt2.asString());
            tableArt2.getSchema().updateVersion();
            tableArt2.fetchFields();
        }
        if (!root.contains("ATTACHMENT")) {
            SQLCreateTable createTable2 = new SQLCreateTable(root, "ATTACHMENT");
            createTable2.addVarCharColumn("SOURCE_TABLE", 128);
            createTable2.addIntegerColumn("SOURCE_ID", 0);
            createTable2.addVarCharColumn("NAME", 256);
            createTable2.addVarCharColumn("MIMETYPE", 256);
            createTable2.addVarCharColumn("FILENAME", 256);
            createTable2.addLongColumn("FILESIZE", 0L, false);
            createTable2.addVarCharColumn("STORAGE_PATH", 256);
            createTable2.addVarCharColumn("STORAGE_FILENAME", 256);
            createTable2.addVarCharColumn("DIRECTORY", 256);
            createTable2.addVarCharColumn("THUMBNAIL", 256);
            createTable2.addIntegerColumn("THUMBNAIL_WIDTH", 32);
            createTable2.addIntegerColumn("THUMBNAIL_HEIGHT", 32);
            createTable2.addVarCharColumn("TAG", 128);
            createTable2.addIntegerColumn("VERSION", 0);
            createTable2.addVarCharColumn("HASH", 32);
            createTable2.addBooleanColumn("ENCRYPTED", Boolean.FALSE, false);
            try {
                root.getBase().getDataSource().execute(createTable2.asString());
                InstallationPanel.insertUndef(createTable2);
                root.refetchTable("ATTACHMENT");
                root.getSchema().updateVersion();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table ATTACHMENT", ex);
            }
        }
        if (!(tableAttachment = root.getTable("ATTACHMENT")).contains("DIRECTORY")) {
            AlterTable alter5 = new AlterTable(tableAttachment);
            alter5.addVarCharColumn("STORAGE_FILENAME", 256);
            alter5.addVarCharColumn("DIRECTORY", 256);
            tableAttachment.getBase().getDataSource().execute(alter5.asString());
            tableAttachment.getSchema().updateVersion();
            tableAttachment.fetchFields();
        }
        if (!tableAttachment.contains("ID_PARENT")) {
            alter2 = new AlterTable(tableAttachment);
            alter2.addForeignColumn("ID_PARENT", tableAttachment);
            tableAttachment.getBase().getDataSource().execute(alter2.asString());
            tableAttachment.getSchema().updateVersion();
            tableAttachment.fetchFields();
        }
        if (!tableAttachment.contains("VERSION")) {
            alter2 = new AlterTable(tableAttachment);
            alter2.addIntegerColumn("VERSION", 0);
            alter2.addVarCharColumn("HASH", 32);
            alter2.addVarCharColumn("INFOS", 8000);
            tableAttachment.getBase().getDataSource().execute(alter2.asString());
            tableAttachment.getSchema().updateVersion();
            tableAttachment.fetchFields();
        }
        if (!tableAttachment.contains("ENCRYPTED")) {
            alter2 = new AlterTable(tableAttachment);
            alter2.addBooleanColumn("ENCRYPTED", Boolean.FALSE, false);
            tableAttachment.getBase().getDataSource().execute(alter2.asString());
            tableAttachment.getSchema().updateVersion();
            tableAttachment.fetchFields();
        }
        List<String> gedTable = Arrays.asList("CLIENT", "MOUVEMENT", "FOURNISSEUR", "ARTICLE", "FACTURE_FOURNISSEUR", "SAISIE_VENTE_FACTURE", "SALARIE");
        for (String string : gedTable) {
            SQLTable tableGED = root.getTable(string);
            if (tableGED.contains("ATTACHMENTS")) continue;
            AlterTable alter8 = new AlterTable(tableGED);
            alter8.addIntegerColumn("ATTACHMENTS", 0);
            tableGED.getBase().getDataSource().execute(alter8.asString());
            tableGED.getSchema().updateVersion();
            tableGED.fetchFields();
        }
        SQLTable tableBLElt2 = root.getTable("BON_DE_LIVRAISON_ELEMENT");
        if (!tableBLElt2.contains("ID_COMMANDE_CLIENT_ELEMENT")) {
            AlterTable t8 = new AlterTable(tableBLElt2);
            t8.addForeignColumn("ID_COMMANDE_CLIENT_ELEMENT", root.getTable("COMMANDE_CLIENT_ELEMENT"));
            tableBLElt2.getBase().getDataSource().execute(t8.asString());
            root.refetchTable(tableBLElt2.getName());
            root.getSchema().updateVersion();
        }
        if (!(tableVFElt = root.getTable("SAISIE_VENTE_FACTURE_ELEMENT")).contains("ID_COMMANDE_CLIENT_ELEMENT")) {
            AlterTable t9 = new AlterTable(tableVFElt);
            t9.addForeignColumn("ID_COMMANDE_CLIENT_ELEMENT", root.getTable("COMMANDE_CLIENT_ELEMENT"));
            tableVFElt.getBase().getDataSource().execute(t9.asString());
            root.refetchTable(tableVFElt.getName());
            root.getSchema().updateVersion();
        }
        if (!(tableCmdElt = root.getTable("COMMANDE_CLIENT_ELEMENT")).contains("LIVRE")) {
            AlterTable t6 = new AlterTable(tableCmdElt);
            t6.addBooleanColumn("LIVRE_FORCED", Boolean.FALSE, false);
            t6.addBooleanColumn("LIVRE", Boolean.FALSE, false);
            t6.addDecimalColumn("QTE_LIVREE", 16, 6, BigDecimal.ZERO, true);
            tableCmdElt.getBase().getDataSource().execute(t6.asString());
            root.refetchTable(tableCmdElt.getName());
            root.getSchema().updateVersion();
            List<String> tablesWorkFlow = Arrays.asList("SAISIE_VENTE_FACTURE", "BON_DE_LIVRAISON");
            for (String tableWorkFlow : tablesWorkFlow) {
                SQLTable tableCmdCli = root.getTable("COMMANDE_CLIENT");
                SQLTable tableTR = root.getTable("TR_COMMANDE_CLIENT");
                SQLTable tableBL2 = root.getTable(tableWorkFlow);
                String sel = "SELECT t.\"ID_COMMANDE_CLIENT\" FROM " + new SQLName(root.getName(), tableTR.getName()).quote() + " t ," + new SQLName(root.getName(), tableCmdCli.getName()).quote() + " c ," + new SQLName(root.getName(), tableBL2.getName()).quote() + " b WHERE c.\"ID\"=t.\"ID_COMMANDE_CLIENT\"" + " AND b.\"ID\"=t.\"ID_" + tableWorkFlow + "\" AND b.\"ARCHIVE\" = 0 AND t.\"ID\" > 1 AND c.\"ID\" > 1 AND  c.\"ARCHIVE\" = 0 GROUP BY t.\"ID_COMMANDE_CLIENT\" HAVING (SUM(b.\"" + (tableWorkFlow.startsWith("BON") ? "TOTAL_HT" : "T_HT") + "\")>=SUM(c.\"T_HT\") ) ";
                List cmd = tableTR.getDBSystemRoot().getDataSource().executeCol(sel);
                UpdateBuilder build = new UpdateBuilder(tableCmdElt);
                build.set("QTE_LIVREE", "\"QTE\"*\"QTE_UNITAIRE\"");
                build.setObject("LIVRE_FORCED", (Object)Boolean.TRUE);
                Where where = new Where(tableCmdElt.getField("ID_COMMANDE_CLIENT"), cmd);
                build.setWhere(where);
                tableTR.getDBSystemRoot().getDataSource().execute(build.asString());
            }
        }
        if (tableCmdElt.contains("LIVRE")) {
            AlterTable t4 = new AlterTable(tableCmdElt);
            t4.alterColumnDefault("LIVRE", "false");
            tableCmdElt.getBase().getDataSource().execute(t4.asString());
            root.refetchTable(tableCmdElt.getName());
            root.getSchema().updateVersion();
            UpdateBuilder upLivre = new UpdateBuilder(tableCmdElt);
            upLivre.setObject("LIVRE", (Object)Boolean.FALSE);
            upLivre.setWhere(new Where((FieldRef)tableCmdElt.getKey(), "=", 1));
            tableCmdElt.getBase().getDataSource().execute(upLivre.asString());
        }
        if (!(tableBRElt = root.getTable("BON_RECEPTION_ELEMENT")).contains("ID_COMMANDE_ELEMENT")) {
            AlterTable t10 = new AlterTable(tableBRElt);
            t10.addForeignColumn("ID_COMMANDE_ELEMENT", root.getTable("COMMANDE_ELEMENT"));
            tableBRElt.getBase().getDataSource().execute(t10.asString());
            root.refetchTable(tableBRElt.getName());
            root.getSchema().updateVersion();
        }
        if (!(tableCmdFElt = root.getTable("COMMANDE_ELEMENT")).contains("RECU")) {
            AlterTable t11 = new AlterTable(tableCmdFElt);
            t11.addBooleanColumn("RECU_FORCED", Boolean.FALSE, false);
            t11.addBooleanColumn("RECU", Boolean.FALSE, false);
            t11.addDecimalColumn("QTE_RECUE", 16, 6, BigDecimal.ZERO, true);
            tableCmdFElt.getBase().getDataSource().execute(t11.asString());
            root.refetchTable(tableCmdFElt.getName());
            root.getSchema().updateVersion();
            SQLTable tableCmdCli = root.getTable("COMMANDE");
            SQLTable tableTR = root.getTable("TR_COMMANDE");
            SQLTable tableBR = root.getTable("BON_RECEPTION");
            String sel = "SELECT t.\"ID_COMMANDE\" FROM " + new SQLName(root.getName(), tableTR.getName()).quote() + " t ," + new SQLName(root.getName(), tableCmdCli.getName()).quote() + " c ," + new SQLName(root.getName(), tableBR.getName()).quote() + " b WHERE c.\"ID\"=t.\"ID_COMMANDE\"" + " AND b.\"ID\"=t.\"ID_BON_RECEPTION\" AND b.\"ARCHIVE\" = 0 AND t.\"ID\" > 1 AND c.\"ID\" > 1 AND c.\"ARCHIVE\" = 0 GROUP BY t.\"ID_COMMANDE\" HAVING (SUM(b.\"TOTAL_HT\")>=SUM(c.\"T_HT\")) ";
            System.err.println(sel);
            List cmd = tableTR.getDBSystemRoot().getDataSource().executeCol(sel);
            UpdateBuilder build = new UpdateBuilder(tableCmdFElt);
            build.set("QTE_RECUE", "\"QTE\"*\"QTE_UNITAIRE\"");
            build.setObject("RECU_FORCED", (Object)Boolean.TRUE);
            Where where = new Where(tableCmdFElt.getField("ID_COMMANDE"), cmd);
            build.setWhere(where);
            System.err.println(build.asString());
            tableTR.getDBSystemRoot().getDataSource().execute(build.asString());
        } else {
            String defaultValue = tableCmdFElt.getField("RECU").getDefaultValue();
            if (defaultValue != null && defaultValue.equals("true")) {
                AlterTable t12 = new AlterTable(tableCmdFElt);
                t12.alterColumn("RECU", EnumSet.allOf(SQLField.Properties.class), "boolean", "false", false);
                tableCmdFElt.getBase().getDataSource().execute(t12.asString());
                root.refetchTable(tableCmdFElt.getName());
                root.getSchema().updateVersion();
                UpdateBuilder build = new UpdateBuilder(tableCmdFElt);
                build.setObject("RECU", (Object)Boolean.FALSE);
                Where w = Where.createRaw(String.valueOf(tableCmdFElt.getField("QTE_RECUE").getQuotedName()) + " < (" + tableCmdFElt.getField("QTE").getQuotedName() + "*" + tableCmdFElt.getField("QTE_UNITAIRE").getQuotedName() + ")", tableCmdFElt.getField("QTE_UNITAIRE"), tableCmdFElt.getField("QTE"), tableCmdFElt.getField("QTE_RECUE"));
                build.setWhere(w.or(new Where((FieldRef)tableCmdFElt.getKey(), "=", 1)));
                System.err.println(build.asString());
                tableCmdFElt.getDBSystemRoot().getDataSource().execute(build.asString());
            }
        }
        SQLTable tableArt3 = root.getTable("ARTICLE");
        if (!tableArt3.contains("MATIERE")) {
            AlterTable alter9 = new AlterTable(tableArt3);
            alter9.addVarCharColumn("MATIERE", 128);
            tableArt3.getBase().getDataSource().execute(alter9.asString());
            tableArt3.getSchema().updateVersion();
            tableArt3.fetchFields();
        }
        if (!root.contains("FABRICANT")) {
            createTableEtat = new SQLCreateTable(root, "FABRICANT");
            createTableEtat.addVarCharColumn("NOM", 256);
            root.getBase().getDataSource().execute(createTableEtat.asString());
            InstallationPanel.insertUndef(createTableEtat);
            root.refetchTable("FABRICANT");
            root.getSchema().updateVersion();
            AlterTable alterA = new AlterTable(root.getTable("ARTICLE"));
            alterA.addForeignColumn("ID_FABRICANT", root.findTable("FABRICANT"));
            root.getBase().getDataSource().execute(alterA.asString());
            root.refetchTable("ARTICLE");
            root.getSchema().updateVersion();
        }
        if (!root.contains("ETAT_DEMANDE_ACHAT_ELEMENT")) {
            createTableEtat = new SQLCreateTable(root, "ETAT_DEMANDE_ACHAT_ELEMENT");
            createTableEtat.addVarCharColumn("NOM", 256);
            createTableEtat.addIntegerColumn("COLOR", null, true);
            root.getBase().getDataSource().execute(createTableEtat.asString());
            InstallationPanel.insertUndef(createTableEtat);
            root.refetchTable("ETAT_DEMANDE_ACHAT_ELEMENT");
            root.getSchema().updateVersion();
            rowVals = new SQLRowValues(root.getTable("ETAT_DEMANDE_ACHAT_ELEMENT"));
            rowVals.put("NOM", "En attente");
            rowVals.insert();
            rowVals.put("NOM", "Demande de prix");
            rowVals.insert();
            rowVals.put("NOM", "En commande");
            rowVals.insert();
            rowVals.put("NOM", "R\u00e9ceptionn\u00e9e");
            rowVals.insert();
            rowVals.put("NOM", "R\u00e9ception partielle");
            rowVals.insert();
            rowVals.put("NOM", "A relancer");
            rowVals.insert();
        }
        if (!root.contains("DEMANDE_ACHAT_ELEMENT")) {
            createTableDmd = new SQLCreateTable(root, "DEMANDE_ACHAT_ELEMENT");
            createTableDmd.addVarCharColumn("CODE", 256);
            createTableDmd.addVarCharColumn("NOM", 256);
            createTableDmd.addIntegerColumn("QTE", 1);
            createTableDmd.addDecimalColumn("QTE_UNITAIRE", 16, 6, BigDecimal.ONE, false);
            createTableDmd.addVarCharColumn("REPERE", 256);
            createTableDmd.addVarCharColumn("REFERENCE", 256);
            createTableDmd.addForeignColumn("FABRICANT");
            createTableDmd.addColumn("DATE", "date");
            createTableDmd.addForeignColumn("ETAT_DEMANDE_ACHAT_ELEMENT");
            createTableDmd.addForeignColumn("UNITE_VENTE");
            createTableDmd.addForeignColumn("ARTICLE");
            createTableDmd.addForeignColumn("FAMILLE_ARTICLE");
            createTableDmd.addForeignColumn("FOURNISSEUR");
            createTableDmd.addBooleanColumn("EN_STOCK", Boolean.FALSE, false);
            root.getBase().getDataSource().execute(createTableDmd.asString());
            InstallationPanel.insertUndef(createTableDmd);
            root.refetchTable("DEMANDE_ACHAT_ELEMENT");
            root.getSchema().updateVersion();
        }
        if (!root.contains("ETAT_DEMANDE_PRIX")) {
            createTableEtat = new SQLCreateTable(root, "ETAT_DEMANDE_PRIX");
            createTableEtat.addVarCharColumn("NOM", 256);
            root.getBase().getDataSource().execute(createTableEtat.asString());
            InstallationPanel.insertUndef(createTableEtat);
            root.refetchTable("ETAT_DEMANDE_PRIX");
            root.getSchema().updateVersion();
            rowVals = new SQLRowValues(root.getTable("ETAT_DEMANDE_PRIX"));
            rowVals.put("NOM", "En attente");
            rowVals.insert();
            rowVals.put("NOM", "Refus\u00e9e");
            rowVals.insert();
            rowVals.put("NOM", "Accept\u00e9e");
            rowVals.insert();
            rowVals.put("NOM", "En cours");
            rowVals.insert();
        }
        if (!root.contains("DEMANDE_PRIX")) {
            createTableDmd = new SQLCreateTable(root, "DEMANDE_PRIX");
            createTableDmd.addVarCharColumn("NUMERO", 256);
            createTableDmd.addVarCharColumn("OBJET", 1024);
            createTableDmd.addForeignColumn("FOURNISSEUR");
            createTableDmd.addColumn("DATE", "date");
            createTableDmd.addColumn("DATE_BUTOIRE", "date");
            createTableDmd.addColumn("T_HT", "bigint DEFAULT 0");
            createTableDmd.addColumn("T_TVA", "bigint DEFAULT 0");
            createTableDmd.addColumn("T_TTC", "bigint DEFAULT 0");
            createTableDmd.addForeignColumn("COMMERCIAL");
            createTableDmd.addForeignColumn("ETAT_DEMANDE_PRIX");
            createTableDmd.addVarCharColumn("INFOS", 1024);
            root.getBase().getDataSource().execute(createTableDmd.asString());
            InstallationPanel.insertUndef(createTableDmd);
            root.refetchTable("DEMANDE_PRIX");
            root.getSchema().updateVersion();
            SQLCreateTable createTableDemandeMElt = new SQLCreateTable(root, "DEMANDE_PRIX_ELEMENT");
            createTableDemandeMElt.addVarCharColumn("NOM", 512);
            createTableDemandeMElt.addForeignColumn("DEMANDE_PRIX");
            createTableDemandeMElt.addForeignColumn("ID_TAXE", root.getTable("TAXE").getSQLName(), root.getTable("TAXE").getKey().getName(), "2");
            createTableDemandeMElt.addIntegerColumn("QTE", 0);
            createTableDemandeMElt.addColumn("VALEUR_METRIQUE_3", "real DEFAULT 0");
            createTableDemandeMElt.addColumn("PRIX_METRIQUE_VT_3", "bigint DEFAULT 0");
            createTableDemandeMElt.addDecimalColumn("PA_HT", 16, 6, BigDecimal.ZERO, false);
            createTableDemandeMElt.addDecimalColumn("PRIX_METRIQUE_HA_2", 16, 6, BigDecimal.ZERO, false);
            createTableDemandeMElt.addDecimalColumn("PRIX_METRIQUE_HA_1", 16, 6, BigDecimal.ZERO, false);
            createTableDemandeMElt.addDecimalColumn("T_PA_TTC", 16, 2, BigDecimal.ZERO, false);
            createTableDemandeMElt.addColumn("VALEUR_METRIQUE_1", "real DEFAULT 0");
            createTableDemandeMElt.addDecimalColumn("T_PA_HT", 16, 6, BigDecimal.ZERO, false);
            createTableDemandeMElt.addColumn("T_POIDS", "real DEFAULT 0");
            createTableDemandeMElt.addColumn("VALEUR_METRIQUE_2", "real DEFAULT 0");
            createTableDemandeMElt.addDecimalColumn("PRIX_METRIQUE_HA_3", 16, 6, BigDecimal.ZERO, false);
            createTableDemandeMElt.addDecimalColumn("PRIX_METRIQUE_VT_2", 16, 6, BigDecimal.ZERO, false);
            createTableDemandeMElt.addDecimalColumn("PRIX_METRIQUE_VT_1", 16, 6, BigDecimal.ZERO, false);
            createTableDemandeMElt.addDecimalColumn("T_PV_TTC", 16, 2, BigDecimal.ZERO, false);
            createTableDemandeMElt.addForeignColumn("ID_METRIQUE_1", root.findTable("METRIQUE"));
            SQLTable findTable = root.findTable("MODE_VENTE_ARTICLE");
            createTableDemandeMElt.addForeignColumn("ID_MODE_VENTE_ARTICLE", findTable.getSQLName(), findTable.getKey().getName(), String.valueOf(5));
            createTableDemandeMElt.addForeignColumn("ID_METRIQUE_3", root.findTable("METRIQUE"));
            createTableDemandeMElt.addForeignColumn("ID_STYLE", root.findTable("STYLE"));
            createTableDemandeMElt.addForeignColumn("ID_METRIQUE_2", root.findTable("METRIQUE"));
            createTableDemandeMElt.addIntegerColumn("QTE_ACHAT", 1);
            createTableDemandeMElt.addForeignColumn("ID_DEVISE", root.findTable("DEVISE"));
            createTableDemandeMElt.addForeignColumn("ID_FAMILLE_ARTICLE", root.findTable("FAMILLE_ARTICLE"));
            createTableDemandeMElt.addVarCharColumn("CODE", 256);
            createTableDemandeMElt.addColumn("SERVICE", "boolean DEFAULT false");
            createTableDemandeMElt.addDecimalColumn("T_PV_HT", 16, 6, BigDecimal.ZERO, false);
            createTableDemandeMElt.addDecimalColumn("PV_HT", 16, 6, BigDecimal.ZERO, false);
            createTableDemandeMElt.addColumn("POIDS", "real DEFAULT 0");
            createTableDemandeMElt.addDecimalColumn("PA_DEVISE", 16, 6, BigDecimal.ZERO, false);
            createTableDemandeMElt.addDecimalColumn("PA_DEVISE_T", 16, 6, BigDecimal.ZERO, false);
            createTableDemandeMElt.addForeignColumn("ID_ARTICLE", root.findTable("ARTICLE"));
            createTableDemandeMElt.addDecimalColumn("QTE_UNITAIRE", 16, 6, BigDecimal.ONE, false);
            createTableDemandeMElt.addForeignColumn("ID_UNITE_VENTE", root.findTable("UNITE_VENTE"));
            createTableDemandeMElt.addVarCharColumn("DESCRIPTIF", 2048);
            createTableDemandeMElt.addIntegerColumn("NIVEAU", 1);
            if (root.contains("DEPOT_STOCK")) {
                createTableDemandeMElt.addForeignColumn("DEPOT_STOCK");
            }
            createTableDemandeMElt.addForeignColumn("ID_ECO_CONTRIBUTION", root.findTable("ECO_CONTRIBUTION"));
            createTableDemandeMElt.addDecimalColumn("ECO_CONTRIBUTION", 16, 2, BigDecimal.ZERO, false);
            createTableDemandeMElt.addDecimalColumn("T_ECO_CONTRIBUTION", 16, 2, BigDecimal.ZERO, false);
            createTableDemandeMElt.addForeignColumn("ID_DEMANDE_ACHAT_ELEMENT", root.findTable("DEMANDE_ACHAT_ELEMENT"));
            root.getBase().getDataSource().execute(createTableDemandeMElt.asString());
            InstallationPanel.insertUndef(createTableDemandeMElt);
            root.refetchTable("DEMANDE_PRIX_ELEMENT");
            root.getSchema().updateVersion();
            AlterTable alterNumero = new AlterTable(root.getTable("NUMEROTATION_AUTO"));
            alterNumero.addVarCharColumn("DMD_PRIX_FORMAT", 128);
            alterNumero.addIntegerColumn("DMD_PRIX_START", 1);
            root.getBase().getDataSource().execute(alterNumero.asString());
            root.refetchTable("NUMEROTATION_AUTO");
            root.getSchema().updateVersion();
            AlterTable alterCmd = new AlterTable(root.getTable("COMMANDE_ELEMENT"));
            alterCmd.addForeignColumn("ID_DEMANDE_ACHAT_ELEMENT", root.findTable("DEMANDE_ACHAT_ELEMENT"));
            root.getBase().getDataSource().execute(alterCmd.asString());
            root.refetchTable("COMMANDE_ELEMENT");
            root.getSchema().updateVersion();
            AlterTable alterF = new AlterTable(root.getTable("FACTURE_FOURNISSEUR_ELEMENT"));
            alterF.addForeignColumn("ID_DEMANDE_ACHAT_ELEMENT", root.findTable("DEMANDE_ACHAT_ELEMENT"));
            root.getBase().getDataSource().execute(alterF.asString());
            root.refetchTable("FACTURE_FOURNISSEUR_ELEMENT");
            root.getSchema().updateVersion();
            AlterTable alterB6 = new AlterTable(root.getTable("BON_RECEPTION_ELEMENT"));
            alterB6.addForeignColumn("ID_DEMANDE_ACHAT_ELEMENT", root.findTable("DEMANDE_ACHAT_ELEMENT"));
            root.getBase().getDataSource().execute(alterB6.asString());
            root.refetchTable("BON_RECEPTION_ELEMENT");
            root.getSchema().updateVersion();
        }
        if (!(tableDmdAChat = root.findTable("DEMANDE_ACHAT_ELEMENT")).contains("ID_FAMILLE_ARTICLE")) {
            AlterTable alterB5 = new AlterTable(tableDmdAChat);
            alterB5.addForeignColumn("ID_FAMILLE_ARTICLE", root.findTable("FAMILLE_ARTICLE"));
            root.getBase().getDataSource().execute(alterB5.asString());
            root.refetchTable("DEMANDE_ACHAT_ELEMENT");
            root.getSchema().updateVersion();
        }
        if (!tableDmdAChat.contains("ID_COMMANDE")) {
            alterB4 = new AlterTable(tableDmdAChat);
            alterB4.addForeignColumn("ID_COMMANDE", root.findTable("COMMANDE"));
            root.getBase().getDataSource().execute(alterB4.asString());
            root.refetchTable("DEMANDE_ACHAT_ELEMENT");
            root.getSchema().updateVersion();
        }
        if (!tableDmdAChat.contains("ID_BON_RECEPTION")) {
            alterB4 = new AlterTable(tableDmdAChat);
            alterB4.addForeignColumn("ID_BON_RECEPTION", root.findTable("BON_RECEPTION"));
            root.getBase().getDataSource().execute(alterB4.asString());
            root.refetchTable("DEMANDE_ACHAT_ELEMENT");
            root.getSchema().updateVersion();
        }
        if (!tableDmdAChat.contains("REPRISE")) {
            alterB4 = new AlterTable(tableDmdAChat);
            alterB4.addBooleanColumn("REPRISE", Boolean.FALSE, false);
            root.getBase().getDataSource().execute(alterB4.asString());
            root.refetchTable("DEMANDE_ACHAT_ELEMENT");
            root.getSchema().updateVersion();
        }
        if (!tableDmdAChat.contains("ID_COMMANDE")) {
            alterB4 = new AlterTable(tableDmdAChat);
            alterB4.addForeignColumn("ID_COMMANDE", root.findTable("COMMANDE"));
            root.getBase().getDataSource().execute(alterB4.asString());
            root.refetchTable("DEMANDE_ACHAT_ELEMENT");
            root.getSchema().updateVersion();
        }
        if (!tableDmdAChat.contains("REPRISE")) {
            alterB4 = new AlterTable(tableDmdAChat);
            alterB4.addBooleanColumn("REPRISE", Boolean.FALSE, false);
            root.getBase().getDataSource().execute(alterB4.asString());
            root.refetchTable("DEMANDE_ACHAT_ELEMENT");
            root.getSchema().updateVersion();
        }
        if (!tableDmdAChat.contains("IMPORT")) {
            alterB4 = new AlterTable(tableDmdAChat);
            alterB4.addBooleanColumn("IMPORT", Boolean.FALSE, false);
            root.getBase().getDataSource().execute(alterB4.asString());
            root.refetchTable("DEMANDE_ACHAT_ELEMENT");
            root.getSchema().updateVersion();
        }
        if (!tableDmdAChat.contains("ID_BON_RECEPTION")) {
            alterB4 = new AlterTable(tableDmdAChat);
            alterB4.addForeignColumn("ID_BON_RECEPTION", root.findTable("BON_RECEPTION"));
            root.getBase().getDataSource().execute(alterB4.asString());
            root.refetchTable("DEMANDE_ACHAT_ELEMENT");
            root.getSchema().updateVersion();
        }
        if (!tableDmdAChat.contains("QTE_RECUE")) {
            alterB4 = new AlterTable(tableDmdAChat);
            alterB4.addIntegerColumn("QTE_RECUE", 0);
            root.getBase().getDataSource().execute(alterB4.asString());
            root.refetchTable("DEMANDE_ACHAT_ELEMENT");
            root.getSchema().updateVersion();
        }
        if (!tableDmdAChat.contains("REPERE_SOURCE")) {
            alterB4 = new AlterTable(tableDmdAChat);
            alterB4.addVarCharColumn("REPERE_SOURCE", 128);
            alterB4.addVarCharColumn("CODE_SOURCE", 128);
            alterB4.addVarCharColumn("NOM_SOURCE", 128);
            root.getBase().getDataSource().execute(alterB4.asString());
            root.refetchTable("DEMANDE_ACHAT_ELEMENT");
            root.getSchema().updateVersion();
        }
        if (!(tableEtatDmdAChat = root.findTable("ETAT_DEMANDE_ACHAT_ELEMENT")).contains("COLOR")) {
            AlterTable alterB42 = new AlterTable(tableEtatDmdAChat);
            alterB42.addIntegerColumn("COLOR", null, true);
            root.getBase().getDataSource().execute(alterB42.asString());
            root.refetchTable("ETAT_DEMANDE_ACHAT_ELEMENT");
            root.getSchema().updateVersion();
        }
        if (!tableDmdAChat.contains("T_HT")) {
            AlterTable alterB5 = new AlterTable(tableDmdAChat);
            alterB5.addVarCharColumn("NUMERO_SE", 128);
            alterB5.addVarCharColumn("DESCRIPTIF_SE", 512);
            alterB5.addVarCharColumn("REVISION", 48);
            alterB5.addDecimalColumn("P_HT", 16, 6, BigDecimal.ZERO, false);
            alterB5.addDecimalColumn("T_HT", 16, 6, BigDecimal.ZERO, false);
            root.getBase().getDataSource().execute(alterB5.asString());
            root.refetchTable("DEMANDE_ACHAT_ELEMENT");
            root.getSchema().updateVersion();
        }
        if (!root.contains("FACTURATION_COMMANDE_CLIENT")) {
            SQLCreateTable createTableEtat2 = new SQLCreateTable(root, "FACTURATION_COMMANDE_CLIENT");
            createTableEtat2.addVarCharColumn("NOM", 256);
            createTableEtat2.addIntegerColumn("TYPE_FACTURE", TypeFactureCommandeClient.GLOBALE.getId());
            createTableEtat2.addBooleanColumn("CHOICE", Boolean.FALSE, false);
            createTableEtat2.addForeignColumn("TYPE_REGLEMENT");
            createTableEtat2.addForeignColumn("COMMANDE_CLIENT");
            createTableEtat2.addForeignColumn("SAISIE_VENTE_FACTURE");
            createTableEtat2.addForeignColumn("MODELE");
            createTableEtat2.addIntegerColumn("AJOURS", 0);
            createTableEtat2.addDecimalColumn("MONTANT", 16, 8, BigDecimal.ZERO, false);
            createTableEtat2.addDecimalColumn("POURCENT", 16, 8, BigDecimal.ZERO, false);
            createTableEtat2.addBooleanColumn("COMPTANT", Boolean.FALSE, false);
            createTableEtat2.addColumn("DATE_PREVISIONNELLE", "date");
            root.getBase().getDataSource().execute(createTableEtat2.asString());
            InstallationPanel.insertUndef(createTableEtat2);
            root.refetchTable("FACTURATION_COMMANDE_CLIENT");
            root.getSchema().updateVersion();
        }
        if (!(tableFacturationCmd = root.getTable("FACTURATION_COMMANDE_CLIENT")).contains("FIN_MOIS")) {
            alt = new AlterTable(tableFacturationCmd);
            alt.addBooleanColumn("FIN_MOIS", Boolean.FALSE, false);
            root.getBase().getDataSource().execute(alt.asString());
            root.refetchTable("FACTURATION_COMMANDE_CLIENT");
            root.getSchema().updateVersion();
        }
        if (!tableFacturationCmd.contains("LENJOUR")) {
            alt = new AlterTable(tableFacturationCmd);
            alt.addIntegerColumn("LENJOUR", 0);
            root.getBase().getDataSource().execute(alt.asString());
            root.refetchTable("FACTURATION_COMMANDE_CLIENT");
            root.getSchema().updateVersion();
        }
        if (!root.contains("CHIFFRAGE_COMMANDE_CLIENT")) {
            SQLCreateTable createTableEtat3 = new SQLCreateTable(root, "CHIFFRAGE_COMMANDE_CLIENT");
            createTableEtat3.addVarCharColumn("NOM", 256);
            createTableEtat3.addForeignColumn("COMMANDE_CLIENT");
            createTableEtat3.addForeignColumn("UNITE_VENTE");
            createTableEtat3.addForeignColumn("FAMILLE_ARTICLE");
            createTableEtat3.addDecimalColumn("QTE", 16, 8, BigDecimal.ZERO, false);
            createTableEtat3.addDecimalColumn("PA_HT", 16, 8, BigDecimal.ZERO, false);
            createTableEtat3.addDecimalColumn("PV_HT", 16, 8, BigDecimal.ZERO, false);
            createTableEtat3.addDecimalColumn("T_PV_HT", 16, 8, BigDecimal.ZERO, false);
            createTableEtat3.addDecimalColumn("T_PA_HT", 16, 8, BigDecimal.ZERO, false);
            createTableEtat3.addDecimalColumn("MARGE", 16, 8, BigDecimal.ZERO, false);
            root.getBase().getDataSource().execute(createTableEtat3.asString());
            InstallationPanel.insertUndef(createTableEtat3);
            root.refetchTable("CHIFFRAGE_COMMANDE_CLIENT");
            root.getSchema().updateVersion();
        }
        if (!(tableVarSal = root.findTable("VARIABLE_SALARIE")).contains("HEURE_ABS_DEFAULT_VAL")) {
            AlterTable alterB7 = new AlterTable(root.getTable("VARIABLE_SALARIE"));
            for (SQLField sqlField : tableVarSal.getContentFields()) {
                String field = sqlField.getName();
                if (field.equalsIgnoreCase("ID_USER_COMMON_CREATE") || field.equalsIgnoreCase("ID_USER_COMMON_MODIFY") || field.equalsIgnoreCase("MODIFICATION_DATE") || field.equalsIgnoreCase("CREATION_DATE") || field.equalsIgnoreCase("HEURE_TRAV") || tableVarSal.contains(String.valueOf(field) + "_DEFAULT_VAL")) continue;
                alterB7.addColumn(String.valueOf(field) + "_DEFAULT_VAL", "real DEFAULT 0");
            }
            root.getBase().getDataSource().execute(alterB7.asString());
            root.refetchTable("VARIABLE_SALARIE");
            root.getSchema().updateVersion();
        }
        if (!(tableFpaye = root.findTable("FICHE_PAYE")).contains("TAXE_CM_SAL")) {
            AlterTable alterB32 = new AlterTable(tableFpaye);
            alterB32.addDecimalColumn("SAL_BASE_BRUT", 16, 2, BigDecimal.ZERO, false);
            alterB32.addDecimalColumn("TAXE_CM_SAL", 16, 2, BigDecimal.ZERO, false);
            alterB32.addDecimalColumn("TAXE_CM_PAT", 16, 2, BigDecimal.ZERO, false);
            alterB32.addDecimalColumn("SAL_BRUT_COTISABLE", 16, 2, BigDecimal.ZERO, false);
            alterB32.addDecimalColumn("SAL_BRUT_TAXABLE", 16, 2, BigDecimal.ZERO, false);
            root.getBase().getDataSource().execute(alterB32.asString());
            root.refetchTable("FICHE_PAYE");
            root.getSchema().updateVersion();
            SQLTable tableElementPaye = root.getTable("FICHE_PAYE_ELEMENT");
            AlterTable tEltPaye = new AlterTable(tableElementPaye);
            tEltPaye.alterColumn("NOM", EnumSet.allOf(SQLField.Properties.class), "varchar(512)", "''", false);
            tableElementPaye.getBase().getDataSource().execute(tEltPaye.asString());
            tableElementPaye.getSchema().updateVersion();
            tableElementPaye.fetchFields();
        }
        if (!tableFpaye.contains("CSG_REDUITE")) {
            alterB3 = new AlterTable(tableFpaye);
            alterB3.addDecimalColumn("CSG_REDUITE", 16, 2, BigDecimal.ZERO, false);
            alterB3.addDecimalColumn("SAL_BRUT_CSG", 16, 2, BigDecimal.ZERO, false);
            alterB3.addDecimalColumn("SAL_BRUT_CSG_REDUITE", 16, 2, BigDecimal.ZERO, false);
            root.getBase().getDataSource().execute(alterB3.asString());
            root.refetchTable("FICHE_PAYE");
            root.getSchema().updateVersion();
        }
        if (!tableFpaye.contains("PERTE_TPT")) {
            alterB3 = new AlterTable(tableFpaye);
            alterB3.addDecimalColumn("PERTE_TPT", 16, 2, BigDecimal.ZERO, false);
            root.getBase().getDataSource().execute(alterB3.asString());
            root.refetchTable("FICHE_PAYE");
            root.getSchema().updateVersion();
        }
        if (!(tableCpaye = root.findTable("CUMULS_PAYE")).contains("TAXE_CM_SAL_C")) {
            AlterTable alterB6 = new AlterTable(tableCpaye);
            alterB6.addDecimalColumn("TAXE_CM_SAL_C", 16, 2, BigDecimal.ZERO, false);
            alterB6.addDecimalColumn("TAXE_CM_PAT_C", 16, 2, BigDecimal.ZERO, false);
            alterB6.addDecimalColumn("SAL_BRUT_COTISABLE_C", 16, 2, BigDecimal.ZERO, false);
            alterB6.addDecimalColumn("SAL_BRUT_TAXABLE_C", 16, 2, BigDecimal.ZERO, false);
            alterB6.addDecimalColumn("SAL_BASE_BRUT_C", 16, 2, BigDecimal.ZERO, false);
            root.getBase().getDataSource().execute(alterB6.asString());
            root.refetchTable("CUMULS_PAYE");
            root.getSchema().updateVersion();
        }
        if (!(tableEtatCivil = root.findTable("ETAT_CIVIL")).contains("NATIONNALITE")) {
            AlterTable alterB8 = new AlterTable(tableEtatCivil);
            alterB8.addVarCharColumn("NATIONNALITE", 256);
            alterB8.addVarCharColumn("CNPS", 256);
            alterB8.addVarCharColumn("TYPE_PIECE_IDENTITE", 256);
            alterB8.addVarCharColumn("NUMERO_PIECE", 256);
            alterB8.addVarCharColumn("NOM_PERE", 256);
            alterB8.addVarCharColumn("NOM_MERE", 256);
            alterB8.addVarCharColumn("CONJOINT_NOM", 256);
            alterB8.addColumn("CONJOINT_DATE_NAISSANCE", "date");
            alterB8.addVarCharColumn("CONJOINT_LIEU_NAISSANCE", 256);
            alterB8.addVarCharColumn("CONJOINT_PROFESSION", 256);
            alterB8.addColumn("DATE_DEBUT_PIECE", "date");
            alterB8.addColumn("DATE_FIN_PIECE", "date");
            root.getBase().getDataSource().execute(alterB8.asString());
            root.refetchTable("ETAT_CIVIL");
            root.getSchema().updateVersion();
        }
        if (!root.contains("ARTICLE_CODE_CLIENT")) {
            SQLCreateTable createTableEtat4 = new SQLCreateTable(root, "ARTICLE_CODE_CLIENT");
            createTableEtat4.addVarCharColumn("NOM", 512);
            createTableEtat4.addVarCharColumn("CODE", 512);
            createTableEtat4.addForeignColumn("CLIENT");
            createTableEtat4.addForeignColumn("ARTICLE");
            root.getBase().getDataSource().execute(createTableEtat4.asString());
            InstallationPanel.insertUndef(createTableEtat4);
            root.refetchTable("ARTICLE_CODE_CLIENT");
            root.getSchema().updateVersion();
        }
        if (!(tableClient = root.getTable("CLIENT")).contains("CODE_FOURNISSEUR")) {
            AlterTable alter10 = new AlterTable(tableClient);
            alter10.addVarCharColumn("CODE_FOURNISSEUR", 256);
            tableCompte.getBase().getDataSource().execute(alter10.asString());
            tableCompte.getSchema().updateVersion();
            tableCompte.fetchFields();
        }
        if (!(tableArticle = root.getTable("ARTICLE")).contains("TARE")) {
            alterArticle = new AlterTable(tableArticle);
            alterArticle.addDecimalColumn("TARE", 16, 8, BigDecimal.ZERO, true);
            tableArticle.getBase().getDataSource().execute(alterArticle.asString());
            tableArticle.getSchema().updateVersion();
            tableArticle.fetchFields();
        }
        if (!tableArticle.contains("IFCO")) {
            alterArticle = new AlterTable(tableArticle);
            alterArticle.addIntegerColumn("IFCO", 0);
            tableArticle.getBase().getDataSource().execute(alterArticle.asString());
            tableArticle.getSchema().updateVersion();
            tableArticle.fetchFields();
        }
        if (!tableArticle.contains("DLC")) {
            alterArticle = new AlterTable(tableArticle);
            alterArticle.addColumn("DLC", "date");
            tableArticle.getBase().getDataSource().execute(alterArticle.asString());
            tableArticle.getSchema().updateVersion();
            tableArticle.fetchFields();
        }
        if (!tableArticle.contains("OPTION")) {
            alterArticle = new AlterTable(tableArticle);
            alterArticle.addBooleanColumn("OPTION", Boolean.FALSE, false);
            tableArticle.getBase().getDataSource().execute(alterArticle.asString());
            tableArticle.getSchema().updateVersion();
            tableArticle.fetchFields();
        }
        if (!(tableFournisseur = root.getTable("FOURNISSEUR")).contains("NUMERO_TVA")) {
            AlterTable alter4 = new AlterTable(tableFournisseur);
            alter4.addVarCharColumn("NUMERO_TVA", 128);
            alter4.addVarCharColumn("SIRET", 128);
            tableFournisseur.getBase().getDataSource().execute(alter4.asString());
            tableFournisseur.getSchema().updateVersion();
            tableFournisseur.fetchFields();
        }
        if (!tableFournisseur.contains("CONDITIONS_PORT")) {
            AlterTable alter3 = new AlterTable(tableFournisseur);
            alter3.addVarCharColumn("CONDITIONS_PORT", 128);
            tableFournisseur.getBase().getDataSource().execute(alter3.asString());
            tableFournisseur.getSchema().updateVersion();
            tableFournisseur.fetchFields();
        }
        SQLTable caisseT = root.getTable("CAISSE");
        String registerLogTableName = "CAISSE_JOURNAL";
        if (!root.contains("CAISSE_JOURNAL")) {
            SQLTable receiptT = root.getTable("TICKET_CAISSE");
            SQLTable userT = root.findTable("USER_COMMON", true);
            SQLCreateTable createLogT = new SQLCreateTable(caisseT.getDBRoot(), "CAISSE_JOURNAL");
            createLogT.setCreateOrder(false);
            AddMDFields.addFields(createLogT, userT);
            createLogT.addForeignColumn("ID_CAISSE", caisseT);
            createLogT.addDateAndTimeColumn("DATE");
            createLogT.addForeignColumn("ID_USER", userT);
            createLogT.addVarCharColumn("EVT", 128);
            createLogT.addVarCharColumn("CREATOR", 128);
            createLogT.addVarCharColumn("CREATOR_VERSION", 128);
            createLogT.addUniqueConstraint("logSequence", Arrays.asList("ID_CAISSE", "DATE"));
            SQLCreateTable createClotureT = new SQLCreateTable(caisseT.getDBRoot(), "CAISSE_CLOTURE");
            createClotureT.setCreateOrder(false);
            AddMDFields.addFields(createClotureT, userT);
            createClotureT.addForeignColumn("ID_ENTREE_JOURNAL", createLogT);
            createClotureT.addVarCharColumn("PERIODE", 32);
            String dateType = createClotureT.getSyntax().getTypeNames(Date.class).iterator().next();
            createClotureT.addColumn("DEBUT", dateType, null, false);
            createClotureT.addColumn("FIN", dateType, null, false);
            createClotureT.addDecimalColumn("TOTAL_TTC", 16, 6, BigDecimal.ZERO, false);
            createClotureT.addVarCharColumn("PREMIER_TICKET", 64, false, "null", true);
            createClotureT.addVarCharColumn("PREMIER_TICKET_HASH", 128, false, "null", true);
            createClotureT.addVarCharColumn("DERNIER_TICKET", 64, false, "null", true);
            createClotureT.addVarCharColumn("DERNIER_TICKET_HASH", 128, false, "null", true);
            createClotureT.addUniqueConstraint("uniqueness", Arrays.asList("ID_ENTREE_JOURNAL"));
            AlterTable alterRegister = new AlterTable(caisseT);
            alterRegister.addForeignColumn("ID_DERNIERE_ENTREE_JOURNAL", createLogT);
            alterRegister.addForeignColumn("ID_DERNIERE_CLOTURE", createClotureT);
            AlterTable alterReceipt = new AlterTable(receiptT);
            alterReceipt.addVarCharColumn("FILE_HASH", 128, false, "null", true);
            alterReceipt.addVarCharColumn("FILE_HASH_PREVIOUS", 128, false, "null", true);
            alterReceipt.addUniqueConstraint("uniqueNumber", new UniqueConstraintCreatorHelper((List)Arrays.asList("NUMERO"), TicketCaisseSQLElement.UNARCHIVED_WHERE){

                @Override
                public Object getObject(SQLSyntax s) {
                    if (s.getSystem() == SQLSystem.H2) {
                        return TicketCaisseSQLElement.UniqueNumber_PartialUniqueTrigger.class;
                    }
                    return super.getObject(s);
                }
            });
            alterReceipt.addUniqueConstraint("uniqueDate", new UniqueConstraintCreatorHelper((List)Arrays.asList("ID_CAISSE", "DATE"), TicketCaisseSQLElement.DATE_WHERE){

                @Override
                public Object getObject(SQLSyntax s) {
                    if (s.getSystem() == SQLSystem.H2) {
                        return TicketCaisseSQLElement.UniqueDate_PartialUniqueTrigger.class;
                    }
                    return super.getObject(s);
                }
            });
            root.createTables(createLogT, createClotureT);
            root.getDBSystemRoot().getDataSource().execute(alterRegister.asString());
            root.getDBSystemRoot().getDataSource().execute(alterReceipt.asString());
            caisseT.getSchema().updateVersion();
            alterRegister.getTable().fetchFields();
            alterReceipt.getTable().fetchFields();
        }
        if (!(tableArt = root.getTable("ARTICLE")).contains("MASQUE_CAISSE")) {
            alterArt = new AlterTable(tableArt);
            alterArt.addBooleanColumn("MASQUE_CAISSE", Boolean.FALSE, false);
            tableArt.getBase().getDataSource().execute(alterArt.asString());
            tableArt.getSchema().updateVersion();
            tableArt.fetchFields();
        }
        if (!tableArt.contains("ADDITIONAL_TICKET_COPY")) {
            alterArt = new AlterTable(tableArt);
            alterArt.addBooleanColumn("ADDITIONAL_TICKET_COPY", Boolean.FALSE, false);
            tableArt.getBase().getDataSource().execute(alterArt.asString());
            tableArt.getSchema().updateVersion();
            tableArt.fetchFields();
        }
        if (!(tableDevisAcompte = root.getTable("DEVIS")).contains("T_ACOMPTE")) {
            AlterTable alterB9 = new AlterTable(tableDevisAcompte);
            alterB9.addLongColumn("T_ACOMPTE", 0L, false);
            root.getBase().getDataSource().execute(alterB9.asString());
            root.refetchTable("DEVIS");
            root.getSchema().updateVersion();
            SQLTable tableEncaisse = root.getTable("ENCAISSER_MONTANT");
            alterC = new AlterTable(tableEncaisse);
            alterC.addBooleanColumn("ACOMPTE", Boolean.FALSE, false);
            alterC.addForeignColumn("ID_DEVIS", tableDevisAcompte);
            root.getBase().getDataSource().execute(alterC.asString());
            root.refetchTable("ENCAISSER_MONTANT");
            root.getSchema().updateVersion();
            SQLTable tableVF2 = root.getTable("SAISIE_VENTE_FACTURE");
            AlterTable alterF = new AlterTable(tableVF2);
            alterF.addLongColumn("T_ACOMPTE", 0L, false);
            root.getBase().getDataSource().execute(alterF.asString());
            root.refetchTable("SAISIE_VENTE_FACTURE");
            root.getSchema().updateVersion();
        }
        if (!(tableCommandeAcompte = root.getTable("COMMANDE_CLIENT")).contains("T_ACOMPTE")) {
            AlterTable alterB22 = new AlterTable(tableCommandeAcompte);
            alterB22.addLongColumn("T_ACOMPTE", 0L, false);
            root.getBase().getDataSource().execute(alterB22.asString());
            root.refetchTable("COMMANDE_CLIENT");
            root.getSchema().updateVersion();
            SQLTable tableEncaisse = root.getTable("ENCAISSER_MONTANT");
            AlterTable alterC2 = new AlterTable(tableEncaisse);
            alterC2.addForeignColumn("ID_COMMANDE_CLIENT", tableDevisAcompte);
            root.getBase().getDataSource().execute(alterC2.asString());
            root.refetchTable("ENCAISSER_MONTANT");
            root.getSchema().updateVersion();
        }
        if (!tableDevisAcompte.contains("DATE_LIVRAISON")) {
            alterB2 = new AlterTable(tableDevisAcompte);
            alterB2.addColumn("DATE_LIVRAISON", "date");
            alterB2.addVarCharColumn("TRANSFORMATION", 200);
            root.getBase().getDataSource().execute(alterB2.asString());
            root.refetchTable("DEVIS");
            root.getSchema().updateVersion();
        }
        if (!tableFpaye.contains("ALLEGEMENT_COTISATION")) {
            alterB2 = new AlterTable(tableFpaye);
            alterB2.addDecimalColumn("ALLEGEMENT_COTISATION", 16, 2, BigDecimal.ZERO, false);
            alterB2.addDecimalColumn("CICE", 16, 2, BigDecimal.ZERO, false);
            alterB2.addDecimalColumn("AVANTAGE_NATURE", 16, 2, BigDecimal.ZERO, false);
            alterB2.addDecimalColumn("HEURE_TRAV", 16, 2, BigDecimal.ZERO, false);
            root.getBase().getDataSource().execute(alterB2.asString());
            root.refetchTable("FICHE_PAYE");
            root.getSchema().updateVersion();
            alterC = new AlterTable(tableCpaye);
            alterC.addDecimalColumn("ALLEGEMENT_COTISATION_C", 16, 2, BigDecimal.ZERO, false);
            alterC.addDecimalColumn("CICE_C", 16, 2, BigDecimal.ZERO, false);
            alterC.addDecimalColumn("AVANTAGE_NATURE_C", 16, 2, BigDecimal.ZERO, false);
            root.getBase().getDataSource().execute(alterC.asString());
            root.refetchTable("CUMULS_PAYE");
            root.getSchema().updateVersion();
        }
        if (!tableFpaye.contains("DETAILS_CONGES")) {
            alterB2 = new AlterTable(tableFpaye);
            alterB2.addVarCharColumn("DETAILS_CONGES", 512);
            root.getBase().getDataSource().execute(alterB2.asString());
            root.refetchTable("FICHE_PAYE");
            root.getSchema().updateVersion();
        }
        if (!(tableFPayeElt = root.getTable("FICHE_PAYE_ELEMENT")).contains("ID_STYLE")) {
            AlterTable alterB10 = new AlterTable(tableFPayeElt);
            alterB10.addForeignColumn("ID_STYLE", root.getTable("STYLE"));
            root.getBase().getDataSource().execute(alterB10.asString());
            root.refetchTable("FICHE_PAYE_ELEMENT");
            root.getSchema().updateVersion();
        }
        boolean upVar = false;
        List<String> f = Arrays.asList("IJSS_BRUT", "IJSS_NET", "FRAIS_PRO", "RBT_TRANSPORT", "HEURE_CHOM", "TAUX_CHOM", "HEURE_INDEM", "ECRETEMENT_CSG", "IJSS_BRUT_SECU_PAS");
        AlterTable alterVarSal = new AlterTable(tableVarSal);
        for (String field : f) {
            if (tableVarSal.contains(field)) continue;
            upVar = true;
            alterVarSal.addColumn(field, "real DEFAULT 0");
            alterVarSal.addColumn(String.valueOf(field) + "_DEFAULT_VAL", "real DEFAULT 0");
            alterVarSal.addColumn(String.valueOf(field) + "_CUMUL_VAL", "real DEFAULT 0");
        }
        if (upVar) {
            root.getBase().getDataSource().execute(alterVarSal.asString());
            root.refetchTable(tableVarSal.getName());
            root.getSchema().updateVersion();
        }
        if (!(tableDevis = root.getTable("DEVIS")).contains("ID_TAXE_PORT")) {
            AlterTable alterB11 = new AlterTable(tableDevis);
            alterB11.addForeignColumn("ID_TAXE_PORT", root.getTable("TAXE"));
            root.getBase().getDataSource().execute(alterB11.asString());
            root.refetchTable(tableDevis.getName());
            root.getSchema().updateVersion();
        }
        List<String> tableRemiseF = Arrays.asList("COMMANDE", "BON_RECEPTION", "FACTURE_FOURNISSEUR");
        for (String t13 : tableRemiseF) {
            SQLTable tableCommande = root.getTable(t13);
            AlterTable tCommande = new AlterTable(tableCommande);
            boolean updateCmd = false;
            if (!tableCommande.contains("ID_TAXE_PORT")) {
                updateCmd = true;
                tCommande.addForeignColumn("ID_TAXE_PORT", root.getTable("TAXE"));
            }
            if (!tableCommande.contains("PORT_HT")) {
                updateCmd = true;
                tCommande.addLongColumn("PORT_HT", 0L, false);
            }
            if (!tableCommande.contains("REMISE_HT")) {
                updateCmd = true;
                tCommande.addLongColumn("REMISE_HT", 0L, false);
            }
            if (!updateCmd) continue;
            tableCommande.getBase().getDataSource().execute(tCommande.asString());
            tableCommande.getSchema().updateVersion();
            tableCommande.fetchFields();
        }
        List<String> tableElement = Arrays.asList("FACTURE_FOURNISSEUR_ELEMENT", "COMMANDE_ELEMENT", "BON_RECEPTION_ELEMENT", "DEMANDE_PRIX_ELEMENT");
        for (String tableName : tableElement) {
            SQLTable table3 = root.getTable(tableName);
            if (table3.contains("ID_FAMILLE_ARTICLE")) continue;
            AlterTable t14 = new AlterTable(table3);
            t14.addForeignColumn("ID_FAMILLE_ARTICLE", root.getTable("FAMILLE_ARTICLE"));
            table3.getBase().getDataSource().execute(t14.asString());
            root.refetchTable(table3.getName());
            root.getSchema().updateVersion();
        }
        SQLTable tableBlElt = root.getTable("BON_RECEPTION_ELEMENT");
        if (!tableBlElt.contains("QTE_ORIGINE")) {
            AlterTable t15 = new AlterTable(tableBlElt);
            t15.addIntegerColumn("QTE_ORIGINE", null, true);
            tableBlElt.getBase().getDataSource().execute(t15.asString());
            root.refetchTable(tableBlElt.getName());
            root.getSchema().updateVersion();
        }
        if (!root.getTable("CAISSE_JOURNAL").contains("HOST_NAME")) {
            AlterTable alterRegisterLog = new AlterTable(root.getTable("CAISSE_JOURNAL"));
            alterRegisterLog.addVarCharColumn("HOST_NAME", 128, true, null, true);
            alterRegisterLog.addVarCharColumn("HOST_USER", 128, true, null, true);
            AlterTable alterRegister = new AlterTable(caisseT);
            alterRegister.dropColumn("ID_DERNIERE_ENTREE_JOURNAL");
            for (String sql : ChangeTable.cat(Arrays.asList(alterRegisterLog, alterRegister))) {
                root.getDBSystemRoot().getDataSource().execute(sql);
            }
            caisseT.getSchema().updateVersion();
            alterRegisterLog.getTable().fetchFields();
            alterRegister.getTable().fetchFields();
        }
        if (!(table = root.findTable("PREFS_COMPTE")).getFieldsName().contains("ID_JOURNAL_AN")) {
            AlterTable t5 = new AlterTable(table);
            t5.addForeignColumn("ID_JOURNAL_AN", root.getTable("JOURNAL"));
            t5.addBooleanColumn("CREATE_NUL_SOLDE_ECR", Boolean.TRUE, false);
            table.getBase().getDataSource().execute(t5.asString());
            table.getSchema().updateVersion();
            table.fetchFields();
        }
        if (!table.getFieldsName().contains("ID_JOURNAL_CB_ATTENTE")) {
            t3 = new AlterTable(table);
            t3.addForeignColumn("ID_JOURNAL_CB_ATTENTE", root.getTable("JOURNAL"));
            table.getBase().getDataSource().execute(t3.asString());
            table.getSchema().updateVersion();
            table.fetchFields();
        }
        if (!table.getFieldsName().contains("ID_COMPTE_PCE_CB_ATTENTE")) {
            t3 = new AlterTable(table);
            t3.addForeignColumn("ID_COMPTE_PCE_CB_ATTENTE", root.getTable("COMPTE_PCE"));
            table.getBase().getDataSource().execute(t3.asString());
            table.getSchema().updateVersion();
            table.fetchFields();
        }
        if (!table.getFieldsName().contains("AUTO_LETTRAGE")) {
            t3 = new AlterTable(table);
            t3.addBooleanColumn("AUTO_LETTRAGE", Boolean.FALSE, false);
            table.getBase().getDataSource().execute(t3.asString());
            table.getSchema().updateVersion();
            table.fetchFields();
        }
        if (!root.contains("ETAT_STOCK")) {
            try {
                SQLCreateTable createTable4 = new SQLCreateTable(root, "ETAT_STOCK");
                createTable4.addColumn("DATE", "date");
                createTable4.addDecimalColumn("MONTANT_HA", 16, 8, BigDecimal.ZERO, true);
                createTable4.addDecimalColumn("MONTANT_VT", 16, 8, BigDecimal.ZERO, true);
                createTable4.addBooleanColumn("INVENTAIRE", Boolean.FALSE, false);
                root.getBase().getDataSource().execute(createTable4.asString());
                InstallationPanel.insertUndef(createTable4);
                root.refetchTable("ETAT_STOCK");
                root.getSchema().updateVersion();
                SQLCreateTable createTableElt = new SQLCreateTable(root, "ETAT_STOCK_ELEMENT");
                createTableElt.addForeignColumn("ARTICLE");
                createTableElt.addForeignColumn("ETAT_STOCK");
                createTableElt.addDecimalColumn("PA", 16, 8, BigDecimal.ZERO, true);
                createTableElt.addDecimalColumn("PV", 16, 8, BigDecimal.ZERO, true);
                createTableElt.addDecimalColumn("T_PA", 16, 8, BigDecimal.ZERO, true);
                createTableElt.addDecimalColumn("T_PV", 16, 8, BigDecimal.ZERO, true);
                createTableElt.addDecimalColumn("QTE", 16, 8, BigDecimal.ZERO, true);
                createTableElt.addDecimalColumn("ECART", 16, 8, BigDecimal.ZERO, true);
                createTableElt.addVarCharColumn("CODE", 256);
                createTableElt.addVarCharColumn("NOM", 2048);
                root.getBase().getDataSource().execute(createTableElt.asString());
                InstallationPanel.insertUndef(createTableElt);
                root.refetchTable("ETAT_STOCK_ELEMENT");
                root.getSchema().updateVersion();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table ETAT_STOCK_ELEMENT", ex);
            }
        } else {
            SQLTable tableEtatStock = root.getTable("ETAT_STOCK_ELEMENT");
            SQLField fieldNom = tableEtatStock.getField("NOM");
            int size = fieldNom.getType().getSize();
            if (size == 512) {
                AlterTable alter11 = new AlterTable(tableEtatStock);
                alter11.alterColumn("NOM", EnumSet.allOf(SQLField.Properties.class), "varchar(2048)", "''", false);
                tableEtatStock.getBase().getDataSource().execute(alter11.asString());
                tableEtatStock.getSchema().updateVersion();
                tableEtatStock.fetchFields();
            }
        }
        SQLTable tableMvtStock = root.getTable("MOUVEMENT_STOCK");
        if (!tableMvtStock.contains("ID_ETAT_STOCK")) {
            AlterTable alter12 = new AlterTable(tableMvtStock);
            alter12.addBooleanColumn("CLOTURE", Boolean.FALSE, false);
            alter12.addBooleanColumn("OUVERTURE", Boolean.FALSE, false);
            alter12.addForeignColumn("ID_ETAT_STOCK", root.getTable("ETAT_STOCK"));
            tableMvtStock.getBase().getDataSource().execute(alter12.asString());
            tableMvtStock.getSchema().updateVersion();
            tableMvtStock.fetchFields();
        }
        if (!(tableEcr = root.getTable("ECRITURE")).contains("CLOTURE")) {
            AlterTable alter13 = new AlterTable(tableEcr);
            alter13.addBooleanColumn("CLOTURE", Boolean.FALSE, false);
            alter13.addBooleanColumn("RAN", Boolean.FALSE, false);
            tableEcr.getBase().getDataSource().execute(alter13.asString());
            tableEcr.getSchema().updateVersion();
            tableEcr.fetchFields();
        }
        if (!(tkmElt = root.getTable("SAISIE_KM_ELEMENT")).contains("JOUR")) {
            AlterTable alterKmElt = new AlterTable(tkmElt);
            alterKmElt.addIntegerColumn("JOUR", 1);
            tkmElt.getBase().getDataSource().execute(alterKmElt.asString());
            tkmElt.getSchema().updateVersion();
            tkmElt.fetchFields();
        }
        for (SQLTable bankT : Arrays.asList(tableFournisseur, tClient)) {
            if (bankT.contains("IBAN")) continue;
            AlterTable alter3 = new AlterTable(bankT);
            alter3.addVarCharColumn("IBAN", 128);
            alter3.addVarCharColumn("BIC", 128);
            bankT.getDBSystemRoot().getDataSource().execute(alter3.asString());
            bankT.getSchema().updateVersion();
            bankT.fetchFields();
        }
        SQLTable typeReglT = root.getTable("TYPE_REGLEMENT");
        if (typeReglT.getRow(10) == null) {
            SQLRowValues directDebitVals = new SQLRowValues(typeReglT).put("NOM", "Pr\u00e9l\u00e8vement");
            directDebitVals.put("COMPTANT", Boolean.FALSE).put("ECHEANCE", Boolean.FALSE);
            directDebitVals.setID(10).insertVerbatim();
        }
        if (!tableClient.contains("ACCEPTE_EMAIL")) {
            AlterTable alter14 = new AlterTable(tableClient);
            alter14.addBooleanColumn("ACCEPTE_EMAIL", Boolean.FALSE, false);
            alter14.addBooleanColumn("ACCEPTE_COURRIER", Boolean.FALSE, false);
            alter14.addBooleanColumn("ACCEPTE_SMS", Boolean.FALSE, false);
            alter14.addBooleanColumn("ACCEPTE_TEL", Boolean.FALSE, false);
            Updater_1_5.exec(alter14);
        }
        if ((contactT = root.getTable("CONTACT")) != null && !contactT.contains("DATE_NAISSANCE")) {
            AlterTable alter4 = new AlterTable(contactT);
            alter4.addColumn("DATE_NAISSANCE", "date");
            Updater_1_5.exec(alter4);
        }
        if ((createSDDMsgTable = SDDMessageSQLElement.getCreateTable(root)) != null) {
            SQLCreateTable createMandate = SEPAMandateSQLElement.getCreateTable(root);
            root.createTables(createSDDMsgTable, createMandate);
            SQLTable msgT = root.getTable(createSDDMsgTable.getName());
            SQLTable mandateT = root.getTable(createMandate.getName());
            AlterTable alterFact = new AlterTable(root.getTable("SAISIE_VENTE_FACTURE"));
            alterFact.addForeignColumn("ID_SDD_MESSAGE", msgT);
            alterFact.addVarCharColumn("SDD_EndToEndId", 35);
            AlterTable alterModeRegl = new AlterTable(root.getTable("MODE_REGLEMENT"));
            alterModeRegl.addForeignColumn(null, mandateT);
            for (String sql : ChangeTable.cat(Arrays.asList(alterFact, alterModeRegl))) {
                root.getDBSystemRoot().getDataSource().execute(sql);
            }
            root.getSchema().updateVersion();
            root.refetch(CollectionUtils.createSet(alterFact.getName(), alterModeRegl.getName()));
            root.setMetadata("SDD_MESSAGE_SERIAL", "0");
        } else {
            SQLField xmlField = root.getTable("SEPA_DIRECT_DEBIT_MESSAGE").getField("XML");
            if (xmlField.getTypeDecl().contains("char")) {
                AlterTable alterTable = new AlterTable(xmlField.getTable());
                alterTable.alterColumn(xmlField.getName(), EnumSet.of(SQLField.Properties.TYPE), alterTable.getSyntax().getTypeNames(Clob.class).iterator().next(), null, null);
                root.getDBSystemRoot().getDataSource().execute(alterTable.asString());
                root.getSchema().updateVersion();
                xmlField.getTable().fetchFields();
            }
        }
        SQLTable vcT = root.getTable("SAISIE_VENTE_COMPTOIR");
        if (!vcT.contains("ID_COMPTE_PCE_PRODUIT")) {
            AlterTable alter15 = new AlterTable(vcT);
            alter15.addForeignColumn("ID_COMPTE_PCE_PRODUIT", root.getTable("COMPTE_PCE"));
            alter15.addForeignColumn("ID_COMPTE_PCE_SERVICE", root.getTable("COMPTE_PCE"));
            Updater_1_5.exec(alter15);
        }
        if (!root.contains(chequeDepotTable = "DEPOT_CHEQUE")) {
            SQLCreateTable createTableDepotCheque = new SQLCreateTable(root, chequeDepotTable);
            createTableDepotCheque.addVarCharColumn("NOM", 512);
            createTableDepotCheque.addLongColumn("MONTANT", 0L, false);
            createTableDepotCheque.addColumn("DATE", "date");
            if (root.contains("BANQUE")) {
                createTableDepotCheque.addForeignColumn("ID_BANQUE", root.getTable("BANQUE"));
            } else if (root.contains("BANQUE_POLE_PRODUIT")) {
                createTableDepotCheque.addForeignColumn("ID_BANQUE", root.getTable("BANQUE_POLE_PRODUIT"));
            }
            createTableDepotCheque.addForeignColumn("ID_ECRITURE", root.getTable("ECRITURE"));
            createTableDepotCheque.addForeignColumn("ID_MOUVEMENT", root.getTable("MOUVEMENT"));
            root.getBase().getDataSource().execute(createTableDepotCheque.asString());
            InstallationPanel.insertUndef(createTableDepotCheque);
            root.refetchTable(chequeDepotTable);
            root.getSchema().updateVersion();
            SQLCreateTable createTableDepotElt = new SQLCreateTable(root, String.valueOf(chequeDepotTable) + "_ELEMENT");
            createTableDepotElt.addVarCharColumn("NUMERO", 128);
            createTableDepotElt.addVarCharColumn("BANQUE", 128);
            createTableDepotElt.addVarCharColumn("PIECE", 512);
            createTableDepotElt.addLongColumn("MONTANT", 0L, false);
            createTableDepotElt.addColumn("DATE", "date");
            createTableDepotElt.addForeignColumn("ID_CHEQUE_A_ENCAISSER", root.getTable("CHEQUE_A_ENCAISSER"));
            createTableDepotElt.addForeignColumn("ID_ECRITURE", root.getTable("ECRITURE"));
            createTableDepotElt.addForeignColumn("ID_CLIENT", root.getTable("CLIENT"));
            createTableDepotElt.addForeignColumn("ID_DEPOT_CHEQUE", root.getTable(chequeDepotTable));
            root.getBase().getDataSource().execute(createTableDepotElt.asString());
            InstallationPanel.insertUndef(createTableDepotElt);
            root.refetchTable(String.valueOf(chequeDepotTable) + "_ELEMENT");
            root.getSchema().updateVersion();
        }
        if (!(articleT = root.getTable("ARTICLE")).contains("QTE_UNITAIRE")) {
            AlterTable alter16 = new AlterTable(articleT);
            alter16.addDecimalColumn("QTE_UNITAIRE", 16, 6, BigDecimal.ONE, false);
            Updater_1_5.exec(alter16);
        }
        if (!(articleFT = root.getTable("ARTICLE_FOURNISSEUR")).contains("QTE_UNITAIRE")) {
            AlterTable alter17 = new AlterTable(articleFT);
            alter17.addDecimalColumn("QTE_UNITAIRE", 16, 6, BigDecimal.ONE, false);
            Updater_1_5.exec(alter17);
        }
        if (!root.contains("COUT_REVIENT")) {
            createTableCR = new SQLCreateTable(root, "COUT_REVIENT");
            createTableCR.addVarCharColumn("CODE", 48);
            createTableCR.addVarCharColumn("NOM", 256);
            createTableCR.addDecimalColumn("POURCENT", 16, 6, BigDecimal.ZERO, false);
            root.getBase().getDataSource().execute(createTableCR.asString());
            InstallationPanel.insertUndef(createTableCR);
            root.refetchTable("COUT_REVIENT");
            root.getSchema().updateVersion();
            AlterTable alterArticle2 = new AlterTable(root.getTable("ARTICLE"));
            alterArticle2.addForeignColumn("ID_COUT_REVIENT", root.findTable("COUT_REVIENT"));
            Updater_1_5.exec(alterArticle2);
            root.refetchTable("ARTICLE");
            root.getSchema().updateVersion();
        }
        if (!root.getTable("ARTICLE").contains("MARGE_WITH_COUT_REVIENT")) {
            AlterTable alterArticle3 = new AlterTable(root.getTable("ARTICLE"));
            alterArticle3.addBooleanColumn("MARGE_WITH_COUT_REVIENT", Boolean.FALSE, false);
            Updater_1_5.exec(alterArticle3);
            root.refetchTable("ARTICLE");
            root.getSchema().updateVersion();
        }
        if (!root.getTable("FACTURE_FOURNISSEUR").contains("NET_A_PAYER")) {
            AlterTable alterFactF = new AlterTable(root.getTable("FACTURE_FOURNISSEUR"));
            alterFactF.addLongColumn("NET_A_PAYER", 0L, false);
            alterFactF.addLongColumn("AVOIR_TTC", 0L, false);
            Updater_1_5.exec(alterFactF);
            root.refetchTable("FACTURE_FOURNISSEUR");
            root.getSchema().updateVersion();
        }
        if (!root.contains("FRAIS_DOCUMENT")) {
            createTableCR = new SQLCreateTable(root, "FRAIS_DOCUMENT");
            createTableCR.addVarCharColumn("CODE", 48);
            createTableCR.addVarCharColumn("NOM", 256);
            createTableCR.addLongColumn("MONTANT_HT", 0L, false);
            createTableCR.addForeignColumn("ID_TAXE", root.getTable("TAXE"));
            createTableCR.addLongColumn("MONTANT_TTC", 0L, false);
            root.getBase().getDataSource().execute(createTableCR.asString());
            InstallationPanel.insertUndef(createTableCR);
            root.refetchTable("FRAIS_DOCUMENT");
            AlterTable alterClient4 = new AlterTable(root.getTable("CLIENT"));
            alterClient4.addForeignColumn("ID_FRAIS_DOCUMENT", root.findTable("FRAIS_DOCUMENT"));
            Updater_1_5.exec(alterClient4);
            root.refetchTable("CLIENT");
            List<String> tables = Arrays.asList("DEVIS", "COMMANDE_CLIENT", "BON_DE_LIVRAISON", "SAISIE_VENTE_FACTURE");
            for (String tableToUp : tables) {
                AlterTable alter18 = new AlterTable(root.getTable(tableToUp));
                alter18.addLongColumn("FRAIS_DOCUMENT_HT", 0L, false);
                alter18.addForeignColumn("ID_TAXE_FRAIS_DOCUMENT", root.getTable("TAXE"));
                Updater_1_5.exec(alter18);
                root.refetchTable(tableToUp);
            }
            root.getSchema().updateVersion();
        }
        SQLTable chequeAvoirT = root.getTable("CHEQUE_AVOIR_CLIENT");
        String string = tBanque = root.contains("BANQUE") ? "BANQUE" : "BANQUE_POLE_PRODUIT";
        if (!chequeAvoirT.contains("ID_" + tBanque)) {
            AlterTable alterChqAvoir = new AlterTable(chequeAvoirT);
            alterChqAvoir.addForeignColumn("ID_" + tBanque, root.findTable(tBanque));
            Updater_1_5.exec(alterChqAvoir);
        }
        if (!(fichePayeT = root.getTable("FICHE_PAYE")).contains("ID_PAS")) {
            SQLCreateTable createTablePas = new SQLCreateTable(root, "PAS");
            createTablePas.addForeignColumn("ID_TYPE_TAUX_PAS", root.findTable("TYPE_TAUX_PAS"));
            createTablePas.addVarCharColumn("CODE_PAS", 256);
            createTablePas.addDecimalColumn("TAUX_PAS", 16, 2, BigDecimal.ZERO, false);
            root.getBase().getDataSource().execute(createTablePas.asString());
            InstallationPanel.insertUndef(createTablePas);
            root.refetchTable("PAS");
            root.getSchema().updateVersion();
            AlterTable alterFichePaye = new AlterTable(fichePayeT);
            alterFichePaye.addForeignColumn("ID_PAS", root.findTable("PAS"));
            alterFichePaye.addDecimalColumn("TOTAL_PAS", 16, 2, BigDecimal.ZERO, false);
            alterFichePaye.addDecimalColumn("NET_AVANT_PAS", 16, 2, BigDecimal.ZERO, false);
            Updater_1_5.exec(alterFichePaye);
            SQLTable tableSal = root.getTable("SALARIE");
            AlterTable alterSalarie = new AlterTable(tableSal);
            alterSalarie.addForeignColumn("ID_PAS", root.findTable("PAS"));
            Updater_1_5.exec(alterSalarie);
            AlterTable alterEtatCivil = new AlterTable(tableEtatCivil);
            alterEtatCivil.addVarCharColumn("NTT", 50);
            Updater_1_5.exec(alterEtatCivil);
            HashMap<String, SQLRow> typeTauxPasMap = new HashMap<String, SQLRow>();
            SQLSelect selTypeTaux = new SQLSelect();
            selTypeTaux.addSelect(root.findTable("TYPE_TAUX_PAS").getKey());
            selTypeTaux.addSelect(root.findTable("TYPE_TAUX_PAS").getField("CODE"));
            List<SQLRow> resultTypeTaux = SQLRowListRSH.execute(selTypeTaux);
            for (SQLRow sqlRow : resultTypeTaux) {
                typeTauxPasMap.put(sqlRow.getString("CODE"), sqlRow);
            }
            SQLSelect selSal = new SQLSelect();
            selSal.addSelect(tableSal.getKey());
            List<SQLRow> rowSal = SQLRowListRSH.execute(selSal);
            for (SQLRow sqlRow : rowSal) {
                SQLRowValues rowValsSal = sqlRow.createEmptyUpdateRow();
                SQLRowValues putRowValues = rowValsSal.putRowValues("ID_PAS");
                putRowValues.put("ID_TYPE_TAUX_PAS", ((SQLRow)typeTauxPasMap.get("13")).getID());
                putRowValues.put("TAUX_PAS", BigDecimal.ZERO);
                putRowValues.commit();
            }
        }
        if (!root.contains("ARTICLE_TARIF_FOURNISSEUR")) {
            createTable = new SQLCreateTable(root, "ARTICLE_TARIF_FOURNISSEUR");
            createTable.addForeignColumn("ARTICLE");
            createTable.addForeignColumn("FOURNISSEUR");
            createTable.addVarCharColumn("REF_FOURNISSEUR", 500);
            createTable.addVarCharColumn("TYPE_REAPPRO", 256);
            createTable.addVarCharColumn("CONDITIONS", 1024);
            createTable.addVarCharColumn("ACHETEUR", 256);
            createTable.addVarCharColumn("CODE_PAYS_ORIGINE", 256);
            createTable.addDecimalColumn("PRIX_ACHAT_DEVISE_F", 16, 6, BigDecimal.valueOf(0L), false);
            createTable.addDecimalColumn("PRIX_ACHAT", 16, 6, BigDecimal.valueOf(0L), false);
            createTable.addIntegerColumn("QTE", 1);
            createTable.addDateAndTimeColumn("DATE_PRIX");
            createTable.addIntegerColumn("DELAI_REAPPRO", 0);
            createTable.addIntegerColumn("DELAI_TRANSPORT", 0);
            createTable.addIntegerColumn("PRIORITE", 0);
            createTable.addDecimalColumn("COEF_PRIX_MINI", 16, 2, BigDecimal.valueOf(0L), false);
            root.getBase().getDataSource().execute(createTable.asString());
            InstallationPanel.insertUndef(createTable);
            root.refetchTable("ARTICLE_TARIF_FOURNISSEUR");
            root.getSchema().updateVersion();
        }
        if (!root.contains("CATEGORIE_COMPTABLE")) {
            createTable = new SQLCreateTable(root, "CATEGORIE_COMPTABLE");
            createTable.addVarCharColumn("NOM", 128);
            createTable.addForeignColumn("ID_TAXE_VENTE", root.getTable("TAXE"));
            createTable.addForeignColumn("ID_TAXE_ACHAT", root.getTable("TAXE"));
            createTable.addForeignColumn("ID_COMPTE_PCE_VENTE", root.getTable("COMPTE_PCE"));
            createTable.addForeignColumn("ID_COMPTE_PCE_ACHAT", root.getTable("COMPTE_PCE"));
            try {
                root.getBase().getDataSource().execute(createTable.asString());
                InstallationPanel.insertUndef(createTable);
                root.refetchTable("CATEGORIE_COMPTABLE");
                root.getSchema().updateVersion();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table CATEGORIE_COMPTABLE", ex);
            }
            AlterTable tableClientCat = new AlterTable(root.getTable("CLIENT"));
            tableClientCat.addForeignColumn("ID_CATEGORIE_COMPTABLE", root.getTable("CATEGORIE_COMPTABLE"));
            root.getBase().getDataSource().execute(tableClientCat.asString());
            root.refetchTable("CLIENT");
            root.getSchema().updateVersion();
            AlterTable tableF = new AlterTable(root.getTable("FOURNISSEUR"));
            tableF.addForeignColumn("ID_CATEGORIE_COMPTABLE", root.getTable("CATEGORIE_COMPTABLE"));
            root.getBase().getDataSource().execute(tableF.asString());
            root.refetchTable("FOURNISSEUR");
            root.getSchema().updateVersion();
            SQLCreateTable createTableArtCat = new SQLCreateTable(root, "ARTICLE_CATEGORIE_COMPTABLE");
            createTableArtCat.addForeignColumn("ID_CATEGORIE_COMPTABLE", root.getTable("CATEGORIE_COMPTABLE"));
            createTableArtCat.addForeignColumn("ID_ARTICLE", root.getTable("ARTICLE"));
            createTableArtCat.addForeignColumn("ID_TAXE_ACHAT", root.getTable("TAXE"));
            createTableArtCat.addForeignColumn("ID_TAXE_VENTE", root.getTable("TAXE"));
            createTableArtCat.addForeignColumn("ID_COMPTE_PCE_VENTE", root.getTable("COMPTE_PCE"));
            createTableArtCat.addForeignColumn("ID_COMPTE_PCE_ACHAT", root.getTable("COMPTE_PCE"));
            try {
                root.getBase().getDataSource().execute(createTableArtCat.asString());
                InstallationPanel.insertUndef(createTableArtCat);
                root.refetchTable("CATEGORIE_COMPTABLE");
                root.getSchema().updateVersion();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table ARTICLE_CATEGORIE_COMPTABLE", ex);
            }
        }
        if (!root.contains("ARTICLE_FOURNISSEUR_SECONDAIRE")) {
            createTable = new SQLCreateTable(root, "ARTICLE_FOURNISSEUR_SECONDAIRE");
            createTable.addForeignColumn("ARTICLE");
            createTable.addForeignColumn("FOURNISSEUR");
            try {
                root.getBase().getDataSource().execute(createTable.asString());
                InstallationPanel.insertUndef(createTable);
                root.refetchTable("ARTICLE_FOURNISSEUR_SECONDAIRE");
                root.getSchema().updateVersion();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table ARTICLE_FOURNISSEUR_SECONDAIRE", ex);
            }
        }
        if (!root.getTable("ARTICLE").contains("AUTO_PRIX_ACHAT_NOMENCLATURE")) {
            AlterTable t16 = new AlterTable(root.getTable("ARTICLE"));
            t16.addBooleanColumn("AUTO_PRIX_ACHAT_NOMENCLATURE", false, false);
            root.getTable("ARTICLE").getBase().getDataSource().execute(t16.asString());
            root.refetchTable(root.getTable("ARTICLE").getName());
            root.getSchema().updateVersion();
        }
        SQLTable userT = root.findTable("USER_COMMON");
        if (!root.contains("DEPOT_STOCK")) {
            SQLCreateTable createTable5 = new SQLCreateTable(root, "DEPOT_STOCK");
            createTable5.addVarCharColumn("CODE", 25);
            createTable5.addVarCharColumn("NOM", 256);
            createTable5.addVarCharColumn("UI_LOCK", 256);
            createTable5.addForeignColumn("ID_USER_UI_LOCK", userT);
            try {
                root.getBase().getDataSource().execute(createTable5.asString());
                InstallationPanel.insertUndef(createTable5);
                root.refetchTable("DEPOT_STOCK");
                root.getSchema().updateVersion();
                SQLRowValues rowValsDefStock = new SQLRowValues(root.getTable("DEPOT_STOCK"));
                rowValsDefStock.put("NOM", "Principal");
                rowValsDefStock.put("UI_LOCK", "ro");
                rowValsDefStock.commit();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table DEPOT_STOCK", ex);
            }
        }
        List<String> tableElementDepot = Arrays.asList("FACTURE_FOURNISSEUR_ELEMENT", "DEVIS_ELEMENT", "COMMANDE_ELEMENT", "BON_RECEPTION_ELEMENT", "COMMANDE_CLIENT_ELEMENT", "BON_DE_LIVRAISON_ELEMENT", "SAISIE_VENTE_FACTURE_ELEMENT", "AVOIR_CLIENT_ELEMENT", "DEMANDE_PRIX_ELEMENT");
        for (String tableName : tableElementDepot) {
            SQLTable tableToAddDepot = root.getTable(tableName);
            if (tableToAddDepot.contains("ID_DEPOT_STOCK")) continue;
            AlterTable t4 = new AlterTable(tableToAddDepot);
            t4.addForeignColumn("ID_DEPOT_STOCK", root.getTable("DEPOT_STOCK"));
            tableToAddDepot.getBase().getDataSource().execute(t4.asString());
            root.refetchTable(tableToAddDepot.getName());
            root.getSchema().updateVersion();
        }
        if (!root.getTable("ARTICLE").contains("ID_DEPOT_STOCK")) {
            AlterTable t32 = new AlterTable(root.getTable("ARTICLE"));
            t32.addForeignColumn("ID_DEPOT_STOCK", root.getTable("DEPOT_STOCK"));
            root.getTable("ARTICLE").getBase().getDataSource().execute(t32.asString());
            root.refetchTable(root.getTable("ARTICLE").getName());
            root.getSchema().updateVersion();
        }
        if (!root.getTable("STOCK").contains("ID_DEPOT_STOCK")) {
            t2 = new AlterTable(root.getTable("STOCK"));
            t2.addForeignColumn("ID_DEPOT_STOCK", root.getTable("DEPOT_STOCK"));
            t2.addForeignColumn("ID_ARTICLE", root.getTable("ARTICLE"));
            t2.addColumn("QTE_MIN", "real DEFAULT 0");
            root.getTable("STOCK").getBase().getDataSource().execute(t2.asString());
            root.refetchTable(root.getTable("STOCK").getName());
            root.getSchema().updateVersion();
        }
        if (!root.getTable("MOUVEMENT_STOCK").contains("ID_STOCK")) {
            t2 = new AlterTable(root.getTable("MOUVEMENT_STOCK"));
            t2.addForeignColumn("ID_STOCK", root.getTable("STOCK"));
            t2.addIntegerColumn("SOURCE_ELEMENTID", 1);
            root.getTable("MOUVEMENT_STOCK").getBase().getDataSource().execute(t2.asString());
            root.refetchTable(root.getTable("MOUVEMENT_STOCK").getName());
            root.getSchema().updateVersion();
            SQLTable tableStock = root.getTable("STOCK");
            UpdateBuilder buildStockArt = new UpdateBuilder(tableStock);
            buildStockArt.addBackwardVirtualJoin(tableArticle, "ID_STOCK");
            buildStockArt.setFromVirtualJoinField("ID_ARTICLE", tableArticle.getAlias(), "ID");
            buildStockArt.setFromVirtualJoinField("QTE_MIN", tableArticle.getAlias(), "QTE_MIN");
            buildStockArt.setWhere(new Where((FieldRef)tableStock.getKey(), "!=", 1));
            UpdateBuilder buildMvtStock = new UpdateBuilder(tableMvtStock);
            buildMvtStock.addForwardVirtualJoin(tableArticle, "ID_ARTICLE");
            buildMvtStock.setFromVirtualJoinField("ID_STOCK", tableArticle.getAlias(), "ID_STOCK");
            UpdateBuilder buildStock = new UpdateBuilder(tableStock);
            buildStock.setObject("ID_DEPOT_STOCK", (Object)DepotStockSQLElement.DEFAULT_ID);
            UpdateBuilder buildArticleDepot = new UpdateBuilder(tableArticle);
            buildArticleDepot.setObject("ID_DEPOT_STOCK", (Object)DepotStockSQLElement.DEFAULT_ID);
            tableStock.getDBSystemRoot().getDataSource().execute(buildArticleDepot.asString());
            tableStock.getDBSystemRoot().getDataSource().execute(buildMvtStock.asString());
            tableStock.getDBSystemRoot().getDataSource().execute(buildStock.asString());
            tableStock.getDBSystemRoot().getDataSource().execute(buildStockArt.asString());
        }
        if (!(tableTrDevis = root.getTable("TR_DEVIS")).contains("ID_BON_DE_LIVRAISON")) {
            t2 = new AlterTable(tableTrDevis);
            t2.addForeignColumn("ID_BON_DE_LIVRAISON", root.getTable("BON_DE_LIVRAISON"));
            tableTrDevis.getBase().getDataSource().execute(t2.asString());
            root.refetchTable(tableTrDevis.getName());
            root.getSchema().updateVersion();
        }
        if (!(tableBLElt = root.getTable("BON_DE_LIVRAISON_ELEMENT")).contains("ID_DEVIS_ELEMENT")) {
            AlterTable t17 = new AlterTable(tableBLElt);
            t17.addForeignColumn("ID_DEVIS_ELEMENT", root.getTable("DEVIS_ELEMENT"));
            tableBLElt.getBase().getDataSource().execute(t17.asString());
            root.refetchTable(tableBLElt.getName());
            root.getSchema().updateVersion();
        }
        if (!(tableDevisElt = root.getTable("DEVIS_ELEMENT")).contains("QTE_LIVREE")) {
            AlterTable t18 = new AlterTable(tableDevisElt);
            t18.addBooleanColumn("LIVRE_FORCED", Boolean.FALSE, false);
            t18.addBooleanColumn("LIVRE", Boolean.FALSE, false);
            t18.addDecimalColumn("QTE_LIVREE", 16, 6, BigDecimal.ZERO, true);
            tableDevisElt.getBase().getDataSource().execute(t18.asString());
            root.refetchTable(tableDevisElt.getName());
            root.getSchema().updateVersion();
            SQLSelect sel = new SQLSelect();
            sel.addSelect(root.getTable("DEVISE_HISTORIQUE").getKey(), "COUNT");
            Number n = (Number)root.getDBSystemRoot().getDataSource().executeScalar(sel.asString());
            if (n.intValue() > 0) {
                SQLPreferences prefs = new SQLPreferences(root);
                prefs.putBoolean("ArticleShowDevise", true);
                try {
                    prefs.sync();
                }
                catch (BackingStoreException e) {
                    e.printStackTrace();
                }
            }
        }
        if (!(tablePosteAn = root.getTable("POSTE_ANALYTIQUE")).contains("OBSOLETE")) {
            AlterTable t5 = new AlterTable(tablePosteAn);
            t5.addBooleanColumn("OBSOLETE", Boolean.FALSE, false);
            tablePosteAn.getBase().getDataSource().execute(t5.asString());
            root.refetchTable(tablePosteAn.getName());
            root.getSchema().updateVersion();
        }
        if (!(tableCheque = root.getTable("CHEQUE_A_ENCAISSER")).contains("ID_COMPTE_PCE_TIERS")) {
            AlterTable t22 = new AlterTable(tableCheque);
            t22.addVarCharColumn("TIERS", 256);
            t22.addForeignColumn("ID_COMPTE_PCE_TIERS", root.getTable("COMPTE_PCE"));
            tableCheque.getBase().getDataSource().execute(t22.asString());
            root.refetchTable(tableCheque.getName());
            SQLTable tableEnc = root.getTable("ENCAISSER_MONTANT");
            AlterTable tEnc = new AlterTable(tableEnc);
            tEnc.addVarCharColumn("TIERS", 256);
            tEnc.addForeignColumn("ID_COMPTE_PCE_TIERS", root.getTable("COMPTE_PCE"));
            tableEnc.getBase().getDataSource().execute(tEnc.asString());
            root.refetchTable(tableEnc.getName());
            root.getSchema().updateVersion();
            SQLTable tableEch2 = root.getTable("ECHEANCE_CLIENT");
            AlterTable tEch = new AlterTable(tableEch2);
            tEch.addVarCharColumn("TIERS", 256);
            tEch.addForeignColumn("ID_COMPTE_PCE_TIERS", root.getTable("COMPTE_PCE"));
            tableEch2.getBase().getDataSource().execute(tEch.asString());
            root.refetchTable(tableEch2.getName());
            root.getSchema().updateVersion();
            Iterator<String> tableChq = root.getTable("DEPOT_CHEQUE_ELEMENT");
            AlterTable tChq = new AlterTable((SQLTable)((Object)tableChq));
            tChq.addVarCharColumn("TIERS", 256);
            ((SQLTable)((Object)tableChq)).getBase().getDataSource().execute(tChq.asString());
            root.refetchTable(((DBStructureItem)((Object)tableChq)).getName());
            root.getSchema().updateVersion();
        }
        if (!tableEcr.contains("DATE_ECHEANCE")) {
            AlterTable t6 = new AlterTable(tableEcr);
            t6.addColumn("DATE_ECHEANCE", "date");
            tableEcr.getBase().getDataSource().execute(t6.asString());
            root.refetchTable(tableEcr.getName());
            root.getSchema().updateVersion();
        }
        if (!tableVarSal.contains("HEURE_ABS_CUMUL_VAL")) {
            AlterTable alterB12 = new AlterTable(root.getTable("VARIABLE_SALARIE"));
            for (SQLField sqlField : tableVarSal.getContentFields()) {
                String field = sqlField.getName();
                if (field.equalsIgnoreCase("ID_USER_COMMON_CREATE") || field.equalsIgnoreCase("ID_USER_COMMON_MODIFY") || field.equalsIgnoreCase("MODIFICATION_DATE") || field.equalsIgnoreCase("CREATION_DATE") || field.endsWith("_DEFAULT_VAL") || tableVarSal.contains(String.valueOf(field) + "_CUMUL_VAL")) continue;
                alterB12.addColumn(String.valueOf(field) + "_CUMUL_VAL", "real DEFAULT 0");
            }
            root.getBase().getDataSource().execute(alterB12.asString());
            root.refetchTable("VARIABLE_SALARIE");
            root.getSchema().updateVersion();
        }
        if (!(tableBL = root.getTable("BON_DE_LIVRAISON")).contains("ID_COMMERCIAL")) {
            alterB = new AlterTable(tableBL);
            alterB.addForeignColumn("ID_COMMERCIAL", root.getTable("COMMERCIAL"));
            root.getBase().getDataSource().execute(alterB.asString());
            root.refetchTable("BON_DE_LIVRAISON");
            root.getSchema().updateVersion();
        }
        if (!tableBL.contains("VERROU_FACTURATION")) {
            alterB = new AlterTable(tableBL);
            alterB.addBooleanColumn("VERROU_FACTURATION", Boolean.FALSE, false);
            root.getBase().getDataSource().execute(alterB.asString());
            root.refetchTable("BON_DE_LIVRAISON");
            root.getSchema().updateVersion();
        }
        SQLTable tableStock = root.getTable("STOCK");
        SQLSelect sel = new SQLSelect();
        sel.addSelectFunctionStar("COUNT");
        sel.addSelect(tableStock.getField("ID_DEPOT_STOCK"));
        sel.addSelect(tableStock.getField("ID_ARTICLE"));
        sel.addGroupBy(tableStock.getField("ID_DEPOT_STOCK"));
        sel.addGroupBy(tableStock.getField("ID_ARTICLE"));
        sel.setHaving(Where.createRaw("COUNT(*)>1", Collections.emptyList()));
        System.err.println(sel.asString());
        List resultStockDoublon = (List)tableStock.getDBSystemRoot().getDataSource().execute(sel.asString(), new ArrayListHandler());
        for (Object[] objects : resultStockDoublon) {
            if (((Number)objects[2]).intValue() == 1) {
                UpdateBuilder buildStockArt = new UpdateBuilder(tableStock);
                buildStockArt.addBackwardVirtualJoin(tableArticle, "ID_STOCK");
                buildStockArt.setFromVirtualJoinField("ID_ARTICLE", tableArticle.getAlias(), "ID");
                buildStockArt.setWhere(new Where((FieldRef)tableStock.getKey(), "!=", 1));
                tableStock.getDBSystemRoot().getDataSource().execute(buildStockArt.asString());
                continue;
            }
            SQLSelect selD = new SQLSelect();
            selD.addSelectStar(tableStock);
            Where w = new Where((FieldRef)tableStock.getField("ID_ARTICLE"), "=", objects[2]);
            w = w.and(new Where((FieldRef)tableStock.getField("ID_DEPOT_STOCK"), "=", objects[1]));
            selD.setWhere(w);
            List<SQLRow> badStock = SQLRowListRSH.execute(selD);
            if (badStock.size() <= 1) continue;
            SQLRowValues stock = badStock.get(0).createUpdateRow();
            List<String> fieldsToMerge = Arrays.asList("QTE_REEL", "QTE_TH", "QTE_RECEPT_ATTENTE", "QTE_LIV_ATTENTE");
            ArrayList<Integer> listBadIds = new ArrayList<Integer>();
            int i = 1;
            while (i < badStock.size()) {
                SQLRow rowBad = badStock.get(i);
                listBadIds.add(rowBad.getID());
                for (String string2 : fieldsToMerge) {
                    stock.put(string2, Float.valueOf(stock.getFloat(string2) + rowBad.getFloat(string2)));
                }
                rowBad.createEmptyUpdateRow().put("ARCHIVE", 1).commit();
                ++i;
            }
            List<SQLTable> tablesToMErge = Arrays.asList(root.getTable("MOUVEMENT_STOCK"), root.getTable("ARTICLE"));
            for (Object mergeTable : tablesToMErge) {
                UpdateBuilder up = new UpdateBuilder((SQLTable)mergeTable);
                up.setObject("ID_STOCK", (Object)stock.getID());
                up.setWhere(new Where(((SQLTable)mergeTable).getField("ID_STOCK"), listBadIds));
                ((DBStructureItem)mergeTable).getDBSystemRoot().getDataSource().execute(up.asString());
            }
            stock.commit();
        }
        if (root.getTable("TARIF_ARTICLE_CLIENT") == null) {
            SQLCreateTable createTableQtyTarif = new SQLCreateTable(root, "TARIF_ARTICLE_CLIENT");
            createTableQtyTarif.addForeignColumn("ID_ARTICLE", root.getTable("ARTICLE"));
            createTableQtyTarif.addForeignColumn("ID_CLIENT", root.getTable("CLIENT"));
            createTableQtyTarif.addDecimalColumn("QUANTITE", 16, 3, BigDecimal.ONE, false);
            createTableQtyTarif.addDecimalColumn("POURCENT_REMISE", 16, 3, null, true);
            try {
                root.getBase().getDataSource().execute(createTableQtyTarif.asString());
                InstallationPanel.insertUndef(createTableQtyTarif);
                root.refetchTable("TARIF_ARTICLE_CLIENT");
                root.getSchema().updateVersion();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table TARIF_QUANTITE", ex);
            }
        }
        if (!(tableTrCmd = root.getTable("TR_COMMANDE")).contains("ID_FACTURE_FOURNISSEUR")) {
            AlterTable t19 = new AlterTable(tableTrCmd);
            t19.addForeignColumn("ID_FACTURE_FOURNISSEUR", root.getTable("FACTURE_FOURNISSEUR"));
            tableTrCmd.getBase().getDataSource().execute(t19.asString());
            root.refetchTable(tableTrCmd.getName());
            root.getSchema().updateVersion();
        }
        if (!(tableContrat = root.getTable("CONTRAT_SALARIE")).contains("COMPLEMENT_PCS")) {
            t = new AlterTable(tableContrat);
            t.addVarCharColumn("COMPLEMENT_PCS", 54);
            tableContrat.getBase().getDataSource().execute(t.asString());
            root.refetchTable(tableContrat.getName());
            root.getSchema().updateVersion();
        }
        if (!tableContrat.contains("SPECTACLE_OBJET")) {
            t = new AlterTable(tableContrat);
            t.addVarCharColumn("SPECTACLE_OBJET", 54);
            tableContrat.getBase().getDataSource().execute(t.asString());
            root.refetchTable(tableContrat.getName());
            root.getSchema().updateVersion();
        }
        if (!tableContrat.contains("SPECTACLE_OBJET")) {
            t = new AlterTable(tableContrat);
            t.addVarCharColumn("SPECTACLE_OBJET", 54);
            tableContrat.getBase().getDataSource().execute(t.asString());
            root.refetchTable(tableContrat.getName());
            root.getSchema().updateVersion();
        }
        if (!tableContrat.contains("SPECTACLE_JOUR_CONTRAT")) {
            t = new AlterTable(tableContrat);
            t.addDecimalColumn("SPECTACLE_JOUR_CONTRAT", 16, 2, null, true);
            tableContrat.getBase().getDataSource().execute(t.asString());
            root.refetchTable(tableContrat.getName());
            root.getSchema().updateVersion();
        }
        List<String> tablesCatComptable = Arrays.asList("DEVIS", "COMMANDE_CLIENT", "BON_DE_LIVRAISON", "SAISIE_VENTE_FACTURE", "AVOIR_CLIENT");
        for (String tableToUp : tablesCatComptable) {
            SQLTable tableCatComptToAdd = root.getTable(tableToUp);
            if (tableCatComptToAdd.contains("ID_CATEGORIE_COMPTABLE")) continue;
            AlterTable alter22 = new AlterTable(tableCatComptToAdd);
            alter22.addForeignColumn("ID_CATEGORIE_COMPTABLE", root.getTable("CATEGORIE_COMPTABLE"));
            Updater_1_5.exec(alter22);
            root.refetchTable(tableToUp);
            root.getSchema().updateVersion();
        }
        if (!root.contains("MODELE_EMAIL")) {
            SQLCreateTable createTable6 = new SQLCreateTable(root, "MODELE_EMAIL");
            createTable6.addVarCharColumn("NOM", 80);
            createTable6.addVarCharColumn("TITRE", 80);
            createTable6.addVarCharColumn("TEXTE", 4096);
            createTable6.addVarCharColumn("FORMAT_DATE", 20);
            createTable6.addBooleanColumn("PAR_DEFAUT", Boolean.FALSE, false);
            try {
                root.getBase().getDataSource().execute(createTable6.asString());
                InstallationPanel.insertUndef(createTable6);
                root.refetchTable("MODELE_EMAIL");
                root.getSchema().updateVersion();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table MODELE_EMAIL", ex);
            }
        }
        root.setMetadata("undefined ID policy", "inDB");
        Map<String, Number> mapTableNameUndefined = SQLTable.getUndefinedIDs(root.getSchema());
        Set<String> tables = root.getSchema().getTableNames();
        for (String tName : tables) {
            if (mapTableNameUndefined.containsKey(tName)) continue;
            System.err.println("Updater_1_5.update() adding undefined in db for " + tName);
            SQLTable.setUndefID(root.getSchema(), tName, null);
        }
        if (!root.contains("CONTACT_SALARIE")) {
            SQLCreateTable createModele = new SQLCreateTable(root, "CONTACT_SALARIE");
            createModele.addVarCharColumn("NOM", 256);
            createModele.addVarCharColumn("PRENOM", 256);
            createModele.addVarCharColumn("TEL_DIRECT", 256);
            createModele.addVarCharColumn("TEL_MOBILE", 256);
            createModele.addVarCharColumn("EMAIL", 256);
            createModele.addVarCharColumn("FAX", 256);
            createModele.addVarCharColumn("FONCTION", 256);
            createModele.addVarCharColumn("TEL_PERSONEL", 256);
            createModele.addVarCharColumn("TEL_STANDARD", 256);
            createModele.addForeignColumn("ID_TITRE_PERSONNEL", root.findTable("TITRE_PERSONNEL"));
            createModele.addForeignColumn("ID_SALARIE", root.findTable("SALARIE"));
            try {
                root.getBase().getDataSource().execute(createModele.asString());
                root.refetchTable("CONTACT_SALARIE");
                SQLRowValues rowVals2 = new SQLRowValues(root.getTable("CONTACT_SALARIE"));
                SQLRow rowInserted = rowVals2.commit();
                SQLTable.setUndefID(root.getSchema(), "CONTACT_SALARIE", rowInserted.getID());
                tableDevis.getSchema().updateVersion();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table MODELE", ex);
            }
        }
        if (!(tableRgltPaye = root.getTable("REGLEMENT_PAYE")).contains("IBAN")) {
            alter = new AlterTable(tableRgltPaye);
            alter.addVarCharColumn("IBAN", 128);
            Updater_1_5.exec(alter);
            root.refetchTable(tableRgltPaye.getName());
            root.getSchema().updateVersion();
        }
        if (!tableRgltPaye.contains("BIC")) {
            alter = new AlterTable(tableRgltPaye);
            alter.addVarCharColumn("BIC", 40);
            Updater_1_5.exec(alter);
            root.refetchTable(tableRgltPaye.getName());
            root.getSchema().updateVersion();
        }
        if (!(tableSalarie = root.getTable("SALARIE")).contains("ID_USER_COMMON")) {
            AlterTable alter19 = new AlterTable(tableSalarie);
            alter19.addForeignColumn("ID_USER_COMMON", userT);
            Updater_1_5.exec(alter19);
            root.refetchTable(tableSalarie.getName());
            root.getSchema().updateVersion();
        }
        if (!(tableInfosSalarie = root.getTable("INFOS_SALARIE_PAYE")).contains("DUREE_FORFAIT")) {
            AlterTable alter20 = new AlterTable(tableInfosSalarie);
            alter20.addColumn("DUREE_FORFAIT", "real");
            Updater_1_5.exec(alter20);
            root.refetchTable(tableSalarie.getName());
            root.getSchema().updateVersion();
        }
        boolean upDimensionArt = false;
        AlterTable alterDimensionArt = new AlterTable(tableArt);
        if (!tableArt.contains("LONGUEUR")) {
            alterDimensionArt.addDecimalColumn("LONGUEUR", 16, 8, null, true);
            upDimensionArt = true;
        }
        if (!tableArt.contains("LARGEUR")) {
            alterDimensionArt.addDecimalColumn("LARGEUR", 16, 8, null, true);
            upDimensionArt = true;
        }
        if (!tableArt.contains("HAUTEUR")) {
            alterDimensionArt.addDecimalColumn("HAUTEUR", 16, 8, null, true);
            upDimensionArt = true;
        }
        if (upDimensionArt) {
            tableArt.getBase().getDataSource().execute(alterDimensionArt.asString());
            tableArt.getSchema().updateVersion();
            tableArt.fetchFields();
        }
        List<String> tableElementWithTable = Arrays.asList("FACTURE_FOURNISSEUR_ELEMENT", "DEVIS_ELEMENT", "COMMANDE_ELEMENT", "BON_RECEPTION_ELEMENT", "COMMANDE_CLIENT_ELEMENT", "BON_DE_LIVRAISON_ELEMENT", "SAISIE_VENTE_FACTURE_ELEMENT", "AVOIR_CLIENT_ELEMENT", "DEMANDE_PRIX_ELEMENT");
        for (String tableName : tableElementWithTable) {
            SQLTable sQLTable2 = root.getTable(tableName);
            boolean upDimensionArtItem = false;
            AlterTable alterDimensionArtItem = new AlterTable(sQLTable2);
            if (!sQLTable2.contains("LONGUEUR")) {
                alterDimensionArtItem.addDecimalColumn("LONGUEUR", 16, 8, null, true);
                upDimensionArtItem = true;
            }
            if (!sQLTable2.contains("LARGEUR")) {
                alterDimensionArtItem.addDecimalColumn("LARGEUR", 16, 8, null, true);
                upDimensionArtItem = true;
            }
            if (!sQLTable2.contains("HAUTEUR")) {
                alterDimensionArtItem.addDecimalColumn("HAUTEUR", 16, 8, null, true);
                upDimensionArtItem = true;
            }
            if (!upDimensionArtItem) continue;
            sQLTable2.getBase().getDataSource().execute(alterDimensionArtItem.asString());
            sQLTable2.getSchema().updateVersion();
            sQLTable2.fetchFields();
        }
        if (!tTva.contains("DEFAULT_ACHAT")) {
            AlterTable alterTaxe = new AlterTable(tTva);
            alterTaxe.addBooleanColumn("DEFAULT_ACHAT", Boolean.FALSE, false);
            tTva.getBase().getDataSource().execute(alterTaxe.asString());
            tTva.getSchema().updateVersion();
            tTva.fetchFields();
        }
        if (!(tableTypeRglt = root.getTable("TYPE_REGLEMENT")).contains("SEPA")) {
            AlterTable alterTaxe = new AlterTable(tableTypeRglt);
            alterTaxe.addBooleanColumn("SEPA", Boolean.FALSE, false);
            tableTypeRglt.getBase().getDataSource().execute(alterTaxe.asString());
            tableTypeRglt.getSchema().updateVersion();
            tableTypeRglt.fetchFields();
            UpdateBuilder updateBuilder = new UpdateBuilder(tableTypeRglt);
            updateBuilder.setObject("SEPA", (Object)Boolean.TRUE);
            updateBuilder.setObject("ECHEANCE", (Object)Boolean.TRUE);
            updateBuilder.setWhere(new Where((FieldRef)tableTypeRglt.getField("NOM"), "=", (Object)"Pr\u00e9l\u00e8vement"));
            tTva.getBase().getDataSource().execute(updateBuilder.asString());
        }
        if (!(tableEch = root.getTable("ECHEANCE_CLIENT")).contains("ID_SEPA_MANDATE")) {
            AlterTable alterTable = new AlterTable(tableEch);
            alterTable.addForeignColumn("ID_SEPA_MANDATE", root.getTable("SEPA_MANDATE"));
            alterTable.addForeignColumn("ID_SDD_MESSAGE", root.getTable("SEPA_DIRECT_DEBIT_MESSAGE"));
            alterTable.addVarCharColumn("SDD_EndToEndId", 35);
            alterTable.addBooleanColumn("FICHIER_CREE", Boolean.FALSE, false);
            alterTable.addBooleanColumn("REJETER", Boolean.FALSE, false);
            alterTable.addVarCharColumn("ETS", 256);
            alterTable.addForeignColumn("ID_" + BanqueSQLElement.TABLENAME, root.getTable(BanqueSQLElement.TABLENAME));
            tableEch.getBase().getDataSource().execute(alterTable.asString());
            tableEch.getSchema().updateVersion();
            tableEch.fetchFields();
        }
        if (!tClient.contains("ID_SEPA_MANDATE_DEFAULT")) {
            AlterTable alterTable = new AlterTable(tClient);
            alterTable.addForeignColumn("ID_SEPA_MANDATE_DEFAULT", root.getTable("SEPA_MANDATE"));
            tClient.getBase().getDataSource().execute(alterTable.asString());
            tClient.getSchema().updateVersion();
            tClient.fetchFields();
        }
        if (!tableArt.contains("AUTO_PRIX_MIN_VENTE_NOMENCLATURE")) {
            AlterTable alterTable = new AlterTable(tableArt);
            alterTable.addBooleanColumn("AUTO_PRIX_MIN_VENTE_NOMENCLATURE", Boolean.FALSE, false);
            tableArt.getBase().getDataSource().execute(alterTable.asString());
            tableArt.getSchema().updateVersion();
            tableArt.fetchFields();
        }
        if (!tableArt.contains("DERNIER_DATE_ACHAT")) {
            AlterTable alterTable = new AlterTable(tableArt);
            alterTable.addColumn("DERNIER_DATE_ACHAT", "date");
            tableArt.getBase().getDataSource().execute(alterTable.asString());
            tableArt.getSchema().updateVersion();
            tableArt.fetchFields();
            ReferenceArticleSQLElement.updateDateAchat(tableArt, null);
        }
        if (!(sQLTable = root.getTable("FACTURE_FOURNISSEUR")).contains("DATE_REGLEMENT")) {
            AlterTable alter21 = new AlterTable(sQLTable);
            alter21.addColumn("DATE_REGLEMENT", "date");
            sQLTable.getBase().getDataSource().execute(alter21.asString());
            sQLTable.getSchema().updateVersion();
            sQLTable.fetchFields();
        }
        if (!(tableEchF = root.getTable("ECHEANCE_FOURNISSEUR")).contains("ID_FACTURE_FOURNISSEUR")) {
            AlterTable alter22 = new AlterTable(tableEchF);
            alter22.addForeignColumn("ID_FACTURE_FOURNISSEUR", sQLTable);
            tableEchF.getBase().getDataSource().execute(alter22.asString());
            tableEchF.getSchema().updateVersion();
            tableEchF.fetchFields();
        }
        List<String> achatItems = Arrays.asList("DEMANDE_PRIX_ELEMENT", "COMMANDE_ELEMENT", "BON_RECEPTION_ELEMENT", "FACTURE_FOURNISSEUR_ELEMENT");
        for (String string2 : achatItems) {
            boolean alter23 = false;
            SQLTable tableItems = root.getTable(string2);
            AlterTable t20 = new AlterTable(tableItems);
            if (!tableItems.getFieldsName().contains("POIDS_COLIS_NET")) {
                t20.addColumn("POIDS_COLIS_NET", "numeric (16,8) DEFAULT 1");
                alter23 = true;
            }
            if (!tableItems.getFieldsName().contains("T_POIDS_COLIS_NET")) {
                t20.addColumn("T_POIDS_COLIS_NET", "numeric (16,8) DEFAULT 1");
                alter23 = true;
            }
            if (!tableItems.getFieldsName().contains("NB_COLIS")) {
                t20.addColumn("NB_COLIS", "integer DEFAULT 0");
                alter23 = true;
            }
            if (!alter23) continue;
            tableItems.getBase().getDataSource().execute(t20.asString());
            tableItems.getSchema().updateVersion();
            tableItems.fetchFields();
        }
        for (String tableName : tableElementWithTable) {
            SQLTable tableToAddTare = root.getTable(tableName);
            boolean upTareArtItem = false;
            AlterTable alterTareArtItem = new AlterTable(tableToAddTare);
            if (!tableToAddTare.contains("TARE")) {
                alterTareArtItem.addDecimalColumn("TARE", 16, 8, null, true);
                alterTareArtItem.alterColumn("POIDS_COLIS_NET", EnumSet.allOf(SQLField.Properties.class), "numeric(16,8)", "0", true);
                alterTareArtItem.alterColumn("T_POIDS_COLIS_NET", EnumSet.allOf(SQLField.Properties.class), "numeric(16,8)", "0", true);
                alterTareArtItem.addDecimalColumn("T_POIDS_BRUT", 16, 8, BigDecimal.ZERO, true);
                upTareArtItem = true;
            }
            if (!upTareArtItem) continue;
            tableToAddTare.getBase().getDataSource().execute(alterTareArtItem.asString());
            tableToAddTare.getSchema().updateVersion();
            tableToAddTare.fetchFields();
            int id = tableToAddTare.getUndefinedID();
            if (id == -1) continue;
            UpdateBuilder build = new UpdateBuilder(tableToAddTare);
            build.setObject("POIDS_COLIS_NET", (Object)BigDecimal.ZERO);
            build.setWhere(new Where((FieldRef)tableToAddTare.getKey(), "=", id));
            tableToAddTare.getDBSystemRoot().getDataSource().execute(build.asString());
        }
        if (tableMvtStock.getField("NOM").getType().getSize() == 45) {
            AlterTable alterMvt = new AlterTable(tableMvtStock);
            alterMvt.alterColumn("NOM", EnumSet.allOf(SQLField.Properties.class), "varchar(512)", "''", false);
            tableMvtStock.getDBSystemRoot().getDataSource().execute(alterMvt.asString());
            tableMvtStock.getSchema().updateVersion();
        }
        SQLTable tableEtatStock = root.getTable("ETAT_STOCK");
        SQLTable tableDepotStock = root.getTable("DEPOT_STOCK");
        if (!tableEtatStock.contains("ID_DEPOT_STOCK")) {
            AlterTable alter24 = new AlterTable(tableEtatStock);
            alter24.addForeignColumn("ID_DEPOT_STOCK", tableDepotStock);
            tableEtatStock.getBase().getDataSource().execute(alter24.asString());
            tableEtatStock.getSchema().updateVersion();
            tableEtatStock.fetchFields();
        }
        if (!root.contains("AGENCE")) {
            SQLCreateTable createAgence = new SQLCreateTable(root, "AGENCE");
            createAgence.addVarCharColumn("DESIGNATION", 256);
            createAgence.addVarCharColumn("TEL_1", 256);
            createAgence.addVarCharColumn("EMAIL", 256);
            createAgence.addVarCharColumn("FAX", 256);
            createAgence.addForeignColumn("ID_CLIENT", root.findTable("CLIENT"));
            createAgence.addForeignColumn("ID_ADRESSE", root.findTable("ADRESSE"));
            try {
                root.getBase().getDataSource().execute(createAgence.asString());
                root.refetchTable("AGENCE");
                SQLRowValues rowVals3 = new SQLRowValues(root.getTable("AGENCE"));
                SQLRow rowInserted = rowVals3.commit();
                SQLTable.setUndefID(root.getSchema(), "AGENCE", rowInserted.getID());
                tableDevis.getSchema().updateVersion();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table AGENCE", ex);
            }
        }
        if (root.getTable("TARIF_FAMILLE_ARTICLE_CLIENT") == null) {
            SQLCreateTable createTableQtyTarif = new SQLCreateTable(root, "TARIF_FAMILLE_ARTICLE_CLIENT");
            createTableQtyTarif.addForeignColumn("ID_FAMILLE_ARTICLE", root.getTable("FAMILLE_ARTICLE"));
            createTableQtyTarif.addForeignColumn("ID_CLIENT", root.getTable("CLIENT"));
            createTableQtyTarif.addDecimalColumn("QUANTITE", 16, 3, BigDecimal.ONE, false);
            createTableQtyTarif.addDecimalColumn("POURCENT_REMISE", 16, 3, null, true);
            try {
                root.getBase().getDataSource().execute(createTableQtyTarif.asString());
                InstallationPanel.insertUndef(createTableQtyTarif);
                root.refetchTable("TARIF_FAMILLE_ARTICLE_CLIENT");
                root.getSchema().updateVersion();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table TARIF_FAMILLE_ARTICLE_CLIENT", ex);
            }
        }
        if (root.getTable("TARIF_FAMILLE_ARTICLE_CLIENT") == null) {
            SQLCreateTable createTableQtyTarif = new SQLCreateTable(root, "TARIF_FAMILLE_ARTICLE_CLIENT");
            createTableQtyTarif.addForeignColumn("ID_FAMILLE_ARTICLE", root.getTable("FAMILLE_ARTICLE"));
            createTableQtyTarif.addForeignColumn("ID_CLIENT", root.getTable("CLIENT"));
            createTableQtyTarif.addDecimalColumn("QUANTITE", 16, 3, BigDecimal.ONE, false);
            createTableQtyTarif.addDecimalColumn("POURCENT_REMISE", 16, 3, null, true);
            try {
                root.getBase().getDataSource().execute(createTableQtyTarif.asString());
                InstallationPanel.insertUndef(createTableQtyTarif);
                root.refetchTable("TARIF_FAMILLE_ARTICLE_CLIENT");
                root.getSchema().updateVersion();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table TARIF_FAMILLE_ARTICLE_CLIENT", ex);
            }
        }
        if (!(tableAvoirC = root.getTable("AVOIR_CLIENT")).contains("ID_TAXE_PORT")) {
            AlterTable alterB13 = new AlterTable(tableAvoirC);
            alterB13.addForeignColumn("ID_TAXE_PORT", root.getTable("TAXE"));
            root.getBase().getDataSource().execute(alterB13.asString());
            root.refetchTable(tableAvoirC.getName());
            root.getSchema().updateVersion();
        }
        if (!(tableVF = root.getTable("SAISIE_VENTE_FACTURE")).contains("ID_FACTURATION_COMMANDE_CLIENT")) {
            AlterTable alter25 = new AlterTable(tableVF);
            SQLTable tableFacturationCommandeClient = tableVF.getDBRoot().getTable("FACTURATION_COMMANDE_CLIENT");
            alter25.addForeignColumn("ID_FACTURATION_COMMANDE_CLIENT", tableFacturationCommandeClient);
            tableVF.getBase().getDataSource().execute(alter25.asString());
            tableVF.getSchema().updateVersion();
            tableVF.fetchFields();
            UpdateBuilder builder = new UpdateBuilder(tableVF);
            AliasedTable ref = new AliasedTable(tableFacturationCommandeClient, "tf");
            builder.addBackwardVirtualJoin(ref, "ID_SAISIE_VENTE_FACTURE");
            builder.setFromVirtualJoinField("ID_FACTURATION_COMMANDE_CLIENT", "tf", tableFacturationCommandeClient.getKey().getName());
            tableVF.getBase().getDataSource().execute(builder.asString());
        }
        if (!root.getTable("NUMEROTATION_AUTO").contains("CODE_LETTRAGE_PARTIEL")) {
            AlterTable alterNumero = new AlterTable(root.getTable("NUMEROTATION_AUTO"));
            alterNumero.addVarCharColumn("CODE_LETTRAGE_PARTIEL", 256);
            root.getBase().getDataSource().execute(alterNumero.asString());
            root.refetchTable("NUMEROTATION_AUTO");
            root.getSchema().updateVersion();
        }
        if (!root.getTable("ECRITURE").contains("LETTRAGE_PARTIEL")) {
            AlterTable alterEcriture = new AlterTable(root.getTable("ECRITURE"));
            alterEcriture.addVarCharColumn("LETTRAGE_PARTIEL", 256);
            root.getBase().getDataSource().execute(alterEcriture.asString());
            root.refetchTable("ECRITURE");
            root.getSchema().updateVersion();
        }
        if (!(tableFactureF = root.getTable("FACTURE_FOURNISSEUR")).contains("ID_AVOIR_FOURNISSEUR_2")) {
            AlterTable alter26 = new AlterTable(tableFactureF);
            SQLTable tableAvoirF = tableVF.getDBRoot().getTable("AVOIR_FOURNISSEUR");
            alter26.addForeignColumn("ID_AVOIR_FOURNISSEUR_2", tableAvoirF);
            tableFactureF.getBase().getDataSource().execute(alter26.asString());
            tableFactureF.getSchema().updateVersion();
            tableVF.fetchFields();
        }
        if (!(tableNumAuto = root.getTable("NUMEROTATION_AUTO")).contains("ARTICLE_FORMAT")) {
            AlterTable alterNumero = new AlterTable(tableNumAuto);
            alterNumero.addVarCharColumn("ARTICLE_FORMAT", 128);
            alterNumero.addIntegerColumn("ARTICLE_START", 1);
            root.getBase().getDataSource().execute(alterNumero.asString());
            root.refetchTable("NUMEROTATION_AUTO");
            root.getSchema().updateVersion();
        }
        if (!tableArticle.contains("VIRTUEL")) {
            SQLCreateTable createTableDeclinaisonCouleur = new SQLCreateTable(root, "ARTICLE_DECLINAISON_COULEUR");
            createTableDeclinaisonCouleur.addVarCharColumn("NOM", 256);
            root.getBase().getDataSource().execute(createTableDeclinaisonCouleur.asString());
            InstallationPanel.insertUndef(createTableDeclinaisonCouleur);
            root.refetchTable("ARTICLE_DECLINAISON_COULEUR");
            root.getSchema().updateVersion();
            SQLCreateTable createTableDeclinaisonTaille = new SQLCreateTable(root, "ARTICLE_DECLINAISON_TAILLE");
            createTableDeclinaisonTaille.addVarCharColumn("NOM", 256);
            root.getBase().getDataSource().execute(createTableDeclinaisonTaille.asString());
            InstallationPanel.insertUndef(createTableDeclinaisonTaille);
            root.refetchTable("ARTICLE_DECLINAISON_TAILLE");
            root.getSchema().updateVersion();
            AlterTable alter27 = new AlterTable(tableArticle);
            alter27.addBooleanColumn("VIRTUEL", false, false);
            alter27.addForeignColumn("ID_ARTICLE_VIRTUEL_PERE", tableArticle);
            alter27.addForeignColumn("ID_ARTICLE_DECLINAISON_TAILLE", root.getTable("ARTICLE_DECLINAISON_TAILLE"));
            alter27.addForeignColumn("ID_ARTICLE_DECLINAISON_COULEUR", root.getTable("ARTICLE_DECLINAISON_COULEUR"));
            tableArticle.getBase().getDataSource().execute(alter27.asString());
            tableArticle.getSchema().updateVersion();
            tableArticle.fetchFields();
        }
        for (String string3 : achatItems) {
            boolean alter28 = false;
            SQLTable tableItems = root.getTable(string3);
            AlterTable t21 = new AlterTable(tableItems);
            if (!tableItems.getFieldsName().contains("ID_ARTICLE_DECLINAISON_TAILLE")) {
                t21.addForeignColumn("ID_ARTICLE_DECLINAISON_TAILLE", root.getTable("ARTICLE_DECLINAISON_TAILLE"));
                alter28 = true;
            }
            if (!tableItems.getFieldsName().contains("ID_ARTICLE_DECLINAISON_COULEUR")) {
                t21.addForeignColumn("ID_ARTICLE_DECLINAISON_COULEUR", root.getTable("ARTICLE_DECLINAISON_COULEUR"));
                alter28 = true;
            }
            if (!alter28) continue;
            tableItems.getBase().getDataSource().execute(t21.asString());
            tableItems.getSchema().updateVersion();
            tableItems.fetchFields();
        }
        for (String tableName : tableElementWithTable) {
            SQLTable tableToDecl = root.getTable(tableName);
            boolean alter29 = false;
            AlterTable alterDecl = new AlterTable(tableToDecl);
            if (!tableToDecl.getFieldsName().contains("ID_ARTICLE_DECLINAISON_TAILLE")) {
                alterDecl.addForeignColumn("ID_ARTICLE_DECLINAISON_TAILLE", root.getTable("ARTICLE_DECLINAISON_TAILLE"));
                alter29 = true;
            }
            if (!tableToDecl.getFieldsName().contains("ID_ARTICLE_DECLINAISON_COULEUR")) {
                alterDecl.addForeignColumn("ID_ARTICLE_DECLINAISON_COULEUR", root.getTable("ARTICLE_DECLINAISON_COULEUR"));
                alter29 = true;
            }
            if (!alter29) continue;
            tableToDecl.getBase().getDataSource().execute(alterDecl.asString());
            tableToDecl.getSchema().updateVersion();
            tableToDecl.fetchFields();
        }
        if (!root.contains("TARIF_PROMOTION")) {
            createTarif = new SQLCreateTable(root, "TARIF_PROMOTION");
            createTarif.addVarCharColumn("NOM", 256);
            createTarif.addColumn("START", "date");
            createTarif.addColumn("END", "date");
            root.getBase().getDataSource().execute(createTarif.asString());
            InstallationPanel.insertUndef(createTarif);
            tableDevis.getSchema().updateVersion();
            root.refetchTable(createTarif.getName());
        }
        if (!root.contains("ARTICLE_TARIF_PROMOTION")) {
            createTarif = new SQLCreateTable(root, "ARTICLE_TARIF_PROMOTION");
            createTarif.addForeignColumn("ID_DEVISE", root.findTable("DEVISE", true));
            createTarif.addForeignColumn("ID_TAXE", root.findTable("TAXE", true));
            createTarif.addForeignColumn("ID_TARIF_PROMOTION", root.findTable("TARIF_PROMOTION", true));
            createTarif.addForeignColumn("ID_ARTICLE", root.findTable("ARTICLE", true));
            createTarif.addIntegerColumn("QTE", 1);
            createTarif.addDecimalColumn("PV_HT", 16, 6, BigDecimal.ZERO, false);
            createTarif.addDecimalColumn("PV_TTC", 16, 6, BigDecimal.ZERO, false);
            createTarif.addDecimalColumn("PRIX_METRIQUE_VT_1", 16, 6, BigDecimal.ZERO, false);
            createTarif.addDecimalColumn("PRIX_METRIQUE_VT_2", 16, 6, BigDecimal.ZERO, false);
            createTarif.addDecimalColumn("PRIX_METRIQUE_VT_3", 16, 6, BigDecimal.ZERO, false);
            root.getBase().getDataSource().execute(createTarif.asString());
            InstallationPanel.insertUndef(createTarif);
            tableDevis.getSchema().updateVersion();
            root.refetchTable(createTarif.getName());
        }
        if (!root.contains("NUMERO_SERIE")) {
            SQLCreateTable createNumeroSerie = new SQLCreateTable(root, "NUMERO_SERIE");
            createNumeroSerie.addForeignColumn("ID_STOCK", root.findTable("STOCK", true));
            createNumeroSerie.addForeignColumn("ID_BON_RECEPTION_ELEMENT", root.findTable("BON_RECEPTION_ELEMENT", true));
            createNumeroSerie.addForeignColumn("ID_BON_DE_LIVRAISON_ELEMENT", root.findTable("BON_DE_LIVRAISON_ELEMENT", true));
            createNumeroSerie.addVarCharColumn("NUMERO", 256);
            root.getBase().getDataSource().execute(createNumeroSerie.asString());
            InstallationPanel.insertUndef(createNumeroSerie);
            SQLCreateTable createLot = new SQLCreateTable(root, "LOT");
            createLot.addForeignColumn("ID_STOCK", root.findTable("STOCK", true));
            createLot.addForeignColumn("ID_BON_RECEPTION_ELEMENT", root.findTable("BON_RECEPTION_ELEMENT", true));
            createLot.addDecimalColumn("QUANTITE", 16, 6, BigDecimal.ONE, false);
            root.getBase().getDataSource().execute(createLot.asString());
            InstallationPanel.insertUndef(createLot);
            SQLCreateTable createTransfertStock = new SQLCreateTable(root, "TRANSFERT_STOCK");
            createTransfertStock.addDateAndTimeColumn("DATE");
            createTransfertStock.addForeignColumn("ID_ARTICLE", root.findTable("ARTICLE", true));
            createTransfertStock.addForeignColumn("ID_DEPOT_STOCK_SOURCE", root.findTable("DEPOT_STOCK", true));
            createTransfertStock.addForeignColumn("ID_DEPOT_STOCK_DEST", root.findTable("DEPOT_STOCK", true));
            createTransfertStock.addDecimalColumn("QUANTITE", 16, 6, BigDecimal.ONE, false);
            createTransfertStock.addVarCharColumn("NUMEROS_SERIE", 50000);
            createTransfertStock.addVarCharColumn("NUMEROS_LOT", 50000);
            createTransfertStock.addVarCharColumn("CONTEXTE", 256);
            root.getBase().getDataSource().execute(createTransfertStock.asString());
            InstallationPanel.insertUndef(createTransfertStock);
            AlterTable alterArticle4 = new AlterTable(tableArticle);
            alterArticle4.addBooleanColumn("NUMERO_LOT_REQUIS", false, false);
            alterArticle4.addBooleanColumn("NUMERO_SERIE_REQUIS", false, false);
            alterArticle4.addBooleanColumn("DLC_REQUIS", false, false);
            alterArticle4.addBooleanColumn("DLUO_REQUIS", false, false);
            tableArticle.getBase().getDataSource().execute(alterArticle4.asString());
            tableArticle.getSchema().updateVersion();
            tableArticle.fetchFields();
            AlterTable alterBonReceptionElement = new AlterTable(root.getTable("BON_RECEPTION_ELEMENT"));
            alterBonReceptionElement.addVarCharColumn("NUMERO_LOT", 256);
            alterBonReceptionElement.addDateAndTimeColumn("DLC");
            alterBonReceptionElement.addDateAndTimeColumn("DLUO");
            tableArticle.getBase().getDataSource().execute(alterBonReceptionElement.asString());
            tableArticle.getSchema().updateVersion();
            root.refetch();
        }
        SQLTable tableBR = root.getTable("BON_RECEPTION");
        SQLTable tableModele = root.getTable("MODELE");
        if (!tableBR.contains("ID_MODELE")) {
            AlterTable a = new AlterTable(tableBR);
            a.addForeignColumn("ID_MODELE", tableModele);
            root.getBase().getDataSource().execute(a.asString());
            tableBR.getSchema().updateVersion();
            root.refetchTable(tableBR.getName());
        }
        SQLTable typeModele = tableModele.getForeignTable("ID_TYPE_MODELE");
        SQLSelect sel2 = new SQLSelect();
        sel2.addSelect(typeModele.getKey());
        sel2.setWhere(new Where((FieldRef)typeModele.getField("TABLE"), "=", (Object)"BON_RECEPTION"));
        List<SQLRow> l = SQLRowListRSH.execute(sel2);
        if (l.isEmpty()) {
            SQLRowValues rowVals4 = new SQLRowValues(typeModele);
            rowVals4.put("TABLE", "BON_RECEPTION");
            rowVals4.put("NOM", "Bon de r\u00e9ception");
            rowVals4.put("DEFAULT_MODELE", "BonReception");
            rowVals4.commit();
        }
        new SetFKDefault(root.getDBSystemRoot()).changeAll(root);
        ArrayList<SQLUpdate> ups = new ArrayList<SQLUpdate>();
        if (userT.getUndefinedIDNumber() != null) {
            for (SQLField userF : root.getDBSystemRoot().getGraph().getReferentKeys(userT)) {
                if (userF.getTable().getDBRoot() != root) continue;
                SQLUpdate up = new SQLUpdate(Where.isNull(userF));
                up.add(userF, userT.getUndefinedIDNumber());
                ups.add(up);
            }
        }
        if (!ups.isEmpty()) {
            SQLUpdate.executeMultipleWithBatch(root.getDBSystemRoot(), ups);
            System.err.println("Updater_1_5.update() fixed " + ups.size() + " error(s) on FK to USER_COMMON");
        } else {
            System.err.println("Updater_1_5.update() no error on FK to USER_COMMON");
        }
    }

    public static void initStock(SQLRow rowArticle, int idDepot) {
        SQLSelect selStock = new SQLSelect();
        selStock.addSelectStar(rowArticle.getTable().getTable("STOCK"));
        selStock.setWhere(new Where((FieldRef)rowArticle.getTable().getTable("STOCK").getField("ID_ARTICLE"), "=", rowArticle.getID()));
        List<SQLRow> rowsStock = SQLRowListRSH.execute(selStock);
        HashMap<Integer, SQLRow> initedDepot = new HashMap<Integer, SQLRow>();
        for (SQLRow sqlRow : rowsStock) {
            initedDepot.put(sqlRow.getForeignID("ID_DEPOT_STOCK"), sqlRow);
        }
        ArrayList<StockItem> stockItems = new ArrayList<StockItem>();
        try {
            if (!initedDepot.keySet().contains(idDepot)) {
                SQLRowValues rowVals = new SQLRowValues(rowArticle.getTable().getTable("STOCK"));
                rowVals.put("ID_ARTICLE", rowArticle.getID());
                rowVals.put("ID_DEPOT_STOCK", idDepot);
                SQLRow rowStock = rowVals.commit();
                if ((rowArticle.getObject("ID_DEPOT_STOCK") == null || rowArticle.isForeignEmpty("ID_DEPOT_STOCK")) && idDepot == DepotStockSQLElement.DEFAULT_ID) {
                    rowArticle.createEmptyUpdateRow().put("ID_STOCK", rowStock.getID()).put("ID_DEPOT_STOCK", DepotStockSQLElement.DEFAULT_ID).commit();
                } else if (idDepot == rowArticle.getForeignID("ID_DEPOT_STOCK")) {
                    rowArticle.createEmptyUpdateRow().put("ID_STOCK", rowStock.getID()).commit();
                }
                stockItems.add(new StockItem(rowArticle, rowStock));
            } else {
                SQLRow rowExisting = (SQLRow)initedDepot.get(idDepot);
                if ((rowArticle.getObject("ID_DEPOT_STOCK") == null || rowArticle.isForeignEmpty("ID_DEPOT_STOCK")) && idDepot == DepotStockSQLElement.DEFAULT_ID) {
                    rowArticle.createEmptyUpdateRow().put("ID_STOCK", rowExisting.getID()).put("ID_DEPOT_STOCK", DepotStockSQLElement.DEFAULT_ID).commit();
                } else if (idDepot == rowArticle.getForeignID("ID_DEPOT_STOCK")) {
                    rowArticle.createEmptyUpdateRow().put("ID_STOCK", rowExisting.getID()).commit();
                }
                stockItems.add(new StockItem(rowArticle, rowExisting));
            }
        }
        catch (SQLException e) {
            ExceptionHandler.handle("Erreur lors de l'initialisation du stock de l'article", e);
        }
        if (rowArticle.getReferentRows(rowArticle.getTable().getTable("ARTICLE_ELEMENT").getField("ID_ARTICLE_PARENT")).size() > 0) {
            ComposedItemStockUpdater up = new ComposedItemStockUpdater(rowArticle.getTable().getDBRoot(), stockItems);
            try {
                up.updateNomenclature(stockItems);
            }
            catch (SQLException e) {
                ExceptionHandler.handle("Erreur lors de l'actualisation du stock!", e);
            }
        }
    }

    public static void initStock(SQLRow row) {
        int foreignID = DepotStockSQLElement.DEFAULT_ID;
        if (row.getObject("ID_DEPOT_STOCK") != null && !row.isForeignEmpty("ID_DEPOT_STOCK")) {
            foreignID = row.getForeignID("ID_DEPOT_STOCK");
        }
        Updater_1_5.initStock(row, foreignID);
    }

    public static void exec(AlterTable alter) throws SQLException {
        alter.getTable().getDBSystemRoot().getDataSource().execute(alter.asString());
        alter.getTable().getSchema().updateVersion();
        alter.getTable().fetchFields();
    }
}

