/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;

public class HTTPClient {
    private static final int MIN_GZIP_SIZE = 64;
    private final String url;
    private SSLSocketFactory socketFactory;
    private String token;
    private boolean throwException = true;

    public HTTPClient(String url) {
        this.url = url;
    }

    public final SSLSocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public final void setSocketFactory(SSLSocketFactory socketFactory) {
        this.socketFactory = socketFactory;
    }

    public final void setToken(String token) {
        this.token = token;
    }

    public final boolean hasToken() {
        return this.getToken() != null;
    }

    public final String getToken() {
        return this.token;
    }

    public final void setThrowException(boolean throwException) {
        this.throwException = throwException;
    }

    public final boolean throwsException() {
        return this.throwException;
    }

    public final Response checkResponseCode(HttpsURLConnection con) throws IOException {
        return this.checkResponseCode(con, null);
    }

    public final Response checkResponseCode(HttpsURLConnection con, Set<Integer> okCodes) throws IOException {
        Response res = Response.create(con, okCodes);
        if (this.throwsException() && !res.isSuccess()) {
            throw new ServerException(res.getCode(), con.getHeaderField("WWW-Authenticate") != null);
        }
        return res;
    }

    public final HttpsURLConnection openConnection(String path) throws IOException {
        HttpsURLConnection con = (HttpsURLConnection)new URL(String.valueOf(this.url) + path).openConnection();
        con.setRequestProperty("Accept-Encoding", "gzip");
        if (this.getSocketFactory() != null) {
            con.setSSLSocketFactory(this.getSocketFactory());
        }
        if (this.getToken() != null) {
            con.setRequestProperty("Authorization", "Bearer " + Base64.getEncoder().encodeToString(this.getToken().getBytes(StandardCharsets.UTF_8)));
        }
        return con;
    }

    public final InputStream getInputStream(HttpsURLConnection con) throws IOException {
        return "gzip".equals(con.getContentEncoding()) ? new GZIPInputStream(con.getInputStream()) : con.getInputStream();
    }

    public final HttpsURLConnection send(HttpsURLConnection con, String formUrlEncodedParams) throws IOException {
        return this.send(con, formUrlEncodedParams, true);
    }

    public final HttpsURLConnection send(HttpsURLConnection con, String formUrlEncodedParams, boolean allowGzip) throws IOException {
        con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        return this.send(con, formUrlEncodedParams.getBytes(StandardCharsets.UTF_8), allowGzip);
    }

    public final HttpsURLConnection send(HttpsURLConnection con, byte[] toSend, boolean allowGzip) throws IOException {
        boolean useGzip;
        boolean bl = useGzip = allowGzip && toSend.length >= 64;
        if (useGzip) {
            con.setRequestProperty("Content-Encoding", "gzip");
        }
        con.setRequestMethod("POST");
        con.setDoOutput(true);
        Throwable throwable = null;
        Object var6_7 = null;
        try (OutputStream o = useGzip ? new GZIPOutputStream(con.getOutputStream()) : con.getOutputStream();){
            o.write(toSend);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return con;
    }

    public static final class Response {
        private final boolean success;
        private final int code;
        private final String message;
        private final String contentEncoding;
        private final String contentType;

        protected static final Response create(HttpsURLConnection con, Set<Integer> okCodes) throws IOException {
            boolean success = okCodes == null ? con.getResponseCode() == 200 : okCodes.contains(con.getResponseCode());
            return new Response(success, con.getResponseCode(), con.getResponseMessage(), con.getContentEncoding(), con.getContentType());
        }

        protected Response(boolean success, int code, String message, String contentEncoding, String contentType) {
            this.success = success;
            this.code = code;
            this.message = message;
            this.contentEncoding = contentEncoding;
            this.contentType = contentType;
        }

        public final int getCode() {
            return this.code;
        }

        public final boolean isSuccess() {
            return this.success;
        }

        public final String getMessage() {
            return this.message;
        }

        public final String getContentEncoding() {
            return this.contentEncoding;
        }

        public final String getContentType() {
            return this.contentType;
        }
    }

    public static class ServerException
    extends RuntimeException {
        private final int responseCode;
        private final boolean authenticateError;

        protected ServerException(int responseCode, boolean authenticateError) {
            super("Response code was " + responseCode);
            this.responseCode = responseCode;
            this.authenticateError = authenticateError;
        }

        public final int getResponseCode() {
            return this.responseCode;
        }

        public final boolean isAuthenticateError() {
            return this.authenticateError;
        }
    }
}

