/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.sql.Connection;
import java.sql.SQLException;
import org.openconcerto.sql.model.SQLDataSource;

public abstract class ConnectionHandler<T, X extends Exception> {
    private Exception exn = null;
    private T res = null;

    public final boolean hasException() {
        return this.exn != null;
    }

    protected final T get() throws X, SQLException {
        if (this.exn != null) {
            if (this.exn instanceof RuntimeException) {
                throw (RuntimeException)this.exn;
            }
            if (this.exn instanceof SQLException) {
                throw (SQLException)this.exn;
            }
            throw this.exn;
        }
        return this.res;
    }

    final T compute(SQLDataSource ds) throws X, SQLException {
        try {
            this.res = this.handle(ds);
            this.exn = null;
        }
        catch (Exception e) {
            this.exn = e;
        }
        return this.get();
    }

    public abstract void setup(Connection var1) throws SQLException;

    public abstract T handle(SQLDataSource var1) throws SQLException, X;

    public abstract boolean canRestoreState();

    public abstract void restoreState(Connection var1) throws SQLException;
}

