/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.element;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openconcerto.sql.element.BaseSQLElementRow;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.SQLElementLink;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValuesCluster;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.utils.ListMap;
import org.openconcerto.utils.Tuple2;

class SQLElementRowR
extends BaseSQLElementRow {
    private static final Tuple2<List<Integer>, List<SQLRow>> findInterTreeLinks(SQLRow r, Map<SQLRow, SQLRow> copies, SQLElementLink ff, boolean returnCopies) {
        assert (copies.containsKey(r)) : "Wrong map";
        ArrayList<Integer> foreignIndexes = new ArrayList<Integer>();
        ArrayList<SQLRow> foreignRows = new ArrayList<SQLRow>();
        int i = 0;
        for (SQLRow foreignRow : r.getDistantRows(ff.getPath())) {
            SQLRow mapped = copies.get(foreignRow);
            if (mapped != null) {
                foreignIndexes.add(i);
                foreignRows.add(returnCopies ? mapped : foreignRow);
            }
            ++i;
        }
        return Tuple2.create(foreignIndexes, foreignRows);
    }

    public SQLElementRowR(SQLRow row) {
        super(row);
    }

    public SQLElementRowR(SQLElement element, SQLRow row) {
        super(element, row);
    }

    @Override
    public boolean equals(Object obj) {
        return this.equals(obj, SQLElement.EqualOption.ALL);
    }

    public boolean equals(Object obj, SQLElement.EqualOption option) {
        if (obj instanceof SQLElementRowR) {
            SQLElement.EqualOption noLinkOption;
            SQLElement.EqualOption firstOption;
            SQLElementRowR o = (SQLElementRowR)obj;
            if (this.getRow().equals(o.getRow())) {
                return true;
            }
            if (option.isParentTested() || option.isNonSharedTested()) {
                SQLElement.EqualOptionBuilder builder = option.createBuilder().setNonSharedTested(false);
                firstOption = builder.build();
                noLinkOption = builder.setParentTested(false).build();
            } else {
                firstOption = noLinkOption = option;
            }
            HashMap<SQLRow, SQLRow> copies = new HashMap<SQLRow, SQLRow>();
            HashMap<SQLRow, SQLRow> fromOtherCopies = new HashMap<SQLRow, SQLRow>();
            if (!this.equalsRec(o, copies, fromOtherCopies, firstOption, noLinkOption)) {
                return false;
            }
            for (SQLRow thisRow : copies.keySet()) {
                for (SQLElementLink ff : this.getElement(thisRow).getOwnedLinks().getByType(SQLElementLink.LinkType.ASSOCIATION)) {
                    if (!option.isNonSharedTested() && !ff.getOwned().isShared()) continue;
                    Tuple2<List<Integer>, List<SQLRow>> interTreeLinks = SQLElementRowR.findInterTreeLinks(thisRow, copies, ff, true);
                    List<Integer> foreignIndexes = interTreeLinks.get0();
                    List<SQLRow> foreignRowsCopies = interTreeLinks.get1();
                    Tuple2<List<Integer>, List<SQLRow>> otherInterTreeLinks = SQLElementRowR.findInterTreeLinks((SQLRow)copies.get(thisRow), fromOtherCopies, ff, false);
                    List<Integer> otherForeignIndexes = otherInterTreeLinks.get0();
                    List<SQLRow> otherForeignRows = otherInterTreeLinks.get1();
                    if (foreignIndexes.equals(otherForeignIndexes) && foreignRowsCopies.equals(otherForeignRows)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private boolean equalsRec(SQLElementRowR o, Map<SQLRow, SQLRow> fromThis, Map<SQLRow, SQLRow> fromOther, SQLElement.EqualOption option, SQLElement.EqualOption nextOption) {
        Tuple2<Boolean, SQLRowValuesCluster.DiffResult> diff = this.getElem().diff(this.getRow(), o.getRow(), option);
        if (!diff.get0().booleanValue()) {
            return false;
        }
        ListMap<SQLTable, SQLRow> children1 = this.getElem().getChildrenRows(this.getRow());
        ListMap<SQLTable, SQLRow> children2 = this.getElem().getChildrenRows(o.getRow());
        if (!children1.keySet().equals(children2.keySet())) {
            return false;
        }
        for (SQLTable childT : children1.keySet()) {
            List l1 = (List)children1.get(childT);
            List l2 = (List)children2.get(childT);
            if (l1.size() != l2.size()) {
                return false;
            }
            Iterator lIter1 = l1.iterator();
            Iterator lIter2 = l2.iterator();
            while (lIter1.hasNext()) {
                SQLRow r2;
                SQLElementRowR o2;
                SQLRow r1 = (SQLRow)lIter1.next();
                SQLElementRowR o1 = new SQLElementRowR(r1);
                if (o1.equalsRec(o2 = new SQLElementRowR(r2 = (SQLRow)lIter2.next()), fromThis, fromOther, nextOption, nextOption)) continue;
                return false;
            }
        }
        SQLRowValuesCluster.DiffResult diffRes = diff.get1();
        diffRes.fillRowMap(fromThis, true);
        diffRes.fillRowMap(fromOther, false);
        return true;
    }
}

