/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc.provider;

import java.math.BigDecimal;
import org.openconcerto.erp.core.common.ui.NumericFormat;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueContext;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProvider;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProviderManager;
import org.openconcerto.sql.model.SQLRowAccessor;

public class MergedGlobalQtyTotalProvider
implements SpreadSheetCellValueProvider {
    private final boolean shortName;
    private final boolean pieceName;

    public MergedGlobalQtyTotalProvider(boolean shortName, boolean pieceName) {
        this.shortName = shortName;
        this.pieceName = pieceName;
    }

    @Override
    public Object getValue(SpreadSheetCellValueContext context) {
        SQLRowAccessor row = context.getRow();
        BigDecimal pv = row.getBigDecimal("PV_HT");
        if (pv != null && pv.compareTo(BigDecimal.ZERO) == 0) {
            return null;
        }
        int qte = row.getInt("QTE");
        if (!this.pieceName && row.getInt("ID_UNITE_VENTE") == 2) {
            return String.valueOf(qte);
        }
        BigDecimal qteUV = row.getBigDecimal("QTE_UNITAIRE");
        BigDecimal mergedQty = qteUV.multiply(new BigDecimal(qte));
        String result = NumericFormat.getQtyDecimalFormat().format(mergedQty);
        SQLRowAccessor rMode = row.getForeign("ID_UNITE_VENTE");
        result = String.valueOf(result) + " " + (this.shortName ? rMode.getString("CODE") : rMode.getString("NOM"));
        return result;
    }

    public static void register() {
        SpreadSheetCellValueProviderManager.put("supplychain.element.qtyunit.merged", new MergedGlobalQtyTotalProvider(false, false));
        SpreadSheetCellValueProviderManager.put("supplychain.element.qtyunit.merged.short", new MergedGlobalQtyTotalProvider(true, false));
        SpreadSheetCellValueProviderManager.put("supplychain.element.qtyunit.alwaysnamed.merged", new MergedGlobalQtyTotalProvider(false, true));
        SpreadSheetCellValueProviderManager.put("supplychain.element.qtyunit.alwaysnamed.merged.short", new MergedGlobalQtyTotalProvider(true, true));
    }
}

