/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.sales.pos.TicketSheetXML;
import org.openconcerto.erp.core.sales.pos.model.Ticket;
import org.openconcerto.erp.core.sales.pos.ui.CaisseFrame;
import org.openconcerto.erp.core.sales.pos.ui.POSButton;
import org.openconcerto.erp.core.sales.pos.ui.POSLabel;
import org.openconcerto.utils.ExceptionHandler;

public class TicketClientNamePanel
extends JPanel {
    public TicketClientNamePanel(final CaisseFrame caisseFrame, final Ticket ticket) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 18;
        c.fill = 1;
        POSLabel label = new POSLabel("Nom du client");
        this.add((Component)label, c);
        ++c.gridy;
        final JTextField text = new JTextField(30);
        text.setFont(label.getFont());
        text.setText(ticket.getClient().getFullName());
        this.add((Component)text, c);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                text.requestFocus();
            }
        });
        POSButton b = new POSButton("Imprimer");
        c.fill = 0;
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ticket.getClient().setFullName(text.getText());
                TicketClientNamePanel.this.printInvoice(ticket);
                caisseFrame.showCaisse();
            }
        });
        ++c.gridy;
        this.add((Component)b, c);
    }

    private void printInvoice(Ticket ticket) {
        TicketSheetXML bSheet = new TicketSheetXML(ticket, ComptaPropsConfiguration.getInstanceCompta());
        try {
            bSheet.createDocument();
            bSheet.showPrintAndExport(true, false, false, true, false, Collections.emptyList());
        }
        catch (Exception originalExn) {
            ExceptionHandler.handle("Erreur lors de la cr\u00e9ation de la facture", originalExn);
        }
    }
}

