/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.ui;

import java.io.IOException;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintServiceAttributeSet;
import javax.print.attribute.standard.PrinterName;
import org.openconcerto.erp.core.sales.pos.ui.POSDisplay;

public class PrinterPOSDisplay
extends POSDisplay {
    private String printerName;

    public PrinterPOSDisplay(String lcdPort) {
        this.printerName = lcdPort;
    }

    @Override
    public void setMessage(String line1, String line2) throws Exception, IOException {
        if (line1 == null) {
            line1 = "";
        }
        if (line2 == null) {
            line2 = "";
        }
        this.sendBytes(new byte[]{12});
        this.sendBytes((String.valueOf(line1) + "\r\n" + line2 + "\r\n").getBytes());
    }

    private synchronized void sendBytes(byte[] b) throws PrintException {
        if (this.printerName == null || this.printerName.isEmpty()) {
            return;
        }
        HashPrintServiceAttributeSet attrSet = new HashPrintServiceAttributeSet(new PrinterName(this.printerName, null));
        PrintService[] lookupPrintServices = PrintServiceLookup.lookupPrintServices(null, attrSet);
        if (lookupPrintServices.length <= 0) {
            throw new PrintException("Printer " + this.printerName + " not found");
        }
        DocPrintJob job = lookupPrintServices[0].createPrintJob();
        DocFlavor.BYTE_ARRAY flavor = DocFlavor.BYTE_ARRAY.AUTOSENSE;
        SimpleDoc doc = new SimpleDoc(b, flavor, null);
        job.print(doc, null);
    }

    public static void main(String[] args) throws IOException, Exception {
        PrinterPOSDisplay p = new PrinterPOSDisplay("EPSON DM-D Display");
        p.setMessage("OpenConcerto", "Caisse ouverte");
    }
}

