/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;

public class QuickOrderedMap<K, V> {
    private final ArrayList<Object> keysAndValues;

    public QuickOrderedMap() {
        this(10);
    }

    public QuickOrderedMap(int initialCapacity) {
        this.keysAndValues = new ArrayList(initialCapacity * 2);
    }

    public int size() {
        return this.keysAndValues.size() / 2;
    }

    public boolean isEmpty() {
        return this.keysAndValues.isEmpty();
    }

    public boolean containsKey(K key) {
        int size = this.keysAndValues.size();
        int i = 0;
        while (i < size) {
            if (this.keysAndValues.get(i).equals(key)) {
                return true;
            }
            i += 2;
        }
        return false;
    }

    public boolean containsValue(V value) {
        int size = this.keysAndValues.size();
        int i = 1;
        while (i < size) {
            if (this.keysAndValues.get(i).equals(value)) {
                return true;
            }
            i += 2;
        }
        return false;
    }

    public K getKey(int index) {
        return (K)this.keysAndValues.get(index * 2);
    }

    public V getValue(int index) {
        return (V)this.keysAndValues.get(1 + index * 2);
    }

    public V get(K key) {
        int size = this.keysAndValues.size();
        int i = 0;
        while (i < size) {
            if (this.keysAndValues.get(i).equals(key)) {
                return (V)this.keysAndValues.get(i + 1);
            }
            i += 2;
        }
        return null;
    }

    public V put(K key, V value) {
        int size = this.keysAndValues.size();
        int i = 0;
        while (i < size) {
            if (this.keysAndValues.get(i).equals(key)) {
                Object old = this.keysAndValues.get(i + 1);
                this.keysAndValues.set(i + 1, value);
                return (V)old;
            }
            i += 2;
        }
        this.keysAndValues.add(key);
        this.keysAndValues.add(value);
        return null;
    }

    public V remove(K key) {
        int size = this.keysAndValues.size();
        int i = 0;
        while (i < size) {
            if (this.keysAndValues.get(i).equals(key)) {
                this.keysAndValues.remove(i);
                return (V)this.keysAndValues.remove(i);
            }
            i += 2;
        }
        return null;
    }

    public void putAll(Map<? extends K, ? extends V> m) {
        Set<K> keySet = m.keySet();
        if (!this.isEmpty()) {
            for (K key : keySet) {
                this.put(key, m.get(key));
            }
        } else {
            for (K key : keySet) {
                this.keysAndValues.add(key);
                this.keysAndValues.add(m.get(key));
            }
        }
    }

    public void clear() {
        this.keysAndValues.clear();
    }
}

