/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.list;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.openconcerto.sql.model.FieldPath;
import org.openconcerto.sql.model.IFieldPath;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLFieldsSet;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.view.list.ListSQLLine;
import org.openconcerto.ui.light.LightUIColumnCellRenderer;
import org.openconcerto.utils.cc.IClosure;
import org.openconcerto.utils.convertor.ValueConvertor;

public abstract class SQLTableModelColumn {
    private final String name;
    private ValueConvertor converter;
    private Class convClass;
    private TableCellRenderer renderer;
    private LightUIColumnCellRenderer lightUIrenderer;
    private IClosure<TableColumn> installer;

    public SQLTableModelColumn(String name) {
        this.name = name;
        this.renderer = null;
        this.installer = null;
        this.lightUIrenderer = null;
    }

    public final String getName() {
        return this.name;
    }

    public String getToolTip() {
        return this.getName();
    }

    public abstract String getIdentifier();

    public Set<SQLField> getFields() {
        HashSet<SQLField> res = new HashSet<SQLField>();
        for (IFieldPath iFieldPath : this.getPaths()) {
            res.add(iFieldPath.getField());
        }
        return res;
    }

    public abstract Set<FieldPath> getPaths();

    public SQLFieldsSet getWriteFields() {
        return new SQLFieldsSet(this.getFields());
    }

    public Set<SQLTable> getWriteTables() {
        return Collections.emptySet();
    }

    public final Set<String> getUsedCols() {
        return Collections.emptySet();
    }

    public Set<String> getUsedExternals() {
        return Collections.emptySet();
    }

    public final Class getValueClass() {
        return this.convClass != null ? this.convClass : this.getValueClass_();
    }

    public abstract boolean isEditable();

    public final Object show(SQLRowAccessor r) {
        Object res = this.show_(r);
        assert (res == null || this.getValueClass_().isInstance(res)) : this.getValueClass_() + " is not the class of " + res;
        if (this.converter != null) {
            res = this.converter.convert(res);
        }
        assert (res == null || this.getValueClass().isInstance(res));
        return res;
    }

    public final void put(ListSQLLine r, Object obj) {
        this.put_(r, this.converter == null ? obj : this.converter.unconvert(obj));
    }

    protected abstract Class getValueClass_();

    protected abstract Object show_(SQLRowAccessor var1);

    protected abstract void put_(ListSQLLine var1, Object var2);

    public <C> void setConverter(ValueConvertor<?, C> vc, Class<C> c) {
        this.converter = vc;
        this.convClass = c;
    }

    public final TableCellRenderer getRenderer() {
        if (this.renderer == null) {
            this.renderer = this.createDefaultRenderer();
        }
        return this.renderer;
    }

    protected TableCellRenderer createDefaultRenderer() {
        return null;
    }

    public final void setRenderer(TableCellRenderer renderer) {
        this.renderer = renderer;
    }

    public void install(TableColumn col) {
        col.setCellRenderer(this.getRenderer());
        if (this.installer != null) {
            this.installer.executeChecked(col);
        }
    }

    public final void setColumnInstaller(IClosure<TableColumn> installer) {
        this.installer = installer;
    }

    public LightUIColumnCellRenderer getLightUIrenderer() {
        return this.lightUIrenderer;
    }

    public void setLightUIrenderer(LightUIColumnCellRenderer lightUIrenderer) {
        this.lightUIrenderer = lightUIrenderer;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " " + this.getIdentifier();
    }
}

