/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.stock.element;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import org.openconcerto.erp.core.sales.product.model.ProductComponent;
import org.openconcerto.erp.core.sales.product.model.ProductHelper;
import org.openconcerto.erp.core.supplychain.stock.element.StockItem;
import org.openconcerto.erp.core.supplychain.stock.element.StockItemComponent;
import org.openconcerto.erp.importer.ArrayTableModel;
import org.openconcerto.erp.importer.DataImporter;
import org.openconcerto.erp.preferences.GestionArticleGlobalPreferencePanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesCluster;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.Tuple3;

public class InventaireFromEtatStockImporter {
    private Map<String, SQLRowValues> kits = new HashMap<String, SQLRowValues>();
    private List<String> codeKits = new ArrayList<String>();
    private SQLRowAccessor depot;
    private static String FAMILLE = "Famille";
    private static String CODE = "Code";
    private static String NOM = "Nom";
    private static String TAILLE = "Taille";
    private static String COULEUR = "Couleur";
    private static String QTE = "Qt\u00e9 r\u00e9elle relev\u00e9e";
    private static String QTE_OPENCONCERTO = "QTE OpenConcerto";
    private final Map<String, Integer> mapCouleur = new HashMap<String, Integer>();
    private final Map<String, Integer> mapTaille = new HashMap<String, Integer>();
    private final DBRoot root;
    private final SQLElement artElt;
    private final Map<String, Tuple2<SQLRowValues, SQLRowValues>> mapArticle = new HashMap<String, Tuple2<SQLRowValues, SQLRowValues>>();
    private final Map<Tuple3<String, String, String>, Tuple2<SQLRowValues, SQLRowValues>> mapDeclArticle = new HashMap<Tuple3<String, String, String>, Tuple2<SQLRowValues, SQLRowValues>>();

    public InventaireFromEtatStockImporter(SQLElement articleElt, SQLRowAccessor depot) {
        this.depot = depot;
        this.root = articleElt.getTable().getDBRoot();
        this.artElt = articleElt;
        SQLSelect sel = new SQLSelect();
        sel.addSelect(articleElt.getTable().getTable("ARTICLE_DECLINAISON_COULEUR").getKey());
        sel.addSelect(articleElt.getTable().getTable("ARTICLE_DECLINAISON_COULEUR").getField("NOM"));
        List<SQLRow> l = SQLRowListRSH.execute(sel);
        for (SQLRow sqlRow : l) {
            this.mapCouleur.put(sqlRow.getString("NOM").trim(), sqlRow.getID());
        }
        sel = new SQLSelect();
        sel.addSelect(articleElt.getTable().getTable("ARTICLE_DECLINAISON_TAILLE").getKey());
        sel.addSelect(articleElt.getTable().getTable("ARTICLE_DECLINAISON_TAILLE").getField("NOM"));
        l = SQLRowListRSH.execute(sel);
        for (SQLRow sqlRow : l) {
            this.mapTaille.put(sqlRow.getString("NOM").trim(), sqlRow.getID());
        }
    }

    public void importArticles(File file, DBRoot root) throws IOException, SQLException {
        SQLTable table = root.findTable("ARTICLE");
        SQLTable tableArtElt = root.findTable("ARTICLE_ELEMENT");
        this.fillArticles();
        HashMap<String, Integer> columnMapping = new HashMap<String, Integer>();
        columnMapping.put(CODE, null);
        columnMapping.put(NOM, null);
        columnMapping.put(TAILLE, null);
        columnMapping.put(FAMILLE, null);
        columnMapping.put(COULEUR, null);
        columnMapping.put(QTE, null);
        columnMapping.put(QTE_OPENCONCERTO, null);
        DataImporter importer = new DataImporter(table);
        importer.setSkipFirstLine(false);
        ArrayTableModel m = importer.createModelFrom(file);
        List line = m.getLineValuesAt(0);
        int i = 0;
        while (i < line.size()) {
            Object e = line.get(i);
            if (e != null) {
                for (Object key : columnMapping.keySet()) {
                    if (!e.toString().equalsIgnoreCase((String)key)) continue;
                    columnMapping.put((String)key, i);
                }
            }
            ++i;
        }
        String msg = "Colonnes import\u00e9es : \n";
        SQLPreferences prefs = SQLPreferences.getMemCached(table.getDBRoot());
        boolean hasDeclinaison = prefs.getBoolean(GestionArticleGlobalPreferencePanel.ACTIVER_DECLINAISON, false);
        List<String> required = hasDeclinaison ? Arrays.asList(CODE, QTE, QTE_OPENCONCERTO, TAILLE, COULEUR) : Arrays.asList(CODE, QTE, QTE_OPENCONCERTO);
        for (Map.Entry entry : columnMapping.entrySet()) {
            if (entry.getValue() != null) {
                msg = String.valueOf(msg) + (String)entry.getKey() + " : " + this.getColumnName((Integer)entry.getValue()) + "\n";
                continue;
            }
            if (required.contains(entry.getKey())) {
                JOptionPane.showMessageDialog(null, "Aucune colonne " + (String)entry.getKey() + " trouv\u00e9e, import annul\u00e9!\nCette colonne est obligatoire.");
                return;
            }
            msg = String.valueOf(msg) + (String)entry.getKey() + " : non import\u00e9e\n";
        }
        int n = JOptionPane.showConfirmDialog(null, msg = String.valueOf(msg) + "\nVoulez vous continuer ?");
        if (n == 0) {
            DataImporter importer2 = new DataImporter(table){

                protected void customizeRowValuesToFetch(SQLRowValues vals) {
                    vals.putRowValues("ID_STOCK").putNulls("ID", "QTE_REEL", "QTE_TH", "ID_DEPOT_STOCK");
                }
            };
            importer2.setSkipFirstLine(true);
            ArrayTableModel m2 = importer2.createModelFrom(file);
            Calendar c = Calendar.getInstance();
            Date today = c.getTime();
            SQLRowValues rowVals = new SQLRowValues(table.getTable("ETAT_STOCK"));
            rowVals.put("DATE", today);
            rowVals.put("INVENTAIRE", Boolean.TRUE);
            rowVals.put("ID_DEPOT_STOCK", this.depot.getID());
            SQLRow rowEtat = rowVals.commit();
            int i2 = 1;
            while (i2 < m2.getRowCount()) {
                List o = m2.getLineValuesAt(i2);
                if (o.size() >= 5) {
                    System.err.println(o);
                    String code = o.get((Integer)columnMapping.get(CODE)).toString();
                    if (code.trim().length() > 0) {
                        Tuple2<SQLRowValues, SQLRowValues> match;
                        String stringQty = o.get((Integer)columnMapping.get(QTE)).toString();
                        Double qty = stringQty.trim().length() == 0 ? 0.0 : Double.valueOf(stringQty);
                        String stringQtyOld = o.get((Integer)columnMapping.get(QTE_OPENCONCERTO)).toString();
                        float qtyOld = stringQtyOld.trim().length() == 0 ? 0.0f : Float.valueOf(stringQtyOld).floatValue();
                        String couleur = "";
                        if (columnMapping.get(COULEUR) != null) {
                            couleur = o.get((Integer)columnMapping.get(COULEUR)).toString();
                        }
                        String taille = "";
                        if (columnMapping.get(TAILLE) != null) {
                            taille = o.get((Integer)columnMapping.get(TAILLE)).toString();
                        }
                        if ((match = this.findArticle(code, couleur, taille)) != null) {
                            SQLRowAccessor stockValues = match.get1();
                            SQLTable tableMvt = table.getTable("MOUVEMENT_STOCK");
                            SQLRowValues rowValsMvtStockClotureFermeture = new SQLRowValues(tableMvt);
                            rowValsMvtStockClotureFermeture.put("QTE", Float.valueOf(-qtyOld));
                            rowValsMvtStockClotureFermeture.put("NOM", "Cl\u00f4ture stock avant inventaire");
                            rowValsMvtStockClotureFermeture.put("ID_ARTICLE", match.get0().getID());
                            rowValsMvtStockClotureFermeture.put("DATE", today);
                            rowValsMvtStockClotureFermeture.put("REEL", Boolean.TRUE);
                            rowValsMvtStockClotureFermeture.put("ID_STOCK", stockValues.getID());
                            BigDecimal prc = this.getPRC(match.get0(), Math.round(qtyOld), today);
                            if (prc == null) {
                                prc = BigDecimal.ZERO;
                            }
                            if (tableMvt.contains("PRICE")) {
                                rowValsMvtStockClotureFermeture.put("PRICE", prc);
                            }
                            rowValsMvtStockClotureFermeture.put("CLOTURE", Boolean.TRUE);
                            rowValsMvtStockClotureFermeture.put("ID_ETAT_STOCK", rowEtat.getID());
                            rowValsMvtStockClotureFermeture.getGraph().store(SQLRowValuesCluster.StoreMode.COMMIT, false);
                            SQLRowValues rowValsItem = new SQLRowValues(table.getTable("ETAT_STOCK_ELEMENT"));
                            rowValsItem.put("ID_ETAT_STOCK", rowEtat.getID());
                            rowValsItem.put("PA", prc);
                            rowValsItem.put("PV", BigDecimal.ZERO);
                            rowValsItem.put("QTE", Float.valueOf(qtyOld));
                            rowValsItem.put("T_PA", prc.multiply(new BigDecimal(qtyOld)));
                            rowValsItem.put("T_PV", BigDecimal.ZERO);
                            rowValsItem.put("CODE", match.get0().getString("CODE"));
                            rowValsItem.put("NOM", match.get0().getString("NOM"));
                            rowValsItem.put("ID_ARTICLE", match.get0().getID());
                            rowValsItem.getGraph().store(SQLRowValuesCluster.StoreMode.COMMIT, false);
                            SQLRowValues rowValsMvtStockClotureOuverture = new SQLRowValues(tableMvt);
                            rowValsMvtStockClotureOuverture.put("QTE", qty);
                            rowValsMvtStockClotureOuverture.put("NOM", "Mise en stock inventaire");
                            rowValsMvtStockClotureOuverture.put("ID_ETAT_STOCK", rowEtat.getID());
                            rowValsMvtStockClotureOuverture.put("ID_ARTICLE", match.get0().getID());
                            rowValsMvtStockClotureOuverture.put("DATE", today);
                            rowValsMvtStockClotureOuverture.put("REEL", Boolean.TRUE);
                            rowValsMvtStockClotureOuverture.put("ID_STOCK", stockValues.getID());
                            rowValsMvtStockClotureOuverture.put("OUVERTURE", Boolean.TRUE);
                            if (tableMvt.contains("PRICE")) {
                                rowValsMvtStockClotureOuverture.put("PRICE", this.getPRC(match.get0(), qty.intValue(), today));
                            }
                            rowValsMvtStockClotureOuverture.getGraph().store(SQLRowValuesCluster.StoreMode.COMMIT, false);
                            SQLRowValues createEmptyUpdateRow = match.get1().createEmptyUpdateRow();
                            createEmptyUpdateRow.put("QTE_REEL", qty);
                            createEmptyUpdateRow.getGraph().store(SQLRowValuesCluster.StoreMode.COMMIT, false);
                        } else {
                            System.err.println("Aucun article correspondant au code " + (String)code);
                        }
                    }
                }
                ++i2;
            }
            ArrayList<String> reqs = new ArrayList<String>();
            for (String code : this.codeKits) {
                System.err.println(code);
                SQLRowValues rowValsKit = this.kits.get(code);
                StockItem item = new StockItem(rowValsKit, ProductComponent.findOrCreateStock(rowValsKit, this.depot));
                Collection elts = rowValsKit.getReferentRows(tableArtElt.getField("ID_ARTICLE_PARENT"));
                for (SQLRowValues sqlRowValues : elts) {
                    if (sqlRowValues.getForeign("ID_ARTICLE") == null) continue;
                    item.addItemComponent(new StockItemComponent(new StockItem(sqlRowValues.getForeign("ID_ARTICLE"), ProductComponent.findOrCreateStock(sqlRowValues.getForeign("ID_ARTICLE"), this.depot)), sqlRowValues.getBigDecimal("QTE_UNITAIRE"), sqlRowValues.getInt("QTE")));
                }
                item.updateQtyFromChildren();
                reqs.add(item.getUpdateRequest());
            }
            ArrayList<Object> handlers = new ArrayList<Object>(reqs.size());
            for (String s : reqs) {
                handlers.add(null);
            }
            SQLUtils.executeMultiple(table.getDBSystemRoot(), reqs, handlers);
        }
    }

    private void checkMinPrice(SQLRow rowValsSuplierLastValid, SQLRow lastValidRow) {
        boolean update = false;
        ProductHelper helper = new ProductHelper(rowValsSuplierLastValid.getTable().getDBRoot());
        BigDecimal result = helper.getEnumPrice(rowValsSuplierLastValid, ProductHelper.SupplierPriceField.COEF_PRIX_MINI);
        if (result != null) {
            int qteSuplier = rowValsSuplierLastValid.getInt("QTE");
            Calendar date2 = rowValsSuplierLastValid.getDate("DATE_PRIX");
            if (date2 != null && lastValidRow != null) {
                Calendar date1 = lastValidRow.getDate("DATE");
                if (date1.get(1) == date2.get(1) && date1.get(2) == date2.get(2) && date1.get(5) == date2.get(5) || date1.after(date2)) {
                    if (lastValidRow.getBigDecimal("PRIX") != null && lastValidRow.getInt("QTE") <= qteSuplier) {
                        try {
                            lastValidRow.asRowValues().put("PRIX", result).commit();
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                        update = true;
                    }
                } else if (date1.before(date2)) {
                    SQLRowValues rowValsToInsert = new SQLRowValues(lastValidRow.getTable());
                    rowValsToInsert.put("PRIX", result);
                    rowValsToInsert.put("DATE", rowValsSuplierLastValid.getObject("DATE_PRIX"));
                    rowValsToInsert.put("QTE", rowValsSuplierLastValid.getObject("QTE"));
                    rowValsToInsert.put("ID_ARTICLE", rowValsSuplierLastValid.getInt("ID_ARTICLE"));
                    try {
                        rowValsToInsert.commit();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public BigDecimal getPRC(SQLRowValues rowVals, int qty, Date d) {
        ProductComponent comp = new ProductComponent(rowVals, new BigDecimal(qty), null, null);
        return comp.getPRC(d);
    }

    private void fillArticles() throws SQLException {
        SQLTable table = Configuration.getInstance().getRoot().findTable("ARTICLE");
        SQLRowValues graph = new SQLRowValues(table);
        graph.put("ID", null);
        graph.put("CODE", null);
        graph.put("NOM", null);
        graph.putRowValues("ID_ARTICLE_DECLINAISON_COULEUR").putNulls("ID", "NOM");
        graph.putRowValues("ID_ARTICLE_DECLINAISON_TAILLE").putNulls("ID", "NOM");
        SQLTable foreignTableStock = table.getForeignTable("ID_STOCK");
        SQLRowValues graphStock = new SQLRowValues(foreignTableStock);
        graphStock.putNulls("ID_DEPOT_STOCK", "ID", "QTE_REEL", "QTE_TH", "QTE_LIV_ATTENTE", "QTE_RECEPT_ATTENTE");
        graphStock.put("ID_ARTICLE", (Object)graph);
        SQLRowValues graphStockArt = new SQLRowValues(foreignTableStock);
        graphStockArt.putNulls("ID_DEPOT_STOCK", "ID", "QTE_REEL", "QTE_TH", "QTE_LIV_ATTENTE", "QTE_RECEPT_ATTENTE");
        graph.put("ID_STOCK", (Object)graphStockArt);
        SQLTable tableArtElt = table.getTable("ARTICLE_ELEMENT");
        SQLRowValues artElt = new SQLRowValues(tableArtElt);
        artElt.put("ID", null);
        artElt.put("QTE", null);
        artElt.put("QTE_UNITAIRE", null);
        artElt.put("ID_ARTICLE_PARENT", (Object)graph);
        SQLRowValues articleParent = artElt.putRowValues("ID_ARTICLE");
        articleParent.putNulls("ID", "CODE", "NOM");
        articleParent.putRowValues("ID_ARTICLE_DECLINAISON_COULEUR").putNulls("ID", "NOM");
        articleParent.putRowValues("ID_ARTICLE_DECLINAISON_TAILLE").putNulls("ID", "NOM");
        SQLRowValues graphStockItem = new SQLRowValues(foreignTableStock);
        graphStockItem.put("ID_ARTICLE", (Object)articleParent);
        SQLRowValues graphStockArtItem = new SQLRowValues(foreignTableStock);
        graphStockArtItem.putNulls("ID_DEPOT_STOCK", "ID", "QTE_REEL", "QTE_TH", "QTE_LIV_ATTENTE", "QTE_RECEPT_ATTENTE");
        articleParent.put("ID_STOCK", (Object)graphStockArtItem);
        SQLRowValuesListFetcher fetcher = SQLRowValuesListFetcher.create(graph);
        List<SQLRowValues> results = fetcher.fetch();
        Calendar c = Calendar.getInstance();
        c.add(2, -2);
        c.set(5, 31);
        Date dEndYear = c.getTime();
        for (SQLRowValues sqlRowValues : results) {
            SQLRowAccessor taille;
            String code = sqlRowValues.getString("CODE");
            Collection<SQLRowValues> stocks = sqlRowValues.getReferentRows(foreignTableStock);
            SQLRowValues rowValsStock = null;
            for (SQLRowValues sqlRowValues2 : stocks) {
                if (sqlRowValues2.getForeignID("ID_DEPOT_STOCK") != this.depot.getID()) continue;
                rowValsStock = sqlRowValues2;
            }
            SQLRowAccessor couleur = sqlRowValues.getObject("ID_ARTICLE_DECLINAISON_COULEUR") == null ? null : sqlRowValues.getNonEmptyForeign("ID_ARTICLE_DECLINAISON_COULEUR");
            SQLRowAccessor sQLRowAccessor = taille = sqlRowValues.getObject("ID_ARTICLE_DECLINAISON_TAILLE") == null ? null : sqlRowValues.getNonEmptyForeign("ID_ARTICLE_DECLINAISON_TAILLE");
            if (couleur == null && taille == null) {
                this.mapArticle.put(sqlRowValues.getString("CODE"), Tuple2.create(sqlRowValues, rowValsStock));
            } else if (couleur == null) {
                this.mapDeclArticle.put(Tuple3.create(sqlRowValues.getString("CODE"), null, taille.getString("NOM")), Tuple2.create(sqlRowValues, rowValsStock));
            } else if (taille == null) {
                this.mapDeclArticle.put(Tuple3.create(sqlRowValues.getString("CODE"), couleur.getString("NOM"), null), Tuple2.create(sqlRowValues, rowValsStock));
            } else {
                this.mapDeclArticle.put(Tuple3.create(sqlRowValues.getString("CODE"), couleur.getString("NOM"), taille.getString("NOM")), Tuple2.create(sqlRowValues, rowValsStock));
            }
            Collection referentRows = sqlRowValues.getReferentRows(tableArtElt.getField("ID_ARTICLE_PARENT"));
            if (referentRows.size() == 0) continue;
            boolean contains = false;
            for (SQLRowValues sqlRowValues2 : referentRows) {
                if (sqlRowValues2.getForeign("ID_ARTICLE") == null || sqlRowValues2.isForeignEmpty("ID_ARTICLE") || sqlRowValues2.getForeign("ID_ARTICLE").getString("CODE") == null || !this.codeKits.contains(sqlRowValues2.getForeign("ID_ARTICLE").getString("CODE"))) continue;
                contains = true;
                break;
            }
            if (!contains) {
                this.codeKits.add(0, code);
            } else {
                this.codeKits.add(code);
            }
            this.kits.put(code, sqlRowValues);
        }
    }

    private Tuple2<SQLRowValues, SQLRowValues> findArticle(String code, String couleur, String taille) throws SQLException {
        Tuple2<SQLRowValues, SQLRowValues> t;
        SQLRowValues rowVals;
        if (!this.mapCouleur.containsKey(couleur)) {
            rowVals = new SQLRowValues(this.root.getTable("ARTICLE_DECLINAISON_COULEUR"));
            rowVals.put("NOM", couleur);
            this.mapCouleur.put(couleur, rowVals.commit().getID());
        }
        if (!this.mapTaille.containsKey(taille)) {
            rowVals = new SQLRowValues(this.root.getTable("ARTICLE_DECLINAISON_TAILLE"));
            rowVals.put("NOM", taille);
            this.mapTaille.put(taille, rowVals.commit().getID());
        }
        if (!(couleur != null && couleur.trim().length() != 0 || taille != null && taille.trim().length() != 0)) {
            t = this.mapArticle.get(code);
            if (t.get1() == null) {
                t = Tuple2.create(t.get0(), ProductComponent.findOrCreateStock(t.get0(), this.depot).asRowValues());
                this.mapArticle.put(code, t);
            }
        } else if (couleur == null || couleur.trim().length() == 0) {
            t = this.mapDeclArticle.get(Tuple3.create(code, null, taille.trim()));
            if (t == null) {
                SQLRowValues artRow = this.cloneFromArticle(this.mapArticle.get(code).get0(), null, this.mapTaille.get(taille.trim())).asRowValues();
                SQLRowValues stockRow = ProductComponent.findOrCreateStock(artRow, this.depot).asRowValues();
                t = Tuple2.create(artRow, stockRow);
                this.mapDeclArticle.put(Tuple3.create(code, null, taille.trim()), t);
            } else if (t.get1() == null) {
                t = Tuple2.create(t.get0(), ProductComponent.findOrCreateStock(t.get0(), this.depot).asRowValues());
                this.mapDeclArticle.put(Tuple3.create(code, null, taille.trim()), t);
            }
        } else if (taille == null || taille.trim().length() == 0) {
            t = this.mapDeclArticle.get(Tuple3.create(code, couleur.trim(), null));
            if (t == null) {
                SQLRowValues artRow = this.cloneFromArticle(this.mapArticle.get(code).get0(), this.mapCouleur.get(couleur.trim()), null).asRowValues();
                SQLRowValues stockRow = ProductComponent.findOrCreateStock(artRow, this.depot).asRowValues();
                t = Tuple2.create(artRow, stockRow);
                this.mapDeclArticle.put(Tuple3.create(code, couleur.trim(), null), t);
            } else if (t.get1() == null) {
                t = Tuple2.create(t.get0(), ProductComponent.findOrCreateStock(t.get0(), this.depot).asRowValues());
                this.mapDeclArticle.put(Tuple3.create(code, couleur.trim(), null), t);
            }
        } else {
            t = this.mapDeclArticle.get(Tuple3.create(code, couleur.trim(), taille.trim()));
            if (t == null) {
                if (this.mapArticle.get(code) != null) {
                    SQLRowValues artRow = this.cloneFromArticle(this.mapArticle.get(code).get0(), this.mapCouleur.get(couleur.trim()), this.mapTaille.get(taille.trim())).asRowValues();
                    SQLRowValues stockRow = ProductComponent.findOrCreateStock(artRow, this.depot).asRowValues();
                    t = Tuple2.create(artRow, stockRow);
                    this.mapDeclArticle.put(Tuple3.create(code, couleur.trim(), taille.trim()), t);
                }
            } else if (t.get1() == null) {
                t = Tuple2.create(t.get0(), ProductComponent.findOrCreateStock(t.get0(), this.depot).asRowValues());
                this.mapDeclArticle.put(Tuple3.create(code, couleur.trim(), taille.trim()), t);
            }
        }
        return t;
    }

    public SQLRow cloneFromArticle(SQLRowAccessor rArt, Integer idCouleur, Integer idTaille) throws SQLException {
        if (rArt == null) {
            return null;
        }
        SQLRowValues copy = this.artElt.createCopy(rArt.getID());
        if (idCouleur != null) {
            copy.put("ID_ARTICLE_DECLINAISON_COULEUR", idCouleur);
        }
        if (idTaille != null) {
            copy.put("ID_ARTICLE_DECLINAISON_TAILLE", idTaille);
        }
        return copy.commit();
    }

    private String getColumnName(int columnNumber) {
        int dividend = columnNumber;
        String columnName = "";
        while (dividend >= 0) {
            int modulo = dividend % 26;
            columnName = String.valueOf(String.valueOf((char)(65 + modulo))) + columnName;
            if ((dividend = (dividend - modulo) / 26) <= 0) break;
            --dividend;
        }
        return columnName;
    }
}

