/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.product.action;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import org.openconcerto.erp.core.common.ui.NumericTextField;
import org.openconcerto.erp.core.sales.product.element.ReferenceArticleSQLElement;
import org.openconcerto.erp.core.supplychain.stock.element.ComposedItemStockUpdater;
import org.openconcerto.erp.core.supplychain.stock.element.StockItem;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JDate;
import org.openconcerto.ui.JLabelBold;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.NumberUtils;
import org.openconcerto.utils.text.SimpleDocumentListener;

public class InventairePanel
extends JPanel {
    private final String mvtStockTableQuoted;
    private static String defaultLabel = "Mise \u00e0 jour des stocks";

    public InventairePanel(final IListe liste, final List<? extends SQLRowAccessor> stocks) {
        super(new GridBagLayout());
        final SQLTable mvtStockTable = Configuration.getInstance().getRoot().findTable("MOUVEMENT_STOCK");
        this.mvtStockTableQuoted = mvtStockTable.getSQLName().quote();
        JLabel qteReel = new JLabel("Quantit\u00e9 r\u00e9el", 4);
        final NumericTextField fieldReel = new NumericTextField();
        JLabel qteLivAtt = new JLabel("Quantit\u00e9 Livraison en attente", 4);
        final NumericTextField fieldLivAtt = new NumericTextField();
        JLabel qteRecpAtt = new JLabel("Quantit\u00e9 R\u00e9ception en attente", 4);
        final NumericTextField fieldRecpAtt = new NumericTextField();
        JLabel qteTh = new JLabel("Quantit\u00e9 th\u00e9orique", 4);
        final NumericTextField fieldTh = new NumericTextField();
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        this.add((Component)new JLabel("Intitul\u00e9"), c);
        final JTextField label = new JTextField();
        ++c.gridx;
        c.gridwidth = 2;
        c.weightx = 1.0;
        this.add((Component)label, c);
        label.setText(defaultLabel);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        this.add((Component)new JLabel("Date", 4), c);
        final JDate date = new JDate(true);
        ++c.gridx;
        c.weightx = 0.0;
        this.add((Component)date, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 3;
        this.add((Component)new JLabelBold("Stock r\u00e9el"), c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 2;
        c.weightx = 0.0;
        this.add((Component)qteReel, c);
        c.gridx += 2;
        c.gridwidth = 1;
        c.weightx = 1.0;
        this.add((Component)fieldReel, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 3;
        this.add((Component)new JLabelBold("Stock virtuel"), c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 2;
        c.weightx = 0.0;
        this.add((Component)qteLivAtt, c);
        c.gridx += 2;
        c.gridwidth = 1;
        c.weightx = 1.0;
        this.add((Component)fieldLivAtt, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 2;
        c.weightx = 0.0;
        this.add((Component)qteRecpAtt, c);
        c.gridx += 2;
        c.gridwidth = 1;
        c.weightx = 1.0;
        this.add((Component)fieldRecpAtt, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 2;
        c.weightx = 0.0;
        this.add((Component)qteTh, c);
        c.gridx += 2;
        c.gridwidth = 1;
        fieldTh.setEditable(false);
        c.weightx = 1.0;
        this.add((Component)fieldTh, c);
        SimpleDocumentListener l = new SimpleDocumentListener(){

            @Override
            public void update(DocumentEvent e) {
                BigDecimal qteReel = fieldReel.getValue() == null ? BigDecimal.ZERO : fieldReel.getValue();
                BigDecimal qteLivAttente = fieldLivAtt.getValue() == null ? BigDecimal.ZERO : fieldLivAtt.getValue();
                BigDecimal qteRecptAttente = fieldRecpAtt.getValue() == null ? BigDecimal.ZERO : fieldRecpAtt.getValue();
                fieldTh.setValue(qteReel.subtract(qteLivAttente).add(qteRecptAttente));
            }
        };
        fieldLivAtt.getDocument().addDocumentListener(l);
        fieldReel.getDocument().addDocumentListener(l);
        fieldRecpAtt.getDocument().addDocumentListener(l);
        if (stocks.size() == 1) {
            SQLRowAccessor r;
            SQLRowAccessor stock = r = stocks.get(0);
            fieldReel.setText(String.valueOf(stock.getFloat("QTE_REEL")));
            fieldLivAtt.setText(String.valueOf(stock.getFloat("QTE_LIV_ATTENTE")));
            fieldRecpAtt.setText(String.valueOf(stock.getFloat("QTE_RECEPT_ATTENTE")));
            fieldTh.setText(String.valueOf(stock.getFloat("QTE_TH")));
        }
        ++c.gridy;
        c.gridx = 0;
        final JButton buttonUpdate = new JButton("Mettre \u00e0 jour");
        JButton buttonCancel = new JButton("Annuler");
        JPanel pButton = new JPanel();
        pButton.add(buttonCancel);
        pButton.add(buttonUpdate);
        c.gridwidth = 0;
        c.anchor = 13;
        c.weightx = 0.0;
        c.fill = 0;
        this.add((Component)pButton, c);
        buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((JFrame)SwingUtilities.getRoot(InventairePanel.this)).dispose();
            }
        });
        buttonUpdate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                buttonUpdate.setEnabled(false);
                defaultLabel = label.getText();
                BigDecimal qteReel = fieldReel.getValue();
                BigDecimal qteLivAttente = fieldLivAtt.getValue();
                BigDecimal qteRecptAttente = fieldRecpAtt.getValue();
                ArrayList multipleRequests = new ArrayList();
                ArrayList<String> multipleRequestsHundred = new ArrayList<String>(100);
                boolean usePrice = mvtStockTable.contains("PRICE");
                ArrayList<StockItem> stockItems = new ArrayList<StockItem>();
                Date dateValue = date.getValue();
                for (SQLRowAccessor sQLRowAccessor : stocks) {
                    double diff;
                    StockItem item;
                    if (multipleRequestsHundred.size() > 100) {
                        multipleRequests.add(multipleRequestsHundred);
                        multipleRequestsHundred = new ArrayList(100);
                    }
                    if (!(item = new StockItem(sQLRowAccessor.getForeign("ID_ARTICLE"), sQLRowAccessor)).isStockInit()) {
                        ((ReferenceArticleSQLElement)liste.getSource().getElem().getDirectory().getElement("ARTICLE")).initStock(sQLRowAccessor.getForeignID("ID_ARTICLE"));
                        SQLRow rowArticle = sQLRowAccessor.getForeign("ID_ARTICLE").asRow();
                        rowArticle.fetchValues();
                        item = new StockItem(rowArticle, rowArticle.getForeign("ID_STOCK"));
                    }
                    stockItems.add(item);
                    boolean modified = false;
                    if (qteReel != null && !NumberUtils.areNumericallyEqual(qteReel, item.getRealQty())) {
                        diff = qteReel.doubleValue() - item.getRealQty();
                        item.updateQty(diff, StockItem.TypeStockMouvement.REEL);
                        multipleRequestsHundred.add(InventairePanel.this.getMvtRequest(dateValue, BigDecimal.ZERO, diff, item, label.getText(), true, usePrice));
                        modified = true;
                    }
                    if (qteLivAttente != null && !NumberUtils.areNumericallyEqual(qteLivAttente, item.getDeliverQty())) {
                        item.updateQty(diff, StockItem.TypeStockMouvement.THEORIQUE, (diff = item.getDeliverQty() - qteLivAttente.doubleValue()) > 0.0);
                        multipleRequestsHundred.add(InventairePanel.this.getMvtRequest(dateValue, BigDecimal.ZERO, diff, item, label.getText(), false, usePrice));
                        modified = true;
                    }
                    if (qteRecptAttente != null && !NumberUtils.areNumericallyEqual(qteRecptAttente, item.getReceiptQty())) {
                        diff = qteRecptAttente.doubleValue() - item.getReceiptQty();
                        item.updateQty(Math.abs(diff), StockItem.TypeStockMouvement.THEORIQUE, diff < 0.0);
                        multipleRequestsHundred.add(InventairePanel.this.getMvtRequest(dateValue, BigDecimal.ZERO, diff, item, label.getText(), false, usePrice));
                        modified = true;
                    }
                    if (!modified) continue;
                    if (item.isStockInit()) {
                        multipleRequestsHundred.add(item.getUpdateRequest());
                        continue;
                    }
                    throw new IllegalStateException();
                }
                multipleRequests.add(multipleRequestsHundred);
                try {
                    for (List list : multipleRequests) {
                        int size = list.size();
                        ArrayList<Object> handlers = new ArrayList<Object>(size);
                        int i = 0;
                        while (i < size) {
                            handlers.add(null);
                            ++i;
                        }
                        SQLUtils.executeMultiple(Configuration.getInstance().getRoot().getDBSystemRoot(), list, handlers);
                    }
                }
                catch (SQLException sQLException) {
                    ExceptionHandler.handle("Stock update error", sQLException);
                }
                DBRoot dBRoot = mvtStockTable.getDBRoot();
                if (dBRoot.contains("ARTICLE_ELEMENT")) {
                    ComposedItemStockUpdater comp = new ComposedItemStockUpdater(dBRoot, stockItems);
                    try {
                        comp.update();
                    }
                    catch (SQLException e1) {
                        e1.printStackTrace();
                    }
                }
                liste.getModel().updateAll();
                ((JFrame)SwingUtilities.getRoot(InventairePanel.this)).dispose();
            }
        });
    }

    private String getMvtRequest(Date time, BigDecimal prc, double qteFinal, StockItem item, String label, boolean reel, boolean usePrice) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String mvtStockQuery = "INSERT INTO " + this.mvtStockTableQuoted + " (\"QTE\",\"DATE\",\"ID_ARTICLE\",\"ID_STOCK\",\"NOM\",\"REEL\",\"ORDRE\"";
        if (usePrice && prc != null) {
            mvtStockQuery = String.valueOf(mvtStockQuery) + ",\"PRICE\"";
        }
        mvtStockQuery = String.valueOf(mvtStockQuery) + ") VALUES(" + qteFinal + ",'" + dateFormat.format(time) + "'," + item.getArticle().getID() + "," + item.stock.getID() + ",'" + label + "'," + reel + ", (SELECT (MAX(\"ORDRE\")+1) FROM " + this.mvtStockTableQuoted + ")";
        if (usePrice && prc != null) {
            mvtStockQuery = String.valueOf(mvtStockQuery) + "," + prc.setScale(6, RoundingMode.HALF_UP).toString();
        }
        mvtStockQuery = String.valueOf(mvtStockQuery) + ")";
        return mvtStockQuery;
    }
}

