/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.ui;

import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.jdom2.JDOMException;
import org.openconcerto.erp.core.sales.pos.POSConfiguration;
import org.openconcerto.erp.core.sales.pos.io.BarcodeReader;
import org.openconcerto.erp.core.sales.pos.io.ESCSerialDisplay;
import org.openconcerto.erp.core.sales.pos.io.TicketPrinter;
import org.openconcerto.erp.core.sales.pos.model.Article;
import org.openconcerto.erp.core.sales.pos.model.Client;
import org.openconcerto.erp.core.sales.pos.model.Paiement;
import org.openconcerto.erp.core.sales.pos.model.ReceiptCode;
import org.openconcerto.erp.core.sales.pos.model.RegisterFiles;
import org.openconcerto.erp.core.sales.pos.model.RegisterLog;
import org.openconcerto.erp.core.sales.pos.model.RegisterLogEntry;
import org.openconcerto.erp.core.sales.pos.model.RegisterState;
import org.openconcerto.erp.core.sales.pos.model.Ticket;
import org.openconcerto.erp.core.sales.pos.model.TicketItem;
import org.openconcerto.erp.core.sales.pos.ui.ArticleSelectionListener;
import org.openconcerto.erp.core.sales.pos.ui.BarcodeListener;
import org.openconcerto.erp.core.sales.pos.ui.CaisseFrame;
import org.openconcerto.erp.core.sales.pos.ui.CaisseListener;
import org.openconcerto.erp.core.sales.pos.ui.POSDisplay;
import org.openconcerto.erp.core.sales.pos.ui.PrinterPOSDisplay;
import org.openconcerto.erp.core.sales.pos.ui.TicketCellRenderer;
import org.openconcerto.erp.preferences.TemplateNXProps;
import org.openconcerto.erp.utils.SoundGenerator;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.utils.FileUtils;
import org.openconcerto.utils.StringUtils;

public class CaisseControler
implements BarcodeListener {
    private Article articleSelected;
    private Paiement paiementSelected;
    private Ticket t;
    private Client client = Client.NONE;
    private List<CaisseListener> listeners = new ArrayList<CaisseListener>();
    private final BarcodeReader r;
    private Paiement p1 = new Paiement(1);
    private Paiement p2 = new Paiement(3);
    private Paiement p3 = new Paiement(2);
    private final CaisseFrame caisseFrame;
    private final POSDisplay lcd;
    private TicketItem ticketItemSelected;

    public CaisseControler(CaisseFrame caisseFrame) throws ParseException, JDOMException, IOException {
        int dayIndex;
        this.caisseFrame = caisseFrame;
        RegisterLog lastLog = caisseFrame.getFiles().getLastLog();
        if (lastLog == null || lastLog.getRegisterState().getStatus() != RegisterState.Status.OPEN) {
            throw new IllegalStateException("Not open");
        }
        String lastHash = lastLog.getLastReceiptHash();
        RegisterLogEntry.ReceiptEntry lastReceiptEvent = lastLog.getLastReceiptCreationEvent();
        if (lastReceiptEvent == null) {
            dayIndex = 1;
        } else {
            ReceiptCode lastCode = lastReceiptEvent.getCode();
            dayIndex = lastCode.getDayIndex() + 1;
        }
        POSConfiguration posConf = this.getPOSConf();
        this.t = new Ticket(posConf.getPosID(), dayIndex, lastHash);
        this.t.addPaiement(this.p1);
        this.t.addPaiement(this.p2);
        this.t.addPaiement(this.p3);
        int scanDelay = posConf.getScanDelay();
        this.r = new BarcodeReader(scanDelay);
        this.r.start();
        this.r.addBarcodeListener(this);
        this.lcd = posConf.getLCDType().equals("serial") ? new ESCSerialDisplay(posConf.getLCDPort()) : new PrinterPOSDisplay(posConf.getLCDPort());
        this.setLCDDefaultDisplay(0);
    }

    public final CaisseFrame getCaisseFrame() {
        return this.caisseFrame;
    }

    protected final POSConfiguration getPOSConf() {
        return this.getCaisseFrame().getPOSConf();
    }

    public Article getArticleSelected() {
        return this.articleSelected;
    }

    public Paiement getPaiementSelected() {
        return this.paiementSelected;
    }

    void setArticleSelected(Article a) {
        if (a != this.articleSelected) {
            this.articleSelected = a;
            this.paiementSelected = null;
            this.fire();
        }
    }

    void setPaiementSelected(Paiement p) {
        this.paiementSelected = p;
        this.articleSelected = null;
        this.ticketItemSelected = null;
        this.fire();
    }

    private void fire() {
        int stop = this.listeners.size();
        int i = 0;
        while (i < stop) {
            this.listeners.get(i).caisseStateChanged();
            ++i;
        }
    }

    void addCaisseListener(CaisseListener l) {
        this.listeners.add(l);
    }

    public void setClient(Client client) {
        if (client == null) {
            throw new IllegalArgumentException("Customer cannot be null");
        }
        this.client = client;
        this.t.setClient(client);
        this.fire();
    }

    public boolean isClientDefined() {
        return this.client != Client.NONE;
    }

    public Client getClient() {
        return this.client;
    }

    public void setCodePostal(String codePostal) {
        this.t.setCodePostal(codePostal);
    }

    public void addArticle(Article a) {
        this.t.addArticle(a);
        this.fire();
        String price = TicketCellRenderer.centsToString(a.getPriceWithTax(this.t.getItemCount(a), false).movePointRight(2).setScale(0, RoundingMode.HALF_UP).intValue());
        this.setLCD(a.getName(), price, 0);
        this.setLCDDefaultDisplay(2);
    }

    void incrementArticle(Article a) {
        this.t.incrementArticle(a);
        this.fire();
        String price = TicketCellRenderer.centsToString(a.getPriceWithTax(this.t.getItemCount(a), false).movePointRight(2).setScale(0, RoundingMode.HALF_UP).intValue());
        this.setLCD(a.getName(), price, 0);
        this.setLCDDefaultDisplay(2);
    }

    void removeArticle(Article a) {
        this.t.removeArticle(a);
        this.fire();
    }

    public List<Paiement> getPaiements() {
        return this.t.getPaiements();
    }

    public void addPaiement(Paiement p) {
        this.t.addPaiement(p);
        this.fire();
    }

    public void clearPaiement(Paiement paiement) {
        if (this.p1.equals(paiement) || this.p2.equals(paiement) || this.p3.equals(paiement)) {
            paiement.setMontantInCents(0);
        }
        this.fire();
    }

    public void setPaiementValue(Paiement p, int v) {
        int soldeInCents;
        if (p.getType() == 4 && v > (soldeInCents = this.getClient().getSolde().movePointRight(2).intValue())) {
            v = soldeInCents;
        }
        p.setMontantInCents(v);
        this.fire();
        this.setLCD("Paiement " + p.getTypeAsString().replace('\u00e8', 'e').replace('\u00e9', 'e'), TicketCellRenderer.centsToString(p.getMontantInCents()), 0);
        this.setLCDDefaultDisplay(3);
    }

    public int getTotal() {
        return this.t.getTotalInCents();
    }

    public int getPaidTotal() {
        return this.t.getPaidTotal();
    }

    public List<TicketItem> getItems() {
        return this.t.getItems();
    }

    public BigDecimal getItemCount(Article article) {
        return this.t.getItemCount(article);
    }

    public void clearArticle(Article article) {
        this.t.clearArticle(article);
        this.setTicketItemSelected(null);
    }

    public void setArticleCount(Article article, BigDecimal count) {
        this.t.setArticleCount(article, count);
        this.setArticleSelected(null);
    }

    @Override
    public void barcodeRead(final String code) {
        System.err.println("CaisseControler.barcodeRead() barcode : " + code);
        if (code.equalsIgnoreCase("especes")) {
            this.autoFillPaiement(this.p1);
        } else if (code.equalsIgnoreCase("cb")) {
            this.autoFillPaiement(this.p2);
        } else if (code.equalsIgnoreCase("cheque")) {
            this.autoFillPaiement(this.p3);
        } else if (code.equalsIgnoreCase("annuler")) {
            if (this.articleSelected != null) {
                this.clearArticle(this.articleSelected);
            } else if (this.paiementSelected != null) {
                this.paiementSelected.setMontantInCents(0);
                this.fire();
            }
        } else if (!(code.equalsIgnoreCase("valider") || code.equalsIgnoreCase("facture") || code.equalsIgnoreCase("ticket"))) {
            List<Article> list = Article.getArticleFromBarcode(code);
            if (list != null && !list.isEmpty()) {
                if (list.size() == 1) {
                    Article a = list.get(0);
                    System.err.println("CaisseControler.barcodeRead() barcode : " + code + " : product found : " + a.getName());
                    this.incrementArticle(a);
                    this.setArticleSelected(a);
                } else {
                    this.caisseFrame.showArticleSelector(list, new ArticleSelectionListener(){

                        @Override
                        public void articleSelected(Article a) {
                            System.err.println("CaisseControler.barcodeRead() barcode : " + code + " : product selected : " + a.getName());
                            CaisseControler.this.incrementArticle(a);
                            CaisseControler.this.setArticleSelected(a);
                            CaisseControler.this.caisseFrame.showCaisse();
                        }
                    });
                }
            } else {
                System.err.println("CaisseControler.barcodeRead() barcode : " + code + " : no product found");
                Ticket t = Ticket.getTicketFromCode(code, this.caisseFrame.getFiles());
                if (t != null) {
                    System.err.println("CaisseControler.barcodeRead() barcode : " + code + " : receipt found :" + t.getNumber());
                    this.caisseFrame.showTickets(t);
                } else {
                    new SoundGenerator().playSound(300.0, 0.15, 0.75, (byte)0, (byte)1);
                }
            }
        }
    }

    void autoFillPaiement(Paiement p) {
        int soldeInCents;
        int nouveauMontant = this.getTotal() - this.getPaidTotal() + p.getMontantInCents();
        if (p.getType() == 4 && nouveauMontant > (soldeInCents = this.getClient().getSolde().movePointRight(2).intValue())) {
            nouveauMontant = soldeInCents;
        }
        p.setMontantInCents(nouveauMontant);
        this.setPaiementSelected(p);
        this.setLCD("Paiement " + p.getTypeAsString(), TicketCellRenderer.centsToString(p.getMontantInCents()), 0);
        this.setLCDDefaultDisplay(3);
    }

    void addBarcodeListener(BarcodeListener l) {
        this.r.addBarcodeListener(l);
    }

    public boolean canAddPaiement(int type) {
        int paiementCount = this.t.getPaiements().size();
        if (paiementCount >= 6) {
            return false;
        }
        int i = 0;
        while (i < paiementCount) {
            Paiement p = this.t.getPaiements().get(i);
            if (p.getType() == type && p.getMontantInCents() != 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public void keyReceived(KeyEvent ee) {
    }

    public static String getCents(int cents) {
        String s = String.valueOf(Math.abs(cents) % 100);
        if (s.length() < 2) {
            s = "0" + s;
        }
        return s;
    }

    public static String getEuros(int cents) {
        return String.valueOf(cents / 100);
    }

    public Ticket saveAndClearTicket(RegisterFiles files, SQLElementDirectory dir) throws IOException, SQLException {
        if (!this.isTicketValid()) {
            return null;
        }
        this.t.setCreationCal(Calendar.getInstance());
        String fileHash = this.t.save(files, dir);
        Ticket res = this.t;
        int newIndex = this.t.getNumber() + 1;
        this.t = new Ticket(this.getPOSConf().getPosID(), newIndex, fileHash);
        this.p1 = new Paiement(1);
        this.p2 = new Paiement(3);
        this.p3 = new Paiement(2);
        this.t.addPaiement(this.p1);
        this.t.addPaiement(this.p2);
        this.t.addPaiement(this.p3);
        this.setPaiementSelected(null);
        this.setArticleSelected(null);
        this.client = Client.NONE;
        return res;
    }

    public int getTicketNumber() {
        return this.t.getNumber();
    }

    public void openDrawer() {
        try {
            TicketPrinter prt = this.getPOSConf().getTicketPrinterConfiguration1().createTicketPrinter();
            prt.openDrawer();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void switchListMode() {
        this.caisseFrame.mainPanel.switchListMode();
    }

    public void setLCD(final String line1, final String line2, int delay) {
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                try {
                    CaisseControler.this.lcd.setMessage(line1, line2);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        Timer timer = new Timer("LCD : " + line1, true);
        timer.schedule(task, (long)delay * 1000L);
    }

    public void setLCDDefaultDisplay(int delay) {
        if (this.t.getTotalInCents() > 0) {
            int count = 0;
            List<TicketItem> articles = this.t.getItems();
            for (TicketItem pair : articles) {
                Article a = pair.getArticle();
                if (a.getSalesUnit() == null) {
                    count += pair.getQty().intValue();
                    continue;
                }
                ++count;
            }
            String line1 = count == 1 ? "1 article" : String.valueOf(count) + " articles";
            int cents = this.t.getTotalInCents();
            this.setLCD(line1, "Total : " + TicketCellRenderer.centsToString(cents), delay);
        } else {
            this.setLCD(this.getPOSConf().getLCDLine1(), this.getPOSConf().getLCDLine2(), delay);
        }
    }

    public void sendCBRequest(Paiement p) {
        this.caisseFrame.showCBPanel(p);
    }

    public void setArticleHT(TicketItem item, BigDecimal ht) {
        Article newArticle = new Article(item.getArticle());
        newArticle.updatePriceWithoutTax(ht);
        item.setArticle(newArticle);
        this.fire();
    }

    public void openPriceEditor(TicketItem item) {
        this.caisseFrame.showPriceEditor(item, this);
    }

    public void enableBarcodeReader() {
        this.r.setEnabled(true);
    }

    public void disableBarcodeReader() {
        this.r.setEnabled(false);
    }

    public boolean isTicketValid() {
        return !this.t.getItems().isEmpty() && (this.getTotal() >= 0 && this.getPaidTotal() >= this.getTotal() || this.getTotal() < 0 && this.getPaidTotal() == this.getTotal());
    }

    public Set<Integer> loadFavoriteProductsIds() {
        TemplateNXProps nxprops = (TemplateNXProps)TemplateNXProps.getInstance();
        File f = new File(nxprops.getDefaultStringValue(), "favorites.txt");
        System.out.println("CaisseControler.saveFavoriteProductsIds() loading favorites from " + f.getAbsolutePath());
        HashSet<Integer> result = new HashSet<Integer>();
        if (f.exists()) {
            try {
                String s = FileUtils.read(f);
                List<String> sIds = StringUtils.fastSplit(s, ',');
                for (String string : sIds) {
                    if (string.isEmpty()) continue;
                    result.add(Integer.parseInt(string));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public void saveFavoriteProductsIds(List<Article> products) {
        TemplateNXProps nxprops = (TemplateNXProps)TemplateNXProps.getInstance();
        File f = new File(nxprops.getDefaultStringValue(), "favorites.txt");
        System.out.println("CaisseControler.saveFavoriteProductsIds() saving favorites to " + f.getAbsolutePath());
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (FileOutputStream fOut = new FileOutputStream(f);){
                for (Article product : products) {
                    fOut.write(String.valueOf(product.getId()).getBytes());
                    fOut.write(44);
                }
                fOut.flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setTicketItemSelected(TicketItem item) {
        this.ticketItemSelected = item;
        if (item == null) {
            this.articleSelected = null;
        } else {
            this.articleSelected = item.getArticle();
            this.paiementSelected = null;
        }
        this.fire();
    }

    public TicketItem getTicketItemSelected() {
        return this.ticketItemSelected;
    }

    public void removeTicketItem(TicketItem item) {
        this.t.removeTicketItem(item);
        this.setTicketItemSelected(null);
    }

    public void cancel(Ticket ticket) {
        this.t.clear();
        for (TicketItem a : ticket.getItems()) {
            Article article = a.getArticle();
            TicketItem item = new TicketItem(article, a.getQty().multiply(new BigDecimal(-1)));
            this.t.addItem(item);
        }
        ArrayList<Paiement> typesAdded = new ArrayList<Paiement>();
        for (Paiement p : ticket.getPaiements()) {
            Paiement paiement = new Paiement(p.getType());
            paiement.setMontantInCents(-1 * p.getMontantInCents());
            this.t.addPaiement(paiement);
            typesAdded.add(p);
        }
        ArrayList<Paiement> types = new ArrayList<Paiement>();
        types.add(new Paiement(3));
        types.add(new Paiement(2));
        types.add(new Paiement(1));
        for (Paiement paiement : types) {
            boolean typeFound = false;
            for (Paiement p : typesAdded) {
                if (paiement.getType() != p.getType()) continue;
                typeFound = true;
            }
            if (typeFound) continue;
            this.t.addPaiement(paiement);
        }
        this.caisseFrame.showCaisse();
        this.fire();
    }

    public void openStockErrorPanel(Map<TicketItem, Integer> missingQty, Runnable runnable) {
        this.caisseFrame.showStockErrorPanel(missingQty, runnable);
    }
}

