/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.payment.action;

import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JFrame;
import org.openconcerto.erp.action.CreateFrameAbstractAction;
import org.openconcerto.erp.core.common.ui.IListFilterDatePanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.view.IListFrame;
import org.openconcerto.sql.view.ListeAddPanel;
import org.openconcerto.sql.view.list.SQLTableModelColumn;
import org.openconcerto.sql.view.list.SQLTableModelColumnPath;
import org.openconcerto.sql.view.list.SQLTableModelSourceOnline;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.utils.cc.ITransformer;

public class ListeDesRelancesAction
extends CreateFrameAbstractAction {
    private IListFrame frame;

    public ListeDesRelancesAction() {
        this.putValue("Name", "Liste des relances");
    }

    public JFrame createFrame() {
        SQLElement elt = Configuration.getInstance().getDirectory().getElement("RELANCE");
        this.frame = new IListFrame(new ListeAddPanel(elt){

            @Override
            protected void createUI() {
                super.createUI();
                this.btnMngr.setAdditional(this.buttonModifier, new ITransformer<JButton, String>(){

                    @Override
                    public String transformChecked(JButton input) {
                        SQLRowValues row = this.getListe().getSelectedRow();
                        if (row.getObject("ID_TYPE_LETTRE_RELANCE") == null || row.isForeignEmpty("ID_TYPE_LETTRE_RELANCE")) {
                            return "Vous ne pouvez pas modifier une relance envoy\u00e9e par mail!";
                        }
                        return null;
                    }
                });
            }
        });
        SQLTableModelSourceOnline src = (SQLTableModelSourceOnline)this.frame.getPanel().getListe().getModel().getReq();
        this.frame.getPanel().getListe().setModificationAllowed(true);
        for (SQLTableModelColumn column : src.getColumns()) {
            if (!column.getClass().isAssignableFrom(SQLTableModelColumnPath.class)) continue;
            ((SQLTableModelColumnPath)column).setEditable(false);
        }
        ((SQLTableModelColumnPath)src.getColumns(elt.getTable().getField("INFOS")).iterator().next()).setEditable(true);
        this.frame.getPanel().setAddVisible(false);
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridwidth = 0;
        c.fill = 0;
        c.weightx = 0.0;
        c.gridy = 4;
        IListFilterDatePanel datePanel = new IListFilterDatePanel(this.frame.getPanel().getListe(), elt.getTable().getField("DATE"), IListFilterDatePanel.getDefaultMap());
        ++c.gridy;
        c.anchor = 10;
        datePanel.setFilterOnDefault();
        this.frame.getPanel().add((Component)datePanel, c);
        return this.frame;
    }
}

