/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;

public class TinyMap<K, V>
extends AbstractMap<K, V> {
    private static final Function<Map.Entry<?, ?>, Object> KEY_GETTER = Map.Entry::getKey;
    private static final Function<Map.Entry<?, ?>, Object> VALUE_GETTER = Map.Entry::getValue;
    private final ArrayList<Map.Entry<K, V>> entries;
    private transient Set<Map.Entry<K, V>> entrySet;
    transient int modCount = 0;

    public TinyMap() {
        this(10);
    }

    public TinyMap(int initialCapacity) {
        this.entries = new ArrayList(initialCapacity);
    }

    public TinyMap(Map<? extends K, ? extends V> m) {
        this.entries = new ArrayList(m.size());
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.entries.add(new AbstractMap.SimpleEntry<K, V>(entry));
        }
        ++this.modCount;
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.indexOfKey(key) >= 0;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.indexOf(value, VALUE_GETTER) >= 0;
    }

    private int indexOfKey(Object key) {
        return this.indexOf(key, KEY_GETTER);
    }

    private final int indexOf(Object o, Function<Map.Entry<?, ?>, Object> getter) {
        int stop = this.entries.size();
        int i = 0;
        while (i < stop) {
            Map.Entry<K, V> e = this.entries.get(i);
            if (Objects.equals(o, getter.apply(e))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public V get(Object key) {
        int i = this.indexOfKey(key);
        if (i < 0) {
            return null;
        }
        return this.entries.get(i).getValue();
    }

    @Override
    public V put(K key, V value) {
        V res;
        int i = this.indexOfKey(key);
        if (i < 0) {
            this.entries.add(new AbstractMap.SimpleEntry<K, V>(key, value));
            ++this.modCount;
            res = null;
        } else {
            res = this.entries.get(i).setValue(value);
        }
        return res;
    }

    @Override
    public V remove(Object key) {
        return this.remove(this.indexOfKey(key));
    }

    private V remove(int i) {
        if (i < 0) {
            return null;
        }
        Map.Entry<K, V> res = this.entries.remove(i);
        ++this.modCount;
        return res.getValue();
    }

    @Override
    public boolean remove(Object key, Object value) {
        int i = this.indexOfKey(key);
        if (i < 0) {
            return false;
        }
        boolean eqVal = Objects.equals(this.entries.get(i).getValue(), value);
        if (eqVal) {
            this.remove(i);
        }
        return eqVal;
    }

    @Override
    public void clear() {
        this.entries.clear();
        ++this.modCount;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet es = this.entrySet;
        return es == null ? (this.entrySet = new EntrySet()) : es;
    }

    final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        public final int size() {
            return TinyMap.this.size();
        }

        @Override
        public final void clear() {
            TinyMap.this.clear();
        }

        @Override
        public final Iterator<Map.Entry<K, V>> iterator() {
            return new Iterator<Map.Entry<K, V>>(){
                private int expectedModCount;
                private int currentPos;
                private Map.Entry<K, V> lastReturned;
                {
                    this.expectedModCount = ((EntrySet)EntrySet.this).TinyMap.this.modCount;
                    this.currentPos = -1;
                    this.lastReturned = null;
                }

                @Override
                public boolean hasNext() {
                    int nextIndex = this.currentPos + 1;
                    return nextIndex < EntrySet.this.size();
                }

                @Override
                public Map.Entry<K, V> next() {
                    Map.Entry res;
                    this.checkForComodification();
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    ++this.currentPos;
                    this.lastReturned = res = (Map.Entry)TinyMap.this.entries.get(this.currentPos);
                    return res;
                }

                @Override
                public void remove() {
                    this.checkForComodification();
                    if (this.lastReturned == null) {
                        throw new IllegalStateException();
                    }
                    TinyMap.this.remove(this.currentPos);
                    --this.currentPos;
                    this.lastReturned = null;
                    this.expectedModCount = ((EntrySet)EntrySet.this).TinyMap.this.modCount;
                }

                final void checkForComodification() {
                    if (((EntrySet)EntrySet.this).TinyMap.this.modCount != this.expectedModCount) {
                        throw new ConcurrentModificationException();
                    }
                }
            };
        }

        @Override
        public final boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return TinyMap.this.entries.contains(e);
        }

        @Override
        public final boolean remove(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry e = (Map.Entry)o;
                Object key = e.getKey();
                Object value = e.getValue();
                return TinyMap.this.remove(key, value);
            }
            return false;
        }
    }
}

