/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.Set;

public class ClassPathLoader {
    private static ClassPathLoader instance = new ClassPathLoader();
    private Set<URL> urls = new HashSet<URL>();

    public static ClassPathLoader getInstance() {
        return instance;
    }

    public void addJar(File jarFile) throws MalformedURLException {
        this.urls.add(jarFile.toURI().toURL());
    }

    public void addJarFromDirectory(File dir) throws MalformedURLException {
        if (!dir.exists()) {
            System.out.println("Module directory doesn't exist : " + dir.getName());
            return;
        }
        File[] dirs = dir.listFiles();
        int i = 0;
        while (i < dirs.length) {
            File f = dirs[i];
            if (f.getName().endsWith(".jar")) {
                this.addJar(f);
            }
            ++i;
        }
    }

    public void load() {
        try {
            Method addURL = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            addURL.setAccessible(true);
            ClassLoader cl = ClassLoader.getSystemClassLoader();
            for (URL url : this.urls) {
                System.out.println("Loading module " + url);
                addURL.invoke((Object)cl, url);
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }
}

