/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.light;

import java.util.HashMap;
import net.minidev.json.JSONObject;
import org.openconcerto.ui.light.JSONToLightUIConvertor;
import org.openconcerto.ui.light.LightUIAutoCompleteComboBox;
import org.openconcerto.ui.light.LightUIBadge;
import org.openconcerto.ui.light.LightUIButton;
import org.openconcerto.ui.light.LightUIButtonLink;
import org.openconcerto.ui.light.LightUIButtonUnmanaged;
import org.openconcerto.ui.light.LightUIButtonWithContext;
import org.openconcerto.ui.light.LightUIButtonWithSelectionContext;
import org.openconcerto.ui.light.LightUICheckBox;
import org.openconcerto.ui.light.LightUIColorPicker;
import org.openconcerto.ui.light.LightUIComboBox;
import org.openconcerto.ui.light.LightUIDate;
import org.openconcerto.ui.light.LightUIDropDownButton;
import org.openconcerto.ui.light.LightUIElement;
import org.openconcerto.ui.light.LightUIFileUpload;
import org.openconcerto.ui.light.LightUIFrame;
import org.openconcerto.ui.light.LightUIHourEditor;
import org.openconcerto.ui.light.LightUIImage;
import org.openconcerto.ui.light.LightUILabel;
import org.openconcerto.ui.light.LightUILine;
import org.openconcerto.ui.light.LightUIList;
import org.openconcerto.ui.light.LightUIListRow;
import org.openconcerto.ui.light.LightUIPanel;
import org.openconcerto.ui.light.LightUIPasswordField;
import org.openconcerto.ui.light.LightUIPictureUpload;
import org.openconcerto.ui.light.LightUIRadioButtons;
import org.openconcerto.ui.light.LightUIRawHMTL;
import org.openconcerto.ui.light.LightUISlider;
import org.openconcerto.ui.light.LightUITab;
import org.openconcerto.ui.light.LightUITabbed;
import org.openconcerto.ui.light.LightUITable;
import org.openconcerto.ui.light.LightUIText;
import org.openconcerto.ui.light.LightUITextArea;
import org.openconcerto.ui.light.LightUITextField;
import org.openconcerto.utils.io.JSONConverter;

public class JSONToLightUIConvertorManager {
    HashMap<String, JSONToLightUIConvertor> map = new HashMap();
    private static final JSONToLightUIConvertorManager instance = new JSONToLightUIConvertorManager();

    public static JSONToLightUIConvertorManager getInstance() {
        return instance;
    }

    public void put(String className, JSONToLightUIConvertor convertor) {
        this.map.put(className, convertor);
    }

    public LightUIElement createUIElementFromJSON(JSONObject jsonElement) {
        Integer type = JSONConverter.getParameterFromJSON(jsonElement, "type", Integer.class, null);
        switch (type) {
            case 0: {
                LightUILabel l = new LightUILabel();
                l.fromJSON(jsonElement);
                return l;
            }
            case 1: {
                LightUITextField l = new LightUITextField();
                l.fromJSON(jsonElement);
                return l;
            }
            case 2: {
                LightUIDate l = new LightUIDate();
                l.fromJSON(jsonElement);
                return l;
            }
            case 3: {
                LightUIComboBox l = new LightUIComboBox();
                l.fromJSON(jsonElement);
                return l;
            }
            case 4: {
                LightUITable l = new LightUITable();
                l.fromJSON(jsonElement);
                return l;
            }
            case 5: {
                LightUICheckBox l = new LightUICheckBox();
                l.fromJSON(jsonElement);
                return l;
            }
            case 6: {
                LightUITabbed l = new LightUITabbed();
                l.fromJSON(jsonElement);
                return l;
            }
            case 7: {
                throw new IllegalAccessError("WTF");
            }
            case 8: {
                LightUIPanel l = new LightUIPanel();
                l.fromJSON(jsonElement);
                return l;
            }
            case 9: {
                throw new IllegalAccessError("TODO");
            }
            case 10: {
                LightUIText l = new LightUIText(jsonElement);
                return l;
            }
            case 11: {
                LightUIList l = new LightUIList(jsonElement);
                return l;
            }
            case 12: {
                LightUIDropDownButton l = new LightUIDropDownButton(jsonElement);
                return l;
            }
            case 13: {
                LightUIFrame l = new LightUIFrame();
                l.fromJSON(jsonElement);
                return l;
            }
            case 14: {
                LightUIImage l = new LightUIImage(jsonElement);
                return l;
            }
            case 15: {
                LightUIFileUpload l = new LightUIFileUpload();
                l.fromJSON(jsonElement);
                return l;
            }
            case 16: {
                LightUILine l = new LightUILine();
                l.fromJSON(jsonElement);
                return l;
            }
            case 17: {
                LightUITab l = new LightUITab(jsonElement);
                return l;
            }
            case 18: {
                LightUISlider l = new LightUISlider();
                l.fromJSON(jsonElement);
                return l;
            }
            case 19: {
                LightUIPictureUpload l = new LightUIPictureUpload();
                l.fromJSON(jsonElement);
                return l;
            }
            case 20: {
                LightUIButton l = new LightUIButton();
                l.fromJSON(jsonElement);
                return l;
            }
            case 21: {
                LightUIButtonWithContext l = new LightUIButtonWithContext(jsonElement);
                return l;
            }
            case 22: {
                LightUIButton button = new LightUIButton();
                button.fromJSON(jsonElement);
                return button;
            }
            case 23: {
                LightUIButtonUnmanaged l = new LightUIButtonUnmanaged();
                l.fromJSON(jsonElement);
                return l;
            }
            case 24: {
                LightUIButtonWithSelectionContext l = new LightUIButtonWithSelectionContext(jsonElement);
                return l;
            }
            case 25: {
                LightUIButtonLink l = new LightUIButtonLink();
                l.fromJSON(jsonElement);
                return l;
            }
            case 26: {
                LightUIRawHMTL l = new LightUIRawHMTL(jsonElement);
                return l;
            }
            case 27: {
                LightUITextArea l = new LightUITextArea(jsonElement);
                return l;
            }
            case 28: {
                LightUIFileUpload l = new LightUIFileUpload();
                l.fromJSON(jsonElement);
                return l;
            }
            case 29: {
                LightUIListRow l = new LightUIListRow(jsonElement);
                return l;
            }
            case 30: {
                LightUIBadge l = new LightUIBadge(jsonElement);
                l.fromJSON(jsonElement);
                return l;
            }
            case 31: {
                LightUIAutoCompleteComboBox l = new LightUIAutoCompleteComboBox();
                l.fromJSON(jsonElement);
                return l;
            }
            case 32: {
                LightUIColorPicker l = new LightUIColorPicker(jsonElement);
                return l;
            }
            case 33: {
                LightUIHourEditor l = new LightUIHourEditor(jsonElement);
                return l;
            }
            case 34: {
                LightUIRadioButtons l = new LightUIRadioButtons();
                l.fromJSON(jsonElement);
                return l;
            }
            case 35: {
                LightUIPasswordField l = new LightUIPasswordField();
                l.fromJSON(jsonElement);
                return l;
            }
        }
        throw new IllegalArgumentException("unsupported type " + type);
    }
}

