/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.date;

import java.util.Calendar;
import java.util.Set;
import org.openconcerto.ui.date.DayOfWeek;
import org.openconcerto.ui.date.EventProvider;
import org.openconcerto.ui.date.Period;

public class EventProviders {
    private EventProviders() {
    }

    protected static void setDayOfMonth(Calendar c, int dayOfMonth) {
        c.set(5, Math.min(c.getActualMaximum(5), dayOfMonth));
    }

    private static abstract class ConstantPeriodEventProvider
    implements EventProvider {
        private final Period period;
        private final int increment;

        protected ConstantPeriodEventProvider(Period period, int increment) {
            this.period = period;
            if (increment == 0) {
                throw new IllegalArgumentException("Empty increment");
            }
            this.increment = increment;
        }

        @Override
        public final void next(Calendar c, boolean initialValue) {
            if (!initialValue || this.currentPeriodBefore(c)) {
                c.add(this.period.getCalendarField(), initialValue ? 1 : this.increment);
            }
            this.setDate(c);
        }

        protected boolean currentPeriodBefore(Calendar c) {
            Calendar clone = (Calendar)c.clone();
            this.setDate(clone);
            return clone.compareTo(c) < 0;
        }

        protected abstract void setDate(Calendar var1);
    }

    static final class Daily
    implements EventProvider {
        private final int dayIncrement;

        protected Daily(int dayIncrement) {
            this.dayIncrement = dayIncrement;
        }

        @Override
        public final void next(Calendar c, boolean initialValue) {
            if (!initialValue) {
                c.add(Period.DAY.getCalendarField(), this.dayIncrement);
            }
        }
    }

    static final class Monthly
    extends ConstantPeriodEventProvider {
        private final int dayOfMonth;

        protected Monthly(int dayOfMonth, int increment) {
            super(Period.MONTH, increment);
            this.dayOfMonth = dayOfMonth;
        }

        @Override
        protected boolean currentPeriodBefore(Calendar c) {
            return this.dayOfMonth < c.get(5);
        }

        @Override
        protected void setDate(Calendar c) {
            if (c.get(5) != this.dayOfMonth) {
                EventProviders.setDayOfMonth(c, this.dayOfMonth);
            }
        }
    }

    static final class MonthlyDayOfWeek
    extends WeekInMonth {
        protected MonthlyDayOfWeek(int ordinal, DayOfWeek day, int increment) {
            super(Period.MONTH, increment, ordinal, day);
        }
    }

    private static abstract class WeekInMonth
    extends ConstantPeriodEventProvider {
        private final int ordinal;
        private final DayOfWeek day;

        protected WeekInMonth(Period period, int increment, int ordinal, DayOfWeek day) {
            super(period, increment);
            if (period.compareTo(Period.MONTH) < 0) {
                throw new IllegalArgumentException("Period too short : " + (Object)((Object)period));
            }
            this.ordinal = ordinal;
            this.day = day;
        }

        @Override
        protected void setDate(Calendar c) {
            c.clear(5);
            c.clear(6);
            c.clear(3);
            c.clear(4);
            c.set(8, this.ordinal);
            c.set(7, this.day.getCalendarField());
        }
    }

    static final class Weekly
    implements EventProvider {
        private final int increment;
        private final Set<DayOfWeek> days;

        protected Weekly(int increment, Set<DayOfWeek> days) {
            this.increment = increment;
            if (days.isEmpty()) {
                throw new IllegalArgumentException("no days");
            }
            this.days = days;
        }

        @Override
        public final void next(Calendar c, boolean initialValue) {
            int currentWeekNumber = c.get(3);
            if (!initialValue) {
                c.add(7, 1);
            }
            while (c.get(3) == currentWeekNumber || initialValue) {
                if (this.days.contains((Object)DayOfWeek.fromCalendar(c))) {
                    return;
                }
                c.add(7, 1);
            }
            c.add(7, -1);
            assert (c.get(3) == currentWeekNumber);
            c.add(Period.WEEK.getCalendarField(), this.increment);
            c.set(7, c.getFirstDayOfWeek());
            this.next(c, true);
        }
    }

    static final class Yearly
    extends ConstantPeriodEventProvider {
        private final int dayOfMonth;
        private final int month;

        protected Yearly(int dayOfMonth, int month, int increment) {
            super(Period.YEAR, increment);
            this.dayOfMonth = dayOfMonth;
            this.month = month;
        }

        @Override
        protected void setDate(Calendar c) {
            c.set(2, this.month);
            EventProviders.setDayOfMonth(c, this.dayOfMonth);
        }
    }

    static final class YearlyDayOfWeekEventProvider
    extends WeekInMonth {
        private final int month;

        protected YearlyDayOfWeekEventProvider(int ordinal, DayOfWeek day, int month, int increment) {
            super(Period.YEAR, increment, ordinal, day);
            this.month = month;
        }

        @Override
        protected void setDate(Calendar c) {
            super.setDate(c);
            c.set(2, this.month);
        }
    }
}

