/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.view.FileDropHandler;

public class DropManager {
    private static final DropManager instance = new DropManager();
    private final Map<SQLTable, List<FileDropHandler>> handlers = new HashMap<SQLTable, List<FileDropHandler>>();

    private DropManager() {
    }

    public static DropManager getInstance() {
        return instance;
    }

    public void add(SQLTable table, FileDropHandler handler) {
        List<FileDropHandler> l = this.handlers.get(table);
        if (l == null) {
            l = new ArrayList<FileDropHandler>();
            this.handlers.put(table, l);
        }
        if (l.contains(handler)) {
            throw new IllegalArgumentException("Handler already defined for table " + table);
        }
        l.add(handler);
    }

    public List<FileDropHandler> getHandlerForTable(SQLTable tableName) {
        List<FileDropHandler> l = this.handlers.get(tableName);
        if (l == null) {
            l = new ArrayList<FileDropHandler>(0);
        }
        return l;
    }
}

