/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.users.rights;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openconcerto.sql.element.GlobalMapper;
import org.openconcerto.sql.element.GroupSQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.request.ComboSQLRequest;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.sql.sqlobject.IComboSelectionItem;
import org.openconcerto.sql.sqlobject.SQLRequestComboBox;
import org.openconcerto.sql.users.rights.RightEditor;
import org.openconcerto.sql.users.rights.RightEditorManager;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.group.Group;
import org.openconcerto.utils.CollectionUtils;

public class UserRightSQLComponent
extends GroupSQLComponent {
    public static String ID = "user.right";
    private JTextField objectField = new JTextField();
    private JPanel customEditorPanel = new JPanel(new GridBagLayout());
    private final ElementComboBox right = new ElementComboBox();
    private final GridBagConstraints cCustomPanel;
    private RightEditor currentRightEditor;
    private JComponent currentRightEditorComponent;
    private int userID = -1;

    public UserRightSQLComponent(SQLElement element) {
        super(element, (Group)GlobalMapper.getInstance().get(ID));
        this.customEditorPanel.setBorder(null);
        this.customEditorPanel.setOpaque(false);
        this.cCustomPanel = new DefaultGridBagConstraints();
        this.cCustomPanel.weightx = 1.0;
        this.currentRightEditor = RightEditorManager.getInstance().getDefaultRightEditor();
        this.objectField.setVisible(false);
    }

    @Override
    public JComponent createEditor(String id) {
        if (id.equals("ID_USER_COMMON")) {
            SQLRequestComboBox user = new SQLRequestComboBox();
            return user;
        }
        if (id.equals("OBJECT")) {
            return this.objectField;
        }
        if (id.equals("ID_RIGHT")) {
            this.right.setListIconVisible(false);
            return this.right;
        }
        if (id.equals("user.right.parameters.editor")) {
            this.updateCodeEditor(null);
            return this.customEditorPanel;
        }
        return super.createEditor(id);
    }

    @Override
    public void select(SQLRowAccessor r) {
        super.select(r);
        if (this.currentRightEditorComponent != null && r != null) {
            this.currentRightEditor.setValue(r.getString("OBJECT"), this.getTable().getDBRoot(), this.getElement().getDirectory(), this.currentRightEditorComponent);
        }
    }

    @Override
    public JComponent getLabel(String id) {
        JComponent comp = super.getLabel(id);
        if (id.equals("OBJECT")) {
            comp.setVisible(false);
        }
        return comp;
    }

    @Override
    protected Set<String> createRequiredNames() {
        return CollectionUtils.createSet("ID_RIGHT", "HAVE_RIGHT");
    }

    @Override
    protected void addViews() {
        super.addViews();
        SQLRequestComboBox user = (SQLRequestComboBox)this.getEditor("ID_USER_COMMON");
        user.getRequest().setUndefLabel("Par d\u00e9faut");
        this.right.getRequest().addToGraphToFetch(Collections.singleton("CODE"));
        this.right.getRequest().keepRows(ComboSQLRequest.KeepMode.ROW);
        this.right.fillCombo();
        this.right.addModelListener("selectedValue", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                UserRightSQLComponent.this.objectField.setText("");
                UserRightSQLComponent.this.customEditorPanel.removeAll();
                UserRightSQLComponent.this.updateCodeEditor((IComboSelectionItem)evt.getNewValue());
                UserRightSQLComponent.this.customEditorPanel.revalidate();
                UserRightSQLComponent.this.customEditorPanel.repaint();
            }
        });
    }

    private void updateCodeEditor(IComboSelectionItem newValue) {
        String code = newValue == null ? "" : newValue.getRow().getString("CODE");
        this.currentRightEditor = RightEditorManager.getInstance().getRightEditor(code);
        this.currentRightEditorComponent = this.currentRightEditor.getRightEditor(code, this.getTable().getDBRoot(), this.getElement().getDirectory(), this.objectField);
        this.customEditorPanel.add((Component)this.currentRightEditorComponent, this.cCustomPanel);
    }

    @Override
    protected SQLRowValues createDefaults() {
        if (this.userID >= 0) {
            return new SQLRowValues(this.getTable()).put("ID_USER_COMMON", this.userID);
        }
        return null;
    }

    public final void setUserID(int userID) {
        this.userID = userID;
    }
}

