/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.changer.convert;

import java.sql.SQLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openconcerto.sql.changer.Changer;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.graph.Link;
import org.openconcerto.sql.model.graph.SQLKey;
import org.openconcerto.sql.utils.AlterTable;
import org.openconcerto.sql.utils.ChangeTable;

public class AddFK
extends Changer<SQLTable> {
    public AddFK(DBSystemRoot b) {
        super(b);
    }

    @Override
    protected void changeImpl(SQLTable t) throws SQLException {
        this.getStream().println(t + "... ");
        if (this.getSystemRoot().getServer().getSQLSystem() == SQLSystem.MYSQL) {
            this.toInno(t);
        }
        Set<Link> foreignLinks = t.getForeignLinks();
        HashSet<List<String>> realFKs = new HashSet<List<String>>();
        for (Link link : foreignLinks) {
            if (link.getName() == null) continue;
            realFKs.add(link.getCols());
        }
        HashSet<List<String>> allFKs = new HashSet<List<String>>(realFKs);
        for (String virtualFK : SQLKey.foreignKeys(t)) {
            allFKs.add(Collections.singletonList(virtualFK));
        }
        if (allFKs.size() > 0) {
            HashSet<List<String>> indexes = new HashSet<List<String>>();
            for (SQLTable.Index i : t.getIndexes()) {
                indexes.add(i.getCols());
            }
            AlterTable alter = new AlterTable(t);
            for (final List list : allFKs) {
                if (!realFKs.contains(list)) {
                    SQLField key = t.getField((String)list.get(0));
                    SQLTable foreignT = SQLKey.keyToTable(key);
                    alter.addForeignConstraint(list, foreignT.getContextualSQLName(key.getTable()), false, Collections.singletonList(foreignT.getKey().getName()));
                    this.getStream().println("ajout de " + key);
                }
                if (!indexes.contains(list)) {
                    alter.addOutsideClause(new ChangeTable.DeferredClause(){

                        @Override
                        public String asString(ChangeTable<?> ct, SQLName tableName) {
                            return AddFK.this.getSyntax().getCreateIndex("_fki", tableName, list);
                        }

                        @Override
                        public ChangeTable.ClauseType getType() {
                            return ChangeTable.ClauseType.ADD_INDEX;
                        }
                    });
                    this.getStream().println("ajout d'index pour " + list);
                    continue;
                }
                this.getStream().println("pas besoin d'index pour " + list);
            }
            if (!alter.isEmpty()) {
                this.getDS().execute(alter.asString());
                t.getSchema().updateVersion();
            }
        }
    }

    private void toInno(SQLTable t) {
        if (!this.getDS().execute1("show table status like '" + t.getName() + "'").get("Engine").equals("InnoDB")) {
            this.getDS().execute("ALTER TABLE " + t.getName() + " ENGINE = InnoDB;");
        }
    }
}

