/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.rights;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.openconcerto.erp.config.MainFrame;
import org.openconcerto.erp.config.MenuManager;
import org.openconcerto.ui.component.combo.ISearchableCombo;
import org.openconcerto.ui.group.Group;
import org.openconcerto.ui.group.Item;
import org.openconcerto.utils.cc.ITransformer;
import org.openconcerto.utils.model.DefaultIMutableListModel;

public class MenuGroupComboItem {
    private final String id;
    private boolean isGroup;
    private boolean isToLevel;

    public MenuGroupComboItem(String id, boolean isGroup, boolean isTopLevel) {
        this.id = id;
        this.isGroup = isGroup;
        this.isToLevel = isTopLevel;
    }

    public String getId() {
        return this.id;
    }

    public String getTranslation() {
        String mngrLabel = MenuManager.getInstance().getLabelForId(this.id);
        Action mngrAction = MenuManager.getInstance().getActionForId(this.id);
        String mngrActionName = mngrAction == null || mngrAction.getValue("Name") == null ? null : mngrAction.getValue("Name").toString();
        return MainFrame.getFirstNonEmpty(Arrays.asList(mngrLabel, mngrActionName, this.id));
    }

    public String toString() {
        return this.getTranslation();
    }

    public static ISearchableCombo<MenuGroupComboItem> getComboMenu() {
        final ImageIcon icon = new ImageIcon(MenuGroupComboItem.class.getResource("submenu.png"));
        final ImageIcon icon2 = new ImageIcon(MenuGroupComboItem.class.getResource("group.png"));
        ISearchableCombo<MenuGroupComboItem> box = new ISearchableCombo<MenuGroupComboItem>();
        box.setIconFactory(new ITransformer<MenuGroupComboItem, Icon>(){

            @Override
            public Icon transformChecked(MenuGroupComboItem input) {
                if (!input.isGroup) {
                    return icon;
                }
                if (!input.isToLevel) {
                    return icon2;
                }
                return null;
            }
        });
        DefaultIMutableListModel<MenuGroupComboItem> comboItems = new DefaultIMutableListModel<MenuGroupComboItem>();
        Group g = MenuManager.getInstance().getGroup();
        ArrayList<MenuGroupComboItem> result = new ArrayList<MenuGroupComboItem>();
        int i = 0;
        while (i < g.getSize()) {
            Group item = (Group)g.getItem(i);
            MenuGroupComboItem comboItem = new MenuGroupComboItem(item.getId(), item.getSize() > 0, true);
            result.add(comboItem);
            MenuGroupComboItem.getSubMenu(item, result);
            ++i;
        }
        comboItems.addAll(result);
        box.initCache(comboItems);
        return box;
    }

    private static void getSubMenu(Group g, List<MenuGroupComboItem> result) {
        int i = 0;
        while (i < g.getSize()) {
            Item item = g.getItem(i);
            MenuGroupComboItem comboItem = new MenuGroupComboItem(item.getId(), item instanceof Group, false);
            result.add(comboItem);
            if (item instanceof Group) {
                MenuGroupComboItem.getSubMenu((Group)item, result);
            }
            ++i;
        }
    }
}

