/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.purchase.importer;

import com.lowagie.text.pdf.PRStream;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfString;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;

public class FacturXImporter {
    public static final String TYPE_MINIMUM = "urn:factur-x.eu:1p0:minimum";
    public static final String TYPE_BASIC = "urn:cen.eu:en16931:2017:compliant:factur-x.eu:1p0:basic";
    public static final String RSM_NS = "urn:un:unece:uncefact:data:standard:CrossIndustryInvoice:100";
    public static final String RAM_NS = "urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100";
    public static final String UDT_NS = "urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100";

    public boolean importFromPDF(File file) throws IOException, JDOMException, ParseException {
        HashMap<String, byte[]> files = new HashMap<String, byte[]>();
        PdfReader reader = new PdfReader((InputStream)new FileInputStream(file));
        PdfDictionary root = reader.getCatalog();
        PdfDictionary names = root.getAsDict(PdfName.NAMES);
        PdfDictionary embeddedFilesDict = names.getAsDict(PdfName.EMBEDDEDFILES);
        PdfArray embeddedFiles = embeddedFilesDict.getAsArray(PdfName.NAMES);
        int len = embeddedFiles.size();
        int i = 0;
        while (i < len) {
            PdfString name = embeddedFiles.getAsString(i);
            PdfDictionary fileSpec = embeddedFiles.getAsDict(i + 1);
            PdfDictionary streams = fileSpec.getAsDict(PdfName.EF);
            PRStream stream = null;
            stream = streams.contains(PdfName.UF) ? (PRStream)streams.getAsStream(PdfName.UF) : (PRStream)streams.getAsStream(PdfName.F);
            if (stream != null) {
                files.put(name.toUnicodeString(), PdfReader.getStreamBytes((PRStream)stream));
            }
            i += 2;
        }
        if (!files.containsKey("factur-x.xml")) {
            return false;
        }
        SAXBuilder builder = new SAXBuilder();
        Namespace nsRMS = Namespace.getNamespace(RSM_NS);
        Namespace nsRAM = Namespace.getNamespace(RAM_NS);
        Namespace nsUDT = Namespace.getNamespace(UDT_NS);
        this.log(new String((byte[])files.get("factur-x.xml")));
        Document document = builder.build(new ByteArrayInputStream((byte[])files.get("factur-x.xml")));
        Element rootNode = document.getRootElement();
        Element exchangedDocumentContext = rootNode.getChild("ExchangedDocumentContext", nsRMS);
        Element guidelineSpecifiedDocumentContextParameter = exchangedDocumentContext.getChild("GuidelineSpecifiedDocumentContextParameter", nsRAM);
        String type = guidelineSpecifiedDocumentContextParameter.getChildText("ID", nsRAM);
        this.log("type de FacturX : " + type);
        Element exchangedDocument = rootNode.getChild("ExchangedDocument", nsRMS);
        String numeroFacture = exchangedDocument.getChildText("ID", nsRAM);
        this.log("num\u00e9ro de facture : " + numeroFacture);
        String typeFacture = exchangedDocument.getChildText("TypeCode", nsRAM);
        this.log("type de facture : " + typeFacture);
        Element dateTimeString = exchangedDocument.getChild("IssueDateTime", nsRAM).getChild("DateTimeString", nsUDT);
        if (!dateTimeString.getAttributeValue("format").equals("102")) {
            throw new IllegalArgumentException("invalid date format : " + dateTimeString.getAttributeValue("format"));
        }
        String txtDateTimeString = dateTimeString.getText();
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        Date dateFacture = df.parse(txtDateTimeString);
        this.log("date de facture : " + dateFacture);
        String commentaire = "";
        if (exchangedDocument.getChild("IncludedNote", nsRAM) != null && exchangedDocument.getChild("IncludedNote").getChild("Content", nsRAM) != null) {
            commentaire = exchangedDocument.getChild("IncludedNote", nsRAM).getChildText("Content", nsRAM);
        }
        this.log("commentaire : " + commentaire);
        Element supplyChainTradeTransaction = rootNode.getChild("SupplyChainTradeTransaction", nsRMS);
        Element applicableHeaderTradeAgreement = supplyChainTradeTransaction.getChild("ApplicableHeaderTradeAgreement", nsRAM);
        Element sellerTradeParty = applicableHeaderTradeAgreement.getChild("SellerTradeParty", nsRAM);
        String nomFournisseur = sellerTradeParty.getChildText("Name", nsRAM);
        this.log("nom du fournisseur : " + nomFournisseur);
        Element specifiedLegalOrganization = sellerTradeParty.getChild("SpecifiedLegalOrganization", nsRAM);
        String siretFournisseur = specifiedLegalOrganization.getChildText("ID", nsRAM);
        this.log("SIRET du fournisseur : " + siretFournisseur);
        Element postalTradeAddress = sellerTradeParty.getChild("PostalTradeAddress", nsRAM);
        String codePays = postalTradeAddress.getChildText("CountryID", nsRAM);
        this.log("Code pays du fournisseur : " + codePays);
        Element specifiedTaxRegistration = sellerTradeParty.getChild("SpecifiedTaxRegistration", nsRAM);
        String tvaFournisseur = specifiedTaxRegistration.getChildText("ID", nsRAM);
        this.log("TVA du fournisseur : " + tvaFournisseur);
        Element applicableHeaderTradeSettlement = supplyChainTradeTransaction.getChild("ApplicableHeaderTradeSettlement", nsRAM);
        String codeDevise = applicableHeaderTradeSettlement.getChildText("InvoiceCurrencyCode", nsRAM);
        this.log("code devise : " + codeDevise);
        Element specifiedTradeSettlementHeaderMonetarySummation = applicableHeaderTradeSettlement.getChild("SpecifiedTradeSettlementHeaderMonetarySummation", nsRAM);
        BigDecimal totalHT = new BigDecimal(specifiedTradeSettlementHeaderMonetarySummation.getChildText("TaxBasisTotalAmount", nsRAM));
        BigDecimal totalTax = new BigDecimal(specifiedTradeSettlementHeaderMonetarySummation.getChildText("TaxTotalAmount", nsRAM));
        BigDecimal totalTTC = new BigDecimal(specifiedTradeSettlementHeaderMonetarySummation.getChildText("GrandTotalAmount", nsRAM));
        BigDecimal totalNetPayer = new BigDecimal(specifiedTradeSettlementHeaderMonetarySummation.getChildText("DuePayableAmount", nsRAM));
        this.log("total HT  : " + totalHT);
        this.log("total TVA : " + totalTax);
        this.log("total TTC : " + totalTTC);
        this.log("total \u00e0 payer : " + totalNetPayer);
        return true;
    }

    private void log(String string) {
        System.err.println(string);
    }

    public static void main(String[] args) throws Exception {
        FacturXImporter i = new FacturXImporter();
        i.importFromPDF(new File("test/FacturX/Facture_FR_MINIMUM.pdf"));
    }
}

