/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.order.action;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.dbutils.ResultSetHandler;
import org.openconcerto.erp.importer.ArrayTableModel;
import org.openconcerto.erp.importer.DataImporter;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.StringUtils;
import org.openconcerto.utils.Tuple3;

public class ImportProductsToOrder {
    private Map<Object, Integer> fabMap = new HashMap<Object, Integer>();
    private DBRoot root;
    private Map<String, SQLRowAccessor> artMap = new HashMap<String, SQLRowAccessor>();
    private SQLRowAccessor rowAffaire = null;
    private SQLRowAccessor rowFamille = null;

    public static void main(String[] args) throws IOException, SQLException {
        ImportProductsToOrder importer = new ImportProductsToOrder();
        importer.importFile(new File("export-inventor-17-819.xls"), null);
    }

    public void setRowAffaire(SQLRowAccessor rowAffaire) {
        this.rowAffaire = rowAffaire;
    }

    public void setRowFamille(SQLRowAccessor rowFamille) {
        this.rowFamille = rowFamille;
    }

    public void importFile(File file, DBRoot root) throws IOException, SQLException {
        this.root = root;
        DataImporter importer = new DataImporter();
        importer.setSkipFirstLine(true);
        ArrayTableModel m = importer.createModelFromXLS(file, 0);
        m.dump(0, 40);
        try {
            this.resolveFab(root);
        }
        catch (SQLException originalExn) {
            ExceptionHandler.handle("Impossible de cr\u00e9er les fournisseurs", originalExn);
            return;
        }
        try {
            this.resolveArticle(root);
        }
        catch (SQLException originalExn) {
            ExceptionHandler.handle("Impossible de cr\u00e9er les articles", originalExn);
            return;
        }
        int size = m.getRowCount();
        ArrayList<List<Object>> cleanData = new ArrayList<List<Object>>();
        this.fetch(cleanData, m, 0, BigDecimal.ONE, null);
        ArrayTableModel cleanModel = new ArrayTableModel(cleanData);
        SQLTable table = root.getTable("DEMANDE_ACHAT_ELEMENT");
        importer.setTable(table);
        importer.map(0, table.getField("REPERE"));
        importer.map(1, table.getField("QTE"));
        importer.map(2, table.getField("QTE_UNITAIRE"));
        importer.map(3, table.getField("ID_UNITE_VENTE"));
        importer.map(4, table.getField("NOM"));
        importer.map(5, table.getField("CODE"));
        importer.map(6, table.getField("ID_FABRICANT"));
        importer.map(7, table.getField("ID_ETAT_DEMANDE_ACHAT_ELEMENT"));
        importer.map(8, table.getField("ID_ARTICLE"));
        importer.map(9, table.getField("REVISION"));
        importer.map(10, table.getField("REPERE_SOURCE"));
        importer.map(11, table.getField("CODE_SOURCE"));
        importer.map(12, table.getField("NOM_SOURCE"));
        importer.map(13, table.getField("ID_FAMILLE_ARTICLE"));
        if (table.contains("ID_AFFAIRE")) {
            importer.map(14, table.getField("ID_AFFAIRE"));
        }
        importer.importFromModel(cleanModel);
        List rowsToInsert = importer.getValuesToInsert();
        ArrayList<String> queries = new ArrayList<String>(rowsToInsert.size());
        ArrayList<1> handlers = new ArrayList<1>(rowsToInsert.size());
        ResultSetHandler handler = new ResultSetHandler(){

            @Override
            public Object handle(ResultSet rs) throws SQLException {
                return null;
            }
        };
        SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd");
        String date = formater.format(new Date());
        for (SQLRowValues rowValsToInsert : rowsToInsert) {
            String query = "INSERT INTO " + rowValsToInsert.getTable().getSQLName();
            query = String.valueOf(query) + " (\"REPERE\", \"QTE\", \"QTE_UNITAIRE\", \"ID_UNITE_VENTE\", \"NOM\", \"CODE\", \"ID_FABRICANT\", \"ID_ETAT_DEMANDE_ACHAT_ELEMENT\", \"ID_ARTICLE\",\"REVISION\",\"REPERE_SOURCE\",\"CODE_SOURCE\",\"NOM_SOURCE\",\"IMPORT\",\"ID_FAMILLE_ARTICLE\", ";
            if (table.contains("ID_AFFAIRE")) {
                query = String.valueOf(query) + "\"ID_AFFAIRE\",";
            }
            query = String.valueOf(query) + "\"DATE\",\"ORDRE\") VALUES (";
            query = String.valueOf(query) + SQLBase.quoteStringStd(rowValsToInsert.getString("REPERE")) + ", ";
            query = String.valueOf(query) + rowValsToInsert.getInt("QTE") + ", ";
            query = String.valueOf(query) + rowValsToInsert.getBigDecimal("QTE_UNITAIRE") + ", ";
            query = String.valueOf(query) + rowValsToInsert.getForeignID("ID_UNITE_VENTE") + ", ";
            query = String.valueOf(query) + SQLBase.quoteStringStd(rowValsToInsert.getString("NOM")) + ", ";
            query = String.valueOf(query) + SQLBase.quoteStringStd(rowValsToInsert.getString("CODE")) + ", ";
            query = String.valueOf(query) + rowValsToInsert.getForeignID("ID_FABRICANT") + ", ";
            query = String.valueOf(query) + rowValsToInsert.getForeignID("ID_ETAT_DEMANDE_ACHAT_ELEMENT") + ", ";
            int foreignID = rowValsToInsert.getForeignID("ID_ARTICLE");
            if (foreignID < 1) {
                foreignID = 1;
            }
            query = String.valueOf(query) + foreignID + ", ";
            query = String.valueOf(query) + SQLBase.quoteStringStd(rowValsToInsert.getString("REVISION")) + ", ";
            query = String.valueOf(query) + SQLBase.quoteStringStd(rowValsToInsert.getString("REPERE_SOURCE")) + ", ";
            String codeSource = rowValsToInsert.getString("CODE_SOURCE");
            if (table.contains("ID_AFFAIRE") && (codeSource == null || codeSource.trim().length() == 0)) {
                codeSource = String.valueOf(rowValsToInsert.getForeign("ID_AFFAIRE").getString("NUMERO")) + "_000";
            }
            query = String.valueOf(query) + SQLBase.quoteStringStd(codeSource) + ", ";
            query = String.valueOf(query) + SQLBase.quoteStringStd(rowValsToInsert.getString("NOM_SOURCE")) + ", ";
            query = String.valueOf(query) + "true, ";
            query = String.valueOf(query) + rowValsToInsert.getForeignID("ID_FAMILLE_ARTICLE") + ", ";
            if (table.contains("ID_AFFAIRE")) {
                query = String.valueOf(query) + rowValsToInsert.getForeignID("ID_AFFAIRE") + ", ";
            }
            query = String.valueOf(query) + "'" + date + "', ";
            query = String.valueOf(query) + "(SELECT (MAX(\"ORDRE\")+1) FROM " + rowValsToInsert.getTable().getSQLName() + "));";
            System.err.println(query);
            queries.add(query);
            handlers.add(handler);
        }
        SQLUtils.executeMultiple(table.getDBSystemRoot(), queries, handlers);
    }

    /*
     * Unable to fully structure code
     */
    private int fetch(List<List<Object>> result, ArrayTableModel m, int index, BigDecimal qtyMult, Tuple3<String, String, String> parent) throws SQLException {
        size = m.getRowCount();
        if (index < size) ** GOTO lbl119
        return size;
lbl-1000:
        // 1 sources

        {
            line = m.getLineValuesAt(index);
            structure = (line.get(6) == null ? "" : line.get(6)).toString();
            repere = line.get(0).toString();
            if (repere.trim().length() == 0) {
                return size;
            }
            if (repere.endsWith(".0")) {
                repere = repere.replaceAll(".0", "");
            }
            c1 = line.get(1);
            qty = 1;
            uQty = BigDecimal.ONE;
            idUnit = 2;
            if (c1 instanceof Double) {
                d = (Double)c1;
                qty = d.intValue();
            } else if (c1 instanceof String) {
                all = c1.toString().trim();
                splited = StringUtils.fastSplit(all, ' ');
                uQtystr = splited.get(0).trim().replace(',', '.');
                uQty = new BigDecimal(uQtystr);
                if (splited.get(1).trim().equalsIgnoreCase("mm")) {
                    idUnit = 11;
                } else {
                    throw new IllegalStateException("cannot parse " + all);
                }
            }
            repereNext = null;
            if (index < size - 1) {
                repereNext = m.getLineValuesAt(index + 1).get(0).toString();
            }
            des = line.get(2);
            ref = line.get(3);
            if (parent != null && parent.get0() != null && !repere.startsWith(String.valueOf((String)parent.get0()) + ".")) ** GOTO lbl118
            if (repereNext != null && repereNext.startsWith(String.valueOf(repere) + ".") && !structure.equalsIgnoreCase("Achet\u00e9") && !structure.equalsIgnoreCase("Indivisible")) {
                qtyMultChild = qtyMult.multiply(uQty).multiply(new BigDecimal(qty));
                index = this.fetch(result, m, index + 1, qtyMultChild, Tuple3.create(repere, ref.toString(), des.toString()));
                continue;
            }
            cleanLine = new ArrayList<Object>();
            art = this.artMap.get(ref.toString());
            cleanLine.add(repere);
            if (art != null) {
                idUnit = art.getForeignID("ID_UNITE_VENTE");
            }
            cleanLine.add(qty * qtyMult.intValue());
            cleanLine.add(uQty);
            cleanLine.add(idUnit);
            if (des.toString().isEmpty()) {
                cleanLine.add(ref.toString());
            } else {
                cleanLine.add(des.toString());
            }
            cleanLine.add(ref.toString());
            c4 = line.get(4);
            if (c4 != null && c4.toString().trim().length() > 0) {
                key = this.fabMap.get(c4.toString());
                if (key == null) {
                    rowVAlsFab = new SQLRowValues(this.root.getTable("FABRICANT"));
                    rowVAlsFab.put("NOM", c4.toString());
                    insertedRow = rowVAlsFab.insert();
                    this.fabMap.put(c4.toString(), insertedRow.getID());
                    key = insertedRow.getID();
                }
                cleanLine.add(key);
            } else {
                cleanLine.add(1);
            }
            cleanLine.add(1);
            if (art != null) {
                cleanLine.add(art.getID());
            } else {
                cleanLine.add(null);
            }
            c5 = line.get(5);
            cleanLine.add(c5.toString());
            repereSource = "";
            refSource = "";
            desSource = "";
            if (parent != null) {
                repereSource = (String)parent.get0();
                refSource = (String)parent.get1();
                desSource = parent.get2();
            }
            cleanLine.add(repereSource.toString());
            cleanLine.add(refSource.toString());
            cleanLine.add(desSource.toString());
            if (this.rowFamille != null) {
                cleanLine.add(this.rowFamille.getID());
            } else {
                cleanLine.add(1);
            }
            if (this.rowAffaire != null) {
                cleanLine.add(this.rowAffaire.getID());
            }
            if (!structure.equalsIgnoreCase("Indivisible")) {
                result.add(cleanLine);
            }
            if (structure.equalsIgnoreCase("Achet\u00e9") || structure.equalsIgnoreCase("Indivisible")) {
                repereOrigin = repere;
                while (index < size && (repere.equalsIgnoreCase(repereOrigin) || repere.startsWith(String.valueOf(repereOrigin) + "."))) {
                    if (++index >= size || (repere = (line = m.getLineValuesAt(index)).get(0).toString()).trim().length() != 0) continue;
                    return size;
                }
            } else {
                ++index;
                continue;
lbl118:
                // 1 sources

                return index;
            }
lbl119:
            // 4 sources

            ** while (index < size)
        }
lbl120:
        // 1 sources

        return size;
    }

    private void resolveFab(DBRoot root) throws SQLException {
        SQLTable table = root.findTable("FABRICANT");
        SQLRowValues vals = new SQLRowValues(table);
        vals.put("NOM", null);
        SQLRowValuesListFetcher fetcher = new SQLRowValuesListFetcher(vals);
        List<SQLRowValues> existingRows = fetcher.fetch();
        for (SQLRowValues sqlRowValues : existingRows) {
            this.fabMap.put(sqlRowValues.getString("NOM"), sqlRowValues.getID());
        }
    }

    private void resolveArticle(DBRoot root) throws SQLException {
        SQLTable table = root.findTable("ARTICLE");
        SQLRowValues vals = new SQLRowValues(table);
        vals.put("CODE", null);
        vals.put("NOM", null);
        vals.put("PA_HT", null);
        vals.put("ID_UNITE_VENTE", null);
        SQLRowValuesListFetcher fetcher = new SQLRowValuesListFetcher(vals);
        List<SQLRowValues> existingRows = fetcher.fetch();
        for (SQLRowValues sqlRowValues : existingRows) {
            this.artMap.put(sqlRowValues.getString("CODE"), sqlRowValues);
        }
    }
}

