/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.quote.report;

import org.openconcerto.erp.generationDoc.AbstractSheetXMLWithDate;
import org.openconcerto.erp.generationDoc.gestcomm.OptionDocProcessor;
import org.openconcerto.erp.preferences.PrinterNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLRow;

public class DevisXmlSheet
extends AbstractSheetXMLWithDate {
    public static final String TEMPLATE_ID = "Devis";
    public static final String TEMPLATE_PROPERTY_NAME = "LocationDevis";

    @Override
    public String getReference() {
        return this.row.getString("OBJET");
    }

    @Override
    public SQLRow getRowLanguage() {
        SQLRow rowClient = this.row.getForeignRow("ID_CLIENT");
        if (rowClient.getTable().contains("ID_LANGUE")) {
            return rowClient.getForeignRow("ID_LANGUE");
        }
        return super.getRowLanguage();
    }

    public DevisXmlSheet(SQLRow row) {
        super(row);
        this.printer = PrinterNXProps.getInstance().getStringProperty("DevisPrinter");
        this.elt = Configuration.getInstance().getDirectory().getElement("DEVIS");
        this.setPostProcess(new OptionDocProcessor());
    }

    @Override
    public String getDefaultTemplateId() {
        return TEMPLATE_ID;
    }

    @Override
    public String getName() {
        return "Devis_" + this.row.getString("NUMERO");
    }
}

