/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.product.action;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.openconcerto.erp.core.supplychain.stock.element.DepotStockSQLElement;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.ConnectionHandlerNoSetup;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLInsert;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.SQLTableEvent;
import org.openconcerto.sql.model.SQLUpdate;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.sqlobject.SQLRequestComboBox;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.utils.ExceptionHandler;

public class InitializeStockPanel
extends JPanel {
    public InitializeStockPanel(final SQLElement eltArt, final List<SQLRowAccessor> selectedRows) {
        super(new GridBagLayout());
        final JButton buttonUpdate = new JButton("Initialiser");
        SQLElement stockElt = eltArt.getDirectory().getElement("DEPOT_STOCK");
        final SQLRequestComboBox comboStockDepart = new SQLRequestComboBox();
        comboStockDepart.uiInit(stockElt.createComboRequest());
        comboStockDepart.addModelListener("wantedID", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                InitializeStockPanel.this.updateButtons(buttonUpdate, comboStockDepart);
            }
        });
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridx = 0;
        c.weightx = 0.0;
        this.add((Component)new JLabel("D\u00e9p\u00f4t", 4), c);
        ++c.gridx;
        this.add((Component)comboStockDepart, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        ++c.gridy;
        c.gridx = 0;
        JButton buttonCancel = new JButton("Annuler");
        JPanel pButton = new JPanel();
        pButton.add(buttonCancel);
        pButton.add(buttonUpdate);
        c.gridwidth = 2;
        c.anchor = 14;
        c.weightx = 0.0;
        c.fill = 0;
        this.add((Component)pButton, c);
        buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((JFrame)SwingUtilities.getRoot(InitializeStockPanel.this)).dispose();
            }
        });
        buttonUpdate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                buttonUpdate.setEnabled(false);
                final SQLRow rowDepot = comboStockDepart.getSelectedRow();
                SwingWorker<Integer, Object> worker = new SwingWorker<Integer, Object>(){

                    @Override
                    protected Integer doInBackground() throws Exception {
                        try {
                            SQLUtils.executeAtomic(eltArt.getTable().getDBSystemRoot().getDataSource(), new ConnectionHandlerNoSetup<Object, SQLException>(){

                                @Override
                                public Object handle(SQLDataSource ds) throws SQLException {
                                    ArrayList<Integer> idsArt = new ArrayList<Integer>();
                                    for (SQLRowAccessor sqlRowValues : selectedRows) {
                                        idsArt.add(sqlRowValues.getID());
                                    }
                                    SQLSelect selStock = new SQLSelect();
                                    SQLTable stockTable = eltArt.getTable().getDBRoot().getTable("STOCK");
                                    selStock.addSelect(stockTable.getKey());
                                    selStock.addSelect(stockTable.getField("ID_ARTICLE"));
                                    Where w = new Where(stockTable.getField("ID_ARTICLE"), idsArt);
                                    selStock.setWhere(w.and(new Where((FieldRef)stockTable.getField("ID_DEPOT_STOCK"), "=", rowDepot.getID())));
                                    List<SQLRow> rowsStock = SQLRowListRSH.execute(selStock);
                                    HashSet<Integer> artInited = new HashSet<Integer>();
                                    for (SQLRow sqlRowValues : rowsStock) {
                                        artInited.add(sqlRowValues.getForeignID("ID_ARTICLE"));
                                    }
                                    ArrayList<SQLRowAccessor> rowValsArtWithInsert = new ArrayList<SQLRowAccessor>();
                                    ArrayList<SQLInsert> sqlInserts = new ArrayList<SQLInsert>();
                                    for (SQLRowAccessor sqlRowValues : selectedRows) {
                                        if (artInited.contains(sqlRowValues.getID())) continue;
                                        SQLInsert insert = new SQLInsert();
                                        insert.add(stockTable.getField("ID_ARTICLE"), sqlRowValues.getID());
                                        insert.add(stockTable.getField("ID_DEPOT_STOCK"), rowDepot.getID());
                                        sqlInserts.add(insert);
                                        rowValsArtWithInsert.add(sqlRowValues);
                                    }
                                    if (!sqlInserts.isEmpty()) {
                                        List<Number> executeSimilarInserts = SQLInsert.executeSimilarInserts(stockTable.getDBSystemRoot(), sqlInserts, true);
                                        ArrayList<SQLUpdate> updates = new ArrayList<SQLUpdate>();
                                        int i = 0;
                                        while (i < executeSimilarInserts.size()) {
                                            SQLRowAccessor rowVals = (SQLRowAccessor)rowValsArtWithInsert.get(i);
                                            if (rowVals.getForeignID("ID_DEPOT_STOCK") == rowDepot.getID() || rowVals.isForeignEmpty("ID_DEPOT_STOCK") && rowDepot.getID() == DepotStockSQLElement.DEFAULT_ID) {
                                                SQLUpdate up = new SQLUpdate(new Where((FieldRef)eltArt.getTable().getKey(), "=", (Object)rowVals.getIDNumber()));
                                                up.add(eltArt.getTable().getField("ID_STOCK"), executeSimilarInserts.get(i));
                                                updates.add(up);
                                            }
                                            ++i;
                                        }
                                        if (!updates.isEmpty()) {
                                            SQLUpdate.executeMultipleWithBatch(eltArt.getTable().getDBSystemRoot(), updates);
                                            eltArt.getTable().fire(new SQLTableEvent(eltArt.getTable(), -1, SQLTableEvent.Mode.ROW_UPDATED));
                                        }
                                    }
                                    return null;
                                }
                            });
                        }
                        catch (SQLException e1) {
                            ExceptionHandler.handle("Stock update error", e1);
                        }
                        return null;
                    }

                    @Override
                    protected void done() {
                        try {
                            Integer n = (Integer)this.get();
                        }
                        catch (Exception e) {
                            ExceptionHandler.handle("Stock update error", e);
                        }
                        super.done();
                        JOptionPane.showMessageDialog((JFrame)SwingUtilities.getRoot(InitializeStockPanel.this), "Initialisation des stocks termin\u00e9e");
                    }
                };
                worker.execute();
                ((JFrame)SwingUtilities.getRoot(InitializeStockPanel.this)).dispose();
            }
        });
        this.updateButtons(buttonUpdate, comboStockDepart);
    }

    private void updateButtons(JButton buttonUpdate, SQLRequestComboBox comboStockDepart) {
        buttonUpdate.setEnabled(comboStockDepart.getSelectedRow() != null);
    }
}

