/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.text.NumberFormatter;
import org.openconcerto.erp.core.sales.pos.ui.CaissePanel;
import org.openconcerto.erp.core.sales.pos.ui.POSLabel;
import org.openconcerto.ui.DefaultGridBagConstraints;

public class SoldePaiementPanel
extends JPanel {
    private JFormattedTextField textField;
    private JRadioButton bCB;
    private JRadioButton bCheque;
    private JRadioButton bEspece;

    public SoldePaiementPanel() {
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.insets = new Insets(14, 5, 5, 5);
        this.add((Component)new POSLabel("Montant"), c);
        NumberFormatter formatter = new NumberFormatter(new DecimalFormat("##0.00", new DecimalFormatSymbols(Locale.ENGLISH)));
        formatter.setAllowsInvalid(false);
        this.textField = new JFormattedTextField(formatter);
        this.textField.setHorizontalAlignment(4);
        this.textField.setFont(this.textField.getFont().deriveFont(20.0f));
        this.textField.setMargin(new Insets(5, 5, 5, 5));
        this.textField.setPreferredSize(new Dimension(100, this.textField.getPreferredSize().height));
        ++c.gridx;
        c.insets = new Insets(14, 5, 5, 0);
        this.add((Component)this.textField, c);
        ++c.gridx;
        c.insets = new Insets(14, 0, 5, 5);
        JButton b = new JButton("C");
        b.setBackground(CaissePanel.LIGHT_BLUE);
        b.setForeground(Color.WHITE);
        b.setFont(b.getFont().deriveFont(18.0f));
        b.setFocusPainted(false);
        b.setPreferredSize(new Dimension(64, 40));
        b.setFocusable(false);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SoldePaiementPanel.this.textField.setValue(null);
            }
        });
        this.add((Component)b, c);
        ++c.gridx;
        c.gridwidth = 3;
        c.gridx = 1;
        ++c.gridy;
        c.weighty = 1.0;
        this.bCB = this.createRadioButton("CB");
        this.bCB.setFocusable(false);
        this.bCB.setSelected(true);
        this.add((Component)this.bCB, c);
        ++c.gridy;
        this.bCheque = this.createRadioButton("Ch\u00e8que");
        this.bCheque.setFocusable(false);
        this.add((Component)this.bCheque, c);
        ++c.gridy;
        this.bEspece = this.createRadioButton("Esp\u00e8ce");
        this.bEspece.setFocusable(false);
        this.add((Component)this.bEspece, c);
        ButtonGroup g = new ButtonGroup();
        g.add(this.bCB);
        g.add(this.bCheque);
        g.add(this.bEspece);
        c.gridx = 4;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 4;
        c.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.createCalculatorPanel(), c);
        this.setBackground(Color.WHITE);
    }

    private JRadioButton createRadioButton(String string) {
        JRadioButton b = new JRadioButton(string);
        b.setFont(b.getFont().deriveFont(20.0f));
        b.setOpaque(false);
        b.setFocusable(false);
        return b;
    }

    JPanel createCalculatorPanel() {
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        JButton b7 = this.createButton("7");
        p.add((Component)b7, c);
        ++c.gridx;
        JButton b8 = this.createButton("8");
        p.add((Component)b8, c);
        ++c.gridx;
        JButton b9 = this.createButton("9");
        p.add((Component)b9, c);
        c.gridx = 0;
        ++c.gridy;
        JButton b4 = this.createButton("4");
        p.add((Component)b4, c);
        ++c.gridx;
        JButton b5 = this.createButton("5");
        p.add((Component)b5, c);
        ++c.gridx;
        JButton b6 = this.createButton("6");
        p.add((Component)b6, c);
        c.gridx = 0;
        ++c.gridy;
        JButton b1 = this.createButton("1");
        p.add((Component)b1, c);
        ++c.gridx;
        JButton b2 = this.createButton("2");
        p.add((Component)b2, c);
        ++c.gridx;
        JButton b3 = this.createButton("3");
        p.add((Component)b3, c);
        c.gridx = 0;
        ++c.gridy;
        JButton b0 = this.createButton("0");
        c.gridwidth = 2;
        p.add((Component)b0, c);
        c.gridx += 2;
        c.gridwidth = 1;
        JButton bPoint = this.createButton(".");
        p.add((Component)bPoint, c);
        p.setBackground(CaissePanel.LIGHT_BLUE);
        p.setFocusable(false);
        return p;
    }

    private JButton createButton(final String string) {
        JButton b = new JButton(string);
        b.setBackground(CaissePanel.DARK_BLUE);
        b.setForeground(Color.WHITE);
        b.setFont(b.getFont().deriveFont(20.0f));
        b.setBorderPainted(false);
        b.setFocusPainted(false);
        b.setPreferredSize(new Dimension(64, 64));
        b.setFocusable(false);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                char c = string.charAt(0);
                SoldePaiementPanel.this.textField.grabFocus();
                SoldePaiementPanel.this.textField.dispatchEvent(new KeyEvent(SoldePaiementPanel.this.textField, 400, System.currentTimeMillis(), 0, 0, c));
            }
        });
        return b;
    }

    public BigDecimal getAmount() {
        try {
            this.textField.commitEdit();
            BigDecimal m = new BigDecimal(((Number)this.textField.getValue()).doubleValue());
            return m;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public int getPaymentType() {
        if (this.bCB.isSelected()) {
            return 3;
        }
        if (this.bCheque.isSelected()) {
            return 2;
        }
        if (this.bEspece.isSelected()) {
            return 1;
        }
        throw new IllegalStateException("Unable to compute payment type");
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame jFrame = new JFrame();
                jFrame.setUndecorated(true);
                jFrame.setDefaultCloseOperation(3);
                jFrame.setContentPane(new SoldePaiementPanel());
                jFrame.pack();
                jFrame.setVisible(true);
            }
        });
    }
}

