/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openconcerto.erp.core.sales.pos.model.Client;
import org.openconcerto.erp.core.sales.pos.ui.CaisseFrame;
import org.openconcerto.erp.core.sales.pos.ui.CaissePanel;
import org.openconcerto.erp.core.sales.pos.ui.DetailClientPanel;
import org.openconcerto.erp.core.sales.pos.ui.POSButton;
import org.openconcerto.erp.core.sales.pos.ui.StatusBar;
import org.openconcerto.erp.core.sales.pos.ui.TicketCellRenderer;
import org.openconcerto.ui.DefaultListModel;
import org.openconcerto.ui.touch.ScrollableList;

public class ListeDesClientsPanel
extends JPanel {
    private ScrollableList clientList;
    private DefaultListModel ticketLlistModel;

    ListeDesClientsPanel(final CaisseFrame caisseFrame) {
        this.setBackground(new Color(245, 245, 245));
        this.setOpaque(true);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        StatusBar p = new StatusBar();
        p.setTitle("Liste des clients");
        p.setLayout(new FlowLayout(2));
        POSButton bBack = new POSButton("Fermer");
        p.add(bBack);
        this.add((Component)p, c);
        ++c.gridy;
        c.gridwidth = 1;
        c.weighty = 1.0;
        c.gridheight = 1;
        this.ticketLlistModel = new DefaultListModel();
        final List<Client> allClients = caisseFrame.getPOSConf().allClients();
        this.ticketLlistModel.addAll(new Vector<Client>(allClients));
        final Font f = new Font("Arial", 0, 24);
        this.clientList = new ScrollableList(this.ticketLlistModel){

            @Override
            public void paintCell(Graphics g, Object object, int index, boolean isSelected, int posY) {
                g.setFont(f);
                if (isSelected) {
                    g.setColor(new Color(232, 242, 254));
                } else {
                    g.setColor(Color.WHITE);
                }
                g.fillRect(0, posY, this.getWidth(), this.getCellHeight());
                g.setColor(Color.GRAY);
                g.drawLine(0, posY + this.getCellHeight() - 1, this.getWidth(), posY + this.getCellHeight() - 1);
                if (isSelected) {
                    g.setColor(Color.BLACK);
                } else {
                    g.setColor(Color.GRAY);
                }
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                Client client = (Client)object;
                String label = client.getFullName();
                int soldeInCents = client.getSolde().movePointRight(2).setScale(0, RoundingMode.HALF_UP).intValue();
                String euro = String.valueOf(TicketCellRenderer.centsToString(soldeInCents)) + "\u20ac";
                int wEuro = (int)g.getFontMetrics().getStringBounds(euro, g).getWidth();
                g.drawString(label, 10, posY + 24);
                g.drawString(euro, this.getWidth() - 5 - wEuro, posY + 24);
                String addr = client.getAddr();
                if (addr != null) {
                    g.drawString(addr, 10, posY + 48);
                }
            }
        };
        this.add((Component)this.clientList, c);
        ++c.gridy;
        c.weighty = 0.0;
        c.fill = 1;
        JPanel pBottom = new JPanel();
        pBottom.setOpaque(true);
        pBottom.setBackground(CaissePanel.DARK_BLUE);
        pBottom.setLayout(new BorderLayout(3, 3));
        Font f1 = new Font("Arial", 0, 21);
        JLabel label = new JLabel(new ImageIcon(this.getClass().getResource("search.png")));
        pBottom.add((Component)label, "West");
        pBottom.setBorder(BorderFactory.createLineBorder(CaissePanel.DARK_BLUE, 3));
        final JTextField textField = new JTextField();
        textField.setBorder(BorderFactory.createLineBorder(CaissePanel.DARK_BLUE, 1));
        textField.setFont(f1);
        pBottom.add((Component)textField, "Center");
        this.add((Component)pBottom, c);
        c.fill = 1;
        c.gridx = 1;
        c.gridy = 1;
        c.gridheight = 2;
        c.weighty = 1.0;
        c.insets = new Insets(10, 10, 10, 10);
        final DetailClientPanel detailClientPanel = new DetailClientPanel(caisseFrame);
        this.add((Component)detailClientPanel, c);
        this.clientList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Client selectedValue = (Client)ListeDesClientsPanel.this.clientList.getSelectedValue();
                detailClientPanel.setSelectedClient(selectedValue);
            }
        });
        bBack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                caisseFrame.showCaisse();
            }
        });
        textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ArrayList<Client> clients = new ArrayList<Client>();
                String text = textField.getText().trim().toLowerCase();
                if (text.isEmpty()) {
                    clients.addAll(allClients);
                } else {
                    for (Client c : allClients) {
                        if (!c.getFullName().toLowerCase().contains(text)) continue;
                        clients.add(c);
                    }
                }
                ListeDesClientsPanel.this.ticketLlistModel.removeAllElements();
                ListeDesClientsPanel.this.ticketLlistModel.addAll(clients);
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                textField.grabFocus();
            }
        });
    }

    public void setSelectedClient(Object selectedValue) {
        this.clientList.setSelectedValue(selectedValue, true);
    }
}

