/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Stack;
import javax.swing.AbstractListModel;
import javax.swing.SwingUtilities;
import org.openconcerto.erp.core.sales.pos.model.Article;
import org.openconcerto.erp.core.sales.pos.model.Categorie;
import org.openconcerto.utils.StringUtils;

public class FilteredListModel
extends AbstractListModel {
    private final List<Object> items = new ArrayList<Object>();
    private final Stack<String> searches = new Stack();
    private final Thread t;

    public FilteredListModel() {
        this.items.addAll(Categorie.getFavoriteProducts());
        final ArrayList<Categorie> l = new ArrayList<Categorie>(Categorie.getAllCategories());
        Collections.sort(l, new Comparator<Categorie>(){

            @Override
            public int compare(Categorie o1, Categorie o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        for (Categorie categorie : l) {
            List<Article> articles = categorie.getArticles();
            if (articles.isEmpty()) continue;
            this.items.add(categorie);
            this.items.addAll(articles);
        }
        this.t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (true) {
                    String s = null;
                    Stack stack = FilteredListModel.this.searches;
                    synchronized (stack) {
                        if (!FilteredListModel.this.searches.isEmpty()) {
                            s = ((String)FilteredListModel.this.searches.lastElement()).toLowerCase();
                            FilteredListModel.this.searches.clear();
                        }
                    }
                    if (s != null) {
                        final ArrayList<Object> newitems = new ArrayList<Object>();
                        for (Categorie categorie : l) {
                            List<Article> allArticles = categorie.getArticles();
                            if (s.trim().isEmpty()) {
                                if (allArticles.isEmpty()) continue;
                                newitems.add(categorie);
                                newitems.addAll(allArticles);
                                continue;
                            }
                            String[] parts = StringUtils.fastSplit(s, ' ').toArray(new String[0]);
                            int length = parts.length;
                            ArrayList<Article> articles = new ArrayList<Article>();
                            int size = allArticles.size();
                            int i = 0;
                            while (i < size) {
                                Article a = allArticles.get(i);
                                String name = String.valueOf(a.getName().toLowerCase()) + a.getCode().toLowerCase() + a.getBarCode().toLowerCase();
                                int j = 0;
                                while (j < length) {
                                    if (!name.contains(parts[j])) break;
                                    if (j == length - 1) {
                                        articles.add(a);
                                    }
                                    ++j;
                                }
                                ++i;
                            }
                            if (articles.isEmpty()) continue;
                            newitems.add(categorie);
                            newitems.addAll(articles);
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                FilteredListModel.this.items.clear();
                                FilteredListModel.this.items.addAll(Categorie.getFavoriteProducts());
                                FilteredListModel.this.items.addAll(newitems);
                                FilteredListModel.this.fireContentsChanged(this, 0, FilteredListModel.this.items.size());
                            }
                        });
                        continue;
                    }
                    try {
                        Thread.sleep(100L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        });
        this.t.setName("FilteredListModel search");
        this.t.setPriority(1);
        this.t.setDaemon(true);
        this.t.start();
    }

    @Override
    public int getSize() {
        return this.items.size();
    }

    @Override
    public Object getElementAt(int index) {
        return this.items.get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFilter(String text) {
        System.err.println("FilteredListModel.setFilter() " + text);
        this.items.clear();
        Stack<String> stack = this.searches;
        synchronized (stack) {
            this.searches.add(text);
        }
    }
}

