/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.io;

import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.HashPrintServiceAttributeSet;
import javax.print.attribute.standard.PrinterName;
import org.openconcerto.erp.core.sales.pos.io.StringStandardPrinter;
import org.openconcerto.erp.core.sales.pos.ui.TextAreaTicketPrinter;
import org.openconcerto.utils.StringUtils;

public class SwingPrinter
extends TextAreaTicketPrinter {
    private final String printerName;

    public SwingPrinter(String printerName) {
        if (StringUtils.isEmpty(printerName, true)) {
            throw new IllegalArgumentException("Missing printer name");
        }
        this.printerName = printerName;
    }

    public final String getPrinterName() {
        return this.printerName;
    }

    @Override
    public void printBuffer() throws Exception {
        super.printBuffer();
        HashPrintServiceAttributeSet attrSet = new HashPrintServiceAttributeSet(new PrinterName(this.printerName, null));
        PrintService[] lookupPrintServices = PrintServiceLookup.lookupPrintServices(null, attrSet);
        if (lookupPrintServices.length <= 0) {
            throw new PrintException("Printer " + this.printerName + " not found");
        }
        this.print(null, null, false, lookupPrintServices[0], new HashPrintRequestAttributeSet(StringStandardPrinter.createJobName(this.getDocName())), true);
    }
}

