/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.ui;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.concurrent.ExecutionException;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingWorker;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.finance.accounting.report.Map2033B;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JDate;
import org.openconcerto.utils.Tuple2;

public class ResultatAnalytiquePanel
extends JPanel {
    private final JDate dateDebutPeriode = new JDate();
    private final JDate dateFinPeriode = new JDate();

    public ResultatAnalytiquePanel() {
        super(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridx = -1;
        JLabel label = new JLabel("G\u00e9n\u00e9rer un compte de r\u00e9sultat pour le poste analytique ");
        this.add((Component)label, c);
        final ElementComboBox box = new ElementComboBox();
        box.init(Configuration.getInstance().getDirectory().getElement("POSTE_ANALYTIQUE"));
        this.add((Component)box, c);
        ++c.gridy;
        final JProgressBar bar = new JProgressBar();
        c.gridwidth = 0;
        this.add((Component)bar, c);
        ++c.gridy;
        c.gridwidth = 1;
        JPanel panelPeriode = new JPanel();
        panelPeriode.add(new JLabel("P\u00e9riode du "));
        panelPeriode.add(this.dateDebutPeriode);
        panelPeriode.add(new JLabel(" au "));
        panelPeriode.add(this.dateFinPeriode);
        c.gridwidth = 0;
        c.weightx = 1.0;
        this.add((Component)panelPeriode, c);
        this.setUpDatePeriode();
        ++c.gridy;
        c.gridwidth = 0;
        c.fill = 0;
        c.anchor = 13;
        JButton gen = new JButton("Cr\u00e9er");
        gen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Map2033B map2033B = new Map2033B(bar, ResultatAnalytiquePanel.this.dateDebutPeriode.getDate(), ResultatAnalytiquePanel.this.dateFinPeriode.getDate(), box.getSelectedRow());
                map2033B.generateMap();
            }
        });
        this.add((Component)gen, c);
    }

    private void setUpDatePeriode() {
        new SwingWorker<Tuple2<Date, Date>, Object>(){

            @Override
            protected Tuple2<Date, Date> doInBackground() throws Exception {
                SQLRow rowSociete = ((ComptaPropsConfiguration)Configuration.getInstance()).getRowSociete();
                SQLRow rowExercice = Configuration.getInstance().getBase().getTable("EXERCICE_COMMON").getRow(rowSociete.getInt("ID_EXERCICE_COMMON"));
                Date dateFin = (Date)rowExercice.getObject("DATE_FIN");
                Date dateDeb = (Date)rowExercice.getObject("DATE_DEB");
                return new Tuple2<Date, Date>(dateDeb, dateFin);
            }

            @Override
            protected void done() {
                try {
                    Tuple2 t = (Tuple2)this.get();
                    ResultatAnalytiquePanel.this.dateDebutPeriode.setValue((Date)t.get0());
                    ResultatAnalytiquePanel.this.dateFinPeriode.setValue((Date)t.get1());
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
            }
        }.execute();
    }
}

