/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.common.element;

import java.util.ArrayList;
import java.util.List;
import org.openconcerto.erp.core.common.component.AdresseSQLComponent;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.utils.ListMap;

public class AdresseSQLElement
extends ComptaSQLConfElement {
    public AdresseSQLElement() {
        super("ADRESSE", "une adresse", "adresses");
    }

    @Override
    public ListMap<String, String> getShowAs() {
        if (this.getTable().contains("DISTRICT")) {
            return ListMap.singleton(null, new String[]{"DEST", "RUE", "DISTRICT", "DEPARTEMENT", "CODE_POSTAL", "VILLE"});
        }
        return ListMap.singleton(null, new String[]{"DEST", "RUE", "CODE_POSTAL", "VILLE"});
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("LIBELLE");
        l.add("DEST");
        l.add("RUE");
        l.add("CODE_POSTAL");
        l.add("VILLE");
        return l;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("LIBELLE");
        l.add("RUE");
        l.add("CODE_POSTAL");
        l.add("VILLE");
        return l;
    }

    @Override
    public SQLComponent createComponent() {
        return new AdresseSQLComponent(this);
    }

    @Override
    protected String createCode() {
        return "address";
    }

    @Override
    public boolean isPrivate() {
        return true;
    }
}

