/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.prog;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;

public class EncConv {
    private static final File destDir = new File("converti");

    public static void main(String[] args) throws IOException {
        File f = new File(args[0]);
        EncConv.process(f);
    }

    private static void convert(File f) throws FileNotFoundException, UnsupportedEncodingException, IOException {
        int len;
        System.out.print(f + "... ");
        FileInputStream in = new FileInputStream(f);
        InputStreamReader r = new InputStreamReader((InputStream)in, "Cp1252");
        File destFile = new File(destDir, f.getPath());
        destFile.getParentFile().mkdirs();
        FileOutputStream out = new FileOutputStream(destFile);
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)out, "UTF8");
        char[] buf = new char[512];
        while ((len = r.read(buf)) != -1) {
            w.write(buf, 0, len);
        }
        w.close();
        r.close();
        System.out.println("converted");
    }

    private static void process(File f) throws IOException {
        if (f.isDirectory()) {
            File[] children = f.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().endsWith(".java");
                }
            });
            int i = 0;
            while (i < children.length) {
                File child = children[i];
                EncConv.process(child);
                ++i;
            }
        } else {
            EncConv.convert(f);
        }
    }
}

